(put 'encode-ethio-font 'ccl-program ccl-encode-ethio-font)

(defvar bdf-font-directory-int24 "c:/Meadow/intlfonts-1.2")
(defvar bdf-font-name-prefix-int24 "bdfintn24-")

(defvar bdf-font-file-alist-int24
  '((ascii "European/lt1-24-etl.bdf" 0)
    (japanese-jisx0212 "Japanese/jksp24.bdf" 0)
    (japanese-jisx0208 "Japanese.X/jiskan24.bdf" 0)
    (latin-jisx0201 "Japanese/12x24rk.bdf" 0)
    (katakana-jisx0201 "Japanese/a18rk.bdf" 1)
    (chinese-big5-1 "Chinese/taipei24.bdf" encode-big5-font)
    (chinese-big5-2 "Chinese/taipei24.bdf" encode-big5-font)
    (chinese-gb2312 "Chinese.X/gb24st.bdf" 0)
    (chinese-cns11643-1 "Chinese/cns-1-24.bdf" 0)
    (chinese-cns11643-2 "Chinese/cns-2-24.bdf" 0)
    (chinese-cns11643-3 "Chinese/cns-3-24.bdf" 0)
    (chinese-cns11643-4 "Chinese/cns-4-24.bdf" 0)
    (chinese-cns11643-5 "Chinese/cns-5-24.bdf" 0)
    (chinese-cns11643-6 "Chinese/cns-6-24.bdf" 0)
    (chinese-cns11643-7 "Chinese/cns-7-24.bdf" 0)
    (korean-ksc5601 "Korean.X/hanglm24.bdf" 0)
    (thai-tis620 "Asian/thai24.bdf" 1)
    (vietnamese-viscii-upper "Asian/visc24-etl.bdf" encode-viscii-font)
    (vietnamese-viscii-lower "Asian/visc24-etl.bdf" encode-viscii-font)
    (arabic-digit "Misc/arab24-0-etl.bdf" 0)
    (arabic-1-column "Misc/arab24-1-etl.bdf" 0)
    (arabic-2-column "Misc/arab24-2-etl.bdf" 0)
    (ipa "Misc/ipa24-etl.bdf" 1)
    (lao "Asian/lao24-mule.bdf" 1)
    (latin-iso8859-1 "European/lt1-24-etl.bdf" 1)
    (latin-iso8859-2 "European/lt2-24-etl.bdf" 1)
    (latin-iso8859-3 "European/lt3-24-etl.bdf" 1)
    (latin-iso8859-4 "European/lt4-24-etl.bdf" 1)
    (cyrillic-iso8859-5 "European/cyr24-etl.bdf" 1)
    (greek-iso8859-7 "European/grk24-etl.bdf" 1)
    (hebrew-iso8859-8 "Misc/heb24-etl.bdf" 1)
    (latin-iso8859-9 "European/lt5-24-etl.bdf" 1)
    (ethiopic "Ethiopic/ethio24f-uni.bdf" encode-ethio-font)
    (chinese-sisheng "Chinese/sish24-etl.bdf" 0)
    (tibetan "Asian/tib24-mule.bdf" 0)
    (tibetan-1-column "Asian/tib1c24-mule.bdf" 0)
    (indian-is13194 "Asian/ind24-mule.bdf" 0)
    (indian-1-column "Asian/ind1c24-mule.bdf" 0)
    (indian-2-column "Asian/ind24-mule.bdf" 0)
    ))

  (new-fontset "int24-fontset"
	       (mapcar
		(lambda (x)
		  (let* ((charset (car x))
			 (filename (nth 1 x))
			 (encoding (nth 2 x))
			 (fontname
			  (concat bdf-font-name-prefix-int24
				  (symbol-name charset))))
		    (w32-auto-regist-bdf-font
		     fontname
		     (expand-file-name filename bdf-font-directory-int24)
		     encoding)
		    (cons charset fontname)))
		bdf-font-file-alist-int24))
