# AWSTATS SEARCH ENGINES DATABASE
#------------------------------------------------------------------------------
# If you want to add a Search Engine to extend AWStats database detection capabilities,
# you must add an entry in SearchEnginesSearchIDOrder, SearchEnginesHashID and in
# SearchEnginesHashLib.
# An entry if known in SearchEnginesKnownUrl is also welcome.
#
# to eldy: Please check if the following description is correct:
# You need the following information to specify a search engine:
# (a) A regular expression that matches the referrer string of the
#    search engine. Unclear: What about slashes in the name of
#    a search engine, e.g. as in 'ecosia.com/search'. Seems that
#    AWStats will non find search strings containing a slash.
#    Maybe use a search string without a slash, and - if necessary -
#    an entry in %NotSearchEnginesKeys , if this search string
#    matches entries that are not search engines.
#    Example of a web address of a Amazon search engine:
#    http://www.amazon.de/gp/bit/apps/web/SERP/search/ref=bit_bds-p24_serp_cr_de?ie=UTF8tagbase=bds-p24&query=deutsch+8.+klasse+gymnasium+protokoll
# (b) A unique string to identify the search engine within AWStats
# (c) A regular expression that finds the start of the query part in the
#    referrer string
# (d) A HTML-fragment that goes into the reports generated by AWStats which
#    identifies the search engine to human reader of the report. In the
#    simplest case this is a string containing the name of the search
#    engine. You can also provide a hypertext clause that presents the
#    name together with a link to the search engine.
#
# The regular expression (a) goes into SearchEnginesSearchIDOrder_list1
# or ..._list2. List 1 contains common search engines, list 2 those
# that are not so often used.
#
# SearchEnginesHashID contains to consecutive entries for each search
# engine: The regular expression (a) followed bei the search engine
# identifier (b)
#
# SearchEnginesKnownUrl specifies how to find the start of the query.
# For each search engine you enter the search engine identifier (b)
# followed by the regular expression (c). Unclear: It is possible to
# omit this entry. If you do this, how will AWStats find the start of
# the query?
#
# SearchEnginesHashLib contains also two entries for each search engine:
# The search engine identifier (b) followed by the HTML-Fragment (d)
#
# There are search engines that do not use a query part in their URLs.
# They put the search expression in the main part of the URL instead.
# AWStats is able to handle these cases. They are specified as described
# above, except the following two things:
# - The regular expression (c) searches the complete URL and not only
#   the query part.
# - An additional Entry in the list %SearchEnginesWithKeysNotInQuery is
#   necessary.
#
#
# AWStats runs a sanity check of the contents of search_engines.pm. This
# check detects the following things:
# - Inconsistencies (number of entries)
# It does not detect the following errors:
# - If the HTML-Fragment (d) is syntactically incorrect.
#
#------------------------------------------------------------------------------
# Modified by ホビット 2017/8/25
# 2005-08-19 Sean Carlos http://www.antezeta.com/awstats.html
#            added minor italian search engines
#                  arianna http://arianna.libero.it/
#                  supereva http://search.supereva.com/
#                  kataweb http://kataweb.it/
#            corrected uk looksmart
#                  'askuk','ask=', 'bbc','q=', 'freeserve','q=', 'looksmart','key=',
#            to
#                  'askuk','ask=', 'bbc','q=', 'freeserve','q=', 'looksmartuk','key=',
#            corrected spelling
#                     internationnal -> international
#            added 'google\.'=>'mail\.google\.', to NotSearchEnginesKeys in order to
#            avoid counting gmail referrals as search engine traffic
# 2005-08-21 Sean Carlos http://www.antezeta.com/awstats.html
#            avoid counting babelfish.altavista referrals as search engine traffic
#            avoid counting translate.google referrals as search engine traffic
# 2005-11-20 Sean Carlos
# 	     added missing 'tiscali','key=', entry.  Check order
# 2005-11-22 Sean Carlos
# 	     added Google Base & Froogle.  Froogle not tested.
# 2006-04-18 Sean Carlos http://www.antezeta.com/awstats.html
# 	     added biglotron.com (France)
# 	     added blingo http://www.blingo.com/
# 	     added Clusty & Vivisimo
# 	     added eniro.no (Norway) [https://sourceforge.net/forum/message.php?msg_id=3134783]
# 	     added GPU p2p search http://search.centraldatabase.org/
# 	     added mail.tiscali to "not search engines list" [https://sourceforge.net/forum/message.php?msg_id=3166688]
# 	     added Ask group's "mysearch"
# 	     added sify.com (India)
# 	     added sogou.com (Cina) [https://sourceforge.net/forum/message.php?msg_id=3501603]
# 	     Ask changes:
# 	     - added Ask Japan (ask.jp)
# 	     - break out Ask new country level variants (DE, ES, FR, IT, NL)
# 	     - updated Ask name from Ask Jevees
# 	     - added Ask q= parameter - many recent searches probably not recognized; [https://sourceforge.net/forum/message.php?msg_id=3465444]
# 	     - updated Ask uk (new uk.ask.com added to older ask.co.uk)
# 	     updated voila kw|rdata parameter [https://sourceforge.net/forum/message.php?msg_id=3373912]
#	     for each new engine, added link to Search Engine.  This serves to document engine. Done for major & Italian engines as well. Requires patch
#		to AWStats to allow untranslated html.  Otherwise html will appear instead of link.
#	     reviewed mnoGoSearch (http://www.mnogosearch.org/); the search engined mentioned no longer
#		exists https://sourceforge.net/forum/message.php?msg_id=3025426
# 2006-05-13 Sean Carlos http://www.antezeta.com/awstats.html
#            added 10 Chello European broadband portals (Austria, Belgium, Czech Republic, France, Hungary, The Netherlands, Norway, Poland, Slovakia, Sweden)
#	     added Alice Internal Search (blends data with Google?) search.alice.it.master:10005
#            added detection of google cache views from IPs 66.249.93.104 72.14.203.104 72.14.207.104
#		To do: add more extensive IP list; keywords not yet detected.
#            added icerocket.com blog search http://www.icerocket.com/
#	     added live.com (msn) http://www.live.com/
# 	     added Meta motor kartoo.  Note: Kartoo does not provide search words in referrers, thus the engine will appear in the
#		search engine list but the actual search words are not available.
#	     added netluchs.de http://www.netluchs.de/
#	     added sphere.com blog search http://www.sphere.com/
#	     added wwweasel.de http://wwweasel.de
#	     added Yahoo Mindset! http://mindset.research.yahoo.com/
#            updated Mirago query parameter recognition (qry=); added breakout for each country (France, Germany, Spain, Italy, Norway, Sweden, Denmark, Netherlands, Belgium, Switzerland)
# 2006-05-13 Sean Carlos http://www.antezeta.com/awstats.html
#	     added Google cache IPs 64.233.183.104 & 66.102.7.104
# 2006-05-20 Sean Carlos http://www.antezeta.com/awstats.html
#		anzwers.com.au
#		schoenerbrausen.de http://www.schoenerbrausen.de/
#		added Google cache IP 216.239.59.104
#		answerbus http://www.answerbus.com/ (does not provide keywords)
# 2006-05-23 Sean Carlos http://www.antezeta.com/awstats.html
#		added Google cache IP 66.102.9.104, 64.233.161.104
# 2006-06-23 Sean Carlos http://www.antezeta.com/awstats.html
#	     	added Alice Search search.alice.it
#		added GoodSearch http://www.goodsearch.com/ (does not provide keywords) "a Yahoo-powered search engine that donates money to your favorite charity or school each time you search the web"
#		added googlee.com, variant of Google
#		added gotuneed http://www.gotuneed.com/ Italian search engine, in beta
#		added icq.com
#		added logic to parse Google Cache search keywords. Seems to work for alpha but not numeric cache IDs, i.e. search?q=cache:lWVLmnuGJswJ: is recognized but q=cache:Yv5qxeJNuhgJ: is not recognized. The URL triggering the keywords will also appear.  The URLs are probably too varied to parse out?
#		added Nusearch http://www.nusearch.com/
#		added Polymeta www.polymeta.hu (does not provide keywords)
#		added scroogle http://www.scroogle.org/ (does not always provide keywords)
#		added Tango http://tango.hu/search.php?st=0&q=jeles+napok
#		Changed Google Cache notation 64\.233\.(161|167|179|183|187)\.104 to 64\.233\.1[0-9]{2}\.104
#		 			      72\.14\.(203|205|207|209|221)\.104 to 72\.14\.2[0-9]{2}\.104
#					      216\.239\.(51|59)\.104 to 216\.239\.5[0-9]\.104
#					      66\.102\.(7|9)\.104 to 66\.102\.[1-9]\.104
# 2006-06-27 Sean Carlos http://www.antezeta.com/awstats.html
#		added Onet.pl http://szukaj.onet.pl/
#		corrected name "Wirtualna Polska" from "Szukaj" (search); added link http://szukaj.wp.pl/
# 2006-06-30 Sean Carlos http://www.antezeta.com/awstats.html
#	Additional Polish Search Engines:
#	added Dodaj.pl http://www.dodaj.pl/
#	added Gazeta.pl http://szukaj.gazeta.pl/
#	added Gery.pl http://szukaj.gery.pl/
#	added Hoga.pl http://www.hoga.pl/
#	added Interia.pl http://www.google.interia.pl/
#	added Katalog.Onet.pl http://katalog.onet.pl/
#	added NetSprint.pl http://www.netsprint.pl/
#	added o2.pl http://szukaj2.o2.pl/
#	added Polska http://szukaj.polska.pl/
#	added Szukacz http://www.szukacz.pl/
#	added Wow.pl http://szukaj.wow.pl/
#	added Sagool http://sagool.jp/

# 2006-08-25 Social Bookmarks
#	International
#	added del.icio.us/search - for now, just search referrer. To do: consider /tag/(tagname) referrer?
# 	added stumbleupon.com - No keywords supplied.
#	added swik.net
#       added digg. Keywords sometimes supplied.
#	Italy
# 	added segnalo.alice.it - No keywords supplied.
#	added ineffabile.it - No keywords supplied.

#       added filter for google groups.  Attempt to parse group name as keyword.

# 2006-09-14
#	added Eniro Sverige http://www.eniro.se/
#	added MyWebSearch http://search.mywebsearch.com/
#	added Teecno http://www.teecno.it/ Italian Open Source Search Engine

#package AWSSE;

# 2006-09-25 (Gabor Moizes)
# added 4-counter (Google alternative) http://4-counter.com/
# added Googlecom (Google alternative) http://googlecom.com/
# added Goggle (Google alternative) http://goggle.co.hu/
# added Comet toolbar http://as.starware.com
# added new IP for Yahoo: 216.109.125.130
# added Ledix http://ledix.net/
# added AT&T search (powered by Google) http://www.att.net/
# added Keresolap (Hungarian search engine) http://www.keresolap.hu/
# added Mozbot (French search engine) http://www.mozbot.fr/
# added Zoznam (Slovak search engine) http://www.zoznam.sk/
# added sapo.pt (Portuguese search engine) http://www.sapo.pt/
# added shaw.ca (powered by Google) http://start.shaw.ca/
# added Searchalot http://www.searchalot.com/
# added Copernic http://www.copernic.com/
# added 216.109.125.130 to Yahoo
# added 66.218.69.11 to Yahoo
# added Avantfind http://www.avantfind.com/
# added Steadysearch http://www.steadysearch.com/
# added Steadysearch http://www.steady-search.com/
# modified 216\.239\.5[0-9]\.104/search to 216\.239\.5[0-9]\.104

# RobC 2016/09/02 $
#  massive edit..... 
#  added all google country TLDs to split count by google country.
#  any google TLD not listed in here goes into 'Google catchall' for each country
#  each google country has 3 possibilities, normal, images, or catchall (a catchall for other google sub domains)
#  Several other search engines added too.
#  Whole file cleaned up and partly sorted, comments taken out to make it easier to 
#  add, find and edit entries. Fact is that vast majority of searches are from Google so
#  I made it Google centric which shows you which countries your google searches are coming from.
#  Should now contain all searchengines from awstats 7.5 release (plus a lot more)
#  May be too slow for big log files but you can try and see.
#  Currently tuned for my top search engines. Yours will likely differ.
#  If you put your sites 30 most used search engines at top of SearchEnginesSearchIDOrder_list1 and
#  at top of SearchEnginesHashID starting with most used at top, then performance is improved a tad.
#  SearchEnginesSearchIDOrder_list1 and SearchEnginesHashID must be in exact same order as each other.
#  SearchEnginesKnownUrl and SearchEnginesHashLib can be in any order you like.
#  Good luck  
#            
#  p.s. save your current search-engines.pm file before using this one just in case its too slow or you find an error.
#       I'm bound to have made one or two mistakes but it runs a years worth of log files from one my sites just fine.  

# 2016-10-15 RobC 
#              Added a few minor search engines and some minor tweaks.
#

# 2018-03-13 RobC 
#              Added more search engines plus improvements for yahoo.
#

#------------------------------------------------------------------------------
# SearchEnginesSearchIDOrder
# It contains all matching criteria to search for in log fields. This list is
# used to know in which order to search Search Engines IDs.
# Most frequent one are in list1, used when LevelForSearchEnginesDetection is 1 or more
# Minor robots are in list2, used when LevelForSearchEnginesDetection is 2 or more
# Note: Regex IDs are in lower case and ' ' and '+' are changed into '_'
#------------------------------------------------------------------------------
@SearchEnginesSearchIDOrder_list1=(
# Japanese Search Engines
# Added by Ryu 2007.01.06
'66\.102\.11\.104',
'64\.233\.179\.99',
'72\.14\.235\.132',
'74\.125\.(77|95|113|153|155)\.132',
'74\.125\.113\.104',
'209\.85\.(129|135|165|173|175|207)\.104',
'209\.85\.(129|135|173|175|229)\.132',
'216\.239\.(37\.99|39\.104|41\.104|63\.104)',
'webcache\.googleusercontent\.com',
'www\.answers\.com',
'search\.allabout\.co\.jp',
'search\.aol\.jp',
'search\.auone\.jp',
'avabox\.jp',
'biglobe\.ne\.jp',
'search\.cashback\.ne\.jp',
'search\.kbg\.jp',
'\.cometsystems\.com',
'\.cybozu\.net',
'cache\.yahoofs\.jp',
'yahoo-search\.jp',
'clusty\.jp',
'docomo\.ne\.jp',
'eniro\.fi',
'excite\.co\.jp',
'excite-cache\.jp',
'ezsch\.ezweb\.ne\.jp',
'www\.fastbrowsersearch\.com',
'fc2\.super-search\.jp',
'find\.x0\.to',
'search\.fresheye\.com',
'dir\.fresheye\.com',
'goo\.ne\.jp',
'google\.co\.jp',
'search\.idol-photo\.com',
'iug\.newsing\.jp',
'search\.1pa2\.info',
'search\.juno\.com',
'jword\.jp',
's\.luna\.tv',
#'msnscache\.com',
'www\.marsflag\.com',
'meta2\.the-search\.jp',
'bach\.istc\.kobe-u\.ac\.jp',
'meta\.rrzn\.uni-hannover\.de',
'naver\.co\.jp',
'naver\.com',
'search\.lifemile\.jp',
'search\.50pt\.jp',
'search\.point-box\.jp',
'sitesearch\.nikkei\.co\.jp',
'search\.okodukai\.jp',
'search\.jp\.aol\.com',
'search\.livedoor\.com',
'search\.nifty\.com',
'search\.msn\.co\.jp',
'search\.odn\.ne\.jp',
'search-hp\.com',
'niwango\.jp',
'olane\.jp',
'pex\.jp',
'picsearch\.com',
'picsearch\.sk',
'picmy\.jp',
'www\.prsearch\.',
'www\.so-net\.ne\.jp',
'm\.technorati\.jp',
'www\.technorati\.jp',
'technorati\.jp',
'technorati\.com',
'tocc\.co\.jp',
'www\.baidu\.jp',
'image\.baidu\.jp',
'www\.ceek\.jp',
'www\.dir\.bg',
'www\.infoseek\.co\.jp',
'www\.megite\.com',
'www\.seochat\.com',
'www\.websearch\.com',
'www\.yahoogle\.jp',
'yicha\.jp',
'^www\.google\.co\.uk$',
'^images\.google\.co\.uk$',
'^translate\.google\.co\.uk$',
'google\.co\.uk$',
'^www\.google\.com$',
'^images\.google\.com$',
'^translate\.google\.com$',
'google\.com$',

'^www\.bing\.com$',
'^cn\.bing\.com$',
'^global\.bing\.com$',
'bing\.com$',

'^(www\.|)yandex\.ru$',
'^(www\.|)yandex\.com\.tr$',
'^(www\.|)yandex\.ua$',
'^(www\.|)yandex\.kz$',
'^(www\.|)yandex\.com$',
'yandex\.',
'^ya\.ru$',

'^www\.google\.de$',
'^images\.google\.de$',
'^translate\.google\.de$',
'google\.de$',
'^www\.google\.fr$',
'^images\.google\.fr$',
'^translate\.google\.fr$',
'google\.fr$',
'^www\.google\.ca$',
'^images\.google\.ca$',
'^translate\.google\.ca$',
'google\.ca$',
'^www\.google\.es$',
'^images\.google\.es$',
'^translate\.google\.es$',
'google\.es$',
'^www\.google\.com\.au$',
'^images\.google\.com\.au$',
'^translate\.google\.com\.au$',
'google\.com\.au$',
'^www\.google\.nl$',
'^images\.google\.nl$',
'^translate\.google\.nl$',
'google\.nl$',
'^www\.google\.gr$',
'^images\.google\.gr$',
'^translate\.google\.gr$',
'google\.gr$',
'^www\.google\.se$',
'^images\.google\.se$',
'^translate\.google\.se$',
'google\.se$',
'^www\.google\.ie$',
'^images\.google\.ie$',
'^translate\.google\.ie$',
'google\.ie$',
'^www\.google\.it$',
'^images\.google\.it$',
'^translate\.google\.it$',
'google\.it$',
'^www\.google\.no$',
'^images\.google\.no$',
'^translate\.google\.no$',
'google\.no$',
'^www\.google\.com\.tr$',
'^images\.google\.com\.tr$',
'^translate\.google\.com\.tr$',
'google\.com\.tr$',
'^www\.google\.co\.in$',
'^images\.google\.co\.in$',
'^translate\.google\.co\.in$',
'google\.co\.in$',
'^www\.google\.pt$',
'^images\.google\.pt$',
'^translate\.google\.pt$',
'google\.pt$',
'^www\.google\.hr$',
'^images\.google\.hr$',
'^translate\.google\.hr$',
'google\.hr$',
'^www\.google\.co\.nz$',
'^images\.google\.co\.nz$',
'^translate\.google\.co\.nz$',
'google\.co\.nz$',
'^www\.google\.pl$',
'^images\.google\.pl$',
'^translate\.google\.pl$',
'google\.pl$',

'^www\.google\.ac$',
'^images\.google\.ac$',
'^translate\.google\.ac$',
'google\.ac$',
'^www\.google\.ad$',
'^images\.google\.ad$',
'^translate\.google\.ad$',
'google\.ad$',
'^www\.google\.ae$',
'^images\.google\.ae$',
'^translate\.google\.ae$',
'google\.ae$',
'^www\.google\.al$',
'^images\.google\.al$',
'^translate\.google\.al$',
'google\.al$',
'^www\.google\.am$',
'^images\.google\.am$',
'^translate\.google\.am$',
'google\.am$',
'^www\.google\.as$',
'^images\.google\.as$',
'^translate\.google\.as$',
'google\.as$',
'^www\.google\.at$',
'^images\.google\.at$',
'^translate\.google\.at$',
'google\.at$',
'^www\.google\.az$',
'^images\.google\.az$',
'^translate\.google\.az$',
'google\.az$',
'^www\.google\.ba$',
'^images\.google\.ba$',
'^translate\.google\.ba$',
'google\.ba$',
'^www\.google\.be$',
'^images\.google\.be$',
'^translate\.google\.be$',
'google\.be$',
'^www\.google\.bf$',
'^images\.google\.bf$',
'^translate\.google\.bf$',
'google\.bf$',
'^www\.google\.bg$',
'^images\.google\.bg$',
'^translate\.google\.bg$',
'google\.bg$',
'^www\.google\.bi$',
'^images\.google\.bi$',
'^translate\.google\.bi$',
'google\.bi$',
'^www\.google\.bj$',
'^images\.google\.bj$',
'^translate\.google\.bj$',
'google\.bj$',
'^www\.google\.bs$',
'^images\.google\.bs$',
'^translate\.google\.bs$',
'google\.bs$',
'^www\.google\.bt$',
'^images\.google\.bt$',
'^translate\.google\.bt$',
'google\.bt$',
'^www\.google\.by$',
'^images\.google\.by$',
'^translate\.google\.by$',
'google\.by$',
'^www\.google\.cat$',
'^images\.google\.cat$',
'^translate\.google\.cat$',
'google\.cat$',
'^www\.google\.cc$',
'^images\.google\.cc$',
'^translate\.google\.cc$',
'google\.cc$',
'^www\.google\.cd$',
'^images\.google\.cd$',
'^translate\.google\.cd$',
'google\.cd$',
'^www\.google\.cf$',
'^images\.google\.cf$',
'^translate\.google\.cf$',
'google\.cf$',
'^www\.google\.cg$',
'^images\.google\.cg$',
'^translate\.google\.cg$',
'google\.cg$',
'^www\.google\.ch$',
'^images\.google\.ch$',
'^translate\.google\.ch$',
'google\.ch$',
'^www\.google\.ci$',
'^images\.google\.ci$',
'^translate\.google\.ci$',
'google\.ci$',
'^www\.google\.cl$',
'^images\.google\.cl$',
'^translate\.google\.cl$',
'google\.cl$',
'^www\.google\.cm$',
'^images\.google\.cm$',
'^translate\.google\.cm$',
'google\.cm$',
'^www\.google\.cn$',
'^images\.google\.cn$',
'^translate\.google\.cn$',
'google\.cn$',
'^www\.google\.co\.ao$',
'^images\.google\.co\.ao$',
'^translate\.google\.co\.ao$',
'google\.co\.ao$',
'^www\.google\.co\.bw$',
'^images\.google\.co\.bw$',
'^translate\.google\.co\.bw$',
'google\.co\.bw$',
'^www\.google\.co\.ck$',
'^images\.google\.co\.ck$',
'^translate\.google\.co\.ck$',
'google\.co\.ck$',
'^www\.google\.co\.cr$',
'^images\.google\.co\.cr$',
'^translate\.google\.co\.cr$',
'google\.co\.cr$',
'^www\.google\.co\.id$',
'^images\.google\.co\.id$',
'^translate\.google\.co\.id$',
'google\.co\.id$',
'^www\.google\.co\.il$',
'^images\.google\.co\.il$',
'^translate\.google\.co\.il$',
'google\.co\.il$',
'^www\.google\.co\.jp$',
'^images\.google\.co\.jp$',
'^translate\.google\.co\.jp$',
'google\.co\.jp$',
'^www\.google\.co\.ke$',
'^images\.google\.co\.ke$',
'^translate\.google\.co\.ke$',
'google\.co\.ke$',
'^www\.google\.co\.kr$',
'^images\.google\.co\.kr$',
'^translate\.google\.co\.kr$',
'google\.co\.kr$',
'^www\.google\.co\.ls$',
'^images\.google\.co\.ls$',
'^translate\.google\.co\.ls$',
'google\.co\.ls$',
'^www\.google\.co\.ma$',
'^images\.google\.co\.ma$',
'^translate\.google\.co\.ma$',
'google\.co\.ma$',
'^www\.google\.co\.mz$',
'^images\.google\.co\.mz$',
'^translate\.google\.co\.mz$',
'google\.co\.mz$',
'^www\.google\.co\.th$',
'^images\.google\.co\.th$',
'^translate\.google\.co\.th$',
'google\.co\.th$',
'^www\.google\.co\.tz$',
'^images\.google\.co\.tz$',
'^translate\.google\.co\.tz$',
'google\.co\.tz$',
'^www\.google\.co\.ug$',
'^images\.google\.co\.ug$',
'^translate\.google\.co\.ug$',
'google\.co\.ug$',
'^www\.google\.co\.uz$',
'^images\.google\.co\.uz$',
'^translate\.google\.co\.uz$',
'google\.co\.uz$',
'^www\.google\.co\.ve$',
'^images\.google\.co\.ve$',
'^translate\.google\.co\.ve$',
'google\.co\.ve$',
'^www\.google\.co\.vi$',
'^images\.google\.co\.vi$',
'^translate\.google\.co\.vi$',
'google\.co\.vi$',
'^www\.google\.co\.za$',
'^images\.google\.co\.za$',
'^translate\.google\.co\.za$',
'google\.co\.za$',
'^www\.google\.co\.zm$',
'^images\.google\.co\.zm$',
'^translate\.google\.co\.zm$',
'google\.co\.zm$',
'^www\.google\.co\.zw$',
'^images\.google\.co\.zw$',
'^translate\.google\.co\.zw$',
'google\.co\.zw$',
'^www\.google\.com\.af$',
'^images\.google\.com\.af$',
'^translate\.google\.com\.af$',
'google\.com\.af$',
'^www\.google\.com\.ag$',
'^images\.google\.com\.ag$',
'^translate\.google\.com\.ag$',
'google\.com\.ag$',
'^www\.google\.com\.ai$',
'^images\.google\.com\.ai$',
'^translate\.google\.com\.ai$',
'google\.com\.ai$',
'^www\.google\.com\.ar$',
'^images\.google\.com\.ar$',
'^translate\.google\.com\.ar$',
'google\.com\.ar$',
'^www\.google\.com\.bd$',
'^images\.google\.com\.bd$',
'^translate\.google\.com\.bd$',
'google\.com\.bd$',
'^www\.google\.com\.bh$',
'^images\.google\.com\.bh$',
'^translate\.google\.com\.bh$',
'google\.com\.bh$',
'^www\.google\.com\.bn$',
'^images\.google\.com\.bn$',
'^translate\.google\.com\.bn$',
'google\.com\.bn$',
'^www\.google\.com\.bo$',
'^images\.google\.com\.bo$',
'^translate\.google\.com\.bo$',
'google\.com\.bo$',
'^www\.google\.com\.br$',
'^images\.google\.com\.br$',
'^translate\.google\.com\.br$',
'google\.com\.br$',
'^www\.google\.com\.bz$',
'^images\.google\.com\.bz$',
'^translate\.google\.com\.bz$',
'google\.com\.bz$',
'^www\.google\.com\.co$',
'^images\.google\.com\.co$',
'^translate\.google\.com\.co$',
'google\.com\.co$',
'^www\.google\.com\.cu$',
'^images\.google\.com\.cu$',
'^translate\.google\.com\.cu$',
'google\.com\.cu$',
'^www\.google\.com\.cy$',
'^images\.google\.com\.cy$',
'^translate\.google\.com\.cy$',
'google\.com\.cy$',
'^www\.google\.com\.do$',
'^images\.google\.com\.do$',
'^translate\.google\.com\.do$',
'google\.com\.do$',
'^www\.google\.com\.ec$',
'^images\.google\.com\.ec$',
'^translate\.google\.com\.ec$',
'google\.com\.ec$',
'^www\.google\.com\.eg$',
'^images\.google\.com\.eg$',
'^translate\.google\.com\.eg$',
'google\.com\.eg$',
'^www\.google\.com\.et$',
'^images\.google\.com\.et$',
'^translate\.google\.com\.et$',
'google\.com\.et$',
'^www\.google\.com\.fj$',
'^images\.google\.com\.fj$',
'^translate\.google\.com\.fj$',
'google\.com\.fj$',
'^www\.google\.com\.gh$',
'^images\.google\.com\.gh$',
'^translate\.google\.com\.gh$',
'google\.com\.gh$',
'^www\.google\.com\.gi$',
'^images\.google\.com\.gi$',
'^translate\.google\.com\.gi$',
'google\.com\.gi$',
'^www\.google\.com\.gt$',
'^images\.google\.com\.gt$',
'^translate\.google\.com\.gt$',
'google\.com\.gt$',
'^www\.google\.com\.hk$',
'^images\.google\.com\.hk$',
'^translate\.google\.com\.hk$',
'google\.com\.hk$',
'^www\.google\.com\.jm$',
'^images\.google\.com\.jm$',
'^translate\.google\.com\.jm$',
'google\.com\.jm$',
'^www\.google\.com\.kh$',
'^images\.google\.com\.kh$',
'^translate\.google\.com\.kh$',
'google\.com\.kh$',
'^www\.google\.com\.kw$',
'^images\.google\.com\.kw$',
'^translate\.google\.com\.kw$',
'google\.com\.kw$',
'^www\.google\.com\.lb$',
'^images\.google\.com\.lb$',
'^translate\.google\.com\.lb$',
'google\.com\.lb$',
'^www\.google\.com\.lc$',
'^images\.google\.com\.lc$',
'^translate\.google\.com\.lc$',
'google\.com\.lc$',
'^www\.google\.com\.ly$',
'^images\.google\.com\.ly$',
'^translate\.google\.com\.ly$',
'google\.com\.ly$',
'^www\.google\.com\.mm$',
'^images\.google\.com\.mm$',
'^translate\.google\.com\.mm$',
'google\.com\.mm$',
'^www\.google\.com\.mt$',
'^images\.google\.com\.mt$',
'^translate\.google\.com\.mt$',
'google\.com\.mt$',
'^www\.google\.com\.mx$',
'^images\.google\.com\.mx$',
'^translate\.google\.com\.mx$',
'google\.com\.mx$',
'^www\.google\.com\.my$',
'^images\.google\.com\.my$',
'^translate\.google\.com\.my$',
'google\.com\.my$',
'^www\.google\.com\.na$',
'^images\.google\.com\.na$',
'^translate\.google\.com\.na$',
'google\.com\.na$',
'^www\.google\.com\.nf$',
'^images\.google\.com\.nf$',
'^translate\.google\.com\.nf$',
'google\.com\.nf$',
'^www\.google\.com\.ng$',
'^images\.google\.com\.ng$',
'^translate\.google\.com\.ng$',
'google\.com\.ng$',
'^www\.google\.com\.ni$',
'^images\.google\.com\.ni$',
'^translate\.google\.com\.ni$',
'google\.com\.ni$',
'^www\.google\.com\.np$',
'^images\.google\.com\.np$',
'^translate\.google\.com\.np$',
'google\.com\.np$',
'^www\.google\.com\.om$',
'^images\.google\.com\.om$',
'^translate\.google\.com\.om$',
'google\.com\.om$',
'^www\.google\.com\.pa$',
'^images\.google\.com\.pa$',
'^translate\.google\.com\.pa$',
'google\.com\.pa$',
'^www\.google\.com\.pe$',
'^images\.google\.com\.pe$',
'^translate\.google\.com\.pe$',
'google\.com\.pe$',
'^www\.google\.com\.pg$',
'^images\.google\.com\.pg$',
'^translate\.google\.com\.pg$',
'google\.com\.pg$',
'^www\.google\.com\.ph$',
'^images\.google\.com\.ph$',
'^translate\.google\.com\.ph$',
'google\.com\.ph$',
'^www\.google\.com\.pk$',
'^images\.google\.com\.pk$',
'^translate\.google\.com\.pk$',
'google\.com\.pk$',
'^www\.google\.com\.pr$',
'^images\.google\.com\.pr$',
'^translate\.google\.com\.pr$',
'google\.com\.pr$',
'^www\.google\.com\.py$',
'^images\.google\.com\.py$',
'^translate\.google\.com\.py$',
'google\.com\.py$',
'^www\.google\.com\.qa$',
'^images\.google\.com\.qa$',
'^translate\.google\.com\.qa$',
'google\.com\.qa$',
'^www\.google\.com\.sa$',
'^images\.google\.com\.sa$',
'^translate\.google\.com\.sa$',
'google\.com\.sa$',
'^www\.google\.com\.sb$',
'^images\.google\.com\.sb$',
'^translate\.google\.com\.sb$',
'google\.com\.sb$',
'^www\.google\.com\.sg$',
'^images\.google\.com\.sg$',
'^translate\.google\.com\.sg$',
'google\.com\.sg$',
'^www\.google\.com\.sl$',
'^images\.google\.com\.sl$',
'^translate\.google\.com\.sl$',
'google\.com\.sl$',
'^www\.google\.com\.sv$',
'^images\.google\.com\.sv$',
'^translate\.google\.com\.sv$',
'google\.com\.sv$',
'^www\.google\.com\.tj$',
'^images\.google\.com\.tj$',
'^translate\.google\.com\.tj$',
'google\.com\.tj$',
'^www\.google\.com\.tw$',
'^images\.google\.com\.tw$',
'^translate\.google\.com\.tw$',
'google\.com\.tw$',
'^www\.google\.com\.ua$',
'^images\.google\.com\.ua$',
'^translate\.google\.com\.ua$',
'google\.com\.ua$',
'^www\.google\.com\.uy$',
'^images\.google\.com\.uy$',
'^translate\.google\.com\.uy$',
'google\.com\.uy$',
'^www\.google\.com\.vc$',
'^images\.google\.com\.vc$',
'^translate\.google\.com\.vc$',
'google\.com\.vc$',
'^www\.google\.com\.vn$',
'^images\.google\.com\.vn$',
'^translate\.google\.com\.vn$',
'google\.com\.vn$',
'^www\.google\.cv$',
'^images\.google\.cv$',
'^translate\.google\.cv$',
'google\.cv$',
'^www\.google\.cz$',
'^images\.google\.cz$',
'^translate\.google\.cz$',
'google\.cz$',
'^www\.google\.dj$',
'^images\.google\.dj$',
'^translate\.google\.dj$',
'google\.dj$',
'^www\.google\.dk$',
'^images\.google\.dk$',
'^translate\.google\.dk$',
'google\.dk$',
'^www\.google\.dm$',
'^images\.google\.dm$',
'^translate\.google\.dm$',
'google\.dm$',
'^www\.google\.dz$',
'^images\.google\.dz$',
'^translate\.google\.dz$',
'google\.dz$',
'^www\.google\.ee$',
'^images\.google\.ee$',
'^translate\.google\.ee$',
'google\.ee$',
'^www\.google\.fi$',
'^images\.google\.fi$',
'^translate\.google\.fi$',
'google\.fi$',
'^www\.google\.fm$',
'^images\.google\.fm$',
'^translate\.google\.fm$',
'google\.fm$',
'^www\.google\.ga$',
'^images\.google\.ga$',
'^translate\.google\.ga$',
'google\.ga$',
'^www\.google\.ge$',
'^images\.google\.ge$',
'^translate\.google\.ge$',
'google\.ge$',
'^www\.google\.gf$',
'^images\.google\.gf$',
'^translate\.google\.gf$',
'google\.gf$',
'^www\.google\.gg$',
'^images\.google\.gg$',
'^translate\.google\.gg$',
'google\.gg$',
'^www\.google\.gl$',
'^images\.google\.gl$',
'^translate\.google\.gl$',
'google\.gl$',
'^www\.google\.gm$',
'^images\.google\.gm$',
'^translate\.google\.gm$',
'google\.gm$',
'^www\.google\.gp$',
'^images\.google\.gp$',
'^translate\.google\.gp$',
'google\.gp$',
'^www\.google\.gy$',
'^images\.google\.gy$',
'^translate\.google\.gy$',
'google\.gy$',
'^www\.google\.hn$',
'^images\.google\.hn$',
'^translate\.google\.hn$',
'google\.hn$',
'^www\.google\.ht$',
'^images\.google\.ht$',
'^translate\.google\.ht$',
'google\.ht$',
'^www\.google\.hu$',
'^images\.google\.hu$',
'^translate\.google\.hu$',
'google\.hu$',
'^www\.google\.im$',
'^images\.google\.im$',
'^translate\.google\.im$',
'google\.im$',
'^www\.google\.io$',
'^images\.google\.io$',
'^translate\.google\.io$',
'google\.io$',
'^www\.google\.iq$',
'^images\.google\.iq$',
'^translate\.google\.iq$',
'google\.iq$',
'^www\.google\.is$',
'^images\.google\.is$',
'^translate\.google\.is$',
'google\.is$',
'^www\.google\.je$',
'^images\.google\.je$',
'^translate\.google\.je$',
'google\.je$',
'^www\.google\.jo$',
'^images\.google\.jo$',
'^translate\.google\.jo$',
'google\.jo$',
'^www\.google\.kg$',
'^images\.google\.kg$',
'^translate\.google\.kg$',
'google\.kg$',
'^www\.google\.ki$',
'^images\.google\.ki$',
'^translate\.google\.ki$',
'google\.ki$',
'^www\.google\.kz$',
'^images\.google\.kz$',
'^translate\.google\.kz$',
'google\.kz$',
'^www\.google\.la$',
'^images\.google\.la$',
'^translate\.google\.la$',
'google\.la$',
'^www\.google\.li$',
'^images\.google\.li$',
'^translate\.google\.li$',
'google\.li$',
'^www\.google\.lk$',
'^images\.google\.lk$',
'^translate\.google\.lk$',
'google\.lk$',
'^www\.google\.lt$',
'^images\.google\.lt$',
'^translate\.google\.lt$',
'google\.lt$',
'^www\.google\.lu$',
'^images\.google\.lu$',
'^translate\.google\.lu$',
'google\.lu$',
'^www\.google\.lv$',
'^images\.google\.lv$',
'^translate\.google\.lv$',
'google\.lv$',
'^www\.google\.md$',
'^images\.google\.md$',
'^translate\.google\.md$',
'google\.md$',
'^www\.google\.me$',
'^images\.google\.me$',
'^translate\.google\.me$',
'google\.me$',
'^www\.google\.mg$',
'^images\.google\.mg$',
'^translate\.google\.mg$',
'google\.mg$',
'^www\.google\.mk$',
'^images\.google\.mk$',
'^translate\.google\.mk$',
'google\.mk$',
'^www\.google\.ml$',
'^images\.google\.ml$',
'^translate\.google\.ml$',
'google\.ml$',
'^www\.google\.mn$',
'^images\.google\.mn$',
'^translate\.google\.mn$',
'google\.mn$',
'^www\.google\.ms$',
'^images\.google\.ms$',
'^translate\.google\.ms$',
'google\.ms$',
'^www\.google\.mu$',
'^images\.google\.mu$',
'^translate\.google\.mu$',
'google\.mu$',
'^www\.google\.mv$',
'^images\.google\.mv$',
'^translate\.google\.mv$',
'google\.mv$',
'^www\.google\.mw$',
'^images\.google\.mw$',
'^translate\.google\.mw$',
'google\.mw$',
'^www\.google\.ne$',
'^images\.google\.ne$',
'^translate\.google\.ne$',
'google\.ne$',
'^www\.google\.nr$',
'^images\.google\.nr$',
'^translate\.google\.nr$',
'google\.nr$',
'^www\.google\.nu$',
'^images\.google\.nu$',
'^translate\.google\.nu$',
'google\.nu$',
'^www\.google\.pn$',
'^images\.google\.pn$',
'^translate\.google\.pn$',
'google\.pn$',
'^www\.google\.ps$',
'^images\.google\.ps$',
'^translate\.google\.ps$',
'google\.ps$',
'^www\.google\.ro$',
'^images\.google\.ro$',
'^translate\.google\.ro$',
'google\.ro$',
'^www\.google\.rs$',
'^images\.google\.rs$',
'^translate\.google\.rs$',
'google\.rs$',
'^www\.google\.ru$',
'^images\.google\.ru$',
'^translate\.google\.ru$',
'google\.ru$',
'^www\.google\.rw$',
'^images\.google\.rw$',
'^translate\.google\.rw$',
'google\.rw$',
'^www\.google\.sc$',
'^images\.google\.sc$',
'^translate\.google\.sc$',
'google\.sc$',
'^www\.google\.sh$',
'^images\.google\.sh$',
'^translate\.google\.sh$',
'google\.sh$',
'^www\.google\.si$',
'^images\.google\.si$',
'^translate\.google\.si$',
'google\.si$',
'^www\.google\.sk$',
'^images\.google\.sk$',
'^translate\.google\.sk$',
'google\.sk$',
'^www\.google\.sm$',
'^images\.google\.sm$',
'^translate\.google\.sm$',
'google\.sm$',
'^www\.google\.sn$',
'^images\.google\.sn$',
'^translate\.google\.sn$',
'google\.sn$',
'^www\.google\.so$',
'^images\.google\.so$',
'^translate\.google\.so$',
'google\.so$',
'^www\.google\.sr$',
'^images\.google\.sr$',
'^translate\.google\.sr$',
'google\.sr$',
'^www\.google\.st$',
'^images\.google\.st$',
'^translate\.google\.st$',
'google\.st$',
'^www\.google\.td$',
'^images\.google\.td$',
'^translate\.google\.td$',
'google\.td$',
'^www\.google\.tg$',
'^images\.google\.tg$',
'^translate\.google\.tg$',
'google\.tg$',
'^www\.google\.tk$',
'^images\.google\.tk$',
'^translate\.google\.tk$',
'google\.tk$',
'^www\.google\.tl$',
'^images\.google\.tl$',
'^translate\.google\.tl$',
'google\.tl$',
'^www\.google\.tm$',
'^images\.google\.tm$',
'^translate\.google\.tm$',
'google\.tm$',
'^www\.google\.tn$',
'^images\.google\.tn$',
'^translate\.google\.tn$',
'google\.tn$',
'^www\.google\.to$',
'^images\.google\.to$',
'^translate\.google\.to$',
'google\.to$',
'^www\.google\.tt$',
'^images\.google\.tt$',
'^translate\.google\.tt$',
'google\.tt$',
'^www\.google\.us$',
'^images\.google\.us$',
'^translate\.google\.us$',
'google\.us$',
'^www\.google\.vg$',
'^images\.google\.vg$',
'^translate\.google\.vg$',
'google\.vg$',
'^www\.google\.vu$',
'^images\.google\.vu$',
'^translate\.google\.vu$',
'google\.vu$',
'^www\.google\.ws$',
'^images\.google\.ws$',
'^translate\.google\.ws$',
'google\.ws$',

'babylon\.com',
'search\.conduit\.com',
'avg\.com',
'mywebsearch\.com',
'msn\.',
'live\.com',
'search\.aol\.co\.uk',
'searcht\.aol\.co\.uk',
'searcht\.aol\.com',
'search\.aol\.com',
'recherche\.aol\.fr',
'suche\.aol\.de',
'de\.aolsearch\.com',
'sucheaol\.aol\.de',
'search\.hp\.my\.aol\.co\.uk',
'search\.aol\.pl',
'o2suche\.aol\.de',
'search\.aol\.',
'^uk\.ask\.com$',
'^de\.ask\.com$',
'tb\.ask\.com$',
'^images\.ask\.com$',

'base\.google\.',
'froogle\.google\.',
'google\.[\w.]+/products',
'googlecom\.com',
'groups\.google\.',
'googlee\.',

'216\.239\.32\.20',
'173\.194\.32\.223',
'216\.239\.(35|37|39|51)\.100',
'216\.239\.(35|37|39|51)\.101',
'216\.239\.5[0-9]\.104',
'64\.233\.1[0-9]{2}\.104',
'66\.102\.[1-9]\.104',
'66\.249\.93\.104',
'72\.14\.2[0-9]{2}\.104',

'maps\.google',
'translate\.google',
'173\.194\.35\.177',
'android\.googlequicksearchbox',
'google\.',

'^ar\.images\.search\.yahoo\.com$',
'^ar\.search\.yahoo\.com$',
'^at\.images\.search\.yahoo\.com$',
'^at\.search\.yahoo\.com$',
'^au\.images\.search\.yahoo\.com$',
'^au\.search\.yahoo\.com$',
'^br\.images\.search\.yahoo\.com$',
'^br\.search\.yahoo\.com$',
'^ca\.images\.search\.yahoo\.com$',
'^ca\.search\.yahoo\.com$',
'^ca\.yhs4\.search\.yahoo\.com$',
'^ch\.images\.search\.yahoo\.com$',
'^ch\.yhs4\.search\.yahoo\.com$',
'^de\.search\.yahoo\.com$',
'^de\.yhs4\.search\.yahoo\.com$',
'^es\.images\.search\.yahoo\.com$',
'^es\.search\.yahoo\.com$',
'^es\.yhs4\.search\.yahoo\.com$',
'^espanol\.images\.search\.yahoo\.com$',
'^espanol\.search\.yahoo\.com$',
'^fr\.images\.search\.yahoo\.com$',
'^fr\.search\.yahoo\.com$',
'^fr\.yhs4\.search\.yahoo\.com$',
'^gr\.search\.yahoo\.com$',
'^gr\.yhs4\.search\.yahoo\.com$',
'^hk\.image\.search\.yahoo\.com$',
'^hk\.images\.search\.yahoo\.com$',
'^hk\.search\.yahoo\.com$',
'^id\.images\.search\.yahoo\.com$',
'^id\.search\.yahoo\.com$',
'^id\.yhs4\.search\.yahoo\.com$',
'^ie\.search\.yahoo\.com$',
'^image\.search\.yahoo\.co\.jp$',
'^images\.search\.yahoo\.com$',
'^in\.images\.search\.yahoo\.com$',
'^in\.search\.yahoo\.com$',
'^in\.yhs4\.search\.yahoo\.com$',
'^it\.images\.search\.yahoo\.com$',
'^it\.search\.yahoo\.com$',
'^it\.yhs4\.search\.yahoo\.com$',
'^kr\.search\.yahoo\.com$',
'^malaysia\.images\.search\.yahoo\.com$',
'^malaysia\.search\.yahoo\.com$',
'^mx\.images\.search\.yahoo\.com$',
'^mx\.search\.yahoo\.com$',
'^nl\.images\.search\.yahoo\.com$',
'^nl\.search\.yahoo\.com$',
'^nl\.yhs4\.search\.yahoo\.com$',
'^no\.search\.yahoo\.com$',
'^nz\.search\.yahoo\.com$',
'^pe\.images\.search\.yahoo\.com$',
'^ph\.images\.search\.yahoo\.com$',
'^ph\.search\.yahoo\.com$',
'^ph\.yhs4\.search\.yahoo\.com$',
'^pl\.yhs4\.search\.yahoo\.com$',
'^qc\.images\.search\.yahoo\.com$',
'^qc\.search\.yahoo\.com$',
'^r\.search\.yahoo\.com$',
'^ru\.images\.search\.yahoo\.com$',
'^se\.images\.search\.yahoo\.com$',
'^se\.search\.yahoo\.com$',
'^se\.yhs4\.search\.yahoo\.com$',
'^search\.yahoo\.co\.jp$',
'^search\.yahoo\.com$',
'^sg\.images\.search\.yahoo\.com$',
'^sg\.search\.yahoo\.com$',
'^sg\.yhs4\.search\.yahoo\.com$',
'^tr\.yhs4\.search\.yahoo\.com$',
'^tw\.image\.search\.yahoo\.com$',
'^tw\.images\.search\.yahoo\.com$',
'^tw\.search\.yahoo\.com$',
'^uk\.images\.search\.yahoo\.com$',
'^uk\.search\.yahoo\.com$',
'^uk\.yhs\.search\.yahoo\.com$',
'^uk\.yhs4\.search\.yahoo\.com$',
'^us\.search\.yahoo\.com$',
'^us\.yhs4\.search\.yahoo\.com$',
'^vn\.images\.search\.yahoo\.com$',

'mail\.yahoo\.net',
'(66\.218\.71\.225|216\.109\.117\.135|216\.109\.125\.130|66\.218\.69\.11)',
'mindset\.research\.yahoo',

'images\.search\.yahoo',
'yhs4\.search\.yahoo',
'search\.yahoo',
'yahoo',

'^www\.ask\.jp$',
'^es\.ask\.com$',
'^fr\.ask\.com$',
'^www\.iask\.com$',
'^it\.ask\.com$',
'^nl\.ask\.com$',
'(^|\.)ask\.com$',

'www\.tesco\.net',
'yell\.',
'zapmeta\.ch',
'zapmeta\.com',
'zapmeta\.de',
'zapmeta\.it',
'fr\.zapmeta\.ws',
'zapmeta\.ws',
'zapmeta',

'(^|\.)go\.com',
'(161\.58\.227\.204|161\.58\.247\.101|212\.40\.165\.90|213\.133\.108\.202|217\.160\.108\.151|217\.160\.111\.99|217\.160\.131\.108|217\.160\.142\.227|217\.160\.176\.42)',
'\.facemoods\.com',
'\.funmoods\.com',
'\.metasearch\.',
'\.wow\.com',
'163\.com',
'1klik\.dk',
'1search-board\.com',
'212\.227\.33\.241',
'3721\.com',
'4-counter\.com',
'a9\.com',
'accoona\.com',
'alexa\.com',
'allesklar\.de',
'alltheweb\.com',
'altavista\.',
'amazon\.',
'androidsearch\.com',
'answerbus\.com',
'anzwers\.com\.au',
'aport\.ru',
'arianna\.libero\.it',
'as\.starware\.com',
'asevenboard\.com',
'atlanticbb\.net',
'atlas\.cz',
'atomz\.',
'att\.net',
'auone\.jp',
'avantfind\.com',
'image\.baidu\.com',
'baidu\.com',
'bbc\.co\.uk/cgi-bin/search',
'biglotron\.com',
'blekko\.com',
'blingo\.com',
'boatdesign\.net',
'bungeebonesdotcom',
'^burett\.pagelink\.si$',
'centraldatabase\.org',
'centrum\.cz',
'centurylink\.net',
'charter\.net',
'chatzum\.com',
'checkparams\.com',
'chello\.at',
'chello\.be',
'chello\.cz',
'chello\.fr',
'chello\.hu',
'chello\.nl',
'chello\.no',
'chello\.pl',
'chello\.se',
'chello\.sk',
'chello',
'claro-search\.com',
'clinck\.in',
'clusty\.com',
'copernic\.com',
'crawler\.com',
'csillamker\.hu',
'ctrouve\.',
'dalesearch\.com',
'danielsen\.com',
'daum\.net',
'de\.dolphin\.com',
'de\.wiki\.gov\.cn',
'de\.wow\.com',
'dealwifi\.com',
'dejanews\.',
'del\.icio\.us',
'delta-search',
'digg\.com',
'dmoz\.org',
'dodaj\.pl',
'dogpile\.com',
'duckduckgo',
'easysearch\.org\.uk',
'ecosia\.org',
'edderkoppen\.dk',
'engine\.exe',
'eniro\.no',
'eniro\.se',
'ereadingsource\.com',
'es\.mirago\.com',
'etools\.ch',
'euroseek\.',
'everyclick\.com',
'evreka\.passagen\.se',
'excite\.',
'extern\.peoplecheck\.de',
'fastbot\.de',
'find\.dk',
'find1friend\.com',
'findamo\.com',
'findarticles\.com',
'fireball\.de',
'forums\.iboats\.com',
'foxstart\.com',
'francite\.',
'gazeta\.pl',
'gery\.pl',
'globososo\.',
'go\.mail\.ru',
'go\.speedbit\.com',
'go2net\.com',
'godado',
'goggle\.co\.hu$',
'goliat\.hu',
'goodsearch\.com',
'gotuneed\.com',
'haku\.www\.fi',
'heureka\.hu',
'hoga\.pl',
'hotbot\.',
'hubwe\.net',
'icerocket\.com',
'icq\.com\/search',
'ifind\.freeserve',
'ilse\.',
'inbox\.com',
'index\.hu',
'ineffabile\.it',
'intelseek\.com',
'^www\.info\.com$',
'info\.co\.uk',
'infoseek\.de',
'infospace\.com',
'inspsearch\.com',
'int\.search\.myway\.com',
'int\.search-results\.com',
'interia\.pl',
'isearch\.nation\.com',
'i-une\.com',
'ixquick\.com',
'izito\.co\.uk',
'izito\.co\.de',
'izito\.',
'jubii\.dk',
'jumpy\.it',
'startjuno\.com',
'juno\.com',
'jyxo\.(cz|com)',
'kartoo\.com',
'katalog\.onet\.pl',
'kataweb\.it',
'kereso\.startlap\.hu',
'keresolap\.hu',
'kvasir\.',
'kvitters\.',
'lapkereso\.hu',
'lbb\.org',
'ledix\.net',
'libero\.it/',
'localmoxie\.com',
'looksmart\.co\.uk',
'looksmart\.',
'lycos\.',
'mamma\.',
'meinestadt\.de',
'meta\.ua',
'metabot\.ru',
'metacrawler\.',
'metager\.de',
'miner\.bol\.com\.br',
'mirago\.be',
'mirago\.ch',
'mirago\.co\.uk',
'mirago\.de',
'mirago\.dk',
'mirago\.fr',
'mirago\.it',
'mirago\.nl',
'mirago\.se',
'mirago',
'mitrasites\.com',
'mozbot\.fr',
'my\.allgameshome\.com',
'mys\.yoursearch\.me',
'mysearch\.',
'mysearchdial\.com',
'mysearchresults\.com',
'myway\.com',
'najdi\.to',
'nation\.',
'navigationshilfe\.t-online\.de',
'nbci\.com\/search',
'netluchs\.de',
'netscape\.',
'netsprint\.pl',
'netstjernen\.dk',
'netzero\.net',
'no\.mirago\.com',
'northernlight\.',
'nusearch\.com',
'o2\.pl',

'ofir\.dk',
'opasia\.dk',
'orangeworld\.co\.uk',
'orbis\.dk',
'overture\.com',
'pch\.com',
'picsearch\.de',
'pictures\.com',
'plusnetwork\.com',
'pogodak\.',
'polska\.pl',
'polymeta\.hu',
'preciobarato\.xyz',
'questionanswering\.com',
'quick\.cz',
'rambler\.ru',
'recherche\.club-internet\.fr',
'rechercher\.libertysurf\.fr',
'redbox\.cz',
'rr\.com',
'sagool\.jp',
'sapo\.pt',
'schoenerbrausen\.de',
'scroogle\.org',
'search[\w\-]+\.free\.fr',
'search\.1und1\.de',
'search\.alice\.it\.master',
'search\.alice\.it',
'search\.alot\.com',
'search\.bluewin\.ch',
'search\.bt\.com',
'search\.certified-toolbar\.com',
'search\.ch',
'search\.comcast\.net',
'search\.earthlink\.net',
'search\.fbdownloader\.com',
'search\.fdownloadr\.com',
'search\.foxtab\.com',
'search\.genieo\.com',
'search\.goo\.ne\.jp',
'search\.handycafe\.com',
'search\.incredibar\.com',
'search\.incredimail\.com',
'search\.internetto\.hu',
'search\.orange\.co\.uk',
'search\.sky\.com',
'search\.sli\.sympatico\.ca',
'search\.socialdownloadr\.com',
'search\.sweetim\.com',
'search\.terra\.',
'search\.zonealarm\.com',
'searchalgo\.com',
'searchall\.com',
'searchalot\.com',
'searchcompletion\.com',
'searches\.qone8\.com',
'searches\.safehomepage\.com',
'searches\.vi-view\.com',
'searchesnavigator\.com',
'searchgol\.com',
'searchlistingsite\.com',
'searchmobileonline\.com',
'www1\.search-results\.com',
'search-results\.com',
'search-results\.mobi',
'searchsafer\.com',
'searchy\.co\.uk',
'searchya\.com',
'segnalo\.alice\.it',
'semalt\.com',
'sensis\.com\.au',
'seznam\.cz',
'shinyseek\.it',
'shoppstop\.com',
'sify\.com',
'sm\.de',
'smartsuggestor\.com',
'snapdo\.com',
'softonic\.com',
'sogou\.com',
'sok\.start\.no',
'sol\.dk',
'^www\.so\.com$',
'soso\.com',
'sphere\.com',
'splut\.',
'spotjockey\.',
'spray\.',
'sr\.searchfunmoods\.com',
'start\.iminent\.com',
'start\.shaw\.ca',
'start\.toshiba\.com',
'startpage\.com',
'startsiden',
'static\.flipora\.com',
'steadysearch\.com',
'steady-search\.com',
'stumbleupon\.com',
'suche\.1und1\.de',
'suche\.freenet\.de',
'suche\.gmx\.at',
'suche\.gmx\.net',
'suche\d?\.web\.de',
'suchen\.abacho\.de',
'sumaja\.de',
'supereva\.com',
'surfcanyon\.com',
'sweetpacks-search\.com',
'swik\.net',
'swisscows\.ch',
'szukacz\.pl',
'szukaj\.onet\.pl',
'szukaj\.wp\.pl',
'talktalk\.co\.uk',
'tango\.hu',
'teecno\.it',
'teoma\.',
'theallsearches\.com',
'three\.co\.uk',
'tiscali\.',
'tixuma\.de',
'toile\.com',
't-online\.de',
'\.t-online\.',
'turtle\.ru',
'tyfon\.dk',
'uk\.foxstart\.com',
'ukdirectory\.',
'ukindex\.co\.uk',
'ukplus\.',
'umfis\.de',
'umuwa\.de',
'uni-hannover\.de',
'^www\.usatoday\.com$',
'vindex\.',
'virgilio\.it',
'virginmedia\.com',
'vivisimo\.com',
'vizsla\.origo\.hu',
'vnet\.cn',
'voila\.',
'wahoo\.hu',
'webalta\.ru',
'webcrawler\.',
'webmania\.hu',
'websearch\.rakuten\.co\.jp',
'whorush\.com',
'windowssearch\.com',
'wisenut\.com',
'wow\.pl',
'wow\.utop\.it',
'www\.benefind\.de',
'www\.buenosearch\.com',
'www\.dregol\.com',
'www\.govome\.com',
'www\.holasearch\.com',
'www\.metasuche\.ch',
'www\.oneseek\.de',
'www\.qwant\.com',
'www\.search\.com',
'www\.startxxl\.com',
'www\.vlips\.de',
'www\.wow\.com',
'wwweasel\.de',
'xfinity\.com',
'yourbestsearch\.net',
'youtube\.com',
'zhongsou\.com',
'zoeken\.nl',
'zoznam\.sk'
);

@SearchEnginesSearchIDOrder_list2=(
# Minor search engines
);
@SearchEnginesSearchIDOrder_listgen=(
# Generic search engines
'search\..*\.\w+'
);

# NotSearchEnginesKeys
# If a search engine key is found, we check its exclude list to know if it's
# really a search engine
#------------------------------------------------------------------------------
%NotSearchEnginesKeys=(
'altavista\.'=>'babelfish\.altavista\.',
'google\.'=>'mail\.google\.',
'google\.'=>'translate\.google\.',
'google\.'=>'code\.google\.',
'google\.'=>'groups\.google\.',
'msn\.'=>'hotmail\.msn\.',
'tiscali\.'=>'mail\.tiscali\.',
# For Japanese Search Engines
# Added by Ryu 2006.03.15
'googlee\.'=>'mail\.googlee\.',
'googlee\.'=>'translate\.googlee\.',
'goo\.ne\.jp'=>'members\.goo\.ne\.jp'
);

# SearchEnginesHashID
# Each Search Engine Search ID is associated to an AWStats id string
#------------------------------------------------------------------------------
%SearchEnginesHashID = (
# Japanese Search Engines
# Added by Ryu 2007.01.06
'66\.102\.11\.104','googlejapan',
'64\.233\.179\.99','googlejapan',
'72\.14\.235\.132','google',
'74\.125\.(77|95|113|153|155)\.132','google',
'74\.125\.113\.104','google',
'209\.85\.(129|135|165|173|175|207)\.104','google',
'209\.85\.(129|135|173|175|229)\.132','google',
'216\.239\.(37\.99|39\.104|41\.104|63\.104)','googlejapan',
'webcache\.googleusercontent\.com','google_cache',
'www\.answers\.com','answers',
'search\.allabout\.co\.jp','allabout',
'search\.auone\.jp','auone',
'avabox\.jp','avabox',
'biglobe\.ne\.jp','biglobe',
'search\.cashback\.ne\.jp','cashback',
'search\.kbg\.jp','kbg',
'\.cometsystems\.com','cometsystems',
'\.cybozu\.net','cybozu',
'cache\.yahoofs\.jp','yahoocache',
'yahoo-search\.jp','yahoo',
'clusty\.jp','clustyjp',
'docomo\.ne\.jp','docomo',
'eniro\.fi','eniro',
'excite\.co\.jp','excitejapan',
'excite-cache\.jp','excitejapan',
'ezsch\.ezweb\.ne\.jp','ezweb',
'www\.fastbrowsersearch\.com','fastbrowsersearch',
'fc2\.super-search\.jp','fc2',
'find\.x0\.to','asamasearch',
'search\.fresheye\.com','fresheye',
'dir\.fresheye\.com','fresheyedir',
'goo\.ne\.jp','goo',
'google\.co\.jp','google',
'search\.idol-photo\.com','idolphoto',
'iug\.newsing\.jp','iug',
'search\.1pa2\.info','1pa2',
'search\.juno\.com','juno',
'jword\.jp','jword',
's\.luna\.tv','lunascape',
#'msnscache\.com','msn_cache',
'www\.marsflag\.com','marsflag',
'meta2\.the-search\.jp','meta2',
'bach\.istc\.kobe-u\.ac\.jp','metcha',
'meta\.rrzn\.uni-hannover\.de','metager',
'naver\.co\.jp','naverjp',
'naver\.com','navercom',
'search\.lifemile\.jp','lifemile',
'search\.50pt\.jp','50pt',
'search\.point-box\.jp','pointbox',
'sitesearch\.nikkei\.co\.jp','nikkei',
'search\.okodukai\.jp','okodukai',
'search\.aol\.jp','aoljapan',
'search\.jp\.aol\.com','aoljapan',
'search\.livedoor\.com','livedoor',
'search\.nifty\.com','nifty',
'search\.msn\.co\.jp','msnjapan',
'search\.odn\.ne\.jp','odn',
'search-hp\.com','searchhp',
'niwango\.jp','niwango',
'olane\.jp','olane',
'pex\.jp','pex',
'picsearch\.com','picsearchcom',
'picsearch\.sk','picsearchsk',
'picmy\.jp','picmy',
'www\.prsearch\.','prsearch',
'www\.so-net\.ne\.jp','sonet',
'm\.technorati\.jp','mtechnoratijp',
'www\.technorati\.jp','wtechnoratijp',
'technorati\.jp','technoratijp',
'technorati\.com','technorati',
'tocc\.co\.jp','tocc',
'www\.baidu\.jp','baidujp',
'image\.baidu\.jp','imagebaidujp',
'www\.ceek\.jp','ceekjp',
'www\.dir\.bg','dirbg',
'www\.infoseek\.co\.jp','infoseek',
'www\.megite\.com','megite',
'www\.seochat\.com','seochat',
'www\.websearch\.com','websearch',
'www\.yahoogle\.jp','yahoogle',
'yicha\.jp','yicha',
# Major search engines

'^www\.google\.co\.uk$','www_google_co_uk',
'^images\.google\.co\.uk$','images_google_co_uk',
'^translate\.google\.co\.uk$','translate_google_co_uk',
'google\.co\.uk$','google_co_uk',
'^www\.google\.com$','www_google_com',
'^images\.google\.com$','images_google_com',
'^translate\.google\.com$','translate_google_com',
'google\.com$','google_com',

'^www\.bing\.com$','www_bing_com',
'^cn\.bing\.com$','cn_bing_com',
'^global\.bing\.com$','global_bing_com',
'bing\.com$','bing_com_catchall',

'^(www\.|)yandex\.ru$','yandexru',
'^(www\.|)yandex\.com\.tr$','yandexcomtr',
'^(www\.|)yandex\.ua$','yandexua',
'^(www\.|)yandex\.kz$','yandexkz',
'^(www\.|)yandex\.com$','yandexcom',
'yandex\.','yandex',
'^ya\.ru$','ya_ru',

'^www\.google\.de$','www_google_de',
'^images\.google\.de$','images_google_de',
'^translate\.google\.de$','translate_google_de',
'google\.de$','google_de',
'^www\.google\.fr$','www_google_fr',
'^images\.google\.fr$','images_google_fr',
'^translate\.google\.fr$','translate_google_fr',
'google\.fr$','google_fr',
'^www\.google\.ca$','www_google_ca',
'^images\.google\.ca$','images_google_ca',
'^translate\.google\.ca$','translate_google_ca',
'google\.ca$','google_ca',
'^www\.google\.es$','www_google_es',
'^images\.google\.es$','images_google_es',
'^translate\.google\.es$','translate_google_es',
'google\.es$','google_es',
'^www\.google\.com\.au$','www_google_com_au',
'^images\.google\.com\.au$','images_google_com_au',
'^translate\.google\.com\.au$','translate_google_com_au',
'google\.com\.au$','google_com_au',
'^www\.google\.nl$','www_google_nl',
'^images\.google\.nl$','images_google_nl',
'^translate\.google\.nl$','translate_google_nl',
'google\.nl$','google_nl',
'^www\.google\.gr$','www_google_gr',
'^images\.google\.gr$','images_google_gr',
'^translate\.google\.gr$','translate_google_gr',
'google\.gr$','google_gr',
'^www\.google\.se$','www_google_se',
'^images\.google\.se$','images_google_se',
'^translate\.google\.se$','translate_google_se',
'google\.se$','google_se',
'^www\.google\.ie$','www_google_ie',
'^images\.google\.ie$','images_google_ie',
'^translate\.google\.ie$','translate_google_ie',
'google\.ie$','google_ie',
'^www\.google\.it$','www_google_it',
'^images\.google\.it$','images_google_it',
'^translate\.google\.it$','translate_google_it',
'google\.it$','google_it',
'^www\.google\.no$','www_google_no',
'^images\.google\.no$','images_google_no',
'^translate\.google\.no$','translate_google_no',
'google\.no$','google_no',
'^www\.google\.com\.tr$','www_google_com_tr',
'^images\.google\.com\.tr$','images_google_com_tr',
'^translate\.google\.com\.tr$','translate_google_com_tr',
'google\.com\.tr$','google_com_tr',
'^www\.google\.co\.in$','www_google_co_in',
'^images\.google\.co\.in$','images_google_co_in',
'^translate\.google\.co\.in$','translate_google_co_in',
'google\.co\.in$','google_co_in',
'^www\.google\.pt$','www_google_pt',
'^images\.google\.pt$','images_google_pt',
'^translate\.google\.pt$','translate_google_pt',
'google\.pt$','google_pt',
'^www\.google\.hr$','www_google_hr',
'^images\.google\.hr$','images_google_hr',
'^translate\.google\.hr$','translate_google_hr',
'google\.hr$','google_hr',
'^www\.google\.co\.nz$','www_google_co_nz',
'^images\.google\.co\.nz$','images_google_co_nz',
'^translate\.google\.co\.nz$','translate_google_co_nz',
'google\.co\.nz$','google_co_nz',
'^www\.google\.pl$','www_google_pl',
'^images\.google\.pl$','images_google_pl',
'^translate\.google\.pl$','translate_google_pl',
'google\.pl$','google_pl',
'^www\.google\.ac$','www_google_ac',
'^images\.google\.ac$','images_google_ac',
'^translate\.google\.ac$','translate_google_ac',
'google\.ac$','google_ac',
'^www\.google\.ad$','www_google_ad',
'^images\.google\.ad$','images_google_ad',
'^translate\.google\.ad$','translate_google_ad',
'google\.ad$','google_ad',
'^www\.google\.ae$','www_google_ae',
'^images\.google\.ae$','images_google_ae',
'^translate\.google\.ae$','translate_google_ae',
'google\.ae$','google_ae',
'^www\.google\.al$','www_google_al',
'^images\.google\.al$','images_google_al',
'^translate\.google\.al$','translate_google_al',
'google\.al$','google_al',
'^www\.google\.am$','www_google_am',
'^images\.google\.am$','images_google_am',
'^translate\.google\.am$','translate_google_am',
'google\.am$','google_am',
'^www\.google\.as$','www_google_as',
'^images\.google\.as$','images_google_as',
'^translate\.google\.as$','translate_google_as',
'google\.as$','google_as',
'^www\.google\.at$','www_google_at',
'^images\.google\.at$','images_google_at',
'^translate\.google\.at$','translate_google_at',
'google\.at$','google_at',
'^www\.google\.az$','www_google_az',
'^images\.google\.az$','images_google_az',
'^translate\.google\.az$','translate_google_az',
'google\.az$','google_az',
'^www\.google\.ba$','www_google_ba',
'^images\.google\.ba$','images_google_ba',
'^translate\.google\.ba$','translate_google_ba',
'google\.ba$','google_ba',
'^www\.google\.be$','www_google_be',
'^images\.google\.be$','images_google_be',
'^translate\.google\.be$','translate_google_be',
'google\.be$','google_be',
'^www\.google\.bf$','www_google_bf',
'^images\.google\.bf$','images_google_bf',
'^translate\.google\.bf$','translate_google_bf',
'google\.bf$','google_bf',
'^www\.google\.bg$','www_google_bg',
'^images\.google\.bg$','images_google_bg',
'^translate\.google\.bg$','translate_google_bg',
'google\.bg$','google_bg',
'^www\.google\.bi$','www_google_bi',
'^images\.google\.bi$','images_google_bi',
'^translate\.google\.bi$','translate_google_bi',
'google\.bi$','google_bi',
'^www\.google\.bj$','www_google_bj',
'^images\.google\.bj$','images_google_bj',
'^translate\.google\.bj$','translate_google_bj',
'google\.bj$','google_bj',
'^www\.google\.bs$','www_google_bs',
'^images\.google\.bs$','images_google_bs',
'^translate\.google\.bs$','translate_google_bs',
'google\.bs$','google_bs',
'^www\.google\.bt$','www_google_bt',
'^images\.google\.bt$','images_google_bt',
'^translate\.google\.bt$','translate_google_bt',
'google\.bt$','google_bt',
'^www\.google\.by$','www_google_by',
'^images\.google\.by$','images_google_by',
'^translate\.google\.by$','translate_google_by',
'google\.by$','google_by',
'^www\.google\.cat$','www_google_cat',
'^images\.google\.cat$','images_google_cat',
'^translate\.google\.cat$','translate_google_cat',
'google\.cat$','google_cat',
'^www\.google\.cc$','www_google_cc',
'^images\.google\.cc$','images_google_cc',
'^translate\.google\.cc$','translate_google_cc',
'google\.cc$','google_cc',
'^www\.google\.cd$','www_google_cd',
'^images\.google\.cd$','images_google_cd',
'^translate\.google\.cd$','translate_google_cd',
'google\.cd$','google_cd',
'^www\.google\.cf$','www_google_cf',
'^images\.google\.cf$','images_google_cf',
'^translate\.google\.cf$','translate_google_cf',
'google\.cf$','google_cf',
'^www\.google\.cg$','www_google_cg',
'^images\.google\.cg$','images_google_cg',
'^translate\.google\.cg$','translate_google_cg',
'google\.cg$','google_cg',
'^www\.google\.ch$','www_google_ch',
'^images\.google\.ch$','images_google_ch',
'^translate\.google\.ch$','translate_google_ch',
'google\.ch$','google_ch',
'^www\.google\.ci$','www_google_ci',
'^images\.google\.ci$','images_google_ci',
'^translate\.google\.ci$','translate_google_ci',
'google\.ci$','google_ci',
'^www\.google\.cl$','www_google_cl',
'^images\.google\.cl$','images_google_cl',
'^translate\.google\.cl$','translate_google_cl',
'google\.cl$','google_cl',
'^www\.google\.cm$','www_google_cm',
'^images\.google\.cm$','images_google_cm',
'^translate\.google\.cm$','translate_google_cm',
'google\.cm$','google_cm',
'^www\.google\.cn$','www_google_cn',
'^images\.google\.cn$','images_google_cn',
'^translate\.google\.cn$','translate_google_cn',
'google\.cn$','google_cn',
'^www\.google\.co\.ao$','www_google_co_ao',
'^images\.google\.co\.ao$','images_google_co_ao',
'^translate\.google\.co\.ao$','translate_google_co_ao',
'google\.co\.ao$','google_co_ao',
'^www\.google\.co\.bw$','www_google_co_bw',
'^images\.google\.co\.bw$','images_google_co_bw',
'^translate\.google\.co\.bw$','translate_google_co_bw',
'google\.co\.bw$','google_co_bw',
'^www\.google\.co\.ck$','www_google_co_ck',
'^images\.google\.co\.ck$','images_google_co_ck',
'^translate\.google\.co\.ck$','translate_google_co_ck',
'google\.co\.ck$','google_co_ck',
'^www\.google\.co\.cr$','www_google_co_cr',
'^images\.google\.co\.cr$','images_google_co_cr',
'^translate\.google\.co\.cr$','translate_google_co_cr',
'google\.co\.cr$','google_co_cr',
'^www\.google\.co\.id$','www_google_co_id',
'^images\.google\.co\.id$','images_google_co_id',
'^translate\.google\.co\.id$','translate_google_co_id',
'google\.co\.id$','google_co_id',
'^www\.google\.co\.il$','www_google_co_il',
'^images\.google\.co\.il$','images_google_co_il',
'^translate\.google\.co\.il$','translate_google_co_il',
'google\.co\.il$','google_co_il',
'^www\.google\.co\.jp$','www_google_co_jp',
'^images\.google\.co\.jp$','images_google_co_jp',
'^translate\.google\.co\.jp$','translate_google_co_jp',
'google\.co\.jp$','google_co_jp',
'^www\.google\.co\.ke$','www_google_co_ke',
'^images\.google\.co\.ke$','images_google_co_ke',
'^translate\.google\.co\.ke$','translate_google_co_ke',
'google\.co\.ke$','google_co_ke',
'^www\.google\.co\.kr$','www_google_co_kr',
'^images\.google\.co\.kr$','images_google_co_kr',
'^translate\.google\.co\.kr$','translate_google_co_kr',
'google\.co\.kr$','google_co_kr',
'^www\.google\.co\.ls$','www_google_co_ls',
'^images\.google\.co\.ls$','images_google_co_ls',
'^translate\.google\.co\.ls$','translate_google_co_ls',
'google\.co\.ls$','google_co_ls',
'^www\.google\.co\.ma$','www_google_co_ma',
'^images\.google\.co\.ma$','images_google_co_ma',
'^translate\.google\.co\.ma$','translate_google_co_ma',
'google\.co\.ma$','google_co_ma',
'^www\.google\.co\.mz$','www_google_co_mz',
'^images\.google\.co\.mz$','images_google_co_mz',
'^translate\.google\.co\.mz$','translate_google_co_mz',
'google\.co\.mz$','google_co_mz',
'^www\.google\.co\.th$','www_google_co_th',
'^images\.google\.co\.th$','images_google_co_th',
'^translate\.google\.co\.th$','translate_google_co_th',
'google\.co\.th$','google_co_th',
'^www\.google\.co\.tz$','www_google_co_tz',
'^images\.google\.co\.tz$','images_google_co_tz',
'^translate\.google\.co\.tz$','translate_google_co_tz',
'google\.co\.tz$','google_co_tz',
'^www\.google\.co\.ug$','www_google_co_ug',
'^images\.google\.co\.ug$','images_google_co_ug',
'^translate\.google\.co\.ug$','translate_google_co_ug',
'google\.co\.ug$','google_co_ug',
'^www\.google\.co\.uz$','www_google_co_uz',
'^images\.google\.co\.uz$','images_google_co_uz',
'^translate\.google\.co\.uz$','translate_google_co_uz',
'google\.co\.uz$','google_co_uz',
'^www\.google\.co\.ve$','www_google_co_ve',
'^images\.google\.co\.ve$','images_google_co_ve',
'^translate\.google\.co\.ve$','translate_google_co_ve',
'google\.co\.ve$','google_co_ve',
'^www\.google\.co\.vi$','www_google_co_vi',
'^images\.google\.co\.vi$','images_google_co_vi',
'^translate\.google\.co\.vi$','translate_google_co_vi',
'google\.co\.vi$','google_co_vi',
'^www\.google\.co\.za$','www_google_co_za',
'^images\.google\.co\.za$','images_google_co_za',
'^translate\.google\.co\.za$','translate_google_co_za',
'google\.co\.za$','google_co_za',
'^www\.google\.co\.zm$','www_google_co_zm',
'^images\.google\.co\.zm$','images_google_co_zm',
'^translate\.google\.co\.zm$','translate_google_co_zm',
'google\.co\.zm$','google_co_zm',
'^www\.google\.co\.zw$','www_google_co_zw',
'^images\.google\.co\.zw$','images_google_co_zw',
'^translate\.google\.co\.zw$','translate_google_co_zw',
'google\.co\.zw$','google_co_zw',
'^www\.google\.com\.af$','www_google_com_af',
'^images\.google\.com\.af$','images_google_com_af',
'^translate\.google\.com\.af$','translate_google_com_af',
'google\.com\.af$','google_com_af',
'^www\.google\.com\.ag$','www_google_com_ag',
'^images\.google\.com\.ag$','images_google_com_ag',
'^translate\.google\.com\.ag$','translate_google_com_ag',
'google\.com\.ag$','google_com_ag',
'^www\.google\.com\.ai$','www_google_com_ai',
'^images\.google\.com\.ai$','images_google_com_ai',
'^translate\.google\.com\.ai$','translate_google_com_ai',
'google\.com\.ai$','google_com_ai',
'^www\.google\.com\.ar$','www_google_com_ar',
'^images\.google\.com\.ar$','images_google_com_ar',
'^translate\.google\.com\.ar$','translate_google_com_ar',
'google\.com\.ar$','google_com_ar',
'^www\.google\.com\.bd$','www_google_com_bd',
'^images\.google\.com\.bd$','images_google_com_bd',
'^translate\.google\.com\.bd$','translate_google_com_bd',
'google\.com\.bd$','google_com_bd',
'^www\.google\.com\.bh$','www_google_com_bh',
'^images\.google\.com\.bh$','images_google_com_bh',
'^translate\.google\.com\.bh$','translate_google_com_bh',
'google\.com\.bh$','google_com_bh',
'^www\.google\.com\.bn$','www_google_com_bn',
'^images\.google\.com\.bn$','images_google_com_bn',
'^translate\.google\.com\.bn$','translate_google_com_bn',
'google\.com\.bn$','google_com_bn',
'^www\.google\.com\.bo$','www_google_com_bo',
'^images\.google\.com\.bo$','images_google_com_bo',
'^translate\.google\.com\.bo$','translate_google_com_bo',
'google\.com\.bo$','google_com_bo',
'^www\.google\.com\.br$','www_google_com_br',
'^images\.google\.com\.br$','images_google_com_br',
'^translate\.google\.com\.br$','translate_google_com_br',
'google\.com\.br$','google_com_br',
'^www\.google\.com\.bz$','www_google_com_bz',
'^images\.google\.com\.bz$','images_google_com_bz',
'^translate\.google\.com\.bz$','translate_google_com_bz',
'google\.com\.bz$','google_com_bz',
'^www\.google\.com\.co$','www_google_com_co',
'^images\.google\.com\.co$','images_google_com_co',
'^translate\.google\.com\.co$','translate_google_com_co',
'google\.com\.co$','google_com_co',
'^www\.google\.com\.cu$','www_google_com_cu',
'^images\.google\.com\.cu$','images_google_com_cu',
'^translate\.google\.com\.cu$','translate_google_com_cu',
'google\.com\.cu$','google_com_cu',

'^www\.google\.com\.cy$','www_google_com_cy',
'^images\.google\.com\.cy$','images_google_com_cy',
'^translate\.google\.com\.cy$','translate_google_com_cy',
'google\.com\.cy$','google_com_cy',
'^www\.google\.com\.do$','www_google_com_do',
'^images\.google\.com\.do$','images_google_com_do',
'^translate\.google\.com\.do$','translate_google_com_do',
'google\.com\.do$','google_com_do',
'^www\.google\.com\.ec$','www_google_com_ec',
'^images\.google\.com\.ec$','images_google_com_ec',
'^translate\.google\.com\.ec$','translate_google_com_ec',
'google\.com\.ec$','google_com_ec',
'^www\.google\.com\.eg$','www_google_com_eg',
'^images\.google\.com\.eg$','images_google_com_eg',
'^translate\.google\.com\.eg$','translate_google_com_eg',
'google\.com\.eg$','google_com_eg',
'^www\.google\.com\.et$','www_google_com_et',
'^images\.google\.com\.et$','images_google_com_et',
'^translate\.google\.com\.et$','translate_google_com_et',
'google\.com\.et$','google_com_et',
'^www\.google\.com\.fj$','www_google_com_fj',
'^images\.google\.com\.fj$','images_google_com_fj',
'^translate\.google\.com\.fj$','translate_google_com_fj',
'google\.com\.fj$','google_com_fj',
'^www\.google\.com\.gh$','www_google_com_gh',
'^images\.google\.com\.gh$','images_google_com_gh',
'^translate\.google\.com\.gh$','translate_google_com_gh',
'google\.com\.gh$','google_com_gh',
'^www\.google\.com\.gi$','www_google_com_gi',
'^images\.google\.com\.gi$','images_google_com_gi',
'^translate\.google\.com\.gi$','translate_google_com_gi',
'google\.com\.gi$','google_com_gi',
'^www\.google\.com\.gt$','www_google_com_gt',
'^images\.google\.com\.gt$','images_google_com_gt',
'^translate\.google\.com\.gt$','translate_google_com_gt',
'google\.com\.gt$','google_com_gt',
'^www\.google\.com\.hk$','www_google_com_hk',
'^images\.google\.com\.hk$','images_google_com_hk',
'^translate\.google\.com\.hk$','translate_google_com_hk',
'google\.com\.hk$','google_com_hk',
'^www\.google\.com\.jm$','www_google_com_jm',
'^images\.google\.com\.jm$','images_google_com_jm',
'^translate\.google\.com\.jm$','translate_google_com_jm',
'google\.com\.jm$','google_com_jm',
'^www\.google\.com\.kh$','www_google_com_kh',
'^images\.google\.com\.kh$','images_google_com_kh',
'^translate\.google\.com\.kh$','translate_google_com_kh',
'google\.com\.kh$','google_com_kh',
'^www\.google\.com\.kw$','www_google_com_kw',
'^images\.google\.com\.kw$','images_google_com_kw',
'^translate\.google\.com\.kw$','translate_google_com_kw',
'google\.com\.kw$','google_com_kw',
'^www\.google\.com\.lb$','www_google_com_lb',
'^images\.google\.com\.lb$','images_google_com_lb',
'^translate\.google\.com\.lb$','translate_google_com_lb',
'google\.com\.lb$','google_com_lb',
'^www\.google\.com\.lc$','www_google_com_lc',
'^images\.google\.com\.lc$','images_google_com_lc',
'^translate\.google\.com\.lc$','translate_google_com_lc',
'google\.com\.lc$','google_com_lc',
'^www\.google\.com\.ly$','www_google_com_ly',
'^images\.google\.com\.ly$','images_google_com_ly',
'^translate\.google\.com\.ly$','translate_google_com_ly',
'google\.com\.ly$','google_com_ly',
'^www\.google\.com\.mm$','www_google_com_mm',
'^images\.google\.com\.mm$','images_google_com_mm',
'^translate\.google\.com\.mm$','translate_google_com_mm',
'google\.com\.mm$','google_com_mm',
'^www\.google\.com\.mt$','www_google_com_mt',
'^images\.google\.com\.mt$','images_google_com_mt',
'^translate\.google\.com\.mt$','translate_google_com_mt',
'google\.com\.mt$','google_com_mt',
'^www\.google\.com\.mx$','www_google_com_mx',
'^images\.google\.com\.mx$','images_google_com_mx',
'^translate\.google\.com\.mx$','translate_google_com_mx',
'google\.com\.mx$','google_com_mx',
'^www\.google\.com\.my$','www_google_com_my',
'^images\.google\.com\.my$','images_google_com_my',
'^translate\.google\.com\.my$','translate_google_com_my',
'google\.com\.my$','google_com_my',
'^www\.google\.com\.na$','www_google_com_na',
'^images\.google\.com\.na$','images_google_com_na',
'^translate\.google\.com\.na$','translate_google_com_na',
'google\.com\.na$','google_com_na',
'^www\.google\.com\.nf$','www_google_com_nf',
'^images\.google\.com\.nf$','images_google_com_nf',
'^translate\.google\.com\.nf$','translate_google_com_nf',
'google\.com\.nf$','google_com_nf',
'^www\.google\.com\.ng$','www_google_com_ng',
'^images\.google\.com\.ng$','images_google_com_ng',
'^translate\.google\.com\.ng$','translate_google_com_ng',
'google\.com\.ng$','google_com_ng',
'^www\.google\.com\.ni$','www_google_com_ni',
'^images\.google\.com\.ni$','images_google_com_ni',
'^translate\.google\.com\.ni$','translate_google_com_ni',
'google\.com\.ni$','google_com_ni',
'^www\.google\.com\.np$','www_google_com_np',
'^images\.google\.com\.np$','images_google_com_np',
'^translate\.google\.com\.np$','translate_google_com_np',
'google\.com\.np$','google_com_np',
'^www\.google\.com\.om$','www_google_com_om',
'^images\.google\.com\.om$','images_google_com_om',
'^translate\.google\.com\.om$','translate_google_com_om',
'google\.com\.om$','google_com_om',
'^www\.google\.com\.pa$','www_google_com_pa',
'^images\.google\.com\.pa$','images_google_com_pa',
'^translate\.google\.com\.pa$','translate_google_com_pa',
'google\.com\.pa$','google_com_pa',
'^www\.google\.com\.pe$','www_google_com_pe',
'^images\.google\.com\.pe$','images_google_com_pe',
'^translate\.google\.com\.pe$','translate_google_com_pe',
'google\.com\.pe$','google_com_pe',
'^www\.google\.com\.pg$','www_google_com_pg',
'^images\.google\.com\.pg$','images_google_com_pg',
'^translate\.google\.com\.pg$','translate_google_com_pg',
'google\.com\.pg$','google_com_pg',
'^www\.google\.com\.ph$','www_google_com_ph',
'^images\.google\.com\.ph$','images_google_com_ph',
'^translate\.google\.com\.ph$','translate_google_com_ph',
'google\.com\.ph$','google_com_ph',
'^www\.google\.com\.pk$','www_google_com_pk',
'^images\.google\.com\.pk$','images_google_com_pk',
'^translate\.google\.com\.pk$','translate_google_com_pk',
'google\.com\.pk$','google_com_pk',
'^www\.google\.com\.pr$','www_google_com_pr',
'^images\.google\.com\.pr$','images_google_com_pr',
'^translate\.google\.com\.pr$','translate_google_com_pr',
'google\.com\.pr$','google_com_pr',
'^www\.google\.com\.py$','www_google_com_py',
'^images\.google\.com\.py$','images_google_com_py',
'^translate\.google\.com\.py$','translate_google_com_py',
'google\.com\.py$','google_com_py',
'^www\.google\.com\.qa$','www_google_com_qa',
'^images\.google\.com\.qa$','images_google_com_qa',
'^translate\.google\.com\.qa$','translate_google_com_qa',
'google\.com\.qa$','google_com_qa',
'^www\.google\.com\.sa$','www_google_com_sa',
'^images\.google\.com\.sa$','images_google_com_sa',
'^translate\.google\.com\.sa$','translate_google_com_sa',
'google\.com\.sa$','google_com_sa',
'^www\.google\.com\.sb$','www_google_com_sb',
'^images\.google\.com\.sb$','images_google_com_sb',
'^translate\.google\.com\.sb$','translate_google_com_sb',
'google\.com\.sb$','google_com_sb',
'^www\.google\.com\.sg$','www_google_com_sg',
'^images\.google\.com\.sg$','images_google_com_sg',
'^translate\.google\.com\.sg$','translate_google_com_sg',
'google\.com\.sg$','google_com_sg',
'^www\.google\.com\.sl$','www_google_com_sl',
'^images\.google\.com\.sl$','images_google_com_sl',
'^translate\.google\.com\.sl$','translate_google_com_sl',
'google\.com\.sl$','google_com_sl',
'^www\.google\.com\.sv$','www_google_com_sv',
'^images\.google\.com\.sv$','images_google_com_sv',
'^translate\.google\.com\.sv$','translate_google_com_sv',
'google\.com\.sv$','google_com_sv',
'^www\.google\.com\.tj$','www_google_com_tj',
'^images\.google\.com\.tj$','images_google_com_tj',
'^translate\.google\.com\.tj$','translate_google_com_tj',
'google\.com\.tj$','google_com_tj',
'^www\.google\.com\.tw$','www_google_com_tw',
'^images\.google\.com\.tw$','images_google_com_tw',
'^translate\.google\.com\.tw$','translate_google_com_tw',
'google\.com\.tw$','google_com_tw',
'^www\.google\.com\.ua$','www_google_com_ua',
'^images\.google\.com\.ua$','images_google_com_ua',
'^translate\.google\.com\.ua$','translate_google_com_ua',
'google\.com\.ua$','google_com_ua',
'^www\.google\.com\.uy$','www_google_com_uy',
'^images\.google\.com\.uy$','images_google_com_uy',
'^translate\.google\.com\.uy$','translate_google_com_uy',
'google\.com\.uy$','google_com_uy',
'^www\.google\.com\.vc$','www_google_com_vc',
'^images\.google\.com\.vc$','images_google_com_vc',
'^translate\.google\.com\.vc$','translate_google_com_vc',
'google\.com\.vc$','google_com_vc',
'^www\.google\.com\.vn$','www_google_com_vn',
'^images\.google\.com\.vn$','images_google_com_vn',
'^translate\.google\.com\.vn$','translate_google_com_vn',
'google\.com\.vn$','google_com_vn',
'^www\.google\.cv$','www_google_cv',
'^images\.google\.cv$','images_google_cv',
'^translate\.google\.cv$','translate_google_cv',
'google\.cv$','google_cv',
'^www\.google\.cz$','www_google_cz',
'^images\.google\.cz$','images_google_cz',
'^translate\.google\.cz$','translate_google_cz',
'google\.cz$','google_cz',
'^www\.google\.dj$','www_google_dj',
'^images\.google\.dj$','images_google_dj',
'^translate\.google\.dj$','translate_google_dj',
'google\.dj$','google_dj',
'^www\.google\.dk$','www_google_dk',
'^images\.google\.dk$','images_google_dk',
'^translate\.google\.dk$','translate_google_dk',
'google\.dk$','google_dk',
'^www\.google\.dm$','www_google_dm',
'^images\.google\.dm$','images_google_dm',
'^translate\.google\.dm$','translate_google_dm',
'google\.dm$','google_dm',
'^www\.google\.dz$','www_google_dz',
'^images\.google\.dz$','images_google_dz',
'^translate\.google\.dz$','translate_google_dz',
'google\.dz$','google_dz',
'^www\.google\.ee$','www_google_ee',
'^images\.google\.ee$','images_google_ee',
'^translate\.google\.ee$','translate_google_ee',
'google\.ee$','google_ee',
'^www\.google\.fi$','www_google_fi',
'^images\.google\.fi$','images_google_fi',
'^translate\.google\.fi$','translate_google_fi',
'google\.fi$','google_fi',
'^www\.google\.fm$','www_google_fm',
'^images\.google\.fm$','images_google_fm',
'^translate\.google\.fm$','translate_google_fm',
'google\.fm$','google_fm',
'^www\.google\.ga$','www_google_ga',
'^images\.google\.ga$','images_google_ga',
'^translate\.google\.ga$','translate_google_ga',
'google\.ga$','google_ga',
'^www\.google\.ge$','www_google_ge',
'^images\.google\.ge$','images_google_ge',
'^translate\.google\.ge$','translate_google_ge',
'google\.ge$','google_ge',
'^www\.google\.gf$','www_google_gf',
'^images\.google\.gf$','images_google_gf',
'^translate\.google\.gf$','translate_google_gf',
'google\.gf$','google_gf',
'^www\.google\.gg$','www_google_gg',
'^images\.google\.gg$','images_google_gg',
'^translate\.google\.gg$','translate_google_gg',
'google\.gg$','google_gg',
'^www\.google\.gl$','www_google_gl',
'^images\.google\.gl$','images_google_gl',
'^translate\.google\.gl$','translate_google_gl',
'google\.gl$','google_gl',
'^www\.google\.gm$','www_google_gm',
'^images\.google\.gm$','images_google_gm',
'^translate\.google\.gm$','translate_google_gm',
'google\.gm$','google_gm',
'^www\.google\.gp$','www_google_gp',
'^images\.google\.gp$','images_google_gp',
'^translate\.google\.gp$','translate_google_gp',
'google\.gp$','google_gp',
'^www\.google\.gy$','www_google_gy',
'^images\.google\.gy$','images_google_gy',
'^translate\.google\.gy$','translate_google_gy',
'google\.gy$','google_gy',
'^www\.google\.hn$','www_google_hn',
'^images\.google\.hn$','images_google_hn',
'^translate\.google\.hn$','translate_google_hn',
'google\.hn$','google_hn',
'^www\.google\.ht$','www_google_ht',
'^images\.google\.ht$','images_google_ht',
'^translate\.google\.ht$','translate_google_ht',
'google\.ht$','google_ht',
'^www\.google\.hu$','www_google_hu',
'^images\.google\.hu$','images_google_hu',
'^translate\.google\.hu$','translate_google_hu',
'google\.hu$','google_hu',
'^www\.google\.im$','www_google_im',
'^images\.google\.im$','images_google_im',
'^translate\.google\.im$','translate_google_im',
'google\.im$','google_im',
'^www\.google\.io$','www_google_io',
'^images\.google\.io$','images_google_io',
'^translate\.google\.io$','translate_google_io',
'google\.io$','google_io',
'^www\.google\.iq$','www_google_iq',
'^images\.google\.iq$','images_google_iq',
'^translate\.google\.iq$','translate_google_iq',
'google\.iq$','google_iq',
'^www\.google\.is$','www_google_is',
'^images\.google\.is$','images_google_is',
'^translate\.google\.is$','translate_google_is',
'google\.is$','google_is',
'^www\.google\.je$','www_google_je',
'^images\.google\.je$','images_google_je',
'^translate\.google\.je$','translate_google_je',
'google\.je$','google_je',
'^www\.google\.jo$','www_google_jo',
'^images\.google\.jo$','images_google_jo',
'^translate\.google\.jo$','translate_google_jo',
'google\.jo$','google_jo',
'^www\.google\.kg$','www_google_kg',
'^images\.google\.kg$','images_google_kg',
'^translate\.google\.kg$','translate_google_kg',
'google\.kg$','google_kg',
'^www\.google\.ki$','www_google_ki',
'^images\.google\.ki$','images_google_ki',
'^translate\.google\.ki$','translate_google_ki',
'google\.ki$','google_ki',
'^www\.google\.kz$','www_google_kz',
'^images\.google\.kz$','images_google_kz',
'^translate\.google\.kz$','translate_google_kz',
'google\.kz$','google_kz',
'^www\.google\.la$','www_google_la',
'^images\.google\.la$','images_google_la',
'^translate\.google\.la$','translate_google_la',
'google\.la$','google_la',
'^www\.google\.li$','www_google_li',
'^images\.google\.li$','images_google_li',
'^translate\.google\.li$','translate_google_li',
'google\.li$','google_li',
'^www\.google\.lk$','www_google_lk',
'^images\.google\.lk$','images_google_lk',
'^translate\.google\.lk$','translate_google_lk',
'google\.lk$','google_lk',
'^www\.google\.lt$','www_google_lt',
'^images\.google\.lt$','images_google_lt',
'^translate\.google\.lt$','translate_google_lt',
'google\.lt$','google_lt',
'^www\.google\.lu$','www_google_lu',
'^images\.google\.lu$','images_google_lu',
'^translate\.google\.lu$','translate_google_lu',
'google\.lu$','google_lu',
'^www\.google\.lv$','www_google_lv',
'^images\.google\.lv$','images_google_lv',
'^translate\.google\.lv$','translate_google_lv',
'google\.lv$','google_lv',
'^www\.google\.md$','www_google_md',
'^images\.google\.md$','images_google_md',
'^translate\.google\.md$','translate_google_md',
'google\.md$','google_md',
'^www\.google\.me$','www_google_me',
'^images\.google\.me$','images_google_me',
'^translate\.google\.me$','translate_google_me',
'google\.me$','google_me',
'^www\.google\.mg$','www_google_mg',
'^images\.google\.mg$','images_google_mg',
'^translate\.google\.mg$','translate_google_mg',
'google\.mg$','google_mg',
'^www\.google\.mk$','www_google_mk',
'^images\.google\.mk$','images_google_mk',
'^translate\.google\.mk$','translate_google_mk',
'google\.mk$','google_mk',
'^www\.google\.ml$','www_google_ml',
'^images\.google\.ml$','images_google_ml',
'^translate\.google\.ml$','translate_google_ml',
'google\.ml$','google_ml',
'^www\.google\.mn$','www_google_mn',
'^images\.google\.mn$','images_google_mn',
'^translate\.google\.mn$','translate_google_mn',
'google\.mn$','google_mn',
'^www\.google\.ms$','www_google_ms',
'^images\.google\.ms$','images_google_ms',
'^translate\.google\.ms$','translate_google_ms',
'google\.ms$','google_ms',
'^www\.google\.mu$','www_google_mu',
'^images\.google\.mu$','images_google_mu',
'^translate\.google\.mu$','translate_google_mu',
'google\.mu$','google_mu',
'^www\.google\.mv$','www_google_mv',
'^images\.google\.mv$','images_google_mv',
'^translate\.google\.mv$','translate_google_mv',
'google\.mv$','google_mv',
'^www\.google\.mw$','www_google_mw',
'^images\.google\.mw$','images_google_mw',
'^translate\.google\.mw$','translate_google_mw',
'google\.mw$','google_mw',
'^www\.google\.ne$','www_google_ne',
'^images\.google\.ne$','images_google_ne',
'^translate\.google\.ne$','translate_google_ne',
'google\.ne$','google_ne',
'^www\.google\.nr$','www_google_nr',
'^images\.google\.nr$','images_google_nr',
'^translate\.google\.nr$','translate_google_nr',
'google\.nr$','google_nr',
'^www\.google\.nu$','www_google_nu',
'^images\.google\.nu$','images_google_nu',
'^translate\.google\.nu$','translate_google_nu',
'google\.nu$','google_nu',
'^www\.google\.pn$','www_google_pn',
'^images\.google\.pn$','images_google_pn',
'^translate\.google\.pn$','translate_google_pn',
'google\.pn$','google_pn',
'^www\.google\.ps$','www_google_ps',
'^images\.google\.ps$','images_google_ps',
'^translate\.google\.ps$','translate_google_ps',
'google\.ps$','google_ps',
'^www\.google\.ro$','www_google_ro',
'^images\.google\.ro$','images_google_ro',
'^translate\.google\.ro$','translate_google_ro',
'google\.ro$','google_ro',
'^www\.google\.rs$','www_google_rs',
'^images\.google\.rs$','images_google_rs',
'^translate\.google\.rs$','translate_google_rs',
'google\.rs$','google_rs',
'^www\.google\.ru$','www_google_ru',
'^images\.google\.ru$','images_google_ru',
'^translate\.google\.ru$','translate_google_ru',
'google\.ru$','google_ru',
'^www\.google\.rw$','www_google_rw',
'^images\.google\.rw$','images_google_rw',
'^translate\.google\.rw$','translate_google_rw',
'google\.rw$','google_rw',
'^www\.google\.sc$','www_google_sc',
'^images\.google\.sc$','images_google_sc',
'^translate\.google\.sc$','translate_google_sc',
'google\.sc$','google_sc',
'^www\.google\.sh$','www_google_sh',
'^images\.google\.sh$','images_google_sh',
'^translate\.google\.sh$','translate_google_sh',
'google\.sh$','google_sh',
'^www\.google\.si$','www_google_si',
'^images\.google\.si$','images_google_si',
'^translate\.google\.si$','translate_google_si',
'google\.si$','google_si',
'^www\.google\.sk$','www_google_sk',
'^images\.google\.sk$','images_google_sk',
'^translate\.google\.sk$','translate_google_sk',
'google\.sk$','google_sk',
'^www\.google\.sm$','www_google_sm',
'^images\.google\.sm$','images_google_sm',
'^translate\.google\.sm$','translate_google_sm',
'google\.sm$','google_sm',
'^www\.google\.sn$','www_google_sn',
'^images\.google\.sn$','images_google_sn',
'^translate\.google\.sn$','translate_google_sn',
'google\.sn$','google_sn',
'^www\.google\.so$','www_google_so',
'^images\.google\.so$','images_google_so',
'^translate\.google\.so$','translate_google_so',
'google\.so$','google_so',
'^www\.google\.sr$','www_google_sr',
'^images\.google\.sr$','images_google_sr',
'^translate\.google\.sr$','translate_google_sr',
'google\.sr$','google_sr',
'^www\.google\.st$','www_google_st',
'^images\.google\.st$','images_google_st',
'^translate\.google\.st$','translate_google_st',
'google\.st$','google_st',
'^www\.google\.td$','www_google_td',
'^images\.google\.td$','images_google_td',
'^translate\.google\.td$','translate_google_td',
'google\.td$','google_td',
'^www\.google\.tg$','www_google_tg',
'^images\.google\.tg$','images_google_tg',
'^translate\.google\.tg$','translate_google_tg',
'google\.tg$','google_tg',
'^www\.google\.tk$','www_google_tk',
'^images\.google\.tk$','images_google_tk',
'^translate\.google\.tk$','translate_google_tk',
'google\.tk$','google_tk',
'^www\.google\.tl$','www_google_tl',
'^images\.google\.tl$','images_google_tl',
'^translate\.google\.tl$','translate_google_tl',
'google\.tl$','google_tl',
'^www\.google\.tm$','www_google_tm',
'^images\.google\.tm$','images_google_tm',
'^translate\.google\.tm$','translate_google_tm',
'google\.tm$','google_tm',
'^www\.google\.tn$','www_google_tn',
'^images\.google\.tn$','images_google_tn',
'^translate\.google\.tn$','translate_google_tn',
'google\.tn$','google_tn',
'^www\.google\.to$','www_google_to',
'^images\.google\.to$','images_google_to',
'^translate\.google\.to$','translate_google_to',
'google\.to$','google_to',
'^www\.google\.tt$','www_google_tt',
'^images\.google\.tt$','images_google_tt',
'^translate\.google\.tt$','translate_google_tt',
'google\.tt$','google_tt',
'^www\.google\.us$','www_google_us',
'^images\.google\.us$','images_google_us',
'^translate\.google\.us$','translate_google_us',
'google\.us$','google_us',
'^www\.google\.vg$','www_google_vg',
'^images\.google\.vg$','images_google_vg',
'^translate\.google\.vg$','translate_google_vg',
'google\.vg$','google_vg',
'^www\.google\.vu$','www_google_vu',
'^images\.google\.vu$','images_google_vu',
'^translate\.google\.vu$','translate_google_vu',
'google\.vu$','google_vu',
'^www\.google\.ws$','www_google_ws',
'^images\.google\.ws$','images_google_ws',
'^translate\.google\.ws$','translate_google_ws',
'google\.ws$','google_ws',


'babylon\.com','babylon',
'search\.conduit\.com','conduit',
'avg\.com','avg',
'mywebsearch\.com','mywebsearch',

'msn\.','msn',
'live\.com','live',

'search\.aol\.co\.uk','aoluk',
'searcht\.aol\.co\.uk','aoluk',
'searcht\.aol\.com','aolcom',
'search\.aol\.com','aolcom',
'recherche\.aol\.fr','aolfr',
'suche\.aol\.de','aolde',
'de\.aolsearch\.com','aolsearchde',
'sucheaol\.aol\.de','sucheaolde',
'search\.hp\.my\.aol\.co\.uk','hp_my_aol',
'search\.aol\.pl','aolpl',
'o2suche\.aol\.de','aol_o2suche_de',
'search\.aol\.','aolcatchall',

'^uk\.ask\.com$','askuk',
'^de\.ask\.com$','askde',
'tb\.ask\.com$','tbask',
'^images\.ask\.com$','askimages',

'base\.google\.','google_base',
'froogle\.google\.','google_froogle',
'google\.[\w.]+/products','google_products',
'googlecom\.com','google_catchall',
'groups\.google\.','google_groups',
'googlee\.','google_catchall',

'216\.239\.32\.20','google_catchall',
'173\.194\.32\.223','google_catchall',
'216\.239\.(35|37|39|51)\.100','google_cache',
'216\.239\.(35|37|39|51)\.101','google_cache',
'216\.239\.5[0-9]\.104','google_cache',
'64\.233\.1[0-9]{2}\.104','google_cache',
'66\.102\.[1-9]\.104','google_cache',
'66\.249\.93\.104','google_cache',
'72\.14\.2[0-9]{2}\.104','google_cache',

'maps\.google','google_maps',
'translate\.google','google_translate',
'173\.194\.35\.177','googleByIP',
'android\.googlequicksearchbox','android_googlequicksearchbox',
'google\.','google_catchall',

'^ar\.images\.search\.yahoo\.com$','ar_images_search_yahoo_com',
'^ar\.search\.yahoo\.com$','ar_search_yahoo_com',
'^at\.images\.search\.yahoo\.com$','at_images_search_yahoo_com',
'^at\.search\.yahoo\.com$','at_search_yahoo_com',
'^au\.images\.search\.yahoo\.com$','au_images_search_yahoo_com',
'^au\.search\.yahoo\.com$','au_search_yahoo_com',
'^br\.images\.search\.yahoo\.com$','br_images_search_yahoo_com',
'^br\.search\.yahoo\.com$','br_search_yahoo_com',
'^ca\.images\.search\.yahoo\.com$','ca_images_search_yahoo_com',
'^ca\.search\.yahoo\.com$','ca_search_yahoo_com',
'^ca\.yhs4\.search\.yahoo\.com$','ca_yhs4_search_yahoo_com',
'^ch\.images\.search\.yahoo\.com$','ch_images_search_yahoo_com',
'^ch\.yhs4\.search\.yahoo\.com$','ch_yhs4_search_yahoo_com',
'^de\.search\.yahoo\.com$','de_search_yahoo_com',
'^de\.yhs4\.search\.yahoo\.com$','de_yhs4_search_yahoo_com',
'^es\.images\.search\.yahoo\.com$','es_images_search_yahoo_com',
'^es\.search\.yahoo\.com$','es_search_yahoo_com',
'^es\.yhs4\.search\.yahoo\.com$','es_yhs4_search_yahoo_com',
'^espanol\.images\.search\.yahoo\.com$','espanol_images_search_yahoo_com',
'^espanol\.search\.yahoo\.com$','espanol_search_yahoo_com',
'^fr\.images\.search\.yahoo\.com$','fr_images_search_yahoo_com',
'^fr\.search\.yahoo\.com$','fr_search_yahoo_com',
'^fr\.yhs4\.search\.yahoo\.com$','fr_yhs4_search_yahoo_com',
'^gr\.search\.yahoo\.com$','gr_search_yahoo_com',
'^gr\.yhs4\.search\.yahoo\.com$','gr_yhs4_search_yahoo_com',
'^hk\.image\.search\.yahoo\.com$','hk_image_search_yahoo_com',
'^hk\.images\.search\.yahoo\.com$','hk_images_search_yahoo_com',
'^hk\.search\.yahoo\.com$','hk_search_yahoo_com',
'^id\.images\.search\.yahoo\.com$','id_images_search_yahoo_com',
'^id\.search\.yahoo\.com$','id_search_yahoo_com',
'^id\.yhs4\.search\.yahoo\.com$','id_yhs4_search_yahoo_com',
'^ie\.search\.yahoo\.com$','ie_search_yahoo_com',
'^image\.search\.yahoo\.co\.jp$','image_search_yahoo_co_jp',
'^images\.search\.yahoo\.com$','images_search_yahoo_com',
'^in\.images\.search\.yahoo\.com$','in_images_search_yahoo_com',
'^in\.search\.yahoo\.com$','in_search_yahoo_com',
'^in\.yhs4\.search\.yahoo\.com$','in_yhs4_search_yahoo_com',
'^it\.images\.search\.yahoo\.com$','it_images_search_yahoo_com',
'^it\.search\.yahoo\.com$','it_search_yahoo_com',
'^it\.yhs4\.search\.yahoo\.com$','it_yhs4_search_yahoo_com',
'^kr\.search\.yahoo\.com$','kr_search_yahoo_com',
'^malaysia\.images\.search\.yahoo\.com$','malaysia_images_search_yahoo_com',
'^malaysia\.search\.yahoo\.com$','malaysia_search_yahoo_com',
'^mx\.images\.search\.yahoo\.com$','mx_images_search_yahoo_com',
'^mx\.search\.yahoo\.com$','mx_search_yahoo_com',
'^nl\.images\.search\.yahoo\.com$','nl_images_search_yahoo_com',
'^nl\.search\.yahoo\.com$','nl_search_yahoo_com',
'^nl\.yhs4\.search\.yahoo\.com$','nl_yhs4_search_yahoo_com',
'^no\.search\.yahoo\.com$','no_search_yahoo_com',
'^nz\.search\.yahoo\.com$','nz_search_yahoo_com',
'^pe\.images\.search\.yahoo\.com$','pe_images_search_yahoo_com',
'^ph\.images\.search\.yahoo\.com$','ph_images_search_yahoo_com',
'^ph\.search\.yahoo\.com$','ph_search_yahoo_com',
'^ph\.yhs4\.search\.yahoo\.com$','ph_yhs4_search_yahoo_com',
'^pl\.yhs4\.search\.yahoo\.com$','pl_yhs4_search_yahoo_com',
'^qc\.images\.search\.yahoo\.com$','qc_images_search_yahoo_com',
'^qc\.search\.yahoo\.com$','qc_search_yahoo_com',
'^r\.search\.yahoo\.com$','r_search_yahoo_com',
'^ru\.images\.search\.yahoo\.com$','ru_images_search_yahoo_com',
'^se\.images\.search\.yahoo\.com$','se_images_search_yahoo_com',
'^se\.search\.yahoo\.com$','se_search_yahoo_com',
'^se\.yhs4\.search\.yahoo\.com$','se_yhs4_search_yahoo_com',
'^search\.yahoo\.co\.jp$','search_yahoo_co_jp',
'^search\.yahoo\.com$','search_yahoo_com',
'^sg\.images\.search\.yahoo\.com$','sg_images_search_yahoo_com',
'^sg\.search\.yahoo\.com$','sg_search_yahoo_com',
'^sg\.yhs4\.search\.yahoo\.com$','sg_yhs4_search_yahoo_com',
'^tr\.yhs4\.search\.yahoo\.com$','tr_yhs4_search_yahoo_com',
'^tw\.image\.search\.yahoo\.com$','tw_image_search_yahoo_com',
'^tw\.images\.search\.yahoo\.com$','tw_images_search_yahoo_com',
'^tw\.search\.yahoo\.com$','tw_search_yahoo_com',
'^uk\.images\.search\.yahoo\.com$','uk_images_search_yahoo_com',
'^uk\.search\.yahoo\.com$','uk_search_yahoo_com',
'^uk\.yhs\.search\.yahoo\.com$','uk_yhs_search_yahoo_com',
'^uk\.yhs4\.search\.yahoo\.com$','uk_yhs4_search_yahoo_com',

'^us\.search\.yahoo\.com$','us_search_yahoo_com',
'^us\.yhs4\.search\.yahoo\.com$','us_yhs4_search_yahoo_com',
'^vn\.images\.search\.yahoo\.com$','vn_images_search_yahoo_com',

'mail\.yahoo\.net','yahoo_catchall',
'(66\.218\.71\.225|216\.109\.117\.135|216\.109\.125\.130|66\.218\.69\.11)','yahoo_catchall',
'mindset\.research\.yahoo','yahoo_mindset',

'images\.search\.yahoo','images_search_yahoo_catchall',
'yhs4\.search\.yahoo','yhs4_search_yahoo_catchall',
'search\.yahoo','search_yahoo_catchall',
'yahoo','yahoo_catchall',

'^www\.ask\.jp$','askjp',
'^es\.ask\.com$','askes',
'^fr\.ask\.com$','askfr',
'^www\.iask\.com$','iask',
'^it\.ask\.com$','askit',
'^nl\.ask\.com$','asknl',
'(^|\.)ask\.com$','askcatchall',

'www\.tesco\.net','tesco',
'yell\.','yell',
'zapmeta\.ch','zapmeta_ch',
'zapmeta\.com','zapmeta_com',
'zapmeta\.de','zapmeta_de',
'zapmeta\.it','zapmeta_it',
'fr\.zapmeta\.ws','fr_zapmeta_ws',
'zapmeta\.ws','zapmeta_ws',
'zapmeta','zapmeta_catchall',

'(^|\.)go\.com','go',
'(161\.58\.227\.204|161\.58\.247\.101|212\.40\.165\.90|213\.133\.108\.202|217\.160\.108\.151|217\.160\.111\.99|217\.160\.131\.108|217\.160\.142\.227|217\.160\.176\.42)','metacrawler_de',
'\.facemoods\.com','facemoods',
'\.funmoods\.com','funmoods',
'\.metasearch\.','metasearch',
'\.wow\.com','wowuk',
'163\.com','netease',
'1klik\.dk','1klik',
'1search-board\.com','1search',
'212\.227\.33\.241','metaspinner',
'3721\.com','3721',
'4-counter\.com','google4counter',
'a9\.com','a9',
'accoona\.com','accoona',
'alexa\.com','alexa',
'allesklar\.de','allesklar',
'alltheweb\.com','alltheweb',
'altavista\.','altavista',
'amazon\.','amazon',
'androidsearch\.com','androidsearch',
'answerbus\.com','answerbus',
'anzwers\.com\.au','anzwers',
'aport\.ru','aport',
'arianna\.libero\.it','arianna',
'as\.starware\.com','comettoolbar',
'asevenboard\.com','asevenboard',
'atlanticbb\.net','atlanticbb',
'atlas\.cz','atlas',
'atomz\.','atomz',
'att\.net','att',
'auone\.jp','auone',
'avantfind\.com','avantfind',
'image\.baidu\.com','image_baidu',
'baidu\.com','baidu',
'bbc\.co\.uk/cgi-bin/search','bbc',
'biglotron\.com','biglotron',
'blekko\.com','blekko',
'blingo\.com','blingo',
'boatdesign\.net','boatdesign',
'bungeebonesdotcom','bungeebonesdotcom',
'^burett\.pagelink\.si$','burett_pagelink_si',
'centraldatabase\.org','centraldatabase',
'centrum\.cz','centrum',
'centurylink\.net','centurylink',
'charter\.net','charter',
'chatzum\.com','chatzum',
'checkparams\.com','checkparams',
'chello\.at','chelloat',
'chello\.be','chellobe',
'chello\.cz','chellocz',
'chello\.fr','chellofr',
'chello\.hu','chellohu',
'chello\.nl','chellonl',
'chello\.no','chellono',
'chello\.pl','chellopl',
'chello\.se','chellose',
'chello\.sk','chellosk',
'chello','chellocom',
'claro-search\.com','clarosearch',
'clinck\.in','clinck',
'clusty\.com','clusty',
'copernic\.com','copernic',
'crawler\.com','crawler',
'csillamker\.hu','csillamker',
'ctrouve\.','ctrouve',
'dalesearch\.com','dalesearch',
'danielsen\.com','danielsen',
'daum\.net','daum',
'de\.dolphin\.com','de_dolphin_com',
'de\.wiki\.gov\.cn','de_wiki_gov_cn',
'de\.wow\.com','wowsearch',
'dealwifi\.com','dealwifi_com',
'dejanews\.','dejanews',
'del\.icio\.us','delicious',
'delta-search','delta-search',
'digg\.com','digg',
'dmoz\.org','dmoz',
'dodaj\.pl','dodajpl',
'dogpile\.com','dogpile',
'duckduckgo','duckduckgo',
'easysearch\.org\.uk','easysearch',
'ecosia\.org','ecosia',
'edderkoppen\.dk','edderkoppen',
'engine\.exe','engine',
'eniro\.no','eniro',
'eniro\.se','enirose',
'ereadingsource\.com','ereadingsource',
'es\.mirago\.com','miragoes',
'etools\.ch','etools_ch',
'euroseek\.','euroseek',
'everyclick\.com','everyclick',
'evreka\.passagen\.se','passagen',
'excite\.','excite',

'extern\.peoplecheck\.de','peoplecheck_de',
'fastbot\.de','fastbot_de',
'find\.dk','finddk',
'find1friend\.com','find1friend',
'findamo\.com','findamo',
'findarticles\.com','findarticles',
'fireball\.de','fireball',
'forums\.iboats\.com','iboats',
'foxstart\.com','foxstart',
'francite\.','francite',
'gazeta\.pl','gazetapl',
'gery\.pl','gerypl',
'globososo\.','globososo',
'go\.mail\.ru','go_mail_ru',
'go\.speedbit\.com','speedbit',
'go2net\.com','go2net',
'godado','godado',
'goggle\.co\.hu$','goggle (what)',
'goliat\.hu','goliat',
'goodsearch\.com','goodsearch',
'gotuneed\.com','gotuneed',
'haku\.www\.fi','haku',
'heureka\.hu','heureka',
'hoga\.pl','hogapl',
'hotbot\.','hotbot',
'hubwe\.net','hubwe',
'icerocket\.com','icerocket',
'icq\.com\/search','icq',
'ifind\.freeserve','freeserve',
'ilse\.','ilse',
'inbox\.com','inbox',
'index\.hu','indexhu',
'ineffabile\.it','ineffabile',
'intelseek\.com','intelseek_com',
'^www\.info\.com$','www_info_com',
'info\.co\.uk','infouk',
'infoseek\.de','infoseek',
'infospace\.com','infospace',
'inspsearch\.com','inspsearch',
'int\.search\.myway\.com','int_search_myway_com',
'int\.search-results\.com','nortonsavesearch',
'interia\.pl','interiapl',
'isearch\.nation\.com','isearch_nation_com',
'i-une\.com','iune',
'ixquick\.com','ixquick',
'izito\.co\.uk','izito_uk',
'izito\.co\.de','izito_de',
'izito\.','izito_catchall',
'jubii\.dk','jubii',
'jumpy\.it','jumpyit',
'startjuno\.com','startjuno_com',
'juno\.com','juno',
'jyxo\.(cz|com)','jyxo',
'kartoo\.com','kartoo',
'katalog\.onet\.pl','katalogonetpl',
'kataweb\.it','kataweb',
'kereso\.startlap\.hu','startlap_hu',
'keresolap\.hu','keresolap_hu',
'kvasir\.','kvasir',
'kvitters\.','kvitters',
'lapkereso\.hu','lapkereso_hu',
'lbb\.org','lbb',
'ledix\.net','ledix',
'libero\.it/','libero',
'localmoxie\.com','localmoxie',
'looksmart\.co\.uk','looksmart_co_uk',
'looksmart\.','looksmart_catchall',
'lycos\.','lycos',
'mamma\.','mamma',
'meinestadt\.de','meinestadt',
'meta\.ua','metaua',
'metabot\.ru','metabot',
'metacrawler\.','metacrawler',
'metager\.de','metager',
'miner\.bol\.com\.br','miner',
'mirago\.be','miragobe',
'mirago\.ch','miragoch',
'mirago\.co\.uk','miragocouk',
'mirago\.de','miragode',
'mirago\.dk','miragodk',
'mirago\.fr','miragofr',
'mirago\.it','miragoit',
'mirago\.nl','miragonl',
'mirago\.se','miragose',
'mirago','mirago',
'mitrasites\.com','mitrasites',
'mozbot\.fr','mozbot',
'my\.allgameshome\.com','allgameshome',
'mys\.yoursearch\.me','mys_yoursearch_me',
'mysearch\.','mysearch',
'mysearchdial\.com','mysearchdial',
'mysearchresults\.com','mysearchresults',
'myway\.com','myway',
'najdi\.to','najdi',
'nation\.','nation',
'navigationshilfe\.t-online\.de','navigationshilfe_t_online',
'nbci\.com\/search','nbci',
'netluchs\.de','netluchs',
'netscape\.','netscape',
'netsprint\.pl','netsprintpl',
'netstjernen\.dk','netstjernen',
'netzero\.net','netzero',
'no\.mirago\.com','miragono',
'northernlight\.','northernlight',
'nusearch\.com','nusearch',
'o2\.pl','o2pl',
'ofir\.dk','ofir',
'opasia\.dk','opasia',
'orangeworld\.co\.uk','orangeworld',
'orbis\.dk','orbis',
'overture\.com','overture',
'pch\.com','pch',
'picsearch\.de','picsearch',
'pictures\.com','pictures',
'plusnetwork\.com','plusnetwork',
'pogodak\.','pogodak',
'polska\.pl','polskapl',
'polymeta\.hu','polymeta_hu',
'preciobarato\.xyz','preciobarato_xyz',
'questionanswering\.com','questionanswering',
'quick\.cz','quick',
'rambler\.ru','rambler',
'recherche\.club-internet\.fr','clubinternet',
'rechercher\.libertysurf\.fr','libertysurf',
'redbox\.cz','redbox',
'rr\.com','rr',
'sagool\.jp','sagool',
'sapo\.pt','sapo',
'schoenerbrausen\.de','schoenerbrausen',
'scroogle\.org','scroogle',
'search[\w\-]+\.free\.fr','free',
'search\.1und1\.de','search_1und1_de',
'search\.alice\.it\.master','aliceitmaster',
'search\.alice\.it','aliceit',
'search\.alot\.com','alot',
'search\.bluewin\.ch','bluewin',
'search\.bt\.com','bt',
'search\.certified-toolbar\.com','certifiedtoolbarsearch',
'search\.ch','searchch',
'search\.comcast\.net','comcast',
'search\.earthlink\.net','earthlink',
'search\.fbdownloader\.com','fbdownloader',
'search\.fdownloadr\.com','fdownloadr_com',
'search\.foxtab\.com','search_foxtab_com',
'search\.genieo\.com','genieo',
'search\.goo\.ne\.jp','ichiro',
'search\.handycafe\.com','handycafe',
'search\.incredibar\.com','incredibar',
'search\.incredimail\.com','incredimail',
'search\.internetto\.hu','internetto',
'search\.orange\.co\.uk','orange',
'search\.sky\.com','sky',
'search\.sli\.sympatico\.ca','sympatico',
'search\.socialdownloadr\.com','search_socialdownloadr_com',
'search\.sweetim\.com','sweetim',
'search\.terra\.','terra',
'search\.zonealarm\.com','search_zonealarm_com',
'searchalgo\.com','searchalgo',
'searchall\.com','searchall_com',
'searchalot\.com','searchalot',
'searchcompletion\.com','searchcompletion',
'searches\.qone8\.com','searches_qone8_com',
'searches\.safehomepage\.com','safehomepage_com',
'searches\.vi-view\.com','vi-view_com',
'searchesnavigator\.com','searchesnavigator',
'searchgol\.com','searchgol',
'searchlistingsite\.com','searchlistingsite',
'searchmobileonline\.com','searchmobileonline',
'www1\.search-results\.com','searchresults',
'search-results\.com','searchresultscom',
'search-results\.mobi','searchresultsmobi',
'searchsafer\.com','searchsafer',
'searchy\.co\.uk','searchy',
'searchya\.com','searchya',
'segnalo\.alice\.it','segnalo',
'semalt\.com','semalt',
'sensis\.com\.au','sensis',
'seznam\.cz','seznam',
'shinyseek\.it','shinyseek\.it',
'shoppstop\.com','shoppstop',
'sify\.com','sify',
'sm\.de','smde',
'smartsuggestor\.com','smartsuggestor',
'snapdo\.com','snapdo',
'softonic\.com','softonic',
'sogou\.com','sogou',
'sok\.start\.no','start',
'sol\.dk','sol',
'^www\.so\.com$','so_com',
'soso\.com','soso',
'sphere\.com','sphere',
'splut\.','splut',
'spotjockey\.','spotjockey',
'spray\.','spray',
'sr\.searchfunmoods\.com','searchfunmoods',
'start\.iminent\.com','iminent',
'start\.shaw\.ca','shawca',
'start\.toshiba\.com','toshiba',
'startpage\.com','startpage',
'startsiden','startsiden',
'static\.flipora\.com','flipora',
'steadysearch\.com','steadysearch',
'steady-search\.com','steadysearch',
'stumbleupon\.com','stumbleupon',
'suche\.1und1\.de','1und1_de',
'suche\.freenet\.de','freenet_de',
'suche\.gmx\.at','gmxsuche_at',
'suche\.gmx\.net','gmxsuche',
'suche\d?\.web\.de','webde',
'suchen\.abacho\.de','abacho',
'sumaja\.de','sumaja',
'supereva\.com','supereva',
'surfcanyon\.com','surfcanyon_com',
'sweetpacks-search\.com','sweetpacks',
'swik\.net','swik',
'swisscows\.ch','swisscows_ch',
'szukacz\.pl','szukaczpl',
'szukaj\.onet\.pl','onetpl',
'szukaj\.wp\.pl','wp',
'talktalk\.co\.uk','talktalk_uk',
'tango\.hu','tango_hu',
'teecno\.it','teecnoit',
'teoma\.','teoma',
'theallsearches\.com','theallsearches',
'three\.co\.uk','three',
'tiscali\.','tiscali',
'tixuma\.de','tixuma_de',
'toile\.com','toile',
't-online\.de','t_online_de',
'\.t-online\.','t_online_catchall',
'turtle\.ru','turtle',
'tyfon\.dk','tyfon',
'uk\.foxstart\.com','uk_foxstart_com',
'ukdirectory\.','ukdirectory',
'ukindex\.co\.uk','ukindex',
'ukplus\.','ukplus',
'umfis\.de','umfis',
'umuwa\.de','umuwa_de',
'uni-hannover\.de','metahannover',
'^www\.usatoday\.com$','usatoday',
'vindex\.','vindex',
'virgilio\.it','virgilio',
'virginmedia\.com','virginmedia',
'vivisimo\.com','vivisimo',
'vizsla\.origo\.hu','origo',
'vnet\.cn','vnet',
'voila\.','voila',
'wahoo\.hu','wahoo',
'webalta\.ru','webalta',
'webcrawler\.','webcrawler',
'webmania\.hu','webmania',
'websearch\.rakuten\.co\.jp','rakuten',
'whorush\.com','whorush_com',
'windowssearch\.com','windowssearch_com',
'wisenut\.com','wisenut',
'wow\.pl','wowpl',
'wow\.utop\.it','wow_utop_it',
'www\.benefind\.de','benefind',
'www\.buenosearch\.com','www_buenosearch_com',
'www\.dregol\.com','www_dregol_com',
'www\.govome\.com','govome',
'www\.holasearch\.com','holasearch',
'www\.metasuche\.ch','metasuche_ch',
'www\.oneseek\.de','oneseek_de',
'www\.qwant\.com','qwant_com',
'www\.search\.com','search_com',
'www\.startxxl\.com','startxxl',
'www\.vlips\.de','vlips_de',
'www\.wow\.com','www_wow_com',
'wwweasel\.de','wwweasel',
'xfinity\.com','xfinity_com',
'yourbestsearch\.net','yourbestsearch',
'youtube\.com','youtube',
'zhongsou\.com','zhongsou',
'zoeken\.nl','zoeken',
'zoznam\.sk','zoznam',
# Generic search engines
'search\..*\.\w+','search'
);

# SearchEnginesWithKeysNotInQuery
# List of search engines that store keyword as page instead of query parameter
#------------------------------------------------------------------------------
%SearchEnginesWithKeysNotInQuery=(
'a9',1,   # www.a9.com/searchkey1%20searchkey2
'iminent',1, #http://start.iminent.com/StartWeb/1031/toolbox/#q=searchkey1%20searchkey2&additional_arguments
'de_wiki_gov_cn',1, #http://de.wiki.gov.cn/s_searchkey1%20searchkey2
'umuwa_de', 1, #http://umuwa.de/searchkey or http://umuwa.de/searchkey/Images
'amazonsearch', 1, #http://www.amazon.de/gp/bit/apps/web/SERP/search/ref=bit_bds-p24_serp_cr_de?ie=UTF8tagbase=bds-p24&query=deutsch+8.+klasse+gymnasium+protokoll
'answers',1,	# www.answers.com/searckey1%20searchkey2
'fresheyedir',1,	# dir.fresheye.com/ds/kw/new/searckey1/
'idolphoto',1,	# search.idol-photo.com/%E3%82%A8%E3%83%AB%E3%83%95/index10.html
'iug',1,	# iug.newsing.jp/tag/searckey1?...
'meta2',1,	# meta2.the-search.jp/w/IPA+%E7%99%BA%E9%9F%B3_.html
'megite',1,	# www.megite.com/discover/searckey1%20searchkey2
'olane',1,	# olane.jp/keyword/eラーニング/c/8
'pex',1,	# pex.jp/search/Keywords/%E3%82%B9%E3%83%BC%E3%82%B6%E3%83%B3+%E3%82%AF%E3%83%BC%E3%83%AA%E3%83%83%E3%82%B8/xargs/1c6eqo
'yahoogle',1,   # www.yahoogle.jp/yahoogle-1-searckey1%20searchkey2
'mtechnoratijp',1,  # m.technorati.jp/search/searckey1+searchkey2
'wtechnoratijp',1,	# www.technorati.jp/search/searckey1+searchkey2
			# www.technorati.jp/posts/tag/searckey1+searchkey2
'technoratijp',1,  # technorati.jp/search/searckey1+searchkey2
'technorati',1,  # technorati.com/posts/tag/searckey1+searchkey2
);

# SearchEnginesKnownUrl
# Known rules to extract keywords from a referrer search engine URL
#------------------------------------------------------------------------------
%SearchEnginesKnownUrl=(
# Japanese Search Engines
# Added by Ryu 2007.01.06
'answers','www\.answers\.com\/',
'asamasearch','q=',
'allabout','qs=',
'auone','q=',
'avabox','keyword=',
'baidujp','wd=',
'imagebaidujp','word=',
'biglobe','q=',
'cashback','keywords=',
'kbg','extrakey=',
'cometsystems','qry=',
'cybozu','(keywords|query)=',
'ceekjp','q=',
'dirbg','s=',
'clustyjp','query=',
'docomo','key=',
'eniro','q=',
'excitejapan','search=',
'ezweb','query=',
'fastbrowsersearch','q=',
'fc2','search=',
'fresheye','kw=',
'fresheyedir','dir\.fresheye\.com\/ds\/kw\/new\/',
'goo','mt=',
'googlejapan','(p=|q=cache:[0-9A-Za-z]{12}:|as_p=|as_q=|as_epq=|q=)',
'infoseek','qt=',
'idolphoto','photo\.com\/',
'iug','iug\.newsing\.jp\/tag\/',
'1pa2','feed=',
'juno','query=',
'jword','(name|q)=',
'livedoor','q=',
'lunascape','q=',
'megite','www\.megite\.com\/discover\/',
'meta2','meta2\.the-search\.jp\/w\/',
'metcha','q=',
'metager','eingabe=',
'marsflag','key=',
'myway','searchfor=',
'msnjapan','(q|mt)=',
'naverjp','query=',
'navercom','query=',
'lifemile','keywords=',
'50pt','keywords=',
'pointbox','keywords=',
'nikkei','q=',
'okodukai','q=',
'aoljapan','(query|query_contain)=',
'nifty','(text|q)=',
'odn','querystring=',
'niwango','p1=',
'olane','keyword\/',
'pex','(?:keywords\/|keywords=)',
'searchhp','kensaku_ward=',
'picsearchcom','q=',
'picsearchsk','q=',
'picmy','keywords=',
'prsearch','query=',
'rakuten','qt=',
'sonet','query=',
'mtechnoratijp','m\.technorati\.jp\/search\/',
'wtechnoratijp','www\.technorati\.jp\/(?:search|posts/tag)\/',
'technoratijp','technorati\.jp\/search\/',
'technorati','technorati\.com\/(?:tag|posts/tag)\/',
'tocc','qry=',
'yahoocache','w=',
'websearch','qkw=',
'yahoogle','www\.yahoogle\.jp\/yahoogle-1-',
'yicha','(keyword|bt)=',
# Query keys

'www_google_co_uk','(p|q|as_p|as_q)=',

'images_google_co_uk','(p|q|as_p|as_q)=',
'translate_google_co_uk','(p|q|as_p|as_q)=',
'google_co_uk','(p|q|as_p|as_q)=',
'www_google_com','(p|q|as_p|as_q)=',
'images_google_com','(p|q|as_p|as_q)=',
'translate_google_com','(p|q|as_p|as_q)=',
'google_com','(p|q|as_p|as_q)=',
'www_google_de','(p|q|as_p|as_q)=',
'images_google_de','(p|q|as_p|as_q)=',
'translate_google_de','(p|q|as_p|as_q)=',
'google_de','(p|q|as_p|as_q)=',
'www_google_fr','(p|q|as_p|as_q)=',
'images_google_fr','(p|q|as_p|as_q)=',
'translate_google_fr','(p|q|as_p|as_q)=',
'google_fr','(p|q|as_p|as_q)=',
'www_google_ca','(p|q|as_p|as_q)=',
'images_google_ca','(p|q|as_p|as_q)=',
'translate_google_ca','(p|q|as_p|as_q)=',
'google_ca','(p|q|as_p|as_q)=',
'www_google_es','(p|q|as_p|as_q)=',
'images_google_es','(p|q|as_p|as_q)=',
'translate_google_es','(p|q|as_p|as_q)=',
'google_es','(p|q|as_p|as_q)=',
'www_google_com_au','(p|q|as_p|as_q)=',
'images_google_com_au','(p|q|as_p|as_q)=',
'translate_google_com_au','(p|q|as_p|as_q)=',
'google_com_au','(p|q|as_p|as_q)=',
'www_google_nl','(p|q|as_p|as_q)=',
'images_google_nl','(p|q|as_p|as_q)=',
'translate_google_nl','(p|q|as_p|as_q)=',
'google_nl','(p|q|as_p|as_q)=',
'www_google_gr','(p|q|as_p|as_q)=',
'images_google_gr','(p|q|as_p|as_q)=',
'translate_google_gr','(p|q|as_p|as_q)=',
'google_gr','(p|q|as_p|as_q)=',
'www_google_se','(p|q|as_p|as_q)=',
'images_google_se','(p|q|as_p|as_q)=',
'translate_google_se','(p|q|as_p|as_q)=',
'google_se','(p|q|as_p|as_q)=',
'www_google_ie','(p|q|as_p|as_q)=',
'images_google_ie','(p|q|as_p|as_q)=',
'translate_google_ie','(p|q|as_p|as_q)=',
'google_ie','(p|q|as_p|as_q)=',
'www_google_it','(p|q|as_p|as_q)=',
'images_google_it','(p|q|as_p|as_q)=',
'translate_google_it','(p|q|as_p|as_q)=',
'google_it','(p|q|as_p|as_q)=',
'www_google_no','(p|q|as_p|as_q)=',
'images_google_no','(p|q|as_p|as_q)=',
'translate_google_no','(p|q|as_p|as_q)=',
'google_no','(p|q|as_p|as_q)=',
'www_google_com_tr','(p|q|as_p|as_q)=',
'images_google_com_tr','(p|q|as_p|as_q)=',
'translate_google_com_tr','(p|q|as_p|as_q)=',
'google_com_tr','(p|q|as_p|as_q)=',
'www_google_co_in','(p|q|as_p|as_q)=',
'images_google_co_in','(p|q|as_p|as_q)=',
'translate_google_co_in','(p|q|as_p|as_q)=',
'google_co_in','(p|q|as_p|as_q)=',
'www_google_pt','(p|q|as_p|as_q)=',
'images_google_pt','(p|q|as_p|as_q)=',
'translate_google_pt','(p|q|as_p|as_q)=',
'google_pt','(p|q|as_p|as_q)=',
'www_google_hr','(p|q|as_p|as_q)=',
'images_google_hr','(p|q|as_p|as_q)=',
'translate_google_hr','(p|q|as_p|as_q)=',
'google_hr','(p|q|as_p|as_q)=',
'www_google_co_nz','(p|q|as_p|as_q)=',
'images_google_co_nz','(p|q|as_p|as_q)=',
'translate_google_co_nz','(p|q|as_p|as_q)=',
'google_co_nz','(p|q|as_p|as_q)=',
'www_google_pl','(p|q|as_p|as_q)=',
'images_google_pl','(p|q|as_p|as_q)=',
'translate_google_pl','(p|q|as_p|as_q)=',
'google_pl','(p|q|as_p|as_q)=',
'www_google_ac','(p|q|as_p|as_q)=',
'images_google_ac','(p|q|as_p|as_q)=',
'translate_google_ac','(p|q|as_p|as_q)=',
'google_ac','(p|q|as_p|as_q)=',
'www_google_ad','(p|q|as_p|as_q)=',
'images_google_ad','(p|q|as_p|as_q)=',
'translate_google_ad','(p|q|as_p|as_q)=',
'google_ad','(p|q|as_p|as_q)=',
'www_google_ae','(p|q|as_p|as_q)=',
'images_google_ae','(p|q|as_p|as_q)=',
'translate_google_ae','(p|q|as_p|as_q)=',
'google_ae','(p|q|as_p|as_q)=',
'www_google_al','(p|q|as_p|as_q)=',
'images_google_al','(p|q|as_p|as_q)=',
'translate_google_al','(p|q|as_p|as_q)=',
'google_al','(p|q|as_p|as_q)=',
'www_google_am','(p|q|as_p|as_q)=',
'images_google_am','(p|q|as_p|as_q)=',
'translate_google_am','(p|q|as_p|as_q)=',
'google_am','(p|q|as_p|as_q)=',
'www_google_as','(p|q|as_p|as_q)=',
'images_google_as','(p|q|as_p|as_q)=',
'translate_google_as','(p|q|as_p|as_q)=',
'google_as','(p|q|as_p|as_q)=',
'www_google_at','(p|q|as_p|as_q)=',
'images_google_at','(p|q|as_p|as_q)=',
'translate_google_at','(p|q|as_p|as_q)=',
'google_at','(p|q|as_p|as_q)=',
'www_google_az','(p|q|as_p|as_q)=',
'images_google_az','(p|q|as_p|as_q)=',
'translate_google_az','(p|q|as_p|as_q)=',
'google_az','(p|q|as_p|as_q)=',
'www_google_ba','(p|q|as_p|as_q)=',
'images_google_ba','(p|q|as_p|as_q)=',
'translate_google_ba','(p|q|as_p|as_q)=',
'google_ba','(p|q|as_p|as_q)=',
'www_google_be','(p|q|as_p|as_q)=',
'images_google_be','(p|q|as_p|as_q)=',
'translate_google_be','(p|q|as_p|as_q)=',
'google_be','(p|q|as_p|as_q)=',
'www_google_bf','(p|q|as_p|as_q)=',
'images_google_bf','(p|q|as_p|as_q)=',
'translate_google_bf','(p|q|as_p|as_q)=',
'google_bf','(p|q|as_p|as_q)=',
'www_google_bg','(p|q|as_p|as_q)=',
'images_google_bg','(p|q|as_p|as_q)=',
'translate_google_bg','(p|q|as_p|as_q)=',
'google_bg','(p|q|as_p|as_q)=',
'www_google_bi','(p|q|as_p|as_q)=',
'images_google_bi','(p|q|as_p|as_q)=',
'translate_google_bi','(p|q|as_p|as_q)=',
'google_bi','(p|q|as_p|as_q)=',
'www_google_bj','(p|q|as_p|as_q)=',
'images_google_bj','(p|q|as_p|as_q)=',
'translate_google_bj','(p|q|as_p|as_q)=',
'google_bj','(p|q|as_p|as_q)=',
'www_google_bs','(p|q|as_p|as_q)=',
'images_google_bs','(p|q|as_p|as_q)=',
'translate_google_bs','(p|q|as_p|as_q)=',
'google_bs','(p|q|as_p|as_q)=',
'www_google_bt','(p|q|as_p|as_q)=',
'images_google_bt','(p|q|as_p|as_q)=',
'translate_google_bt','(p|q|as_p|as_q)=',
'google_bt','(p|q|as_p|as_q)=',
'www_google_by','(p|q|as_p|as_q)=',
'images_google_by','(p|q|as_p|as_q)=',
'translate_google_by','(p|q|as_p|as_q)=',
'google_by','(p|q|as_p|as_q)=',
'www_google_cat','(p|q|as_p|as_q)=',
'images_google_cat','(p|q|as_p|as_q)=',
'translate_google_cat','(p|q|as_p|as_q)=',
'google_cat','(p|q|as_p|as_q)=',
'www_google_cc','(p|q|as_p|as_q)=',
'images_google_cc','(p|q|as_p|as_q)=',
'translate_google_cc','(p|q|as_p|as_q)=',
'google_cc','(p|q|as_p|as_q)=',
'www_google_cd','(p|q|as_p|as_q)=',
'images_google_cd','(p|q|as_p|as_q)=',
'translate_google_cd','(p|q|as_p|as_q)=',
'google_cd','(p|q|as_p|as_q)=',
'www_google_cf','(p|q|as_p|as_q)=',
'images_google_cf','(p|q|as_p|as_q)=',
'translate_google_cf','(p|q|as_p|as_q)=',
'google_cf','(p|q|as_p|as_q)=',
'www_google_cg','(p|q|as_p|as_q)=',
'images_google_cg','(p|q|as_p|as_q)=',
'translate_google_cg','(p|q|as_p|as_q)=',
'google_cg','(p|q|as_p|as_q)=',
'www_google_ch','(p|q|as_p|as_q)=',
'images_google_ch','(p|q|as_p|as_q)=',
'translate_google_ch','(p|q|as_p|as_q)=',
'google_ch','(p|q|as_p|as_q)=',
'www_google_ci','(p|q|as_p|as_q)=',
'images_google_ci','(p|q|as_p|as_q)=',
'translate_google_ci','(p|q|as_p|as_q)=',
'google_ci','(p|q|as_p|as_q)=',
'www_google_cl','(p|q|as_p|as_q)=',
'images_google_cl','(p|q|as_p|as_q)=',
'translate_google_cl','(p|q|as_p|as_q)=',
'google_cl','(p|q|as_p|as_q)=',
'www_google_cm','(p|q|as_p|as_q)=',
'images_google_cm','(p|q|as_p|as_q)=',
'translate_google_cm','(p|q|as_p|as_q)=',
'google_cm','(p|q|as_p|as_q)=',
'www_google_cn','(p|q|as_p|as_q)=',
'images_google_cn','(p|q|as_p|as_q)=',
'translate_google_cn','(p|q|as_p|as_q)=',
'google_cn','(p|q|as_p|as_q)=',
'www_google_co_ao','(p|q|as_p|as_q)=',
'images_google_co_ao','(p|q|as_p|as_q)=',
'translate_google_co_ao','(p|q|as_p|as_q)=',
'google_co_ao','(p|q|as_p|as_q)=',
'www_google_co_bw','(p|q|as_p|as_q)=',
'images_google_co_bw','(p|q|as_p|as_q)=',
'translate_google_co_bw','(p|q|as_p|as_q)=',
'google_co_bw','(p|q|as_p|as_q)=',
'www_google_co_ck','(p|q|as_p|as_q)=',
'images_google_co_ck','(p|q|as_p|as_q)=',
'translate_google_co_ck','(p|q|as_p|as_q)=',
'google_co_ck','(p|q|as_p|as_q)=',
'www_google_co_cr','(p|q|as_p|as_q)=',
'images_google_co_cr','(p|q|as_p|as_q)=',
'translate_google_co_cr','(p|q|as_p|as_q)=',
'google_co_cr','(p|q|as_p|as_q)=',
'www_google_co_id','(p|q|as_p|as_q)=',
'images_google_co_id','(p|q|as_p|as_q)=',
'translate_google_co_id','(p|q|as_p|as_q)=',
'google_co_id','(p|q|as_p|as_q)=',
'www_google_co_il','(p|q|as_p|as_q)=',
'images_google_co_il','(p|q|as_p|as_q)=',
'translate_google_co_il','(p|q|as_p|as_q)=',
'google_co_il','(p|q|as_p|as_q)=',
'www_google_co_jp','(p|q|as_p|as_q)=',
'images_google_co_jp','(p|q|as_p|as_q)=',
'translate_google_co_jp','(p|q|as_p|as_q)=',
'google_co_jp','(p|q|as_p|as_q)=',
'www_google_co_ke','(p|q|as_p|as_q)=',
'images_google_co_ke','(p|q|as_p|as_q)=',
'translate_google_co_ke','(p|q|as_p|as_q)=',
'google_co_ke','(p|q|as_p|as_q)=',
'www_google_co_kr','(p|q|as_p|as_q)=',
'images_google_co_kr','(p|q|as_p|as_q)=',
'translate_google_co_kr','(p|q|as_p|as_q)=',
'google_co_kr','(p|q|as_p|as_q)=',
'www_google_co_ls','(p|q|as_p|as_q)=',
'images_google_co_ls','(p|q|as_p|as_q)=',
'translate_google_co_ls','(p|q|as_p|as_q)=',
'google_co_ls','(p|q|as_p|as_q)=',
'www_google_co_ma','(p|q|as_p|as_q)=',
'images_google_co_ma','(p|q|as_p|as_q)=',
'translate_google_co_ma','(p|q|as_p|as_q)=',
'google_co_ma','(p|q|as_p|as_q)=',
'www_google_co_mz','(p|q|as_p|as_q)=',
'images_google_co_mz','(p|q|as_p|as_q)=',
'translate_google_co_mz','(p|q|as_p|as_q)=',
'google_co_mz','(p|q|as_p|as_q)=',
'www_google_co_th','(p|q|as_p|as_q)=',
'images_google_co_th','(p|q|as_p|as_q)=',
'translate_google_co_th','(p|q|as_p|as_q)=',
'google_co_th','(p|q|as_p|as_q)=',
'www_google_co_tz','(p|q|as_p|as_q)=',
'images_google_co_tz','(p|q|as_p|as_q)=',
'translate_google_co_tz','(p|q|as_p|as_q)=',
'google_co_tz','(p|q|as_p|as_q)=',
'www_google_co_ug','(p|q|as_p|as_q)=',
'images_google_co_ug','(p|q|as_p|as_q)=',
'translate_google_co_ug','(p|q|as_p|as_q)=',
'google_co_ug','(p|q|as_p|as_q)=',
'www_google_co_uz','(p|q|as_p|as_q)=',
'images_google_co_uz','(p|q|as_p|as_q)=',
'translate_google_co_uz','(p|q|as_p|as_q)=',
'google_co_uz','(p|q|as_p|as_q)=',
'www_google_co_ve','(p|q|as_p|as_q)=',
'images_google_co_ve','(p|q|as_p|as_q)=',
'translate_google_co_ve','(p|q|as_p|as_q)=',
'google_co_ve','(p|q|as_p|as_q)=',
'www_google_co_vi','(p|q|as_p|as_q)=',
'images_google_co_vi','(p|q|as_p|as_q)=',
'translate_google_co_vi','(p|q|as_p|as_q)=',
'google_co_vi','(p|q|as_p|as_q)=',
'www_google_co_za','(p|q|as_p|as_q)=',
'images_google_co_za','(p|q|as_p|as_q)=',
'translate_google_co_za','(p|q|as_p|as_q)=',
'google_co_za','(p|q|as_p|as_q)=',
'www_google_co_zm','(p|q|as_p|as_q)=',
'images_google_co_zm','(p|q|as_p|as_q)=',
'translate_google_co_zm','(p|q|as_p|as_q)=',
'google_co_zm','(p|q|as_p|as_q)=',
'www_google_co_zw','(p|q|as_p|as_q)=',
'images_google_co_zw','(p|q|as_p|as_q)=',
'translate_google_co_zw','(p|q|as_p|as_q)=',
'google_co_zw','(p|q|as_p|as_q)=',
'www_google_com_af','(p|q|as_p|as_q)=',
'images_google_com_af','(p|q|as_p|as_q)=',
'translate_google_com_af','(p|q|as_p|as_q)=',
'google_com_af','(p|q|as_p|as_q)=',
'www_google_com_ag','(p|q|as_p|as_q)=',
'images_google_com_ag','(p|q|as_p|as_q)=',
'translate_google_com_ag','(p|q|as_p|as_q)=',
'google_com_ag','(p|q|as_p|as_q)=',
'www_google_com_ai','(p|q|as_p|as_q)=',
'images_google_com_ai','(p|q|as_p|as_q)=',
'translate_google_com_ai','(p|q|as_p|as_q)=',
'google_com_ai','(p|q|as_p|as_q)=',
'www_google_com_ar','(p|q|as_p|as_q)=',
'images_google_com_ar','(p|q|as_p|as_q)=',
'translate_google_com_ar','(p|q|as_p|as_q)=',
'google_com_ar','(p|q|as_p|as_q)=',
'www_google_com_bd','(p|q|as_p|as_q)=',
'images_google_com_bd','(p|q|as_p|as_q)=',
'translate_google_com_bd','(p|q|as_p|as_q)=',
'google_com_bd','(p|q|as_p|as_q)=',
'www_google_com_bh','(p|q|as_p|as_q)=',
'images_google_com_bh','(p|q|as_p|as_q)=',
'translate_google_com_bh','(p|q|as_p|as_q)=',
'google_com_bh','(p|q|as_p|as_q)=',
'www_google_com_bn','(p|q|as_p|as_q)=',
'images_google_com_bn','(p|q|as_p|as_q)=',
'translate_google_com_bn','(p|q|as_p|as_q)=',
'google_com_bn','(p|q|as_p|as_q)=',
'www_google_com_bo','(p|q|as_p|as_q)=',
'images_google_com_bo','(p|q|as_p|as_q)=',
'translate_google_com_bo','(p|q|as_p|as_q)=',
'google_com_bo','(p|q|as_p|as_q)=',
'www_google_com_br','(p|q|as_p|as_q)=',
'images_google_com_br','(p|q|as_p|as_q)=',
'translate_google_com_br','(p|q|as_p|as_q)=',
'google_com_br','(p|q|as_p|as_q)=',
'www_google_com_bz','(p|q|as_p|as_q)=',
'images_google_com_bz','(p|q|as_p|as_q)=',
'translate_google_com_bz','(p|q|as_p|as_q)=',
'google_com_bz','(p|q|as_p|as_q)=',
'www_google_com_co','(p|q|as_p|as_q)=',
'images_google_com_co','(p|q|as_p|as_q)=',
'translate_google_com_co','(p|q|as_p|as_q)=',
'google_com_co','(p|q|as_p|as_q)=',
'www_google_com_cu','(p|q|as_p|as_q)=',
'images_google_com_cu','(p|q|as_p|as_q)=',
'translate_google_com_cu','(p|q|as_p|as_q)=',
'google_com_cu','(p|q|as_p|as_q)=',
'www_google_com_cy','(p|q|as_p|as_q)=',
'images_google_com_cy','(p|q|as_p|as_q)=',
'translate_google_com_cy','(p|q|as_p|as_q)=',
'google_com_cy','(p|q|as_p|as_q)=',
'www_google_com_do','(p|q|as_p|as_q)=',
'images_google_com_do','(p|q|as_p|as_q)=',
'translate_google_com_do','(p|q|as_p|as_q)=',
'google_com_do','(p|q|as_p|as_q)=',
'www_google_com_ec','(p|q|as_p|as_q)=',
'images_google_com_ec','(p|q|as_p|as_q)=',
'translate_google_com_ec','(p|q|as_p|as_q)=',
'google_com_ec','(p|q|as_p|as_q)=',
'www_google_com_eg','(p|q|as_p|as_q)=',
'images_google_com_eg','(p|q|as_p|as_q)=',
'translate_google_com_eg','(p|q|as_p|as_q)=',
'google_com_eg','(p|q|as_p|as_q)=',
'www_google_com_et','(p|q|as_p|as_q)=',
'images_google_com_et','(p|q|as_p|as_q)=',
'translate_google_com_et','(p|q|as_p|as_q)=',
'google_com_et','(p|q|as_p|as_q)=',
'www_google_com_fj','(p|q|as_p|as_q)=',
'images_google_com_fj','(p|q|as_p|as_q)=',
'translate_google_com_fj','(p|q|as_p|as_q)=',
'google_com_fj','(p|q|as_p|as_q)=',
'www_google_com_gh','(p|q|as_p|as_q)=',
'images_google_com_gh','(p|q|as_p|as_q)=',
'translate_google_com_gh','(p|q|as_p|as_q)=',
'google_com_gh','(p|q|as_p|as_q)=',
'www_google_com_gi','(p|q|as_p|as_q)=',
'images_google_com_gi','(p|q|as_p|as_q)=',
'translate_google_com_gi','(p|q|as_p|as_q)=',
'google_com_gi','(p|q|as_p|as_q)=',
'www_google_com_gt','(p|q|as_p|as_q)=',
'images_google_com_gt','(p|q|as_p|as_q)=',
'translate_google_com_gt','(p|q|as_p|as_q)=',
'google_com_gt','(p|q|as_p|as_q)=',
'www_google_com_hk','(p|q|as_p|as_q)=',
'images_google_com_hk','(p|q|as_p|as_q)=',
'translate_google_com_hk','(p|q|as_p|as_q)=',
'google_com_hk','(p|q|as_p|as_q)=',
'www_google_com_jm','(p|q|as_p|as_q)=',
'images_google_com_jm','(p|q|as_p|as_q)=',
'translate_google_com_jm','(p|q|as_p|as_q)=',
'google_com_jm','(p|q|as_p|as_q)=',
'www_google_com_kh','(p|q|as_p|as_q)=',
'images_google_com_kh','(p|q|as_p|as_q)=',
'translate_google_com_kh','(p|q|as_p|as_q)=',
'google_com_kh','(p|q|as_p|as_q)=',
'www_google_com_kw','(p|q|as_p|as_q)=',
'images_google_com_kw','(p|q|as_p|as_q)=',
'translate_google_com_kw','(p|q|as_p|as_q)=',
'google_com_kw','(p|q|as_p|as_q)=',
'www_google_com_lb','(p|q|as_p|as_q)=',
'images_google_com_lb','(p|q|as_p|as_q)=',
'translate_google_com_lb','(p|q|as_p|as_q)=',
'google_com_lb','(p|q|as_p|as_q)=',
'www_google_com_lc','(p|q|as_p|as_q)=',
'images_google_com_lc','(p|q|as_p|as_q)=',
'translate_google_com_lc','(p|q|as_p|as_q)=',
'google_com_lc','(p|q|as_p|as_q)=',
'www_google_com_ly','(p|q|as_p|as_q)=',
'images_google_com_ly','(p|q|as_p|as_q)=',
'translate_google_com_ly','(p|q|as_p|as_q)=',
'google_com_ly','(p|q|as_p|as_q)=',
'www_google_com_mm','(p|q|as_p|as_q)=',
'images_google_com_mm','(p|q|as_p|as_q)=',
'translate_google_com_mm','(p|q|as_p|as_q)=',
'google_com_mm','(p|q|as_p|as_q)=',
'www_google_com_mt','(p|q|as_p|as_q)=',
'images_google_com_mt','(p|q|as_p|as_q)=',
'translate_google_com_mt','(p|q|as_p|as_q)=',
'google_com_mt','(p|q|as_p|as_q)=',
'www_google_com_mx','(p|q|as_p|as_q)=',
'images_google_com_mx','(p|q|as_p|as_q)=',
'translate_google_com_mx','(p|q|as_p|as_q)=',
'google_com_mx','(p|q|as_p|as_q)=',
'www_google_com_my','(p|q|as_p|as_q)=',
'images_google_com_my','(p|q|as_p|as_q)=',
'translate_google_com_my','(p|q|as_p|as_q)=',
'google_com_my','(p|q|as_p|as_q)=',
'www_google_com_na','(p|q|as_p|as_q)=',
'images_google_com_na','(p|q|as_p|as_q)=',
'translate_google_com_na','(p|q|as_p|as_q)=',
'google_com_na','(p|q|as_p|as_q)=',
'www_google_com_nf','(p|q|as_p|as_q)=',
'images_google_com_nf','(p|q|as_p|as_q)=',
'translate_google_com_nf','(p|q|as_p|as_q)=',
'google_com_nf','(p|q|as_p|as_q)=',
'www_google_com_ng','(p|q|as_p|as_q)=',
'images_google_com_ng','(p|q|as_p|as_q)=',
'translate_google_com_ng','(p|q|as_p|as_q)=',
'google_com_ng','(p|q|as_p|as_q)=',
'www_google_com_ni','(p|q|as_p|as_q)=',
'images_google_com_ni','(p|q|as_p|as_q)=',
'translate_google_com_ni','(p|q|as_p|as_q)=',
'google_com_ni','(p|q|as_p|as_q)=',
'www_google_com_np','(p|q|as_p|as_q)=',
'images_google_com_np','(p|q|as_p|as_q)=',
'translate_google_com_np','(p|q|as_p|as_q)=',
'google_com_np','(p|q|as_p|as_q)=',
'www_google_com_om','(p|q|as_p|as_q)=',
'images_google_com_om','(p|q|as_p|as_q)=',
'translate_google_com_om','(p|q|as_p|as_q)=',
'google_com_om','(p|q|as_p|as_q)=',
'www_google_com_pa','(p|q|as_p|as_q)=',
'images_google_com_pa','(p|q|as_p|as_q)=',
'translate_google_com_pa','(p|q|as_p|as_q)=',
'google_com_pa','(p|q|as_p|as_q)=',
'www_google_com_pe','(p|q|as_p|as_q)=',
'images_google_com_pe','(p|q|as_p|as_q)=',
'translate_google_com_pe','(p|q|as_p|as_q)=',
'google_com_pe','(p|q|as_p|as_q)=',
'www_google_com_pg','(p|q|as_p|as_q)=',
'images_google_com_pg','(p|q|as_p|as_q)=',
'translate_google_com_pg','(p|q|as_p|as_q)=',
'google_com_pg','(p|q|as_p|as_q)=',
'www_google_com_ph','(p|q|as_p|as_q)=',
'images_google_com_ph','(p|q|as_p|as_q)=',
'translate_google_com_ph','(p|q|as_p|as_q)=',
'google_com_ph','(p|q|as_p|as_q)=',
'www_google_com_pk','(p|q|as_p|as_q)=',
'images_google_com_pk','(p|q|as_p|as_q)=',
'translate_google_com_pk','(p|q|as_p|as_q)=',
'google_com_pk','(p|q|as_p|as_q)=',
'www_google_com_pr','(p|q|as_p|as_q)=',
'images_google_com_pr','(p|q|as_p|as_q)=',
'translate_google_com_pr','(p|q|as_p|as_q)=',
'google_com_pr','(p|q|as_p|as_q)=',
'www_google_com_py','(p|q|as_p|as_q)=',
'images_google_com_py','(p|q|as_p|as_q)=',
'translate_google_com_py','(p|q|as_p|as_q)=',
'google_com_py','(p|q|as_p|as_q)=',
'www_google_com_qa','(p|q|as_p|as_q)=',
'images_google_com_qa','(p|q|as_p|as_q)=',
'translate_google_com_qa','(p|q|as_p|as_q)=',
'google_com_qa','(p|q|as_p|as_q)=',
'www_google_com_sa','(p|q|as_p|as_q)=',
'images_google_com_sa','(p|q|as_p|as_q)=',
'translate_google_com_sa','(p|q|as_p|as_q)=',
'google_com_sa','(p|q|as_p|as_q)=',
'www_google_com_sb','(p|q|as_p|as_q)=',
'images_google_com_sb','(p|q|as_p|as_q)=',
'translate_google_com_sb','(p|q|as_p|as_q)=',
'google_com_sb','(p|q|as_p|as_q)=',
'www_google_com_sg','(p|q|as_p|as_q)=',
'images_google_com_sg','(p|q|as_p|as_q)=',
'translate_google_com_sg','(p|q|as_p|as_q)=',
'google_com_sg','(p|q|as_p|as_q)=',
'www_google_com_sl','(p|q|as_p|as_q)=',
'images_google_com_sl','(p|q|as_p|as_q)=',
'translate_google_com_sl','(p|q|as_p|as_q)=',
'google_com_sl','(p|q|as_p|as_q)=',
'www_google_com_sv','(p|q|as_p|as_q)=',
'images_google_com_sv','(p|q|as_p|as_q)=',
'translate_google_com_sv','(p|q|as_p|as_q)=',
'google_com_sv','(p|q|as_p|as_q)=',
'www_google_com_tj','(p|q|as_p|as_q)=',
'images_google_com_tj','(p|q|as_p|as_q)=',
'translate_google_com_tj','(p|q|as_p|as_q)=',
'google_com_tj','(p|q|as_p|as_q)=',
'www_google_com_tw','(p|q|as_p|as_q)=',
'images_google_com_tw','(p|q|as_p|as_q)=',
'translate_google_com_tw','(p|q|as_p|as_q)=',
'google_com_tw','(p|q|as_p|as_q)=',
'www_google_com_ua','(p|q|as_p|as_q)=',
'images_google_com_ua','(p|q|as_p|as_q)=',
'translate_google_com_ua','(p|q|as_p|as_q)=',
'google_com_ua','(p|q|as_p|as_q)=',
'www_google_com_uy','(p|q|as_p|as_q)=',
'images_google_com_uy','(p|q|as_p|as_q)=',
'translate_google_com_uy','(p|q|as_p|as_q)=',
'google_com_uy','(p|q|as_p|as_q)=',
'www_google_com_vc','(p|q|as_p|as_q)=',
'images_google_com_vc','(p|q|as_p|as_q)=',
'translate_google_com_vc','(p|q|as_p|as_q)=',
'google_com_vc','(p|q|as_p|as_q)=',
'www_google_com_vn','(p|q|as_p|as_q)=',
'images_google_com_vn','(p|q|as_p|as_q)=',
'translate_google_com_vn','(p|q|as_p|as_q)=',
'google_com_vn','(p|q|as_p|as_q)=',
'www_google_cv','(p|q|as_p|as_q)=',
'images_google_cv','(p|q|as_p|as_q)=',
'translate_google_cv','(p|q|as_p|as_q)=',
'google_cv','(p|q|as_p|as_q)=',
'www_google_cz','(p|q|as_p|as_q)=',
'images_google_cz','(p|q|as_p|as_q)=',
'translate_google_cz','(p|q|as_p|as_q)=',
'google_cz','(p|q|as_p|as_q)=',
'www_google_dj','(p|q|as_p|as_q)=',
'images_google_dj','(p|q|as_p|as_q)=',
'translate_google_dj','(p|q|as_p|as_q)=',
'google_dj','(p|q|as_p|as_q)=',
'www_google_dk','(p|q|as_p|as_q)=',
'images_google_dk','(p|q|as_p|as_q)=',
'translate_google_dk','(p|q|as_p|as_q)=',
'google_dk','(p|q|as_p|as_q)=',
'www_google_dm','(p|q|as_p|as_q)=',
'images_google_dm','(p|q|as_p|as_q)=',
'translate_google_dm','(p|q|as_p|as_q)=',
'google_dm','(p|q|as_p|as_q)=',
'www_google_dz','(p|q|as_p|as_q)=',
'images_google_dz','(p|q|as_p|as_q)=',
'translate_google_dz','(p|q|as_p|as_q)=',
'google_dz','(p|q|as_p|as_q)=',
'www_google_ee','(p|q|as_p|as_q)=',
'images_google_ee','(p|q|as_p|as_q)=',
'translate_google_ee','(p|q|as_p|as_q)=',
'google_ee','(p|q|as_p|as_q)=',
'www_google_fi','(p|q|as_p|as_q)=',
'images_google_fi','(p|q|as_p|as_q)=',
'translate_google_fi','(p|q|as_p|as_q)=',
'google_fi','(p|q|as_p|as_q)=',
'www_google_fm','(p|q|as_p|as_q)=',
'images_google_fm','(p|q|as_p|as_q)=',
'translate_google_fm','(p|q|as_p|as_q)=',
'google_fm','(p|q|as_p|as_q)=',
'www_google_ga','(p|q|as_p|as_q)=',
'images_google_ga','(p|q|as_p|as_q)=',
'translate_google_ga','(p|q|as_p|as_q)=',
'google_ga','(p|q|as_p|as_q)=',
'www_google_ge','(p|q|as_p|as_q)=',
'images_google_ge','(p|q|as_p|as_q)=',
'translate_google_ge','(p|q|as_p|as_q)=',
'google_ge','(p|q|as_p|as_q)=',
'www_google_gf','(p|q|as_p|as_q)=',
'images_google_gf','(p|q|as_p|as_q)=',
'translate_google_gf','(p|q|as_p|as_q)=',
'google_gf','(p|q|as_p|as_q)=',
'www_google_gg','(p|q|as_p|as_q)=',
'images_google_gg','(p|q|as_p|as_q)=',
'translate_google_gg','(p|q|as_p|as_q)=',
'google_gg','(p|q|as_p|as_q)=',
'www_google_gl','(p|q|as_p|as_q)=',
'images_google_gl','(p|q|as_p|as_q)=',
'translate_google_gl','(p|q|as_p|as_q)=',
'google_gl','(p|q|as_p|as_q)=',
'www_google_gm','(p|q|as_p|as_q)=',
'images_google_gm','(p|q|as_p|as_q)=',
'translate_google_gm','(p|q|as_p|as_q)=',
'google_gm','(p|q|as_p|as_q)=',
'www_google_gp','(p|q|as_p|as_q)=',
'images_google_gp','(p|q|as_p|as_q)=',
'translate_google_gp','(p|q|as_p|as_q)=',
'google_gp','(p|q|as_p|as_q)=',
'www_google_gy','(p|q|as_p|as_q)=',
'images_google_gy','(p|q|as_p|as_q)=',
'translate_google_gy','(p|q|as_p|as_q)=',
'google_gy','(p|q|as_p|as_q)=',
'www_google_hn','(p|q|as_p|as_q)=',
'images_google_hn','(p|q|as_p|as_q)=',
'translate_google_hn','(p|q|as_p|as_q)=',
'google_hn','(p|q|as_p|as_q)=',
'www_google_ht','(p|q|as_p|as_q)=',
'images_google_ht','(p|q|as_p|as_q)=',
'translate_google_ht','(p|q|as_p|as_q)=',
'google_ht','(p|q|as_p|as_q)=',
'www_google_hu','(p|q|as_p|as_q)=',
'images_google_hu','(p|q|as_p|as_q)=',
'translate_google_hu','(p|q|as_p|as_q)=',
'google_hu','(p|q|as_p|as_q)=',
'www_google_im','(p|q|as_p|as_q)=',
'images_google_im','(p|q|as_p|as_q)=',
'translate_google_im','(p|q|as_p|as_q)=',
'google_im','(p|q|as_p|as_q)=',
'www_google_io','(p|q|as_p|as_q)=',
'images_google_io','(p|q|as_p|as_q)=',
'translate_google_io','(p|q|as_p|as_q)=',
'google_io','(p|q|as_p|as_q)=',
'www_google_iq','(p|q|as_p|as_q)=',
'images_google_iq','(p|q|as_p|as_q)=',
'translate_google_iq','(p|q|as_p|as_q)=',
'google_iq','(p|q|as_p|as_q)=',
'www_google_is','(p|q|as_p|as_q)=',
'images_google_is','(p|q|as_p|as_q)=',
'translate_google_is','(p|q|as_p|as_q)=',
'google_is','(p|q|as_p|as_q)=',
'www_google_je','(p|q|as_p|as_q)=',
'images_google_je','(p|q|as_p|as_q)=',
'translate_google_je','(p|q|as_p|as_q)=',
'google_je','(p|q|as_p|as_q)=',
'www_google_jo','(p|q|as_p|as_q)=',
'images_google_jo','(p|q|as_p|as_q)=',
'translate_google_jo','(p|q|as_p|as_q)=',
'google_jo','(p|q|as_p|as_q)=',
'www_google_kg','(p|q|as_p|as_q)=',
'images_google_kg','(p|q|as_p|as_q)=',
'translate_google_kg','(p|q|as_p|as_q)=',
'google_kg','(p|q|as_p|as_q)=',
'www_google_ki','(p|q|as_p|as_q)=',
'images_google_ki','(p|q|as_p|as_q)=',
'translate_google_ki','(p|q|as_p|as_q)=',
'google_ki','(p|q|as_p|as_q)=',
'www_google_kz','(p|q|as_p|as_q)=',
'images_google_kz','(p|q|as_p|as_q)=',
'translate_google_kz','(p|q|as_p|as_q)=',
'google_kz','(p|q|as_p|as_q)=',
'www_google_la','(p|q|as_p|as_q)=',
'images_google_la','(p|q|as_p|as_q)=',
'translate_google_la','(p|q|as_p|as_q)=',
'google_la','(p|q|as_p|as_q)=',
'www_google_li','(p|q|as_p|as_q)=',
'images_google_li','(p|q|as_p|as_q)=',
'translate_google_li','(p|q|as_p|as_q)=',
'google_li','(p|q|as_p|as_q)=',
'www_google_lk','(p|q|as_p|as_q)=',
'images_google_lk','(p|q|as_p|as_q)=',
'translate_google_lk','(p|q|as_p|as_q)=',
'google_lk','(p|q|as_p|as_q)=',
'www_google_lt','(p|q|as_p|as_q)=',
'images_google_lt','(p|q|as_p|as_q)=',
'translate_google_lt','(p|q|as_p|as_q)=',
'google_lt','(p|q|as_p|as_q)=',
'www_google_lu','(p|q|as_p|as_q)=',
'images_google_lu','(p|q|as_p|as_q)=',
'translate_google_lu','(p|q|as_p|as_q)=',
'google_lu','(p|q|as_p|as_q)=',
'www_google_lv','(p|q|as_p|as_q)=',
'images_google_lv','(p|q|as_p|as_q)=',
'translate_google_lv','(p|q|as_p|as_q)=',
'google_lv','(p|q|as_p|as_q)=',
'www_google_md','(p|q|as_p|as_q)=',
'images_google_md','(p|q|as_p|as_q)=',
'translate_google_md','(p|q|as_p|as_q)=',
'google_md','(p|q|as_p|as_q)=',
'www_google_me','(p|q|as_p|as_q)=',
'images_google_me','(p|q|as_p|as_q)=',
'translate_google_me','(p|q|as_p|as_q)=',
'google_me','(p|q|as_p|as_q)=',
'www_google_mg','(p|q|as_p|as_q)=',
'images_google_mg','(p|q|as_p|as_q)=',
'translate_google_mg','(p|q|as_p|as_q)=',
'google_mg','(p|q|as_p|as_q)=',
'www_google_mk','(p|q|as_p|as_q)=',
'images_google_mk','(p|q|as_p|as_q)=',
'translate_google_mk','(p|q|as_p|as_q)=',
'google_mk','(p|q|as_p|as_q)=',
'www_google_ml','(p|q|as_p|as_q)=',
'images_google_ml','(p|q|as_p|as_q)=',
'translate_google_ml','(p|q|as_p|as_q)=',
'google_ml','(p|q|as_p|as_q)=',
'www_google_mn','(p|q|as_p|as_q)=',
'images_google_mn','(p|q|as_p|as_q)=',
'translate_google_mn','(p|q|as_p|as_q)=',
'google_mn','(p|q|as_p|as_q)=',
'www_google_ms','(p|q|as_p|as_q)=',
'images_google_ms','(p|q|as_p|as_q)=',
'translate_google_ms','(p|q|as_p|as_q)=',
'google_ms','(p|q|as_p|as_q)=',
'www_google_mu','(p|q|as_p|as_q)=',
'images_google_mu','(p|q|as_p|as_q)=',
'translate_google_mu','(p|q|as_p|as_q)=',
'google_mu','(p|q|as_p|as_q)=',
'www_google_mv','(p|q|as_p|as_q)=',
'images_google_mv','(p|q|as_p|as_q)=',
'translate_google_mv','(p|q|as_p|as_q)=',
'google_mv','(p|q|as_p|as_q)=',
'www_google_mw','(p|q|as_p|as_q)=',
'images_google_mw','(p|q|as_p|as_q)=',
'translate_google_mw','(p|q|as_p|as_q)=',
'google_mw','(p|q|as_p|as_q)=',
'www_google_ne','(p|q|as_p|as_q)=',
'images_google_ne','(p|q|as_p|as_q)=',
'translate_google_ne','(p|q|as_p|as_q)=',
'google_ne','(p|q|as_p|as_q)=',
'www_google_nr','(p|q|as_p|as_q)=',
'images_google_nr','(p|q|as_p|as_q)=',
'translate_google_nr','(p|q|as_p|as_q)=',
'google_nr','(p|q|as_p|as_q)=',
'www_google_nu','(p|q|as_p|as_q)=',
'images_google_nu','(p|q|as_p|as_q)=',
'translate_google_nu','(p|q|as_p|as_q)=',
'google_nu','(p|q|as_p|as_q)=',
'www_google_pn','(p|q|as_p|as_q)=',
'images_google_pn','(p|q|as_p|as_q)=',
'translate_google_pn','(p|q|as_p|as_q)=',
'google_pn','(p|q|as_p|as_q)=',
'www_google_ps','(p|q|as_p|as_q)=',
'images_google_ps','(p|q|as_p|as_q)=',
'translate_google_ps','(p|q|as_p|as_q)=',
'google_ps','(p|q|as_p|as_q)=',
'www_google_ro','(p|q|as_p|as_q)=',
'images_google_ro','(p|q|as_p|as_q)=',
'translate_google_ro','(p|q|as_p|as_q)=',
'google_ro','(p|q|as_p|as_q)=',
'www_google_rs','(p|q|as_p|as_q)=',
'images_google_rs','(p|q|as_p|as_q)=',
'translate_google_rs','(p|q|as_p|as_q)=',
'google_rs','(p|q|as_p|as_q)=',
'www_google_ru','(p|q|as_p|as_q)=',
'images_google_ru','(p|q|as_p|as_q)=',
'translate_google_ru','(p|q|as_p|as_q)=',
'google_ru','(p|q|as_p|as_q)=',
'www_google_rw','(p|q|as_p|as_q)=',
'images_google_rw','(p|q|as_p|as_q)=',
'translate_google_rw','(p|q|as_p|as_q)=',
'google_rw','(p|q|as_p|as_q)=',
'www_google_sc','(p|q|as_p|as_q)=',
'images_google_sc','(p|q|as_p|as_q)=',
'translate_google_sc','(p|q|as_p|as_q)=',
'google_sc','(p|q|as_p|as_q)=',
'www_google_sh','(p|q|as_p|as_q)=',
'images_google_sh','(p|q|as_p|as_q)=',
'translate_google_sh','(p|q|as_p|as_q)=',
'google_sh','(p|q|as_p|as_q)=',
'www_google_si','(p|q|as_p|as_q)=',
'images_google_si','(p|q|as_p|as_q)=',
'translate_google_si','(p|q|as_p|as_q)=',
'google_si','(p|q|as_p|as_q)=',
'www_google_sk','(p|q|as_p|as_q)=',
'images_google_sk','(p|q|as_p|as_q)=',
'translate_google_sk','(p|q|as_p|as_q)=',
'google_sk','(p|q|as_p|as_q)=',
'www_google_sm','(p|q|as_p|as_q)=',
'images_google_sm','(p|q|as_p|as_q)=',
'translate_google_sm','(p|q|as_p|as_q)=',
'google_sm','(p|q|as_p|as_q)=',
'www_google_sn','(p|q|as_p|as_q)=',
'images_google_sn','(p|q|as_p|as_q)=',
'translate_google_sn','(p|q|as_p|as_q)=',
'google_sn','(p|q|as_p|as_q)=',
'www_google_so','(p|q|as_p|as_q)=',
'images_google_so','(p|q|as_p|as_q)=',
'translate_google_so','(p|q|as_p|as_q)=',
'google_so','(p|q|as_p|as_q)=',
'www_google_sr','(p|q|as_p|as_q)=',
'images_google_sr','(p|q|as_p|as_q)=',
'translate_google_sr','(p|q|as_p|as_q)=',
'google_sr','(p|q|as_p|as_q)=',
'www_google_st','(p|q|as_p|as_q)=',
'images_google_st','(p|q|as_p|as_q)=',
'translate_google_st','(p|q|as_p|as_q)=',
'google_st','(p|q|as_p|as_q)=',
'www_google_td','(p|q|as_p|as_q)=',
'images_google_td','(p|q|as_p|as_q)=',
'translate_google_td','(p|q|as_p|as_q)=',
'google_td','(p|q|as_p|as_q)=',
'www_google_tg','(p|q|as_p|as_q)=',
'images_google_tg','(p|q|as_p|as_q)=',
'translate_google_tg','(p|q|as_p|as_q)=',
'google_tg','(p|q|as_p|as_q)=',
'www_google_tk','(p|q|as_p|as_q)=',
'images_google_tk','(p|q|as_p|as_q)=',
'translate_google_tk','(p|q|as_p|as_q)=',
'google_tk','(p|q|as_p|as_q)=',
'www_google_tl','(p|q|as_p|as_q)=',
'images_google_tl','(p|q|as_p|as_q)=',
'translate_google_tl','(p|q|as_p|as_q)=',
'google_tl','(p|q|as_p|as_q)=',
'www_google_tm','(p|q|as_p|as_q)=',
'images_google_tm','(p|q|as_p|as_q)=',
'translate_google_tm','(p|q|as_p|as_q)=',
'google_tm','(p|q|as_p|as_q)=',
'www_google_tn','(p|q|as_p|as_q)=',
'images_google_tn','(p|q|as_p|as_q)=',
'translate_google_tn','(p|q|as_p|as_q)=',
'google_tn','(p|q|as_p|as_q)=',
'www_google_to','(p|q|as_p|as_q)=',
'images_google_to','(p|q|as_p|as_q)=',
'translate_google_to','(p|q|as_p|as_q)=',
'google_to','(p|q|as_p|as_q)=',
'www_google_tt','(p|q|as_p|as_q)=',
'images_google_tt','(p|q|as_p|as_q)=',
'translate_google_tt','(p|q|as_p|as_q)=',
'google_tt','(p|q|as_p|as_q)=',
'www_google_us','(p|q|as_p|as_q)=',
'images_google_us','(p|q|as_p|as_q)=',
'translate_google_us','(p|q|as_p|as_q)=',
'google_us','(p|q|as_p|as_q)=',
'www_google_vg','(p|q|as_p|as_q)=',
'images_google_vg','(p|q|as_p|as_q)=',
'translate_google_vg','(p|q|as_p|as_q)=',
'google_vg','(p|q|as_p|as_q)=',
'www_google_vu','(p|q|as_p|as_q)=',
'images_google_vu','(p|q|as_p|as_q)=',
'translate_google_vu','(p|q|as_p|as_q)=',
'google_vu','(p|q|as_p|as_q)=',
'www_google_ws','(p|q|as_p|as_q)=',
'images_google_ws','(p|q|as_p|as_q)=',
'translate_google_ws','(p|q|as_p|as_q)=',
'google_ws','(p|q|as_p|as_q)=',

'google_base','(q|p|as_p|as_q)=',
'google_translate','q=',
'googleByIP','q=',
'google_catchall','(q|p|as_p|as_q)=',
'google_cache','(p|q|as_p|as_q)=cache:[0-9A-Za-z]{12}:',
'google_froogle','(q|p|as_p|as_q)=',
'google_groups','group\/', # does not work
'google_maps','(dq|q|p|as_p|as_q)=',
'google_products','(q|p|as_p|as_q)=',
'google4counter','(q|p|as_p|as_q)=',
'android_googlequicksearchbox','(notknown)=',

'1klik','query=',
'1search','query=',
'1und1_de','q=',
'3721','(p|name)=',
'a9','a9\.com\/', 
'abacho','q=',
'accoona','qt=',
'alexa','q=',
'aliceit','qs=',
'aliceitmaster','qs=',
'allesklar','q=',
'allgameshome','s=',
'alltheweb','q(|uery)=',
'alot','q=',
'altavista','p=',
'amazon','query=',
'androidsearch','q=',
'answerbus','',
'anzwers','search=',
'aol_o2suche_de','q(|uery)=',
'aolcatchall','q(|uery)=',
'aolcom','q(|uery)=',
'aolde','q(|uery)=',
'aolfr','q(|uery)=',
'aolpl','q(|uery)=',
'aolsearchde','q(|uery)=',
'aoluk','q(|uery)=',
'aport','r=',
'arianna','query=',
'asevenboard','query=',
'askcatchall','q=',
'askde','q=',
'askes','q=',
'askfr','q=',
'askimages','q=',
'askit','q=',
'askjp','q=',
'asknl','q=',
'askuk','q=',
'atlanticbb','q=',
'atlas','(searchtext|q)=', 
'atomz','sp-q=',
'att','qry=',
'auone','q=',
'avantfind','keywords=',
'avg','q=',
'babylon','q=',
'image_baidu','(word|wd)=',
'baidu','(word|wd)=',
'bbc','q=', 
'benefind','q=',
'biglotron','question=',

'www_bing_com','q(|pvt)=',
'cn_bing_com','q(|pvt)=',
'global_bing_com','q(|pvt)=',
'bing_com_catchall','q(|pvt)=',

'blekko','q=',
'blingo','q=',
'boatdesign','query=',
'bluewin','qry=',
'bt','p=',
'bungeebonesdotcom','query=',
'burett_pagelink_si','q=',
'centraldatabase','query=',
'centrum','q=', 
'centurylink','q=',
'certifiedtoolbarsearch','q=',
'charter','q=',
'chatzum','q=',
'checkparams','q=',
'chelloat','q1=',
'chellobe','q1=',
'chellocom','q1=',
'chellocz','q1=',
'chellofr','q1=',
'chellohu','q1=',
'chellonl','q1=',
'chellono','q1=',
'chellopl','q1=',
'chellose','q1=',
'chellosk','q1=',
'clarosearch','q=',
'clinck','q=',
'clubinternet','q=',
'clusty','query=',
'comcast','q=',
'comettoolbar','qry=',
'conduit','q=',
'copernic','web\/',
'crawler','q=',
'csillamker','q=',
'ctrouve','q=',
'dalesearch','q=',
'danielsen','q=', 
'daum','q=',
'de_dolphin_com','q=',
'de_wiki_gov_cn','de\.wiki\.gov\.cn\/s_',
'dealwifi_com','q=',
'dejanews','q=',
'delicious','all=',
'delta-search','q=',
'digg','s=',
'dmoz','(q|search)=',
'dodajpl','keyword=',
'dogpile','(q=|kw=|web/)',
'duckduckgo','nokey=',
'earthlink','q=',
'easysearch','s=',
'ecosia','q=',
'edderkoppen','query=', 
'engine','p1=', 
'eniro','q=',
'enirose','q=',
'ereadingsource','q=',
'etools_ch','query=',
'euroseek','query=',
'everyclick','keyword=',
'excite','search=',
'facemoods','(q|s)=',
'fastbot_de','red=[0-9]*\+',
'fbdownloader','q=',
'fdownloadr_com','q=',
'find1friend','q=',
'findamo','q=',
'findarticles','key=',
'finddk','words=', 
'fireball','q=', 
'flipora','q=',
'foxstart','q=',
'francite','name=', 
'free','q=',
'freenet_de','query=',
'freeserve','q=',
'funmoods','(q|s)=',
'gazetapl','slowo=',
'genieo','q=',
'gerypl','q=',
'globososo','q=',
'gmxsuche','q=',
'gmxsuche_at','q=',
'go','qt=',
'go_mail_ru','q=',
'go2net','general=',
'godado','Keywords=',
'goliat','KERESES=',
'goodsearch','Keywords=',
'gotuneed','', # Not yet known
'govome','q=',
'haku','w=',
'handycafe','q=',
'heureka','heureka=', 
'hogapl','qt=',
'holasearch','q=',
'hotbot','mt=',
'hp_my_aol','q(|uery)=',
'hubwe','p=',
'iask','(w|k)=',
'iboats','highlight=',
'icerocket','q=',
'ichiro','MT=',
'icq','q=',
'ilse','search_for=', 
'iminent','q=',
'inbox','q=',
'incredibar','q=',
'incredimail','q=',
'indexhu','q=', 
'ineffabile','',
'intelseek_com','search=',
'www_info_com','qkw=',
'infoseek','qt=',
'infospace','qkw=',
'infouk','qkw=',
'inspsearch','q=',
'int_search_myway_com','searchfor=',
'interiapl','q=',
'internetto','searchstr=',
'isearch_nation_com','q=',
'iune','(keywords|q)=',
'ixquick','query=',
'izito_catchall','(query|OVKEY|q)=',
'izito_de','(query|OVKEY|q)=',
'izito_uk','(query|OVKEY|q)=',
'jubii','soegeord=', 
'jumpyit','searchWord=',
'startjuno_com','q=',
'juno','q(|uery)=',
'jyxo','(s|q)=', 
'kartoo','',
'katalogonetpl','qt=',
'kataweb','q=',
'keresolap_hu','q=',
'kvasir','q=',
'kvitters','query=',
'lapkereso_hu','q=',
'lbb','q=', 
'ledix','q=',
'libero','qs=',
'libertysurf','q=',
'live','q=',
'localmoxie','keyword=',
'looksmart_catchall','key=',
'looksmart_co_uk','key=',
'lycos','query=',
'mamma','query=',
'meinestadt','q=',
'metabot','st=',
'metacrawler','general=',
'metacrawler_de','qry=',
'metager','eingabe=',
'metahannover','q=',
'metasearch','q=',
'metaspinner','qry=',
'metasuche_ch','q=',
'metaua','q=',
'miner','q=',
'mirago','(txtsearch|qry)=',
'miragobe','(txtsearch|qry)=',
'miragoch','(txtsearch|qry)=',
'miragocouk','(txtsearch|qry)=',
'miragode','(txtsearch|qry)=',
'miragodk','(txtsearch|qry)=',
'miragoes','(txtsearch|qry)=',
'miragofr','(txtsearch|qry)=',
'miragoit','(txtsearch|qry)=',
'miragonl','(txtsearch|qry)=',
'miragono','(txtsearch|qry)=',
'miragose','(txtsearch|qry)=',
'mitrasites','q=',
'mozbot','q=',
'msn','q=',
'mys_yoursearch_me','q=',
'mysearch','(q|searchfor)=',
'mysearchdial','q=',
'mysearchresults','q=',
'myway','searchfor=',
'mywebsearch','searchfor=',
'najdi','dotaz=',
'nation','q=',
'navigationshilfe_t_online','q=',
'nbci','keyword=',
'netease','q=',
'netscape','search=',
'netsprintpl','q=',
'netstjernen','q=',
'netzero','query=',
'northernlight','qr=',
'nortonsavesearch','q=',
'nusearch','nusearch_terms=',
'o2pl','qt=',
'ofir','querytext=',
'oneseek_de','q=',
'onetpl','qt=',
'opasia','q=', 
'orange','q=',
'orangeworld','q=',
'orbis','search_field=',
'origo','(q|search)=', 
'overture','keywords=',
'passagen','q=',
'pch','q=',
'peoplecheck_de','q=',
'picsearch','q=',
'pictures','q=',
'plusnetwork','q=',
'pogodak','q=',
'polskapl','qt=',
'szukaczpl','q=',
'polymeta_hu','',
'preciobarato_xyz','s=',
'questionanswering','',
'quick','query=', 
'qwant_com','q=',
'rakuten','qt=',
'rambler','(query|words)=',
'redbox','srch=',
'rr','q=',
'safehomepage_com','q=',
'sagool','q=',
'sapo','q=',
'schoenerbrausen','q=',
'scroogle','Gw=',
'search_com','q=',
'search_1und1_de','q=',
'search_foxtab_com','q=',
'search_socialdownloadr_com','q=',
'search_zonealarm_com','q=',
'searchalgo','q=',
'searchall_com','q=',
'searchalot','q=',
'searchch','q=',
'searchcompletion','q=',
'searches_qone8_com','q=',
'searchesnavigator','query=',
'searchfunmoods','q=',
'searchgol','q=',
'searchlistingsite','keyword=',
'searchmobileonline','q=',
'searchresults','q=',
'searchresultscom','q=',
'searchsafer','q=',
'searchy','search_term=',
'searchya','q=',
'segnalo','',
'semalt','u=',
'sensis','find=',
'seznam','(w|q)=', 
'shawca','q=',
'shinyseek\.it','KEY=',
'shoppstop','keywords=',
'sify','keyword=',
'sky','term=',
'smartsuggestor','s=',
'smde','q=',
'snapdo','q=',
'softonic','q=',
'sogou','query=',
'sol','q=', 
'so_com','q=',
'soso','q=',
'speedbit','q=',
'sphere','q=',
'splut','pattern=', 
'spotjockey','Search_Keyword=', 
'spray','string=',
'start','q=',
'startlap_hu','q=',
'startpage','query=', 
'startsiden','q=',
'startxxl','q=',
'steadysearch','w=',
'stumbleupon','',
'sucheaolde','q(|uery)=',
'supereva','q=',
'surfcanyon_com','q=',
'sweetim','q=',
'sweetpacks','q=',
'swik','swik\.net/',
'swisscows_ch','query=',
'sympatico','query=', 
 'szukaczpl','q=',
't_online_catchall','q=',
't_online_de','q=',
'talktalk_uk','query=',
'tango_hu','q=',
'tbask','searchfor=',
'teecnoit','q=',
'teoma','q=',
'terra','query=',
'tesco','q=',
'theallsearches','query=',
'three','q=',
'tiscali','key=',
'tixuma_de','sc=',
'toile','q=',
'toshiba','q=',
'turtle','q=',
'tyfon','q=',
'uk_foxstart_com','q=',
'ukdirectory','k=', 
'ukindex','stext=', 
'ukplus','search=', 
'umfis','suchbegriff=',
'umuwa_de','',
'usatoday','q=',
'vindex','in=',
'virgilio','qs=',
'virginmedia','',
'vi-view_com','q=',
'vivisimo','query=',
'vlips_de','q=',
'vnet','kw=',
'voila','(kw|rdata)=',
'wahoo','q=',
'webalta','q=',
'webcrawler','(q|searchText)=',
'webde','su=',
'webmania','q=',
'whorush_com','q=',
'windowssearch_com','q=',
'wisenut','query=', 
'wow_utop_it','q=',
'wowpl','q=',
'wowsearch','q=',
'wowuk','q=',
'wp','szukaj=',
'www_buenosearch_com','q=',
'www_dregol_com','q=',
'www_wow_com','q=',
'wwweasel','q=',
'xfinity_com','q=',

'ar_images_search_yahoo_com','p=',
'ar_search_yahoo_com','p=',
'at_images_search_yahoo_com','p=',
'at_search_yahoo_com','p=',
'au_images_search_yahoo_com','p=',
'au_search_yahoo_com','p=',
'br_images_search_yahoo_com','p=',
'br_search_yahoo_com','p=',
'ca_images_search_yahoo_com','p=',
'ca_search_yahoo_com','p=',
'ca_yhs4_search_yahoo_com','p=',
'ch_images_search_yahoo_com','p=',
'ch_yhs4_search_yahoo_com','p=',
'de_search_yahoo_com','p=',
'de_yhs4_search_yahoo_com','p=',
'es_images_search_yahoo_com','p=',
'es_search_yahoo_com','p=',
'es_yhs4_search_yahoo_com','p=',
'espanol_images_search_yahoo_com','p=',
'espanol_search_yahoo_com','p=',
'fr_images_search_yahoo_com','p=',
'fr_search_yahoo_com','p=',
'fr_yhs4_search_yahoo_com','p=',
'gr_search_yahoo_com','p=',
'gr_yhs4_search_yahoo_com','p=',
'hk_image_search_yahoo_com','p=',
'hk_images_search_yahoo_com','p=',
'hk_search_yahoo_com','p=',
'id_images_search_yahoo_com','p=',
'id_search_yahoo_com','p=',
'id_yhs4_search_yahoo_com','p=',
'ie_search_yahoo_com','p=',
'image_search_yahoo_co_jp','p=',
'images_search_yahoo_com','p=',
'in_images_search_yahoo_com','p=',
'in_search_yahoo_com','p=',
'in_yhs4_search_yahoo_com','p=',
'it_images_search_yahoo_com','p=',
'it_search_yahoo_com','p=',
'it_yhs4_search_yahoo_com','p=',
'kr_search_yahoo_com','p=',
'malaysia_images_search_yahoo_com','p=',
'malaysia_search_yahoo_com','p=',
'mx_images_search_yahoo_com','p=',
'mx_search_yahoo_com','p=',
'nl_images_search_yahoo_com','p=',
'nl_search_yahoo_com','p=',
'nl_yhs4_search_yahoo_com','p=',
'no_search_yahoo_com','p=',
'nz_search_yahoo_com','p=',
'pe_images_search_yahoo_com','p=',
'ph_images_search_yahoo_com','p=',
'ph_search_yahoo_com','p=',
'ph_yhs4_search_yahoo_com','p=',
'pl_yhs4_search_yahoo_com','p=',
'qc_images_search_yahoo_com','p=',
'qc_search_yahoo_com','p=',
'r_search_yahoo_com','p=',
'ru_images_search_yahoo_com','p=',
'se_images_search_yahoo_com','p=',
'se_search_yahoo_com','p=',
'se_yhs4_search_yahoo_com','p=',
'search_yahoo_co_jp','p=',
'search_yahoo_com','p=',
'sg_images_search_yahoo_com','p=',
'sg_search_yahoo_com','p=',
'sg_yhs4_search_yahoo_com','p=',
'tr_yhs4_search_yahoo_com','p=',
'tw_image_search_yahoo_com','p=',
'tw_images_search_yahoo_com','p=',
'tw_search_yahoo_com','p=',
'uk_images_search_yahoo_com','p=',
'uk_search_yahoo_com','p=',
'uk_yhs_search_yahoo_com','p=',
'uk_yhs4_search_yahoo_com','p=',
'us_search_yahoo_com','p=',
'us_yhs4_search_yahoo_com','p=',
'vn_images_search_yahoo_com','p=',

'yahoo_mindset','p=',

'images_search_yahoo_catchall','p=',
'yhs4_search_yahoo_catchall','p=',
'search_yahoo_catchall','p=',
'yahoo_catchall','p=',

'ya_ru','q=',
'yandex','text=',
'yandexcom','text=',
'yandexcomtr','text=',
'yandexkz','text=',
'yandexru','text=',
'yandexua','text=',
'yell','keywords=',
'yourbestsearch','k=',
'youtube','q=',
'zapmeta_catchall','q(|uery)=',
'zapmeta_ch','q(|uery)=',
'zapmeta_com','q(|uery)=',
'zapmeta_de','q(|uery)=',
'zapmeta_it','q(|uery)=',
'fr_zapmeta_ws','q(|uery)=',
'zapmeta_ws','q(|uery)=',
'zhongsou','(word|w)=',
'zoeken','q(|uery)=',
'zoznam','q='
);

# SearchEnginesKnownUrlTrail
# Known rules to extract keywords from a referrer search engine URL
#------------------------------------------------------------------------------
%SearchEnginesKnownUrlTrail=(
# Japanese Search Engines
# Added by Hobbit_makoto 2007.01.17
'fresheyedir','\/',
'idolphoto','\/index[0-9]+\.html',
'meta2','_\.html',
'olane','\/c\/\d',
'pex','\/xargs.+',
'yahoogle','\.html',
);

# SearchEnginesKnownUrlNotFound
# Known rules to extract not found keywords from a referrer search engine URL
#------------------------------------------------------------------------------
%SearchEnginesKnownUrlNotFound=(
# Most common search engines
'msn','origq='
);

# If no rules are known, WordsToExtractSearchUrl will be used to search keyword parameter
# If no rules are known and search in WordsToExtractSearchUrl failed, this will be used to clean URL of not keyword parameters.
#------------------------------------------------------------------------------
# old and not required @WordsToExtractSearchUrl= ('all=','as_q=','ask=','claus=','dotaz=','find=','general=','Gw=','heureka=','highlight=','ie=','image keys=','imgurl=','in=','iu=','k=','KERESES=','key=','keyword=','keywords=','kw=','mt=','name=','nusearch_terms=','OVKEY=','p=','p1=','pattern=','q=','q1=','qkw=','qpvt=','qr=','qr=','qry=','qs=','qt=','query=','querytext=','question=','r=','rdata=','req=','s=','search=','search_field=','search_for=','Search_Keyword=','search_term=','searchfor=','searchstr=','searchtext=','searchWord=','Serbian=','slowo=','soegeord=','sp-q=','srch=','st=','stext=','string=','su=','szukaj=','term=','text=','tn=','txtsearch=','uery=','w=','wd=','word=','words=');
@WordsToCleanSearchUrl= ('act=','annuaire=','btng=','cat=','categoria=','cfg=','cof=','cou=','count=','cp=','dd=','domain=','dt=','dw=','enc=','exec=','geo=','hc=','height=','hits=','hl=','hq=','hs=','id=','kl=','lang=','loc=','lr=','matchmode=','medor=','message=','meta=','mode=','order=','page=','par=','pays=','pg=','pos=','prg=','qc=','refer=','sa=','safe=','sc=','sort=','src=','start=','style=','stype=','sum=','tag=','temp=','theme=','type=','url=','user=','width=','what=','\\.x=','\\.y=','y=','look=');

# SearchEnginesKnownUTFCoding
# Known parameter that proves a search engine has coded its parameters in UTF-8
#------------------------------------------------------------------------------
%SearchEnginesKnownUTFCoding=(
# Most common search engines
'google','ie=utf-8',
'alltheweb','cs=utf-8'
);


# SearchEnginesHashLib
# List of search engines names
# 'search_engine_id','search_engine_name',
#------------------------------------------------------------------------------
%SearchEnginesHashLib=(
# Japanese Search Engines
# Added by Ryu 2006.03.15
'answers','<a href="http://www.answers.com" rel="nofollow">Answers.com</a>',
'allabout','<a href="http://search.allabout.co.jp" rel="nofollow">All About</a>',
'auone','<a href="http://search.auone.jp" rel="nofollow">au one</a>',
'avabox','<a href="http://avabox.jp" rel="nofollow">Avabox</a>',
'googlejapan','<a href="http://www.google.co.jp" rel="nofollow">Google Japan</a>',
'biglobe','<a href="http://www.biglobe.ne.jp" rel="nofollow">BIGLOBE</a>',
'cashback','<a href="http://www.cashback.ne.jp" rel="nofollow">Cashback Mall</a>',
'kbg','<a href="http://keitai.biglobe.ne.jp" rel="nofollow">ケータイBIGLOBE</a>',
'cometsystems','Comet Systems',
'cybozu','<a href="http://www.cybozu.net" rel="nofollow">cybozu.net</a>',
'aoljapan','<a href="http://search.jp.aol.com" rel="nofollow">AOL Japan</a>',
'goo','<a href="http://goo.ne.jp" rel="nofollow">Goo</a>',
'nifty','<a href="http://www.nifty.com/search/" rel="nofollow">Nifty</a>',
'msnjapan','<a href="http://jp.msn.com" rel="nofollow">Microsoft MSN Japan</a>',
'odn','ODN',
'clustyjp','<a href="http://clusty.jp" rel="nofollow">Clusty Japan</a>',
'docomo','<a href="http://www.nttdocomo.co.jp" rel="nofollow">NTT docomo</a>',
'eniro','<a href="http://eniro.fi" rel="nofollow">eniro</a>',
'excitejapan','Excite Japan',
'ezweb','<a href="http://www.au.kddi.com/service/ezweb/index.html" rel="nofollow">ezweb</a>',
'fastbrowsersearch','<a href="http://www.fastbrowsersearch.com" rel="nofollow">Fast Browser Search</a>',
'sonet','<a href="http://www.so-net.ne.jp/search/web/" rel="nofollow">So-net ウェブ検索</a>',
'mtechnoratijp','<a href="http://m.technorati.jp" rel="nofollow">テクノラティモバイル検索</a>',
'wtechnoratijp','<a href="http://technorati.jp" rel="nofollow">テクノラティ検索(WWW)</a>',
'technoratijp','<a href="http://technorati.jp" rel="nofollow">テクノラティ検索</a>',
'technorati','<a href="http://technorati.com" rel="nofollow">Technorati Search</a>',
'websearch','<a href="http://www.websearch.com" rel="nofollow">WebSearch</a>',
'yahoogle','<a href="http://www.yahoogle.jp" rel="nofollow">yahoogle</a>',
'yicha','<a href="http://yicha.jp" rel="nofollow">yicha</a>',
#'msn_cache','MSN Cache',
'marsflag','<a href="http://www.marsflag.com" rel="nofollow">MARSFLAG</a>',
'meta2','<a href="http://meta2.the-search.jp" rel="nofollow">The Search メタ検索 2.0</a>',
'metcha','<a href="http://bach.istc.kobe-u.ac.jp/metcha/" rel="nofollow">[Metcha Search]メッチャ検索エンジン</a>',
'metager','<a href="http://meta.rrzn.uni-hannover.de" rel="nofollow">Meta Ger</a>',
'myway','<a href="http://home.myway.com" rel="nofollow">MyWay</a>',
'naverjp','<a href="http://www.naver.co.jp" rel="nofollow">Naver.co.jp</a>',
'navercom','<a href="http://www.naver.com" rel="nofollow">Naver.com</a>',
'nikkei','<a href="http://sitesearch.nikkei.co.jp" rel="nofollow">Nikkei Net</a>',
'lifemile','<a href="http://search.lifemile.jp" rel="nofollow">Life Mile</a>',
'50pt','<a href="http://search.50pt.jp" rel="nofollow">50pt</a>',
'pointbox','<a href="http://search.point-box.jp" rel="nofollow">Point Box</a>',
'okodukai','<a href="http://search.okodukai.jp" rel="nofollow">お小遣いJP</a>',
'asamasearch','<a href="http://find.x0.to" rel="nofollow">Asamasearch</a>',
'fc2','<a href="http://fc2.super-search.jp" rel="nofollow">fc2.super-search.jp</a>',
'fresheye','<a href="http://fresheye.com" rel="nofollow">Fresheye</a>',
'fresheyedir','<a href="http://fresheye.com" rel="nofollow">Fresheye(Dir)</a>',
'idolphoto','<a href="http://search.idol-photo.com" rel="nofollow">search.idol-photo.com</a>',
'iug','<a href="http://iug.newsing.jp" rel="nofollow">iUG-newsing</a>',
'1pa2','<a href="http://search.1pa2.info" rel="nofollow">1pa2</a>',
'juno','<a href="http://search.juno.com" rel="nofollow">JUNO</a>',
'jword','<a href="http://www.jword.jp" rel="nofollow">Jword</a>',
'lunascape','<a href="http://s.luna.tv" rel="nofollow">Lunascape</a>',
'seochat','SEOChat',
'tocc','TOCC/Search',
'searchhp','<a href="http://search-hp.com" rel="nofollow">Search HP</a>',
'niwango','<a href="http://niwango.jp" rel="nofollow">ニワンゴ</a>',
'olane','<a href="http://olane.jp" rel="nofollow">olane.jp</a>',
'pex','<a href="http://pex.jp" rel="nofollow">pex.jp</a>',
'picsearchcom','<a href="http://www.picsearch.com" rel="nofollow">picsearch</a>',
'picsearchsk','<a href="http://www.picsearch.sk" rel="nofollow">picsearch.sk</a>',
'picmy','<a href="http://picmy.jp" rel="nofollow">不思議なピクミー</a>',
'prsearch','<a href="http://www.prsearch.biz" rel="nofollow">prsearch</a>',
'rakuten','<a href="http://www.rakuten.co.jp" rel="nofollow">楽天</a>',
'baidujp','<a href="http://www.baidu.jp" rel="nofollow">baidu.jp</a>',
'imagebaidujp','<a href="http://image.baidu.jp" rel="nofollow">image.baidu.jp</a>',
'ceekjp','<a href="http://www.ceek.jp" rel="nofollow">CEEK.JP</a>',
'dirbg','<a href="http://dir.dir.bg" rel="nofollow">Dir.bg</a>',
'infoseek','<a href="http://www.infoseek.co.jp" rel="nofollow">Infoseek</a>',
'yahoocache','Yahoo Cache',
'livedoor','Livedoor',
# Search engine output links or not as the case may be

'www_google_co_uk','<a href="http://www.google.co.uk" title="Search Engine Home Page" rel="nofollow">Google United Kingdom</a>',
'images_google_co_uk','<a href="http://images.google.co.uk" title="Search Engine Home Page" rel="nofollow">Google United Kingdom ( images )</a>',
'translate_google_co_uk','<a href="http://translate.google.co.uk" title="Search Engine Home Page" rel="nofollow">Google Translate United Kingdom</a>',
'google_co_uk','<a href="http://google.co.uk" title="Search Engine Home Page" rel="nofollow">Google United Kingdom ( catchall )</a>',
'www_google_com','<a href="http://www.google.com" title="Search Engine Home Page" rel="nofollow">Google .com</a>',
'images_google_com','<a href="http://images.google.com" title="Search Engine Home Page" rel="nofollow">Google .com ( images )</a>',
'translate_google_com','<a href="http://translate.google.com" title="Search Engine Home Page" rel="nofollow">Google Translate .com</a>',
'google_com','<a href="http://google.com" title="Search Engine Home Page" rel="nofollow">Google .com ( catchall )</a>',
'www_google_de','<a href="http://www.google.de" title="Search Engine Home Page" rel="nofollow">Google Germany</a>',
'images_google_de','<a href="http://images.google.de" title="Search Engine Home Page" rel="nofollow">Google Germany ( images )</a>',
'translate_google_de','<a href="http://translate.google.de" title="Search Engine Home Page" rel="nofollow">Google Translate Germany</a>',
'google_de','<a href="http://google.de" title="Search Engine Home Page" rel="nofollow">Google Germany ( catchall )</a>',
'www_google_fr','<a href="http://www.google.fr" title="Search Engine Home Page" rel="nofollow">Google France</a>',
'images_google_fr','<a href="http://images.google.fr" title="Search Engine Home Page" rel="nofollow">Google France ( images )</a>',
'translate_google_fr','<a href="http://translate.google.fr" title="Search Engine Home Page" rel="nofollow">Google Translate France</a>',
'google_fr','<a href="http://google.fr" title="Search Engine Home Page" rel="nofollow">Google France ( catchall )</a>',
'www_google_ca','<a href="http://www.google.ca" title="Search Engine Home Page" rel="nofollow">Google Canada</a>',
'images_google_ca','<a href="http://images.google.ca" title="Search Engine Home Page" rel="nofollow">Google Canada ( images )</a>',
'translate_google_ca','<a href="http://translate.google.ca" title="Search Engine Home Page" rel="nofollow">Google Translate Canada</a>',
'google_ca','<a href="http://google.ca" title="Search Engine Home Page" rel="nofollow">Google Canada ( catchall )</a>',
'www_google_es','<a href="http://www.google.es" title="Search Engine Home Page" rel="nofollow">Google Spain</a>',
'images_google_es','<a href="http://images.google.es" title="Search Engine Home Page" rel="nofollow">Google Spain ( images )</a>',
'translate_google_es','<a href="http://translate.google.es" title="Search Engine Home Page" rel="nofollow">Google Translate Spain</a>',
'google_es','<a href="http://google.es" title="Search Engine Home Page" rel="nofollow">Google Spain ( catchall )</a>',
'www_google_com_au','<a href="http://www.google.com.au" title="Search Engine Home Page" rel="nofollow">Google Australia</a>',
'images_google_com_au','<a href="http://images.google.com.au" title="Search Engine Home Page" rel="nofollow">Google Australia ( images )</a>',
'translate_google_com_au','<a href="http://translate.google.com.au" title="Search Engine Home Page" rel="nofollow">Google Translate Australia</a>',
'google_com_au','<a href="http://google.com.au" title="Search Engine Home Page" rel="nofollow">Google Australia ( catchall )</a>',
'www_google_nl','<a href="http://www.google.nl" title="Search Engine Home Page" rel="nofollow">Google Netherlands</a>',
'images_google_nl','<a href="http://images.google.nl" title="Search Engine Home Page" rel="nofollow">Google Netherlands ( images )</a>',
'translate_google_nl','<a href="http://translate.google.nl" title="Search Engine Home Page" rel="nofollow">Google Translate Netherlands</a>',
'google_nl','<a href="http://google.nl" title="Search Engine Home Page" rel="nofollow">Google Netherlands ( catchall )</a>',
'www_google_gr','<a href="http://www.google.gr" title="Search Engine Home Page" rel="nofollow">Google Greece</a>',
'images_google_gr','<a href="http://images.google.gr" title="Search Engine Home Page" rel="nofollow">Google Greece ( images )</a>',
'translate_google_gr','<a href="http://translate.google.gr" title="Search Engine Home Page" rel="nofollow">Google Translate Greece</a>',
'google_gr','<a href="http://google.gr" title="Search Engine Home Page" rel="nofollow">Google Greece ( catchall )</a>',
'www_google_se','<a href="http://www.google.se" title="Search Engine Home Page" rel="nofollow">Google Sweden</a>',
'images_google_se','<a href="http://images.google.se" title="Search Engine Home Page" rel="nofollow">Google Sweden ( images )</a>',
'translate_google_se','<a href="http://translate.google.se" title="Search Engine Home Page" rel="nofollow">Google Translate Sweden</a>',
'google_se','<a href="http://google.se" title="Search Engine Home Page" rel="nofollow">Google Sweden ( catchall )</a>',
'www_google_ie','<a href="http://www.google.ie" title="Search Engine Home Page" rel="nofollow">Google Ireland</a>',
'images_google_ie','<a href="http://images.google.ie" title="Search Engine Home Page" rel="nofollow">Google Ireland ( images )</a>',
'translate_google_ie','<a href="http://translate.google.ie" title="Search Engine Home Page" rel="nofollow">Google Translate Ireland</a>',
'google_ie','<a href="http://google.ie" title="Search Engine Home Page" rel="nofollow">Google Ireland ( catchall )</a>',
'www_google_it','<a href="http://www.google.it" title="Search Engine Home Page" rel="nofollow">Google Italy</a>',
'images_google_it','<a href="http://images.google.it" title="Search Engine Home Page" rel="nofollow">Google Italy ( images )</a>',
'translate_google_it','<a href="http://translate.google.it" title="Search Engine Home Page" rel="nofollow">Google Translate Italy</a>',
'google_it','<a href="http://google.it" title="Search Engine Home Page" rel="nofollow">Google Italy ( catchall )</a>',
'www_google_no','<a href="http://www.google.no" title="Search Engine Home Page" rel="nofollow">Google Norway</a>',
'images_google_no','<a href="http://images.google.no" title="Search Engine Home Page" rel="nofollow">Google Norway ( images )</a>',
'translate_google_no','<a href="http://translate.google.no" title="Search Engine Home Page" rel="nofollow">Google Translate Norway</a>',
'google_no','<a href="http://google.no" title="Search Engine Home Page" rel="nofollow">Google Norway ( catchall )</a>',
'www_google_com_tr','<a href="http://www.google.com.tr" title="Search Engine Home Page" rel="nofollow">Google Turkey</a>',
'images_google_com_tr','<a href="http://images.google.com.tr" title="Search Engine Home Page" rel="nofollow">Google Turkey ( images )</a>',
'translate_google_com_tr','<a href="http://translate.google.com.tr" title="Search Engine Home Page" rel="nofollow">Google Translate Turkey</a>',
'google_com_tr','<a href="http://google.com.tr" title="Search Engine Home Page" rel="nofollow">Google Turkey ( catchall )</a>',
'www_google_co_in','<a href="http://www.google.co.in" title="Search Engine Home Page" rel="nofollow">Google India</a>',
'images_google_co_in','<a href="http://images.google.co.in" title="Search Engine Home Page" rel="nofollow">Google India ( images )</a>',
'translate_google_co_in','<a href="http://translate.google.co.in" title="Search Engine Home Page" rel="nofollow">Google Translate India</a>',
'google_co_in','<a href="http://google.co.in" title="Search Engine Home Page" rel="nofollow">Google India ( catchall )</a>',
'www_google_pt','<a href="http://www.google.pt" title="Search Engine Home Page" rel="nofollow">Google Portugal</a>',
'images_google_pt','<a href="http://images.google.pt" title="Search Engine Home Page" rel="nofollow">Google Portugal ( images )</a>',
'translate_google_pt','<a href="http://translate.google.pt" title="Search Engine Home Page" rel="nofollow">Google Translate Portugal</a>',
'google_pt','<a href="http://google.pt" title="Search Engine Home Page" rel="nofollow">Google Portugal ( catchall )</a>',
'www_google_hr','<a href="http://www.google.hr" title="Search Engine Home Page" rel="nofollow">Google Croatia</a>',
'images_google_hr','<a href="http://images.google.hr" title="Search Engine Home Page" rel="nofollow">Google Croatia ( images )</a>',
'translate_google_hr','<a href="http://translate.google.hr" title="Search Engine Home Page" rel="nofollow">Google Translate Croatia</a>',
'google_hr','<a href="http://google.hr" title="Search Engine Home Page" rel="nofollow">Google Croatia ( catchall )</a>',
'www_google_co_nz','<a href="http://www.google.co.nz" title="Search Engine Home Page" rel="nofollow">Google New Zealand</a>',
'images_google_co_nz','<a href="http://images.google.co.nz" title="Search Engine Home Page" rel="nofollow">Google New Zealand ( images )</a>',
'translate_google_co_nz','<a href="http://translate.google.co.nz" title="Search Engine Home Page" rel="nofollow">Google Translate New Zealand</a>',
'google_co_nz','<a href="http://google.co.nz" title="Search Engine Home Page" rel="nofollow">Google New Zealand ( catchall )</a>',
'www_google_pl','<a href="http://www.google.pl" title="Search Engine Home Page" rel="nofollow">Google Poland</a>',
'images_google_pl','<a href="http://images.google.pl" title="Search Engine Home Page" rel="nofollow">Google Poland ( images )</a>',
'translate_google_pl','<a href="http://translate.google.pl" title="Search Engine Home Page" rel="nofollow">Google Translate Poland</a>',
'google_pl','<a href="http://google.pl" title="Search Engine Home Page" rel="nofollow">Google Poland ( catchall )</a>',
'www_google_ac','<a href="http://www.google.ac" title="Search Engine Home Page" rel="nofollow">Google Ascension Island</a>',
'images_google_ac','<a href="http://images.google.ac" title="Search Engine Home Page" rel="nofollow">Google Ascension Island ( images )</a>',
'translate_google_ac','<a href="http://translate.google.ac" title="Search Engine Home Page" rel="nofollow">Google Translate Ascension Island</a>',
'google_ac','<a href="http://google.ac" title="Search Engine Home Page" rel="nofollow">Google Ascension Island ( catchall )</a>',
'www_google_ad','<a href="http://www.google.ad" title="Search Engine Home Page" rel="nofollow">Google Andorra</a>',
'images_google_ad','<a href="http://images.google.ad" title="Search Engine Home Page" rel="nofollow">Google Andorra ( images )</a>',
'translate_google_ad','<a href="http://translate.google.ad" title="Search Engine Home Page" rel="nofollow">Google Translate Andorra</a>',
'google_ad','<a href="http://google.ad" title="Search Engine Home Page" rel="nofollow">Google Andorra ( catchall )</a>',
'www_google_ae','<a href="http://www.google.ae" title="Search Engine Home Page" rel="nofollow">Google United Arab Emirates</a>',
'images_google_ae','<a href="http://images.google.ae" title="Search Engine Home Page" rel="nofollow">Google United Arab Emirates ( images )</a>',
'translate_google_ae','<a href="http://translate.google.ae" title="Search Engine Home Page" rel="nofollow">Google Translate United Arab Emirates</a>',
'google_ae','<a href="http://google.ae" title="Search Engine Home Page" rel="nofollow">Google United Arab Emirates ( catchall )</a>',
'www_google_al','<a href="http://www.google.al" title="Search Engine Home Page" rel="nofollow">Google Albania</a>',
'images_google_al','<a href="http://images.google.al" title="Search Engine Home Page" rel="nofollow">Google Albania ( images )</a>',
'translate_google_al','<a href="http://translate.google.al" title="Search Engine Home Page" rel="nofollow">Google Translate Albania</a>',
'google_al','<a href="http://google.al" title="Search Engine Home Page" rel="nofollow">Google Albania ( catchall )</a>',
'www_google_am','<a href="http://www.google.am" title="Search Engine Home Page" rel="nofollow">Google Armenia</a>',
'images_google_am','<a href="http://images.google.am" title="Search Engine Home Page" rel="nofollow">Google Armenia ( images )</a>',
'translate_google_am','<a href="http://translate.google.am" title="Search Engine Home Page" rel="nofollow">Google Translate Armenia</a>',
'google_am','<a href="http://google.am" title="Search Engine Home Page" rel="nofollow">Google Armenia ( catchall )</a>',
'www_google_as','<a href="http://www.google.as" title="Search Engine Home Page" rel="nofollow">Google American Samoa</a>',
'images_google_as','<a href="http://images.google.as" title="Search Engine Home Page" rel="nofollow">Google American Samoa ( images )</a>',
'translate_google_as','<a href="http://translate.google.as" title="Search Engine Home Page" rel="nofollow">Google Translate American Samoa</a>',
'google_as','<a href="http://google.as" title="Search Engine Home Page" rel="nofollow">Google American Samoa ( catchall )</a>',
'www_google_at','<a href="http://www.google.at" title="Search Engine Home Page" rel="nofollow">Google Austria</a>',
'images_google_at','<a href="http://images.google.at" title="Search Engine Home Page" rel="nofollow">Google Austria ( images )</a>',
'translate_google_at','<a href="http://translate.google.at" title="Search Engine Home Page" rel="nofollow">Google Translate Austria</a>',
'google_at','<a href="http://google.at" title="Search Engine Home Page" rel="nofollow">Google Austria ( catchall )</a>',
'www_google_az','<a href="http://www.google.az" title="Search Engine Home Page" rel="nofollow">Google Azerbaijan</a>',
'images_google_az','<a href="http://images.google.az" title="Search Engine Home Page" rel="nofollow">Google Azerbaijan ( images )</a>',
'translate_google_az','<a href="http://translate.google.az" title="Search Engine Home Page" rel="nofollow">Google Translate Azerbaijan</a>',
'google_az','<a href="http://google.az" title="Search Engine Home Page" rel="nofollow">Google Azerbaijan ( catchall )</a>',
'www_google_ba','<a href="http://www.google.ba" title="Search Engine Home Page" rel="nofollow">Google Bosnia and Herzegovina</a>',
'images_google_ba','<a href="http://images.google.ba" title="Search Engine Home Page" rel="nofollow">Google Bosnia and Herzegovina ( images )</a>',
'translate_google_ba','<a href="http://translate.google.ba" title="Search Engine Home Page" rel="nofollow">Google Translate Bosnia and Herzegovina</a>',
'google_ba','<a href="http://google.ba" title="Search Engine Home Page" rel="nofollow">Google Bosnia and Herzegovina ( catchall )</a>',
'www_google_be','<a href="http://www.google.be" title="Search Engine Home Page" rel="nofollow">Google Belgium</a>',
'images_google_be','<a href="http://images.google.be" title="Search Engine Home Page" rel="nofollow">Google Belgium ( images )</a>',
'translate_google_be','<a href="http://translate.google.be" title="Search Engine Home Page" rel="nofollow">Google Translate Belgium</a>',
'google_be','<a href="http://google.be" title="Search Engine Home Page" rel="nofollow">Google Belgium ( catchall )</a>',
'www_google_bf','<a href="http://www.google.bf" title="Search Engine Home Page" rel="nofollow">Google Burkina Faso</a>',
'images_google_bf','<a href="http://images.google.bf" title="Search Engine Home Page" rel="nofollow">Google Burkina Faso ( images )</a>',
'translate_google_bf','<a href="http://translate.google.bf" title="Search Engine Home Page" rel="nofollow">Google Translate Burkina Faso</a>',
'google_bf','<a href="http://google.bf" title="Search Engine Home Page" rel="nofollow">Google Burkina Faso ( catchall )</a>',
'www_google_bg','<a href="http://www.google.bg" title="Search Engine Home Page" rel="nofollow">Google Bulgaria</a>',
'images_google_bg','<a href="http://images.google.bg" title="Search Engine Home Page" rel="nofollow">Google Bulgaria ( images )</a>',
'translate_google_bg','<a href="http://translate.google.bg" title="Search Engine Home Page" rel="nofollow">Google Translate Bulgaria</a>',
'google_bg','<a href="http://google.bg" title="Search Engine Home Page" rel="nofollow">Google Bulgaria ( catchall )</a>',
'www_google_bi','<a href="http://www.google.bi" title="Search Engine Home Page" rel="nofollow">Google Burundi</a>',
'images_google_bi','<a href="http://images.google.bi" title="Search Engine Home Page" rel="nofollow">Google Burundi ( images )</a>',
'translate_google_bi','<a href="http://translate.google.bi" title="Search Engine Home Page" rel="nofollow">Google Translate Burundi</a>',
'google_bi','<a href="http://google.bi" title="Search Engine Home Page" rel="nofollow">Google Burundi ( catchall )</a>',
'www_google_bj','<a href="http://www.google.bj" title="Search Engine Home Page" rel="nofollow">Google Benin</a>',
'images_google_bj','<a href="http://images.google.bj" title="Search Engine Home Page" rel="nofollow">Google Benin ( images )</a>',
'translate_google_bj','<a href="http://translate.google.bj" title="Search Engine Home Page" rel="nofollow">Google Translate Benin</a>',
'google_bj','<a href="http://google.bj" title="Search Engine Home Page" rel="nofollow">Google Benin ( catchall )</a>',
'www_google_bs','<a href="http://www.google.bs" title="Search Engine Home Page" rel="nofollow">Google Bahamas</a>',
'images_google_bs','<a href="http://images.google.bs" title="Search Engine Home Page" rel="nofollow">Google Bahamas ( images )</a>',
'translate_google_bs','<a href="http://translate.google.bs" title="Search Engine Home Page" rel="nofollow">Google Translate Bahamas</a>',
'google_bs','<a href="http://google.bs" title="Search Engine Home Page" rel="nofollow">Google Bahamas ( catchall )</a>',
'www_google_bt','<a href="http://www.google.bt" title="Search Engine Home Page" rel="nofollow">Google Bhutan</a>',
'images_google_bt','<a href="http://images.google.bt" title="Search Engine Home Page" rel="nofollow">Google Bhutan ( images )</a>',
'translate_google_bt','<a href="http://translate.google.bt" title="Search Engine Home Page" rel="nofollow">Google Translate Bhutan</a>',
'google_bt','<a href="http://google.bt" title="Search Engine Home Page" rel="nofollow">Google Bhutan ( catchall )</a>',
'www_google_by','<a href="http://www.google.by" title="Search Engine Home Page" rel="nofollow">Google Belarus</a>',
'images_google_by','<a href="http://images.google.by" title="Search Engine Home Page" rel="nofollow">Google Belarus ( images )</a>',
'translate_google_by','<a href="http://translate.google.by" title="Search Engine Home Page" rel="nofollow">Google Translate Belarus</a>',
'google_by','<a href="http://google.by" title="Search Engine Home Page" rel="nofollow">Google Belarus ( catchall )</a>',
'www_google_cat','<a href="http://www.google.cat" title="Search Engine Home Page" rel="nofollow">Google Catalan Countries</a>',
'images_google_cat','<a href="http://images.google.cat" title="Search Engine Home Page" rel="nofollow">Google Catalan Countries ( images )</a>',
'translate_google_cat','<a href="http://translate.google.cat" title="Search Engine Home Page" rel="nofollow">Google Translate Catalan Countries</a>',
'google_cat','<a href="http://google.cat" title="Search Engine Home Page" rel="nofollow">Google Catalan Countries ( catchall )</a>',
'www_google_cc','<a href="http://www.google.cc" title="Search Engine Home Page" rel="nofollow">Google Cocos (Keeling) Islands</a>',
'images_google_cc','<a href="http://images.google.cc" title="Search Engine Home Page" rel="nofollow">Google Cocos (Keeling) Islands ( images )</a>',
'translate_google_cc','<a href="http://translate.google.cc" title="Search Engine Home Page" rel="nofollow">Google Translate Cocos (Keeling) Islands</a>',
'google_cc','<a href="http://google.cc" title="Search Engine Home Page" rel="nofollow">Google Cocos (Keeling) Islands ( catchall )</a>',
'www_google_cd','<a href="http://www.google.cd" title="Search Engine Home Page" rel="nofollow">Google Democratic Republic of the Congo</a>',
'images_google_cd','<a href="http://images.google.cd" title="Search Engine Home Page" rel="nofollow">Google Democratic Republic of the Congo ( images )</a>',
'translate_google_cd','<a href="http://translate.google.cd" title="Search Engine Home Page" rel="nofollow">Google Translate Democratic Republic of the Congo</a>',
'google_cd','<a href="http://google.cd" title="Search Engine Home Page" rel="nofollow">Google Democratic Republic of the Congo ( catchall )</a>',
'www_google_cf','<a href="http://www.google.cf" title="Search Engine Home Page" rel="nofollow">Google Central African Republic</a>',
'images_google_cf','<a href="http://images.google.cf" title="Search Engine Home Page" rel="nofollow">Google Central African Republic ( images )</a>',
'translate_google_cf','<a href="http://translate.google.cf" title="Search Engine Home Page" rel="nofollow">Google Translate Central African Republic</a>',
'google_cf','<a href="http://google.cf" title="Search Engine Home Page" rel="nofollow">Google Central African Republic ( catchall )</a>',
'www_google_cg','<a href="http://www.google.cg" title="Search Engine Home Page" rel="nofollow">Google Republic of the Congo</a>',
'images_google_cg','<a href="http://images.google.cg" title="Search Engine Home Page" rel="nofollow">Google Republic of the Congo ( images )</a>',
'translate_google_cg','<a href="http://translate.google.cg" title="Search Engine Home Page" rel="nofollow">Google Translate Republic of the Congo</a>',
'google_cg','<a href="http://google.cg" title="Search Engine Home Page" rel="nofollow">Google Republic of the Congo ( catchall )</a>',
'www_google_ch','<a href="http://www.google.ch" title="Search Engine Home Page" rel="nofollow">Google Switzerland</a>',
'images_google_ch','<a href="http://images.google.ch" title="Search Engine Home Page" rel="nofollow">Google Switzerland ( images )</a>',
'translate_google_ch','<a href="http://translate.google.ch" title="Search Engine Home Page" rel="nofollow">Google Translate Switzerland</a>',
'google_ch','<a href="http://google.ch" title="Search Engine Home Page" rel="nofollow">Google Switzerland ( catchall )</a>',
'www_google_ci','<a href="http://www.google.ci" title="Search Engine Home Page" rel="nofollow">Google Ivory Coast</a>',
'images_google_ci','<a href="http://images.google.ci" title="Search Engine Home Page" rel="nofollow">Google Ivory Coast ( images )</a>',
'translate_google_ci','<a href="http://translate.google.ci" title="Search Engine Home Page" rel="nofollow">Google Translate Ivory Coast</a>',
'google_ci','<a href="http://google.ci" title="Search Engine Home Page" rel="nofollow">Google Ivory Coast ( catchall )</a>',
'www_google_cl','<a href="http://www.google.cl" title="Search Engine Home Page" rel="nofollow">Google Chile</a>',
'images_google_cl','<a href="http://images.google.cl" title="Search Engine Home Page" rel="nofollow">Google Chile ( images )</a>',
'translate_google_cl','<a href="http://translate.google.cl" title="Search Engine Home Page" rel="nofollow">Google Translate Chile</a>',
'google_cl','<a href="http://google.cl" title="Search Engine Home Page" rel="nofollow">Google Chile ( catchall )</a>',
'www_google_cm','<a href="http://www.google.cm" title="Search Engine Home Page" rel="nofollow">Google Cameroon</a>',
'images_google_cm','<a href="http://images.google.cm" title="Search Engine Home Page" rel="nofollow">Google Cameroon ( images )</a>',
'translate_google_cm','<a href="http://translate.google.cm" title="Search Engine Home Page" rel="nofollow">Google Translate Cameroon</a>',
'google_cm','<a href="http://google.cm" title="Search Engine Home Page" rel="nofollow">Google Cameroon ( catchall )</a>',
'www_google_cn','<a href="http://www.google.cn" title="Search Engine Home Page" rel="nofollow">Google China</a>',
'images_google_cn','<a href="http://images.google.cn" title="Search Engine Home Page" rel="nofollow">Google China ( images )</a>',
'translate_google_cn','<a href="http://translate.google.cn" title="Search Engine Home Page" rel="nofollow">Google Translate China</a>',
'google_cn','<a href="http://google.cn" title="Search Engine Home Page" rel="nofollow">Google China ( catchall )</a>',
'www_google_co_ao','<a href="http://www.google.co.ao" title="Search Engine Home Page" rel="nofollow">Google Angola</a>',
'images_google_co_ao','<a href="http://images.google.co.ao" title="Search Engine Home Page" rel="nofollow">Google Angola ( images )</a>',
'translate_google_co_ao','<a href="http://translate.google.co.ao" title="Search Engine Home Page" rel="nofollow">Google Translate Angola</a>',
'google_co_ao','<a href="http://google.co.ao" title="Search Engine Home Page" rel="nofollow">Google Angola ( catchall )</a>',
'www_google_co_bw','<a href="http://www.google.co.bw" title="Search Engine Home Page" rel="nofollow">Google Botswana</a>',
'images_google_co_bw','<a href="http://images.google.co.bw" title="Search Engine Home Page" rel="nofollow">Google Botswana ( images )</a>',
'translate_google_co_bw','<a href="http://translate.google.co.bw" title="Search Engine Home Page" rel="nofollow">Google Translate Botswana</a>',
'google_co_bw','<a href="http://google.co.bw" title="Search Engine Home Page" rel="nofollow">Google Botswana ( catchall )</a>',
'www_google_co_ck','<a href="http://www.google.co.ck" title="Search Engine Home Page" rel="nofollow">Google Cook Islands</a>',
'images_google_co_ck','<a href="http://images.google.co.ck" title="Search Engine Home Page" rel="nofollow">Google Cook Islands ( images )</a>',
'translate_google_co_ck','<a href="http://translate.google.co.ck" title="Search Engine Home Page" rel="nofollow">Google Translate Cook Islands</a>',
'google_co_ck','<a href="http://google.co.ck" title="Search Engine Home Page" rel="nofollow">Google Cook Islands ( catchall )</a>',
'www_google_co_cr','<a href="http://www.google.co.cr" title="Search Engine Home Page" rel="nofollow">Google Costa Rica</a>',
'images_google_co_cr','<a href="http://images.google.co.cr" title="Search Engine Home Page" rel="nofollow">Google Costa Rica ( images )</a>',
'translate_google_co_cr','<a href="http://translate.google.co.cr" title="Search Engine Home Page" rel="nofollow">Google Translate Costa Rica</a>',
'google_co_cr','<a href="http://google.co.cr" title="Search Engine Home Page" rel="nofollow">Google Costa Rica ( catchall )</a>',
'www_google_co_id','<a href="http://www.google.co.id" title="Search Engine Home Page" rel="nofollow">Google Indonesia</a>',
'images_google_co_id','<a href="http://images.google.co.id" title="Search Engine Home Page" rel="nofollow">Google Indonesia ( images )</a>',
'translate_google_co_id','<a href="http://translate.google.co.id" title="Search Engine Home Page" rel="nofollow">Google Translate Indonesia</a>',
'google_co_id','<a href="http://google.co.id" title="Search Engine Home Page" rel="nofollow">Google Indonesia ( catchall )</a>',
'www_google_co_il','<a href="http://www.google.co.il" title="Search Engine Home Page" rel="nofollow">Google Israel</a>',
'images_google_co_il','<a href="http://images.google.co.il" title="Search Engine Home Page" rel="nofollow">Google Israel ( images )</a>',
'translate_google_co_il','<a href="http://translate.google.co.il" title="Search Engine Home Page" rel="nofollow">Google Translate Israel</a>',
'google_co_il','<a href="http://google.co.il" title="Search Engine Home Page" rel="nofollow">Google Israel ( catchall )</a>',
'www_google_co_jp','<a href="http://www.google.co.jp" title="Search Engine Home Page" rel="nofollow">Google Japan</a>',
'images_google_co_jp','<a href="http://images.google.co.jp" title="Search Engine Home Page" rel="nofollow">Google Japan ( images )</a>',
'translate_google_co_jp','<a href="http://translate.google.co.jp" title="Search Engine Home Page" rel="nofollow">Google Translate Japan</a>',
'google_co_jp','<a href="http://google.co.jp" title="Search Engine Home Page" rel="nofollow">Google Japan ( catchall )</a>',
'www_google_co_ke','<a href="http://www.google.co.ke" title="Search Engine Home Page" rel="nofollow">Google Kenya</a>',
'images_google_co_ke','<a href="http://images.google.co.ke" title="Search Engine Home Page" rel="nofollow">Google Kenya ( images )</a>',
'translate_google_co_ke','<a href="http://translate.google.co.ke" title="Search Engine Home Page" rel="nofollow">Google Translate Kenya</a>',
'google_co_ke','<a href="http://google.co.ke" title="Search Engine Home Page" rel="nofollow">Google Kenya ( catchall )</a>',
'www_google_co_kr','<a href="http://www.google.co.kr" title="Search Engine Home Page" rel="nofollow">Google South Korea</a>',
'images_google_co_kr','<a href="http://images.google.co.kr" title="Search Engine Home Page" rel="nofollow">Google South Korea ( images )</a>',
'translate_google_co_kr','<a href="http://translate.google.co.kr" title="Search Engine Home Page" rel="nofollow">Google Translate South Korea</a>',
'google_co_kr','<a href="http://google.co.kr" title="Search Engine Home Page" rel="nofollow">Google South Korea ( catchall )</a>',
'www_google_co_ls','<a href="http://www.google.co.ls" title="Search Engine Home Page" rel="nofollow">Google Lesotho</a>',
'images_google_co_ls','<a href="http://images.google.co.ls" title="Search Engine Home Page" rel="nofollow">Google Lesotho ( images )</a>',
'translate_google_co_ls','<a href="http://translate.google.co.ls" title="Search Engine Home Page" rel="nofollow">Google Translate Lesotho</a>',
'google_co_ls','<a href="http://google.co.ls" title="Search Engine Home Page" rel="nofollow">Google Lesotho ( catchall )</a>',
'www_google_co_ma','<a href="http://www.google.co.ma" title="Search Engine Home Page" rel="nofollow">Google Morocco</a>',
'images_google_co_ma','<a href="http://images.google.co.ma" title="Search Engine Home Page" rel="nofollow">Google Morocco ( images )</a>',
'translate_google_co_ma','<a href="http://translate.google.co.ma" title="Search Engine Home Page" rel="nofollow">Google Translate Morocco</a>',
'google_co_ma','<a href="http://google.co.ma" title="Search Engine Home Page" rel="nofollow">Google Morocco ( catchall )</a>',
'www_google_co_mz','<a href="http://www.google.co.mz" title="Search Engine Home Page" rel="nofollow">Google Mozambique</a>',
'images_google_co_mz','<a href="http://images.google.co.mz" title="Search Engine Home Page" rel="nofollow">Google Mozambique ( images )</a>',
'translate_google_co_mz','<a href="http://translate.google.co.mz" title="Search Engine Home Page" rel="nofollow">Google Translate Mozambique</a>',
'google_co_mz','<a href="http://google.co.mz" title="Search Engine Home Page" rel="nofollow">Google Mozambique ( catchall )</a>',
'www_google_co_th','<a href="http://www.google.co.th" title="Search Engine Home Page" rel="nofollow">Google Thailand</a>',
'images_google_co_th','<a href="http://images.google.co.th" title="Search Engine Home Page" rel="nofollow">Google Thailand ( images )</a>',
'translate_google_co_th','<a href="http://translate.google.co.th" title="Search Engine Home Page" rel="nofollow">Google Translate Thailand</a>',
'google_co_th','<a href="http://google.co.th" title="Search Engine Home Page" rel="nofollow">Google Thailand ( catchall )</a>',
'www_google_co_tz','<a href="http://www.google.co.tz" title="Search Engine Home Page" rel="nofollow">Google Tanzania</a>',
'images_google_co_tz','<a href="http://images.google.co.tz" title="Search Engine Home Page" rel="nofollow">Google Tanzania ( images )</a>',
'translate_google_co_tz','<a href="http://translate.google.co.tz" title="Search Engine Home Page" rel="nofollow">Google Translate Tanzania</a>',
'google_co_tz','<a href="http://google.co.tz" title="Search Engine Home Page" rel="nofollow">Google Tanzania ( catchall )</a>',
'www_google_co_ug','<a href="http://www.google.co.ug" title="Search Engine Home Page" rel="nofollow">Google Uganda</a>',
'images_google_co_ug','<a href="http://images.google.co.ug" title="Search Engine Home Page" rel="nofollow">Google Uganda ( images )</a>',
'translate_google_co_ug','<a href="http://translate.google.co.ug" title="Search Engine Home Page" rel="nofollow">Google Translate Uganda</a>',
'google_co_ug','<a href="http://google.co.ug" title="Search Engine Home Page" rel="nofollow">Google Uganda ( catchall )</a>',
'www_google_co_uz','<a href="http://www.google.co.uz" title="Search Engine Home Page" rel="nofollow">Google Uzbekistan</a>',
'images_google_co_uz','<a href="http://images.google.co.uz" title="Search Engine Home Page" rel="nofollow">Google Uzbekistan ( images )</a>',
'translate_google_co_uz','<a href="http://translate.google.co.uz" title="Search Engine Home Page" rel="nofollow">Google Translate Uzbekistan</a>',
'google_co_uz','<a href="http://google.co.uz" title="Search Engine Home Page" rel="nofollow">Google Uzbekistan ( catchall )</a>',
'www_google_co_ve','<a href="http://www.google.co.ve" title="Search Engine Home Page" rel="nofollow">Google Venezuela</a>',

'images_google_co_ve','<a href="http://images.google.co.ve" title="Search Engine Home Page" rel="nofollow">Google Venezuela ( images )</a>',
'translate_google_co_ve','<a href="http://translate.google.co.ve" title="Search Engine Home Page" rel="nofollow">Google Translate Venezuela</a>',
'google_co_ve','<a href="http://google.co.ve" title="Search Engine Home Page" rel="nofollow">Google Venezuela ( catchall )</a>',
'www_google_co_vi','<a href="http://www.google.co.vi" title="Search Engine Home Page" rel="nofollow">Google United States Virgin Islands</a>',
'images_google_co_vi','<a href="http://images.google.co.vi" title="Search Engine Home Page" rel="nofollow">Google United States Virgin Islands ( images )</a>',
'translate_google_co_vi','<a href="http://translate.google.co.vi" title="Search Engine Home Page" rel="nofollow">Google Translate United States Virgin Islands</a>',
'google_co_vi','<a href="http://google.co.vi" title="Search Engine Home Page" rel="nofollow">Google United States Virgin Islands ( catchall )</a>',
'www_google_co_za','<a href="http://www.google.co.za" title="Search Engine Home Page" rel="nofollow">Google South Africa</a>',
'images_google_co_za','<a href="http://images.google.co.za" title="Search Engine Home Page" rel="nofollow">Google South Africa ( images )</a>',
'translate_google_co_za','<a href="http://translate.google.co.za" title="Search Engine Home Page" rel="nofollow">Google Translate South Africa</a>',
'google_co_za','<a href="http://google.co.za" title="Search Engine Home Page" rel="nofollow">Google South Africa ( catchall )</a>',
'www_google_co_zm','<a href="http://www.google.co.zm" title="Search Engine Home Page" rel="nofollow">Google Zambia</a>',
'images_google_co_zm','<a href="http://images.google.co.zm" title="Search Engine Home Page" rel="nofollow">Google Zambia ( images )</a>',
'translate_google_co_zm','<a href="http://translate.google.co.zm" title="Search Engine Home Page" rel="nofollow">Google Translate Zambia</a>',
'google_co_zm','<a href="http://google.co.zm" title="Search Engine Home Page" rel="nofollow">Google Zambia ( catchall )</a>',
'www_google_co_zw','<a href="http://www.google.co.zw" title="Search Engine Home Page" rel="nofollow">Google Zimbabwe</a>',
'images_google_co_zw','<a href="http://images.google.co.zw" title="Search Engine Home Page" rel="nofollow">Google Zimbabwe ( images )</a>',
'translate_google_co_zw','<a href="http://translate.google.co.zw" title="Search Engine Home Page" rel="nofollow">Google Translate Zimbabwe</a>',
'google_co_zw','<a href="http://google.co.zw" title="Search Engine Home Page" rel="nofollow">Google Zimbabwe ( catchall )</a>',
'www_google_com_af','<a href="http://www.google.com.af" title="Search Engine Home Page" rel="nofollow">Google Afghanistan</a>',
'images_google_com_af','<a href="http://images.google.com.af" title="Search Engine Home Page" rel="nofollow">Google Afghanistan ( images )</a>',
'translate_google_com_af','<a href="http://translate.google.com.af" title="Search Engine Home Page" rel="nofollow">Google Translate Afghanistan</a>',
'google_com_af','<a href="http://google.com.af" title="Search Engine Home Page" rel="nofollow">Google Afghanistan ( catchall )</a>',
'www_google_com_ag','<a href="http://www.google.com.ag" title="Search Engine Home Page" rel="nofollow">Google Antigua and Barbuda</a>',
'images_google_com_ag','<a href="http://images.google.com.ag" title="Search Engine Home Page" rel="nofollow">Google Antigua and Barbuda ( images )</a>',
'translate_google_com_ag','<a href="http://translate.google.com.ag" title="Search Engine Home Page" rel="nofollow">Google Translate Antigua and Barbuda</a>',
'google_com_ag','<a href="http://google.com.ag" title="Search Engine Home Page" rel="nofollow">Google Antigua and Barbuda ( catchall )</a>',
'www_google_com_ai','<a href="http://www.google.com.ai" title="Search Engine Home Page" rel="nofollow">Google Anguilla</a>',
'images_google_com_ai','<a href="http://images.google.com.ai" title="Search Engine Home Page" rel="nofollow">Google Anguilla ( images )</a>',
'translate_google_com_ai','<a href="http://translate.google.com.ai" title="Search Engine Home Page" rel="nofollow">Google Translate Anguilla</a>',
'google_com_ai','<a href="http://google.com.ai" title="Search Engine Home Page" rel="nofollow">Google Anguilla ( catchall )</a>',
'www_google_com_ar','<a href="http://www.google.com.ar" title="Search Engine Home Page" rel="nofollow">Google Argentina</a>',
'images_google_com_ar','<a href="http://images.google.com.ar" title="Search Engine Home Page" rel="nofollow">Google Argentina ( images )</a>',
'translate_google_com_ar','<a href="http://translate.google.com.ar" title="Search Engine Home Page" rel="nofollow">Google Translate Argentina</a>',
'google_com_ar','<a href="http://google.com.ar" title="Search Engine Home Page" rel="nofollow">Google Argentina ( catchall )</a>',
'www_google_com_bd','<a href="http://www.google.com.bd" title="Search Engine Home Page" rel="nofollow">Google Bangladesh</a>',
'images_google_com_bd','<a href="http://images.google.com.bd" title="Search Engine Home Page" rel="nofollow">Google Bangladesh ( images )</a>',
'translate_google_com_bd','<a href="http://translate.google.com.bd" title="Search Engine Home Page" rel="nofollow">Google Translate Bangladesh</a>',
'google_com_bd','<a href="http://google.com.bd" title="Search Engine Home Page" rel="nofollow">Google Bangladesh ( catchall )</a>',
'www_google_com_bh','<a href="http://www.google.com.bh" title="Search Engine Home Page" rel="nofollow">Google Bahrain</a>',
'images_google_com_bh','<a href="http://images.google.com.bh" title="Search Engine Home Page" rel="nofollow">Google Bahrain ( images )</a>',
'translate_google_com_bh','<a href="http://translate.google.com.bh" title="Search Engine Home Page" rel="nofollow">Google Translate Bahrain</a>',
'google_com_bh','<a href="http://google.com.bh" title="Search Engine Home Page" rel="nofollow">Google Bahrain ( catchall )</a>',
'www_google_com_bn','<a href="http://www.google.com.bn" title="Search Engine Home Page" rel="nofollow">Google Brunei</a>',
'images_google_com_bn','<a href="http://images.google.com.bn" title="Search Engine Home Page" rel="nofollow">Google Brunei ( images )</a>',
'translate_google_com_bn','<a href="http://translate.google.com.bn" title="Search Engine Home Page" rel="nofollow">Google Translate Brunei</a>',
'google_com_bn','<a href="http://google.com.bn" title="Search Engine Home Page" rel="nofollow">Google Brunei ( catchall )</a>',
'www_google_com_bo','<a href="http://www.google.com.bo" title="Search Engine Home Page" rel="nofollow">Google Bolivia</a>',
'images_google_com_bo','<a href="http://images.google.com.bo" title="Search Engine Home Page" rel="nofollow">Google Bolivia ( images )</a>',
'translate_google_com_bo','<a href="http://translate.google.com.bo" title="Search Engine Home Page" rel="nofollow">Google Translate Bolivia</a>',
'google_com_bo','<a href="http://google.com.bo" title="Search Engine Home Page" rel="nofollow">Google Bolivia ( catchall )</a>',
'www_google_com_br','<a href="http://www.google.com.br" title="Search Engine Home Page" rel="nofollow">Google Brazil</a>',
'images_google_com_br','<a href="http://images.google.com.br" title="Search Engine Home Page" rel="nofollow">Google Brazil ( images )</a>',
'translate_google_com_br','<a href="http://translate.google.com.br" title="Search Engine Home Page" rel="nofollow">Google Translate Brazil</a>',
'google_com_br','<a href="http://google.com.br" title="Search Engine Home Page" rel="nofollow">Google Brazil ( catchall )</a>',
'www_google_com_bz','<a href="http://www.google.com.bz" title="Search Engine Home Page" rel="nofollow">Google Belize</a>',
'images_google_com_bz','<a href="http://images.google.com.bz" title="Search Engine Home Page" rel="nofollow">Google Belize ( images )</a>',
'translate_google_com_bz','<a href="http://translate.google.com.bz" title="Search Engine Home Page" rel="nofollow">Google Translate Belize</a>',
'google_com_bz','<a href="http://google.com.bz" title="Search Engine Home Page" rel="nofollow">Google Belize ( catchall )</a>',
'www_google_com_co','<a href="http://www.google.com.co" title="Search Engine Home Page" rel="nofollow">Google Colombia</a>',
'images_google_com_co','<a href="http://images.google.com.co" title="Search Engine Home Page" rel="nofollow">Google Colombia ( images )</a>',
'translate_google_com_co','<a href="http://translate.google.com.co" title="Search Engine Home Page" rel="nofollow">Google Translate Colombia</a>',
'google_com_co','<a href="http://google.com.co" title="Search Engine Home Page" rel="nofollow">Google Colombia ( catchall )</a>',
'www_google_com_cu','<a href="http://www.google.com.cu" title="Search Engine Home Page" rel="nofollow">Google Cuba</a>',
'images_google_com_cu','<a href="http://images.google.com.cu" title="Search Engine Home Page" rel="nofollow">Google Cuba ( images )</a>',
'translate_google_com_cu','<a href="http://translate.google.com.cu" title="Search Engine Home Page" rel="nofollow">Google Translate Cuba</a>',
'google_com_cu','<a href="http://google.com.cu" title="Search Engine Home Page" rel="nofollow">Google Cuba ( catchall )</a>',
'www_google_com_cy','<a href="http://www.google.com.cy" title="Search Engine Home Page" rel="nofollow">Google Cyprus</a>',
'images_google_com_cy','<a href="http://images.google.com.cy" title="Search Engine Home Page" rel="nofollow">Google Cyprus ( images )</a>',
'translate_google_com_cy','<a href="http://translate.google.com.cy" title="Search Engine Home Page" rel="nofollow">Google Translate Cyprus</a>',
'google_com_cy','<a href="http://google.com.cy" title="Search Engine Home Page" rel="nofollow">Google Cyprus ( catchall )</a>',
'www_google_com_do','<a href="http://www.google.com.do" title="Search Engine Home Page" rel="nofollow">Google Dominican Republic</a>',
'images_google_com_do','<a href="http://images.google.com.do" title="Search Engine Home Page" rel="nofollow">Google Dominican Republic ( images )</a>',
'translate_google_com_do','<a href="http://translate.google.com.do" title="Search Engine Home Page" rel="nofollow">Google Translate Dominican Republic</a>',
'google_com_do','<a href="http://google.com.do" title="Search Engine Home Page" rel="nofollow">Google Dominican Republic ( catchall )</a>',
'www_google_com_ec','<a href="http://www.google.com.ec" title="Search Engine Home Page" rel="nofollow">Google Ecuador</a>',
'images_google_com_ec','<a href="http://images.google.com.ec" title="Search Engine Home Page" rel="nofollow">Google Ecuador ( images )</a>',
'translate_google_com_ec','<a href="http://translate.google.com.ec" title="Search Engine Home Page" rel="nofollow">Google Translate Ecuador</a>',
'google_com_ec','<a href="http://google.com.ec" title="Search Engine Home Page" rel="nofollow">Google Ecuador ( catchall )</a>',
'www_google_com_eg','<a href="http://www.google.com.eg" title="Search Engine Home Page" rel="nofollow">Google Egypt</a>',
'images_google_com_eg','<a href="http://images.google.com.eg" title="Search Engine Home Page" rel="nofollow">Google Egypt ( images )</a>',
'translate_google_com_eg','<a href="http://translate.google.com.eg" title="Search Engine Home Page" rel="nofollow">Google Translate Egypt</a>',
'google_com_eg','<a href="http://google.com.eg" title="Search Engine Home Page" rel="nofollow">Google Egypt ( catchall )</a>',
'www_google_com_et','<a href="http://www.google.com.et" title="Search Engine Home Page" rel="nofollow">Google Ethiopia</a>',
'images_google_com_et','<a href="http://images.google.com.et" title="Search Engine Home Page" rel="nofollow">Google Ethiopia ( images )</a>',
'translate_google_com_et','<a href="http://translate.google.com.et" title="Search Engine Home Page" rel="nofollow">Google Translate Ethiopia</a>',
'google_com_et','<a href="http://google.com.et" title="Search Engine Home Page" rel="nofollow">Google Ethiopia ( catchall )</a>',
'www_google_com_fj','<a href="http://www.google.com.fj" title="Search Engine Home Page" rel="nofollow">Google Fiji</a>',
'images_google_com_fj','<a href="http://images.google.com.fj" title="Search Engine Home Page" rel="nofollow">Google Fiji ( images )</a>',
'translate_google_com_fj','<a href="http://translate.google.com.fj" title="Search Engine Home Page" rel="nofollow">Google Translate Fiji</a>',
'google_com_fj','<a href="http://google.com.fj" title="Search Engine Home Page" rel="nofollow">Google Fiji ( catchall )</a>',
'www_google_com_gh','<a href="http://www.google.com.gh" title="Search Engine Home Page" rel="nofollow">Google Ghana</a>',
'images_google_com_gh','<a href="http://images.google.com.gh" title="Search Engine Home Page" rel="nofollow">Google Ghana ( images )</a>',
'translate_google_com_gh','<a href="http://translate.google.com.gh" title="Search Engine Home Page" rel="nofollow">Google Translate Ghana</a>',
'google_com_gh','<a href="http://google.com.gh" title="Search Engine Home Page" rel="nofollow">Google Ghana ( catchall )</a>',
'www_google_com_gi','<a href="http://www.google.com.gi" title="Search Engine Home Page" rel="nofollow">Google Gibraltar</a>',
'images_google_com_gi','<a href="http://images.google.com.gi" title="Search Engine Home Page" rel="nofollow">Google Gibraltar ( images )</a>',
'translate_google_com_gi','<a href="http://translate.google.com.gi" title="Search Engine Home Page" rel="nofollow">Google Translate Gibraltar</a>',
'google_com_gi','<a href="http://google.com.gi" title="Search Engine Home Page" rel="nofollow">Google Gibraltar ( catchall )</a>',
'www_google_com_gt','<a href="http://www.google.com.gt" title="Search Engine Home Page" rel="nofollow">Google Guatemala</a>',
'images_google_com_gt','<a href="http://images.google.com.gt" title="Search Engine Home Page" rel="nofollow">Google Guatemala ( images )</a>',
'translate_google_com_gt','<a href="http://translate.google.com.gt" title="Search Engine Home Page" rel="nofollow">Google Translate Guatemala</a>',
'google_com_gt','<a href="http://google.com.gt" title="Search Engine Home Page" rel="nofollow">Google Guatemala ( catchall )</a>',
'www_google_com_hk','<a href="http://www.google.com.hk" title="Search Engine Home Page" rel="nofollow">Google Hong Kong</a>',
'images_google_com_hk','<a href="http://images.google.com.hk" title="Search Engine Home Page" rel="nofollow">Google Hong Kong ( images )</a>',
'translate_google_com_hk','<a href="http://translate.google.com.hk" title="Search Engine Home Page" rel="nofollow">Google Translate Hong Kong</a>',
'google_com_hk','<a href="http://google.com.hk" title="Search Engine Home Page" rel="nofollow">Google Hong Kong ( catchall )</a>',
'www_google_com_jm','<a href="http://www.google.com.jm" title="Search Engine Home Page" rel="nofollow">Google Jamaica</a>',
'images_google_com_jm','<a href="http://images.google.com.jm" title="Search Engine Home Page" rel="nofollow">Google Jamaica ( images )</a>',
'translate_google_com_jm','<a href="http://translate.google.com.jm" title="Search Engine Home Page" rel="nofollow">Google Translate Jamaica</a>',
'google_com_jm','<a href="http://google.com.jm" title="Search Engine Home Page" rel="nofollow">Google Jamaica ( catchall )</a>',
'www_google_com_kh','<a href="http://www.google.com.kh" title="Search Engine Home Page" rel="nofollow">Google Cambodia</a>',
'images_google_com_kh','<a href="http://images.google.com.kh" title="Search Engine Home Page" rel="nofollow">Google Cambodia ( images )</a>',
'translate_google_com_kh','<a href="http://translate.google.com.kh" title="Search Engine Home Page" rel="nofollow">Google Translate Cambodia</a>',
'google_com_kh','<a href="http://google.com.kh" title="Search Engine Home Page" rel="nofollow">Google Cambodia ( catchall )</a>',
'www_google_com_kw','<a href="http://www.google.com.kw" title="Search Engine Home Page" rel="nofollow">Google Kuwait</a>',
'images_google_com_kw','<a href="http://images.google.com.kw" title="Search Engine Home Page" rel="nofollow">Google Kuwait ( images )</a>',
'translate_google_com_kw','<a href="http://translate.google.com.kw" title="Search Engine Home Page" rel="nofollow">Google Translate Kuwait</a>',
'google_com_kw','<a href="http://google.com.kw" title="Search Engine Home Page" rel="nofollow">Google Kuwait ( catchall )</a>',
'www_google_com_lb','<a href="http://www.google.com.lb" title="Search Engine Home Page" rel="nofollow">Google Lebanon</a>',
'images_google_com_lb','<a href="http://images.google.com.lb" title="Search Engine Home Page" rel="nofollow">Google Lebanon ( images )</a>',
'translate_google_com_lb','<a href="http://translate.google.com.lb" title="Search Engine Home Page" rel="nofollow">Google Translate Lebanon</a>',
'google_com_lb','<a href="http://google.com.lb" title="Search Engine Home Page" rel="nofollow">Google Lebanon ( catchall )</a>',
'www_google_com_lc','<a href="http://www.google.com.lc" title="Search Engine Home Page" rel="nofollow">Google Saint Lucia</a>',
'images_google_com_lc','<a href="http://images.google.com.lc" title="Search Engine Home Page" rel="nofollow">Google Saint Lucia ( images )</a>',
'translate_google_com_lc','<a href="http://translate.google.com.lc" title="Search Engine Home Page" rel="nofollow">Google Translate Saint Lucia</a>',
'google_com_lc','<a href="http://google.com.lc" title="Search Engine Home Page" rel="nofollow">Google Saint Lucia ( catchall )</a>',
'www_google_com_ly','<a href="http://www.google.com.ly" title="Search Engine Home Page" rel="nofollow">Google Libya</a>',
'images_google_com_ly','<a href="http://images.google.com.ly" title="Search Engine Home Page" rel="nofollow">Google Libya ( images )</a>',
'translate_google_com_ly','<a href="http://translate.google.com.ly" title="Search Engine Home Page" rel="nofollow">Google Translate Libya</a>',
'google_com_ly','<a href="http://google.com.ly" title="Search Engine Home Page" rel="nofollow">Google Libya ( catchall )</a>',
'www_google_com_mm','<a href="http://www.google.com.mm" title="Search Engine Home Page" rel="nofollow">Google Myanmar</a>',
'images_google_com_mm','<a href="http://images.google.com.mm" title="Search Engine Home Page" rel="nofollow">Google Myanmar ( images )</a>',
'translate_google_com_mm','<a href="http://translate.google.com.mm" title="Search Engine Home Page" rel="nofollow">Google Translate Myanmar</a>',
'google_com_mm','<a href="http://google.com.mm" title="Search Engine Home Page" rel="nofollow">Google Myanmar ( catchall )</a>',
'www_google_com_mt','<a href="http://www.google.com.mt" title="Search Engine Home Page" rel="nofollow">Google Malta</a>',
'images_google_com_mt','<a href="http://images.google.com.mt" title="Search Engine Home Page" rel="nofollow">Google Malta ( images )</a>',
'translate_google_com_mt','<a href="http://translate.google.com.mt" title="Search Engine Home Page" rel="nofollow">Google Translate Malta</a>',
'google_com_mt','<a href="http://google.com.mt" title="Search Engine Home Page" rel="nofollow">Google Malta ( catchall )</a>',
'www_google_com_mx','<a href="http://www.google.com.mx" title="Search Engine Home Page" rel="nofollow">Google Mexico</a>',
'images_google_com_mx','<a href="http://images.google.com.mx" title="Search Engine Home Page" rel="nofollow">Google Mexico ( images )</a>',
'translate_google_com_mx','<a href="http://translate.google.com.mx" title="Search Engine Home Page" rel="nofollow">Google Translate Mexico</a>',
'google_com_mx','<a href="http://google.com.mx" title="Search Engine Home Page" rel="nofollow">Google Mexico ( catchall )</a>',
'www_google_com_my','<a href="http://www.google.com.my" title="Search Engine Home Page" rel="nofollow">Google Malaysia</a>',
'images_google_com_my','<a href="http://images.google.com.my" title="Search Engine Home Page" rel="nofollow">Google Malaysia ( images )</a>',
'translate_google_com_my','<a href="http://translate.google.com.my" title="Search Engine Home Page" rel="nofollow">Google Translate Malaysia</a>',
'google_com_my','<a href="http://google.com.my" title="Search Engine Home Page" rel="nofollow">Google Malaysia ( catchall )</a>',
'www_google_com_na','<a href="http://www.google.com.na" title="Search Engine Home Page" rel="nofollow">Google Namibia</a>',
'images_google_com_na','<a href="http://images.google.com.na" title="Search Engine Home Page" rel="nofollow">Google Namibia ( images )</a>',
'translate_google_com_na','<a href="http://translate.google.com.na" title="Search Engine Home Page" rel="nofollow">Google Translate Namibia</a>',
'google_com_na','<a href="http://google.com.na" title="Search Engine Home Page" rel="nofollow">Google Namibia ( catchall )</a>',
'www_google_com_nf','<a href="http://www.google.com.nf" title="Search Engine Home Page" rel="nofollow">Google Norfolk Island</a>',
'images_google_com_nf','<a href="http://images.google.com.nf" title="Search Engine Home Page" rel="nofollow">Google Norfolk Island ( images )</a>',
'translate_google_com_nf','<a href="http://translate.google.com.nf" title="Search Engine Home Page" rel="nofollow">Google Translate Norfolk Island</a>',
'google_com_nf','<a href="http://google.com.nf" title="Search Engine Home Page" rel="nofollow">Google Norfolk Island ( catchall )</a>',
'www_google_com_ng','<a href="http://www.google.com.ng" title="Search Engine Home Page" rel="nofollow">Google Nigeria</a>',
'images_google_com_ng','<a href="http://images.google.com.ng" title="Search Engine Home Page" rel="nofollow">Google Nigeria ( images )</a>',
'translate_google_com_ng','<a href="http://translate.google.com.ng" title="Search Engine Home Page" rel="nofollow">Google Translate Nigeria</a>',
'google_com_ng','<a href="http://google.com.ng" title="Search Engine Home Page" rel="nofollow">Google Nigeria ( catchall )</a>',
'www_google_com_ni','<a href="http://www.google.com.ni" title="Search Engine Home Page" rel="nofollow">Google Nicaragua</a>',
'images_google_com_ni','<a href="http://images.google.com.ni" title="Search Engine Home Page" rel="nofollow">Google Nicaragua ( images )</a>',
'translate_google_com_ni','<a href="http://translate.google.com.ni" title="Search Engine Home Page" rel="nofollow">Google Translate Nicaragua</a>',
'google_com_ni','<a href="http://google.com.ni" title="Search Engine Home Page" rel="nofollow">Google Nicaragua ( catchall )</a>',
'www_google_com_np','<a href="http://www.google.com.np" title="Search Engine Home Page" rel="nofollow">Google Nepal</a>',
'images_google_com_np','<a href="http://images.google.com.np" title="Search Engine Home Page" rel="nofollow">Google Nepal ( images )</a>',
'translate_google_com_np','<a href="http://translate.google.com.np" title="Search Engine Home Page" rel="nofollow">Google Translate Nepal</a>',
'google_com_np','<a href="http://google.com.np" title="Search Engine Home Page" rel="nofollow">Google Nepal ( catchall )</a>',
'www_google_com_om','<a href="http://www.google.com.om" title="Search Engine Home Page" rel="nofollow">Google Oman</a>',
'images_google_com_om','<a href="http://images.google.com.om" title="Search Engine Home Page" rel="nofollow">Google Oman ( images )</a>',
'translate_google_com_om','<a href="http://translate.google.com.om" title="Search Engine Home Page" rel="nofollow">Google Translate Oman</a>',
'google_com_om','<a href="http://google.com.om" title="Search Engine Home Page" rel="nofollow">Google Oman ( catchall )</a>',
'www_google_com_pa','<a href="http://www.google.com.pa" title="Search Engine Home Page" rel="nofollow">Google Panama</a>',
'images_google_com_pa','<a href="http://images.google.com.pa" title="Search Engine Home Page" rel="nofollow">Google Panama ( images )</a>',
'translate_google_com_pa','<a href="http://translate.google.com.pa" title="Search Engine Home Page" rel="nofollow">Google Translate Panama</a>',
'google_com_pa','<a href="http://google.com.pa" title="Search Engine Home Page" rel="nofollow">Google Panama ( catchall )</a>',
'www_google_com_pe','<a href="http://www.google.com.pe" title="Search Engine Home Page" rel="nofollow">Google Peru</a>',
'images_google_com_pe','<a href="http://images.google.com.pe" title="Search Engine Home Page" rel="nofollow">Google Peru ( images )</a>',
'translate_google_com_pe','<a href="http://translate.google.com.pe" title="Search Engine Home Page" rel="nofollow">Google Translate Peru</a>',
'google_com_pe','<a href="http://google.com.pe" title="Search Engine Home Page" rel="nofollow">Google Peru ( catchall )</a>',
'www_google_com_pg','<a href="http://www.google.com.pg" title="Search Engine Home Page" rel="nofollow">Google Papua New Guinea</a>',
'images_google_com_pg','<a href="http://images.google.com.pg" title="Search Engine Home Page" rel="nofollow">Google Papua New Guinea ( images )</a>',
'translate_google_com_pg','<a href="http://translate.google.com.pg" title="Search Engine Home Page" rel="nofollow">Google Translate Papua New Guinea</a>',
'google_com_pg','<a href="http://google.com.pg" title="Search Engine Home Page" rel="nofollow">Google Papua New Guinea ( catchall )</a>',
'www_google_com_ph','<a href="http://www.google.com.ph" title="Search Engine Home Page" rel="nofollow">Google Philippines</a>',
'images_google_com_ph','<a href="http://images.google.com.ph" title="Search Engine Home Page" rel="nofollow">Google Philippines ( images )</a>',
'translate_google_com_ph','<a href="http://translate.google.com.ph" title="Search Engine Home Page" rel="nofollow">Google Translate Philippines</a>',
'google_com_ph','<a href="http://google.com.ph" title="Search Engine Home Page" rel="nofollow">Google Philippines ( catchall )</a>',
'www_google_com_pk','<a href="http://www.google.com.pk" title="Search Engine Home Page" rel="nofollow">Google Pakistan</a>',
'images_google_com_pk','<a href="http://images.google.com.pk" title="Search Engine Home Page" rel="nofollow">Google Pakistan ( images )</a>',
'translate_google_com_pk','<a href="http://translate.google.com.pk" title="Search Engine Home Page" rel="nofollow">Google Translate Pakistan</a>',
'google_com_pk','<a href="http://google.com.pk" title="Search Engine Home Page" rel="nofollow">Google Pakistan ( catchall )</a>',
'www_google_com_pr','<a href="http://www.google.com.pr" title="Search Engine Home Page" rel="nofollow">Google Puerto Rico</a>',
'images_google_com_pr','<a href="http://images.google.com.pr" title="Search Engine Home Page" rel="nofollow">Google Puerto Rico ( images )</a>',
'translate_google_com_pr','<a href="http://translate.google.com.pr" title="Search Engine Home Page" rel="nofollow">Google Translate Puerto Rico</a>',
'google_com_pr','<a href="http://google.com.pr" title="Search Engine Home Page" rel="nofollow">Google Puerto Rico ( catchall )</a>',
'www_google_com_py','<a href="http://www.google.com.py" title="Search Engine Home Page" rel="nofollow">Google Paraguay</a>',
'images_google_com_py','<a href="http://images.google.com.py" title="Search Engine Home Page" rel="nofollow">Google Paraguay ( images )</a>',
'translate_google_com_py','<a href="http://translate.google.com.py" title="Search Engine Home Page" rel="nofollow">Google Translate Paraguay</a>',
'google_com_py','<a href="http://google.com.py" title="Search Engine Home Page" rel="nofollow">Google Paraguay ( catchall )</a>',
'www_google_com_qa','<a href="http://www.google.com.qa" title="Search Engine Home Page" rel="nofollow">Google Qatar</a>',
'images_google_com_qa','<a href="http://images.google.com.qa" title="Search Engine Home Page" rel="nofollow">Google Qatar ( images )</a>',
'translate_google_com_qa','<a href="http://translate.google.com.qa" title="Search Engine Home Page" rel="nofollow">Google Translate Qatar</a>',
'google_com_qa','<a href="http://google.com.qa" title="Search Engine Home Page" rel="nofollow">Google Qatar ( catchall )</a>',
'www_google_com_sa','<a href="http://www.google.com.sa" title="Search Engine Home Page" rel="nofollow">Google Saudi Arabia</a>',
'images_google_com_sa','<a href="http://images.google.com.sa" title="Search Engine Home Page" rel="nofollow">Google Saudi Arabia ( images )</a>',
'translate_google_com_sa','<a href="http://translate.google.com.sa" title="Search Engine Home Page" rel="nofollow">Google Translate Saudi Arabia</a>',
'google_com_sa','<a href="http://google.com.sa" title="Search Engine Home Page" rel="nofollow">Google Saudi Arabia ( catchall )</a>',
'www_google_com_sb','<a href="http://www.google.com.sb" title="Search Engine Home Page" rel="nofollow">Google Solomon Islands</a>',
'images_google_com_sb','<a href="http://images.google.com.sb" title="Search Engine Home Page" rel="nofollow">Google Solomon Islands ( images )</a>',
'translate_google_com_sb','<a href="http://translate.google.com.sb" title="Search Engine Home Page" rel="nofollow">Google Translate Solomon Islands</a>',
'google_com_sb','<a href="http://google.com.sb" title="Search Engine Home Page" rel="nofollow">Google Solomon Islands ( catchall )</a>',
'www_google_com_sg','<a href="http://www.google.com.sg" title="Search Engine Home Page" rel="nofollow">Google Singapore</a>',
'images_google_com_sg','<a href="http://images.google.com.sg" title="Search Engine Home Page" rel="nofollow">Google Singapore ( images )</a>',
'translate_google_com_sg','<a href="http://translate.google.com.sg" title="Search Engine Home Page" rel="nofollow">Google Translate Singapore</a>',
'google_com_sg','<a href="http://google.com.sg" title="Search Engine Home Page" rel="nofollow">Google Singapore ( catchall )</a>',
'www_google_com_sl','<a href="http://www.google.com.sl" title="Search Engine Home Page" rel="nofollow">Google Sierra Leone</a>',
'images_google_com_sl','<a href="http://images.google.com.sl" title="Search Engine Home Page" rel="nofollow">Google Sierra Leone ( images )</a>',
'translate_google_com_sl','<a href="http://translate.google.com.sl" title="Search Engine Home Page" rel="nofollow">Google Translate Sierra Leone</a>',
'google_com_sl','<a href="http://google.com.sl" title="Search Engine Home Page" rel="nofollow">Google Sierra Leone ( catchall )</a>',
'www_google_com_sv','<a href="http://www.google.com.sv" title="Search Engine Home Page" rel="nofollow">Google El Salvador</a>',
'images_google_com_sv','<a href="http://images.google.com.sv" title="Search Engine Home Page" rel="nofollow">Google El Salvador ( images )</a>',
'translate_google_com_sv','<a href="http://translate.google.com.sv" title="Search Engine Home Page" rel="nofollow">Google Translate El Salvador</a>',
'google_com_sv','<a href="http://google.com.sv" title="Search Engine Home Page" rel="nofollow">Google El Salvador ( catchall )</a>',
'www_google_com_tj','<a href="http://www.google.com.tj" title="Search Engine Home Page" rel="nofollow">Google Tajikistan</a>',
'images_google_com_tj','<a href="http://images.google.com.tj" title="Search Engine Home Page" rel="nofollow">Google Tajikistan ( images )</a>',
'translate_google_com_tj','<a href="http://translate.google.com.tj" title="Search Engine Home Page" rel="nofollow">Google Translate Tajikistan</a>',
'google_com_tj','<a href="http://google.com.tj" title="Search Engine Home Page" rel="nofollow">Google Tajikistan ( catchall )</a>',
'www_google_com_tw','<a href="http://www.google.com.tw" title="Search Engine Home Page" rel="nofollow">Google Taiwan</a>',
'images_google_com_tw','<a href="http://images.google.com.tw" title="Search Engine Home Page" rel="nofollow">Google Taiwan ( images )</a>',
'translate_google_com_tw','<a href="http://translate.google.com.tw" title="Search Engine Home Page" rel="nofollow">Google Translate Taiwan</a>',
'google_com_tw','<a href="http://google.com.tw" title="Search Engine Home Page" rel="nofollow">Google Taiwan ( catchall )</a>',
'www_google_com_ua','<a href="http://www.google.com.ua" title="Search Engine Home Page" rel="nofollow">Google Ukraine</a>',
'images_google_com_ua','<a href="http://images.google.com.ua" title="Search Engine Home Page" rel="nofollow">Google Ukraine ( images )</a>',
'translate_google_com_ua','<a href="http://translate.google.com.ua" title="Search Engine Home Page" rel="nofollow">Google Translate Ukraine</a>',
'google_com_ua','<a href="http://google.com.ua" title="Search Engine Home Page" rel="nofollow">Google Ukraine ( catchall )</a>',
'www_google_com_uy','<a href="http://www.google.com.uy" title="Search Engine Home Page" rel="nofollow">Google Uruguay</a>',
'images_google_com_uy','<a href="http://images.google.com.uy" title="Search Engine Home Page" rel="nofollow">Google Uruguay ( images )</a>',
'translate_google_com_uy','<a href="http://translate.google.com.uy" title="Search Engine Home Page" rel="nofollow">Google Translate Uruguay</a>',
'google_com_uy','<a href="http://google.com.uy" title="Search Engine Home Page" rel="nofollow">Google Uruguay ( catchall )</a>',
'www_google_com_vc','<a href="http://www.google.com.vc" title="Search Engine Home Page" rel="nofollow">Google Saint Vincent and the Grenadines</a>',
'images_google_com_vc','<a href="http://images.google.com.vc" title="Search Engine Home Page" rel="nofollow">Google Saint Vincent and the Grenadines ( images )</a>',
'translate_google_com_vc','<a href="http://translate.google.com.vc" title="Search Engine Home Page" rel="nofollow">Google Translate Saint Vincent and the Grenadines</a>',
'google_com_vc','<a href="http://google.com.vc" title="Search Engine Home Page" rel="nofollow">Google Saint Vincent and the Grenadines ( catchall )</a>',
'www_google_com_vn','<a href="http://www.google.com.vn" title="Search Engine Home Page" rel="nofollow">Google Vietnam</a>',
'images_google_com_vn','<a href="http://images.google.com.vn" title="Search Engine Home Page" rel="nofollow">Google Vietnam ( images )</a>',
'translate_google_com_vn','<a href="http://translate.google.com.vn" title="Search Engine Home Page" rel="nofollow">Google Translate Vietnam</a>',
'google_com_vn','<a href="http://google.com.vn" title="Search Engine Home Page" rel="nofollow">Google Vietnam ( catchall )</a>',
'www_google_cv','<a href="http://www.google.cv" title="Search Engine Home Page" rel="nofollow">Google Cape Verde</a>',
'images_google_cv','<a href="http://images.google.cv" title="Search Engine Home Page" rel="nofollow">Google Cape Verde ( images )</a>',
'translate_google_cv','<a href="http://translate.google.cv" title="Search Engine Home Page" rel="nofollow">Google Translate Cape Verde</a>',
'google_cv','<a href="http://google.cv" title="Search Engine Home Page" rel="nofollow">Google Cape Verde ( catchall )</a>',
'www_google_cz','<a href="http://www.google.cz" title="Search Engine Home Page" rel="nofollow">Google Czech Republic</a>',
'images_google_cz','<a href="http://images.google.cz" title="Search Engine Home Page" rel="nofollow">Google Czech Republic ( images )</a>',
'translate_google_cz','<a href="http://translate.google.cz" title="Search Engine Home Page" rel="nofollow">Google Translate Czech Republic</a>',
'google_cz','<a href="http://google.cz" title="Search Engine Home Page" rel="nofollow">Google Czech Republic ( catchall )</a>',
'www_google_dj','<a href="http://www.google.dj" title="Search Engine Home Page" rel="nofollow">Google Djibouti</a>',
'images_google_dj','<a href="http://images.google.dj" title="Search Engine Home Page" rel="nofollow">Google Djibouti ( images )</a>',
'translate_google_dj','<a href="http://translate.google.dj" title="Search Engine Home Page" rel="nofollow">Google Translate Djibouti</a>',
'google_dj','<a href="http://google.dj" title="Search Engine Home Page" rel="nofollow">Google Djibouti ( catchall )</a>',
'www_google_dk','<a href="http://www.google.dk" title="Search Engine Home Page" rel="nofollow">Google Denmark</a>',
'images_google_dk','<a href="http://images.google.dk" title="Search Engine Home Page" rel="nofollow">Google Denmark ( images )</a>',
'translate_google_dk','<a href="http://translate.google.dk" title="Search Engine Home Page" rel="nofollow">Google Translate Denmark</a>',
'google_dk','<a href="http://google.dk" title="Search Engine Home Page" rel="nofollow">Google Denmark ( catchall )</a>',
'www_google_dm','<a href="http://www.google.dm" title="Search Engine Home Page" rel="nofollow">Google Dominica</a>',
'images_google_dm','<a href="http://images.google.dm" title="Search Engine Home Page" rel="nofollow">Google Dominica ( images )</a>',
'translate_google_dm','<a href="http://translate.google.dm" title="Search Engine Home Page" rel="nofollow">Google Translate Dominica</a>',
'google_dm','<a href="http://google.dm" title="Search Engine Home Page" rel="nofollow">Google Dominica ( catchall )</a>',
'www_google_dz','<a href="http://www.google.dz" title="Search Engine Home Page" rel="nofollow">Google Algeria</a>',
'images_google_dz','<a href="http://images.google.dz" title="Search Engine Home Page" rel="nofollow">Google Algeria ( images )</a>',
'translate_google_dz','<a href="http://translate.google.dz" title="Search Engine Home Page" rel="nofollow">Google Translate Algeria</a>',
'google_dz','<a href="http://google.dz" title="Search Engine Home Page" rel="nofollow">Google Algeria ( catchall )</a>',
'www_google_ee','<a href="http://www.google.ee" title="Search Engine Home Page" rel="nofollow">Google Estonia</a>',
'images_google_ee','<a href="http://images.google.ee" title="Search Engine Home Page" rel="nofollow">Google Estonia ( images )</a>',
'translate_google_ee','<a href="http://translate.google.ee" title="Search Engine Home Page" rel="nofollow">Google Translate Estonia</a>',
'google_ee','<a href="http://google.ee" title="Search Engine Home Page" rel="nofollow">Google Estonia ( catchall )</a>',
'www_google_fi','<a href="http://www.google.fi" title="Search Engine Home Page" rel="nofollow">Google Finland</a>',
'images_google_fi','<a href="http://images.google.fi" title="Search Engine Home Page" rel="nofollow">Google Finland ( images )</a>',
'translate_google_fi','<a href="http://translate.google.fi" title="Search Engine Home Page" rel="nofollow">Google Translate Finland</a>',
'google_fi','<a href="http://google.fi" title="Search Engine Home Page" rel="nofollow">Google Finland ( catchall )</a>',
'www_google_fm','<a href="http://www.google.fm" title="Search Engine Home Page" rel="nofollow">Google Federated States of Micronesia</a>',
'images_google_fm','<a href="http://images.google.fm" title="Search Engine Home Page" rel="nofollow">Google Federated States of Micronesia ( images )</a>',
'translate_google_fm','<a href="http://translate.google.fm" title="Search Engine Home Page" rel="nofollow">Google Translate Federated States of Micronesia</a>',
'google_fm','<a href="http://google.fm" title="Search Engine Home Page" rel="nofollow">Google Federated States of Micronesia ( catchall )</a>',
'www_google_ga','<a href="http://www.google.ga" title="Search Engine Home Page" rel="nofollow">Google Gabon</a>',
'images_google_ga','<a href="http://images.google.ga" title="Search Engine Home Page" rel="nofollow">Google Gabon ( images )</a>',
'translate_google_ga','<a href="http://translate.google.ga" title="Search Engine Home Page" rel="nofollow">Google Translate Gabon</a>',
'google_ga','<a href="http://google.ga" title="Search Engine Home Page" rel="nofollow">Google Gabon ( catchall )</a>',
'www_google_ge','<a href="http://www.google.ge" title="Search Engine Home Page" rel="nofollow">Google Georgia</a>',
'images_google_ge','<a href="http://images.google.ge" title="Search Engine Home Page" rel="nofollow">Google Georgia ( images )</a>',
'translate_google_ge','<a href="http://translate.google.ge" title="Search Engine Home Page" rel="nofollow">Google Translate Georgia</a>',
'google_ge','<a href="http://google.ge" title="Search Engine Home Page" rel="nofollow">Google Georgia ( catchall )</a>',
'www_google_gf','<a href="http://www.google.gf" title="Search Engine Home Page" rel="nofollow">Google French Guiana</a>',
'images_google_gf','<a href="http://images.google.gf" title="Search Engine Home Page" rel="nofollow">Google French Guiana ( images )</a>',
'translate_google_gf','<a href="http://translate.google.gf" title="Search Engine Home Page" rel="nofollow">Google Translate French Guiana</a>',
'google_gf','<a href="http://google.gf" title="Search Engine Home Page" rel="nofollow">Google French Guiana ( catchall )</a>',
'www_google_gg','<a href="http://www.google.gg" title="Search Engine Home Page" rel="nofollow">Google Guernsey</a>',
'images_google_gg','<a href="http://images.google.gg" title="Search Engine Home Page" rel="nofollow">Google Guernsey ( images )</a>',
'translate_google_gg','<a href="http://translate.google.gg" title="Search Engine Home Page" rel="nofollow">Google Translate Guernsey</a>',
'google_gg','<a href="http://google.gg" title="Search Engine Home Page" rel="nofollow">Google Guernsey ( catchall )</a>',
'www_google_gl','<a href="http://www.google.gl" title="Search Engine Home Page" rel="nofollow">Google Greenland</a>',
'images_google_gl','<a href="http://images.google.gl" title="Search Engine Home Page" rel="nofollow">Google Greenland ( images )</a>',
'translate_google_gl','<a href="http://translate.google.gl" title="Search Engine Home Page" rel="nofollow">Google Translate Greenland</a>',
'google_gl','<a href="http://google.gl" title="Search Engine Home Page" rel="nofollow">Google Greenland ( catchall )</a>',
'www_google_gm','<a href="http://www.google.gm" title="Search Engine Home Page" rel="nofollow">Google Gambia</a>',
'images_google_gm','<a href="http://images.google.gm" title="Search Engine Home Page" rel="nofollow">Google Gambia ( images )</a>',
'translate_google_gm','<a href="http://translate.google.gm" title="Search Engine Home Page" rel="nofollow">Google Translate Gambia</a>',
'google_gm','<a href="http://google.gm" title="Search Engine Home Page" rel="nofollow">Google Gambia ( catchall )</a>',
'www_google_gp','<a href="http://www.google.gp" title="Search Engine Home Page" rel="nofollow">Google Guadeloupe</a>',
'images_google_gp','<a href="http://images.google.gp" title="Search Engine Home Page" rel="nofollow">Google Guadeloupe ( images )</a>',
'translate_google_gp','<a href="http://translate.google.gp" title="Search Engine Home Page" rel="nofollow">Google Translate Guadeloupe</a>',
'google_gp','<a href="http://google.gp" title="Search Engine Home Page" rel="nofollow">Google Guadeloupe ( catchall )</a>',
'www_google_gy','<a href="http://www.google.gy" title="Search Engine Home Page" rel="nofollow">Google Guyana</a>',
'images_google_gy','<a href="http://images.google.gy" title="Search Engine Home Page" rel="nofollow">Google Guyana ( images )</a>',
'translate_google_gy','<a href="http://translate.google.gy" title="Search Engine Home Page" rel="nofollow">Google Translate Guyana</a>',
'google_gy','<a href="http://google.gy" title="Search Engine Home Page" rel="nofollow">Google Guyana ( catchall )</a>',
'www_google_hn','<a href="http://www.google.hn" title="Search Engine Home Page" rel="nofollow">Google Honduras</a>',
'images_google_hn','<a href="http://images.google.hn" title="Search Engine Home Page" rel="nofollow">Google Honduras ( images )</a>',
'translate_google_hn','<a href="http://translate.google.hn" title="Search Engine Home Page" rel="nofollow">Google Translate Honduras</a>',
'google_hn','<a href="http://google.hn" title="Search Engine Home Page" rel="nofollow">Google Honduras ( catchall )</a>',
'www_google_ht','<a href="http://www.google.ht" title="Search Engine Home Page" rel="nofollow">Google Haiti</a>',
'images_google_ht','<a href="http://images.google.ht" title="Search Engine Home Page" rel="nofollow">Google Haiti ( images )</a>',
'translate_google_ht','<a href="http://translate.google.ht" title="Search Engine Home Page" rel="nofollow">Google Translate Haiti</a>',
'google_ht','<a href="http://google.ht" title="Search Engine Home Page" rel="nofollow">Google Haiti ( catchall )</a>',
'www_google_hu','<a href="http://www.google.hu" title="Search Engine Home Page" rel="nofollow">Google Hungary</a>',
'images_google_hu','<a href="http://images.google.hu" title="Search Engine Home Page" rel="nofollow">Google Hungary ( images )</a>',
'translate_google_hu','<a href="http://translate.google.hu" title="Search Engine Home Page" rel="nofollow">Google Translate Hungary</a>',
'google_hu','<a href="http://google.hu" title="Search Engine Home Page" rel="nofollow">Google Hungary ( catchall )</a>',
'www_google_im','<a href="http://www.google.im" title="Search Engine Home Page" rel="nofollow">Google Isle of Man</a>',
'images_google_im','<a href="http://images.google.im" title="Search Engine Home Page" rel="nofollow">Google Isle of Man ( images )</a>',
'translate_google_im','<a href="http://translate.google.im" title="Search Engine Home Page" rel="nofollow">Google Translate Isle of Man</a>',
'google_im','<a href="http://google.im" title="Search Engine Home Page" rel="nofollow">Google Isle of Man ( catchall )</a>',
'www_google_io','<a href="http://www.google.io" title="Search Engine Home Page" rel="nofollow">Google British Indian Ocean Territory</a>',
'images_google_io','<a href="http://images.google.io" title="Search Engine Home Page" rel="nofollow">Google British Indian Ocean Territory ( images )</a>',
'translate_google_io','<a href="http://translate.google.io" title="Search Engine Home Page" rel="nofollow">Google Translate British Indian Ocean Territory</a>',
'google_io','<a href="http://google.io" title="Search Engine Home Page" rel="nofollow">Google British Indian Ocean Territory ( catchall )</a>',
'www_google_iq','<a href="http://www.google.iq" title="Search Engine Home Page" rel="nofollow">Google Iraq</a>',
'images_google_iq','<a href="http://images.google.iq" title="Search Engine Home Page" rel="nofollow">Google Iraq ( images )</a>',
'translate_google_iq','<a href="http://translate.google.iq" title="Search Engine Home Page" rel="nofollow">Google Translate Iraq</a>',
'google_iq','<a href="http://google.iq" title="Search Engine Home Page" rel="nofollow">Google Iraq ( catchall )</a>',
'www_google_is','<a href="http://www.google.is" title="Search Engine Home Page" rel="nofollow">Google Iceland</a>',
'images_google_is','<a href="http://images.google.is" title="Search Engine Home Page" rel="nofollow">Google Iceland ( images )</a>',
'translate_google_is','<a href="http://translate.google.is" title="Search Engine Home Page" rel="nofollow">Google Translate Iceland</a>',
'google_is','<a href="http://google.is" title="Search Engine Home Page" rel="nofollow">Google Iceland ( catchall )</a>',
'www_google_je','<a href="http://www.google.je" title="Search Engine Home Page" rel="nofollow">Google Jersey</a>',
'images_google_je','<a href="http://images.google.je" title="Search Engine Home Page" rel="nofollow">Google Jersey ( images )</a>',
'translate_google_je','<a href="http://translate.google.je" title="Search Engine Home Page" rel="nofollow">Google Translate Jersey</a>',
'google_je','<a href="http://google.je" title="Search Engine Home Page" rel="nofollow">Google Jersey ( catchall )</a>',
'www_google_jo','<a href="http://www.google.jo" title="Search Engine Home Page" rel="nofollow">Google Jordan</a>',
'images_google_jo','<a href="http://images.google.jo" title="Search Engine Home Page" rel="nofollow">Google Jordan ( images )</a>',
'translate_google_jo','<a href="http://translate.google.jo" title="Search Engine Home Page" rel="nofollow">Google Translate Jordan</a>',
'google_jo','<a href="http://google.jo" title="Search Engine Home Page" rel="nofollow">Google Jordan ( catchall )</a>',
'www_google_kg','<a href="http://www.google.kg" title="Search Engine Home Page" rel="nofollow">Google Kyrgyzstan</a>',
'images_google_kg','<a href="http://images.google.kg" title="Search Engine Home Page" rel="nofollow">Google Kyrgyzstan ( images )</a>',
'translate_google_kg','<a href="http://translate.google.kg" title="Search Engine Home Page" rel="nofollow">Google Translate Kyrgyzstan</a>',
'google_kg','<a href="http://google.kg" title="Search Engine Home Page" rel="nofollow">Google Kyrgyzstan ( catchall )</a>',
'www_google_ki','<a href="http://www.google.ki" title="Search Engine Home Page" rel="nofollow">Google Kiribati</a>',
'images_google_ki','<a href="http://images.google.ki" title="Search Engine Home Page" rel="nofollow">Google Kiribati ( images )</a>',
'translate_google_ki','<a href="http://translate.google.ki" title="Search Engine Home Page" rel="nofollow">Google Translate Kiribati</a>',
'google_ki','<a href="http://google.ki" title="Search Engine Home Page" rel="nofollow">Google Kiribati ( catchall )</a>',
'www_google_kz','<a href="http://www.google.kz" title="Search Engine Home Page" rel="nofollow">Google Kazakhstan</a>',
'images_google_kz','<a href="http://images.google.kz" title="Search Engine Home Page" rel="nofollow">Google Kazakhstan ( images )</a>',
'translate_google_kz','<a href="http://translate.google.kz" title="Search Engine Home Page" rel="nofollow">Google Translate Kazakhstan</a>',
'google_kz','<a href="http://google.kz" title="Search Engine Home Page" rel="nofollow">Google Kazakhstan ( catchall )</a>',
'www_google_la','<a href="http://www.google.la" title="Search Engine Home Page" rel="nofollow">Google Laos</a>',
'images_google_la','<a href="http://images.google.la" title="Search Engine Home Page" rel="nofollow">Google Laos ( images )</a>',
'translate_google_la','<a href="http://translate.google.la" title="Search Engine Home Page" rel="nofollow">Google Translate Laos</a>',
'google_la','<a href="http://google.la" title="Search Engine Home Page" rel="nofollow">Google Laos ( catchall )</a>',
'www_google_li','<a href="http://www.google.li" title="Search Engine Home Page" rel="nofollow">Google Liechtenstein</a>',
'images_google_li','<a href="http://images.google.li" title="Search Engine Home Page" rel="nofollow">Google Liechtenstein ( images )</a>',
'translate_google_li','<a href="http://translate.google.li" title="Search Engine Home Page" rel="nofollow">Google Translate Liechtenstein</a>',
'google_li','<a href="http://google.li" title="Search Engine Home Page" rel="nofollow">Google Liechtenstein ( catchall )</a>',
'www_google_lk','<a href="http://www.google.lk" title="Search Engine Home Page" rel="nofollow">Google Sri Lanka</a>',
'images_google_lk','<a href="http://images.google.lk" title="Search Engine Home Page" rel="nofollow">Google Sri Lanka ( images )</a>',
'translate_google_lk','<a href="http://translate.google.lk" title="Search Engine Home Page" rel="nofollow">Google Translate Sri Lanka</a>',
'google_lk','<a href="http://google.lk" title="Search Engine Home Page" rel="nofollow">Google Sri Lanka ( catchall )</a>',
'www_google_lt','<a href="http://www.google.lt" title="Search Engine Home Page" rel="nofollow">Google Lithuania</a>',
'images_google_lt','<a href="http://images.google.lt" title="Search Engine Home Page" rel="nofollow">Google Lithuania ( images )</a>',
'translate_google_lt','<a href="http://translate.google.lt" title="Search Engine Home Page" rel="nofollow">Google Translate Lithuania</a>',
'google_lt','<a href="http://google.lt" title="Search Engine Home Page" rel="nofollow">Google Lithuania ( catchall )</a>',
'www_google_lu','<a href="http://www.google.lu" title="Search Engine Home Page" rel="nofollow">Google Luxembourg</a>',
'images_google_lu','<a href="http://images.google.lu" title="Search Engine Home Page" rel="nofollow">Google Luxembourg ( images )</a>',
'translate_google_lu','<a href="http://translate.google.lu" title="Search Engine Home Page" rel="nofollow">Google Translate Luxembourg</a>',
'google_lu','<a href="http://google.lu" title="Search Engine Home Page" rel="nofollow">Google Luxembourg ( catchall )</a>',
'www_google_lv','<a href="http://www.google.lv" title="Search Engine Home Page" rel="nofollow">Google Latvia</a>',
'images_google_lv','<a href="http://images.google.lv" title="Search Engine Home Page" rel="nofollow">Google Latvia ( images )</a>',
'translate_google_lv','<a href="http://translate.google.lv" title="Search Engine Home Page" rel="nofollow">Google Translate Latvia</a>',
'google_lv','<a href="http://google.lv" title="Search Engine Home Page" rel="nofollow">Google Latvia ( catchall )</a>',
'www_google_md','<a href="http://www.google.md" title="Search Engine Home Page" rel="nofollow">Google Moldova</a>',
'images_google_md','<a href="http://images.google.md" title="Search Engine Home Page" rel="nofollow">Google Moldova ( images )</a>',
'translate_google_md','<a href="http://translate.google.md" title="Search Engine Home Page" rel="nofollow">Google Translate Moldova</a>',
'google_md','<a href="http://google.md" title="Search Engine Home Page" rel="nofollow">Google Moldova ( catchall )</a>',
'www_google_me','<a href="http://www.google.me" title="Search Engine Home Page" rel="nofollow">Google Montenegro</a>',
'images_google_me','<a href="http://images.google.me" title="Search Engine Home Page" rel="nofollow">Google Montenegro ( images )</a>',
'translate_google_me','<a href="http://translate.google.me" title="Search Engine Home Page" rel="nofollow">Google Translate Montenegro</a>',
'google_me','<a href="http://google.me" title="Search Engine Home Page" rel="nofollow">Google Montenegro ( catchall )</a>',
'www_google_mg','<a href="http://www.google.mg" title="Search Engine Home Page" rel="nofollow">Google Madagascar</a>',
'images_google_mg','<a href="http://images.google.mg" title="Search Engine Home Page" rel="nofollow">Google Madagascar ( images )</a>',
'translate_google_mg','<a href="http://translate.google.mg" title="Search Engine Home Page" rel="nofollow">Google Translate Madagascar</a>',
'google_mg','<a href="http://google.mg" title="Search Engine Home Page" rel="nofollow">Google Madagascar ( catchall )</a>',
'www_google_mk','<a href="http://www.google.mk" title="Search Engine Home Page" rel="nofollow">Google Macedonia</a>',
'images_google_mk','<a href="http://images.google.mk" title="Search Engine Home Page" rel="nofollow">Google Macedonia ( images )</a>',
'translate_google_mk','<a href="http://translate.google.mk" title="Search Engine Home Page" rel="nofollow">Google Translate Macedonia</a>',
'google_mk','<a href="http://google.mk" title="Search Engine Home Page" rel="nofollow">Google Macedonia ( catchall )</a>',
'www_google_ml','<a href="http://www.google.ml" title="Search Engine Home Page" rel="nofollow">Google Mali</a>',
'images_google_ml','<a href="http://images.google.ml" title="Search Engine Home Page" rel="nofollow">Google Mali ( images )</a>',
'translate_google_ml','<a href="http://translate.google.ml" title="Search Engine Home Page" rel="nofollow">Google Translate Mali</a>',
'google_ml','<a href="http://google.ml" title="Search Engine Home Page" rel="nofollow">Google Mali ( catchall )</a>',
'www_google_mn','<a href="http://www.google.mn" title="Search Engine Home Page" rel="nofollow">Google Mongolia</a>',
'images_google_mn','<a href="http://images.google.mn" title="Search Engine Home Page" rel="nofollow">Google Mongolia ( images )</a>',
'translate_google_mn','<a href="http://translate.google.mn" title="Search Engine Home Page" rel="nofollow">Google Translate Mongolia</a>',
'google_mn','<a href="http://google.mn" title="Search Engine Home Page" rel="nofollow">Google Mongolia ( catchall )</a>',
'www_google_ms','<a href="http://www.google.ms" title="Search Engine Home Page" rel="nofollow">Google Montserrat</a>',
'images_google_ms','<a href="http://images.google.ms" title="Search Engine Home Page" rel="nofollow">Google Montserrat ( images )</a>',
'translate_google_ms','<a href="http://translate.google.ms" title="Search Engine Home Page" rel="nofollow">Google Translate Montserrat</a>',
'google_ms','<a href="http://google.ms" title="Search Engine Home Page" rel="nofollow">Google Montserrat ( catchall )</a>',
'www_google_mu','<a href="http://www.google.mu" title="Search Engine Home Page" rel="nofollow">Google Mauritius</a>',
'images_google_mu','<a href="http://images.google.mu" title="Search Engine Home Page" rel="nofollow">Google Mauritius ( images )</a>',
'translate_google_mu','<a href="http://translate.google.mu" title="Search Engine Home Page" rel="nofollow">Google Translate Mauritius</a>',
'google_mu','<a href="http://google.mu" title="Search Engine Home Page" rel="nofollow">Google Mauritius ( catchall )</a>',
'www_google_mv','<a href="http://www.google.mv" title="Search Engine Home Page" rel="nofollow">Google Maldives</a>',
'images_google_mv','<a href="http://images.google.mv" title="Search Engine Home Page" rel="nofollow">Google Maldives ( images )</a>',
'translate_google_mv','<a href="http://translate.google.mv" title="Search Engine Home Page" rel="nofollow">Google Translate Maldives</a>',
'google_mv','<a href="http://google.mv" title="Search Engine Home Page" rel="nofollow">Google Maldives ( catchall )</a>',
'www_google_mw','<a href="http://www.google.mw" title="Search Engine Home Page" rel="nofollow">Google Malawi</a>',
'images_google_mw','<a href="http://images.google.mw" title="Search Engine Home Page" rel="nofollow">Google Malawi ( images )</a>',
'translate_google_mw','<a href="http://translate.google.mw" title="Search Engine Home Page" rel="nofollow">Google Translate Malawi</a>',
'google_mw','<a href="http://google.mw" title="Search Engine Home Page" rel="nofollow">Google Malawi ( catchall )</a>',
'www_google_ne','<a href="http://www.google.ne" title="Search Engine Home Page" rel="nofollow">Google Niger</a>',
'images_google_ne','<a href="http://images.google.ne" title="Search Engine Home Page" rel="nofollow">Google Niger ( images )</a>',
'translate_google_ne','<a href="http://translate.google.ne" title="Search Engine Home Page" rel="nofollow">Google Translate Niger</a>',
'google_ne','<a href="http://google.ne" title="Search Engine Home Page" rel="nofollow">Google Niger ( catchall )</a>',
'www_google_nr','<a href="http://www.google.nr" title="Search Engine Home Page" rel="nofollow">Google Nauru</a>',
'images_google_nr','<a href="http://images.google.nr" title="Search Engine Home Page" rel="nofollow">Google Nauru ( images )</a>',
'translate_google_nr','<a href="http://translate.google.nr" title="Search Engine Home Page" rel="nofollow">Google Translate Nauru</a>',
'google_nr','<a href="http://google.nr" title="Search Engine Home Page" rel="nofollow">Google Nauru ( catchall )</a>',
'www_google_nu','<a href="http://www.google.nu" title="Search Engine Home Page" rel="nofollow">Google Niue</a>',
'images_google_nu','<a href="http://images.google.nu" title="Search Engine Home Page" rel="nofollow">Google Niue ( images )</a>',
'translate_google_nu','<a href="http://translate.google.nu" title="Search Engine Home Page" rel="nofollow">Google Translate Niue</a>',
'google_nu','<a href="http://google.nu" title="Search Engine Home Page" rel="nofollow">Google Niue ( catchall )</a>',
'www_google_pn','<a href="http://www.google.pn" title="Search Engine Home Page" rel="nofollow">Google Pitcairn Islands</a>',
'images_google_pn','<a href="http://images.google.pn" title="Search Engine Home Page" rel="nofollow">Google Pitcairn Islands ( images )</a>',
'translate_google_pn','<a href="http://translate.google.pn" title="Search Engine Home Page" rel="nofollow">Google Translate Pitcairn Islands</a>',
'google_pn','<a href="http://google.pn" title="Search Engine Home Page" rel="nofollow">Google Pitcairn Islands ( catchall )</a>',
'www_google_ps','<a href="http://www.google.ps" title="Search Engine Home Page" rel="nofollow">Google Palestine</a>',
'images_google_ps','<a href="http://images.google.ps" title="Search Engine Home Page" rel="nofollow">Google Palestine[4] ( images )</a>',
'translate_google_ps','<a href="http://translate.google.ps" title="Search Engine Home Page" rel="nofollow">Google Translate Palestine[4]</a>',
'google_ps','<a href="http://google.ps" title="Search Engine Home Page" rel="nofollow">Google Palestine[4] ( catchall )</a>',
'www_google_ro','<a href="http://www.google.ro" title="Search Engine Home Page" rel="nofollow">Google Romania</a>',
'images_google_ro','<a href="http://images.google.ro" title="Search Engine Home Page" rel="nofollow">Google Romania ( images )</a>',
'translate_google_ro','<a href="http://translate.google.ro" title="Search Engine Home Page" rel="nofollow">Google Translate Romania</a>',
'google_ro','<a href="http://google.ro" title="Search Engine Home Page" rel="nofollow">Google Romania ( catchall )</a>',
'www_google_rs','<a href="http://www.google.rs" title="Search Engine Home Page" rel="nofollow">Google Serbia</a>',
'images_google_rs','<a href="http://images.google.rs" title="Search Engine Home Page" rel="nofollow">Google Serbia ( images )</a>',
'translate_google_rs','<a href="http://translate.google.rs" title="Search Engine Home Page" rel="nofollow">Google Translate Serbia</a>',
'google_rs','<a href="http://google.rs" title="Search Engine Home Page" rel="nofollow">Google Serbia ( catchall )</a>',
'www_google_ru','<a href="http://www.google.ru" title="Search Engine Home Page" rel="nofollow">Google Russia</a>',
'images_google_ru','<a href="http://images.google.ru" title="Search Engine Home Page" rel="nofollow">Google Russia ( images )</a>',
'translate_google_ru','<a href="http://translate.google.ru" title="Search Engine Home Page" rel="nofollow">Google Translate Russia</a>',
'google_ru','<a href="http://google.ru" title="Search Engine Home Page" rel="nofollow">Google Russia ( catchall )</a>',
'www_google_rw','<a href="http://www.google.rw" title="Search Engine Home Page" rel="nofollow">Google Rwanda</a>',
'images_google_rw','<a href="http://images.google.rw" title="Search Engine Home Page" rel="nofollow">Google Rwanda ( images )</a>',
'translate_google_rw','<a href="http://translate.google.rw" title="Search Engine Home Page" rel="nofollow">Google Translate Rwanda</a>',
'google_rw','<a href="http://google.rw" title="Search Engine Home Page" rel="nofollow">Google Rwanda ( catchall )</a>',
'www_google_sc','<a href="http://www.google.sc" title="Search Engine Home Page" rel="nofollow">Google Seychelles</a>',
'images_google_sc','<a href="http://images.google.sc" title="Search Engine Home Page" rel="nofollow">Google Seychelles ( images )</a>',
'translate_google_sc','<a href="http://translate.google.sc" title="Search Engine Home Page" rel="nofollow">Google Translate Seychelles</a>',
'google_sc','<a href="http://google.sc" title="Search Engine Home Page" rel="nofollow">Google Seychelles ( catchall )</a>',
'www_google_sh','<a href="http://www.google.sh" title="Search Engine Home Page" rel="nofollow">Google Saint Helena and Ascension and Tristan da Cunha</a>',
'images_google_sh','<a href="http://images.google.sh" title="Search Engine Home Page" rel="nofollow">Google Saint Helena and Ascension and Tristan da Cunha ( images )</a>',
'translate_google_sh','<a href="http://translate.google.sh" title="Search Engine Home Page" rel="nofollow">Google Translate Saint Helena and Ascension and Tristan da Cunha</a>',
'google_sh','<a href="http://google.sh" title="Search Engine Home Page" rel="nofollow">Google Saint Helena and Ascension and Tristan da Cunha ( catchall )</a>',
'www_google_si','<a href="http://www.google.si" title="Search Engine Home Page" rel="nofollow">Google Slovenia</a>',
'images_google_si','<a href="http://images.google.si" title="Search Engine Home Page" rel="nofollow">Google Slovenia ( images )</a>',
'translate_google_si','<a href="http://translate.google.si" title="Search Engine Home Page" rel="nofollow">Google Translate Slovenia</a>',
'google_si','<a href="http://google.si" title="Search Engine Home Page" rel="nofollow">Google Slovenia ( catchall )</a>',
'www_google_sk','<a href="http://www.google.sk" title="Search Engine Home Page" rel="nofollow">Google Slovakia</a>',
'images_google_sk','<a href="http://images.google.sk" title="Search Engine Home Page" rel="nofollow">Google Slovakia ( images )</a>',
'translate_google_sk','<a href="http://translate.google.sk" title="Search Engine Home Page" rel="nofollow">Google Translate Slovakia</a>',
'google_sk','<a href="http://google.sk" title="Search Engine Home Page" rel="nofollow">Google Slovakia ( catchall )</a>',
'www_google_sm','<a href="http://www.google.sm" title="Search Engine Home Page" rel="nofollow">Google San Marino</a>',
'images_google_sm','<a href="http://images.google.sm" title="Search Engine Home Page" rel="nofollow">Google San Marino ( images )</a>',
'translate_google_sm','<a href="http://translate.google.sm" title="Search Engine Home Page" rel="nofollow">Google Translate San Marino</a>',
'google_sm','<a href="http://google.sm" title="Search Engine Home Page" rel="nofollow">Google San Marino ( catchall )</a>',
'www_google_sn','<a href="http://www.google.sn" title="Search Engine Home Page" rel="nofollow">Google Senegal</a>',
'images_google_sn','<a href="http://images.google.sn" title="Search Engine Home Page" rel="nofollow">Google Senegal ( images )</a>',
'translate_google_sn','<a href="http://translate.google.sn" title="Search Engine Home Page" rel="nofollow">Google Translate Senegal</a>',
'google_sn','<a href="http://google.sn" title="Search Engine Home Page" rel="nofollow">Google Senegal ( catchall )</a>',
'www_google_so','<a href="http://www.google.so" title="Search Engine Home Page" rel="nofollow">Google Somalia</a>',
'images_google_so','<a href="http://images.google.so" title="Search Engine Home Page" rel="nofollow">Google Somalia ( images )</a>',
'translate_google_so','<a href="http://translate.google.so" title="Search Engine Home Page" rel="nofollow">Google Translate Somalia</a>',
'google_so','<a href="http://google.so" title="Search Engine Home Page" rel="nofollow">Google Somalia ( catchall )</a>',
'www_google_sr','<a href="http://www.google.sr" title="Search Engine Home Page" rel="nofollow">Google Suriname</a>',
'images_google_sr','<a href="http://images.google.sr" title="Search Engine Home Page" rel="nofollow">Google Suriname ( images )</a>',
'translate_google_sr','<a href="http://translate.google.sr" title="Search Engine Home Page" rel="nofollow">Google Translate Suriname</a>',
'google_sr','<a href="http://google.sr" title="Search Engine Home Page" rel="nofollow">Google Suriname ( catchall )</a>',
'www_google_st','<a href="http://www.google.st" title="Search Engine Home Page" rel="nofollow">Google Sao Tome and Principe</a>',
'images_google_st','<a href="http://images.google.st" title="Search Engine Home Page" rel="nofollow">Google Sao Tome and Principe ( images )</a>',
'translate_google_st','<a href="http://translate.google.st" title="Search Engine Home Page" rel="nofollow">Google Translate Sao Tome and Principe</a>',
'google_st','<a href="http://google.st" title="Search Engine Home Page" rel="nofollow">Google Sao Tome and Principe ( catchall )</a>',
'www_google_td','<a href="http://www.google.td" title="Search Engine Home Page" rel="nofollow">Google Chad</a>',
'images_google_td','<a href="http://images.google.td" title="Search Engine Home Page" rel="nofollow">Google Chad ( images )</a>',
'translate_google_td','<a href="http://translate.google.td" title="Search Engine Home Page" rel="nofollow">Google Translate Chad</a>',
'google_td','<a href="http://google.td" title="Search Engine Home Page" rel="nofollow">Google Chad ( catchall )</a>',
'www_google_tg','<a href="http://www.google.tg" title="Search Engine Home Page" rel="nofollow">Google Togo</a>',
'images_google_tg','<a href="http://images.google.tg" title="Search Engine Home Page" rel="nofollow">Google Togo ( images )</a>',
'translate_google_tg','<a href="http://translate.google.tg" title="Search Engine Home Page" rel="nofollow">Google Translate Togo</a>',
'google_tg','<a href="http://google.tg" title="Search Engine Home Page" rel="nofollow">Google Togo ( catchall )</a>',
'www_google_tk','<a href="http://www.google.tk" title="Search Engine Home Page" rel="nofollow">Google Tokelau</a>',
'images_google_tk','<a href="http://images.google.tk" title="Search Engine Home Page" rel="nofollow">Google Tokelau ( images )</a>',
'translate_google_tk','<a href="http://translate.google.tk" title="Search Engine Home Page" rel="nofollow">Google Translate Tokelau</a>',
'google_tk','<a href="http://google.tk" title="Search Engine Home Page" rel="nofollow">Google Tokelau ( catchall )</a>',
'www_google_tl','<a href="http://www.google.tl" title="Search Engine Home Page" rel="nofollow">Google Timor-Leste</a>',
'images_google_tl','<a href="http://images.google.tl" title="Search Engine Home Page" rel="nofollow">Google Timor-Leste ( images )</a>',
'translate_google_tl','<a href="http://translate.google.tl" title="Search Engine Home Page" rel="nofollow">Google Translate Timor-Leste</a>',
'google_tl','<a href="http://google.tl" title="Search Engine Home Page" rel="nofollow">Google Timor-Leste ( catchall )</a>',
'www_google_tm','<a href="http://www.google.tm" title="Search Engine Home Page" rel="nofollow">Google Turkmenistan</a>',
'images_google_tm','<a href="http://images.google.tm" title="Search Engine Home Page" rel="nofollow">Google Turkmenistan ( images )</a>',
'translate_google_tm','<a href="http://translate.google.tm" title="Search Engine Home Page" rel="nofollow">Google Translate Turkmenistan</a>',
'google_tm','<a href="http://google.tm" title="Search Engine Home Page" rel="nofollow">Google Turkmenistan ( catchall )</a>',
'www_google_tn','<a href="http://www.google.tn" title="Search Engine Home Page" rel="nofollow">Google Tunisia</a>',
'images_google_tn','<a href="http://images.google.tn" title="Search Engine Home Page" rel="nofollow">Google Tunisia ( images )</a>',
'translate_google_tn','<a href="http://translate.google.tn" title="Search Engine Home Page" rel="nofollow">Google Translate Tunisia</a>',
'google_tn','<a href="http://google.tn" title="Search Engine Home Page" rel="nofollow">Google Tunisia ( catchall )</a>',
'www_google_to','<a href="http://www.google.to" title="Search Engine Home Page" rel="nofollow">Google Tonga</a>',
'images_google_to','<a href="http://images.google.to" title="Search Engine Home Page" rel="nofollow">Google Tonga ( images )</a>',
'translate_google_to','<a href="http://translate.google.to" title="Search Engine Home Page" rel="nofollow">Google Translate Tonga</a>',
'google_to','<a href="http://google.to" title="Search Engine Home Page" rel="nofollow">Google Tonga ( catchall )</a>',
'www_google_tt','<a href="http://www.google.tt" title="Search Engine Home Page" rel="nofollow">Google Trinidad and Tobago</a>',
'images_google_tt','<a href="http://images.google.tt" title="Search Engine Home Page" rel="nofollow">Google Trinidad and Tobago ( images )</a>',
'translate_google_tt','<a href="http://translate.google.tt" title="Search Engine Home Page" rel="nofollow">Google Translate Trinidad and Tobago</a>',
'google_tt','<a href="http://google.tt" title="Search Engine Home Page" rel="nofollow">Google Trinidad and Tobago ( catchall )</a>',
'www_google_us','<a href="http://www.google.us" title="Search Engine Home Page" rel="nofollow">Google United States</a>',
'images_google_us','<a href="http://images.google.us" title="Search Engine Home Page" rel="nofollow">Google United States ( images )</a>',
'translate_google_us','<a href="http://translate.google.us" title="Search Engine Home Page" rel="nofollow">Google Translate United States</a>',
'google_us','<a href="http://google.us" title="Search Engine Home Page" rel="nofollow">Google United States ( catchall )</a>',
'www_google_vg','<a href="http://www.google.vg" title="Search Engine Home Page" rel="nofollow">Google British Virgin Islands</a>',
'images_google_vg','<a href="http://images.google.vg" title="Search Engine Home Page" rel="nofollow">Google British Virgin Islands ( images )</a>',
'translate_google_vg','<a href="http://translate.google.vg" title="Search Engine Home Page" rel="nofollow">Google Translate British Virgin Islands</a>',
'google_vg','<a href="http://google.vg" title="Search Engine Home Page" rel="nofollow">Google British Virgin Islands ( catchall )</a>',
'www_google_vu','<a href="http://www.google.vu" title="Search Engine Home Page" rel="nofollow">Google Vanuatu</a>',
'images_google_vu','<a href="http://images.google.vu" title="Search Engine Home Page" rel="nofollow">Google Vanuatu ( images )</a>',
'translate_google_vu','<a href="http://translate.google.vu" title="Search Engine Home Page" rel="nofollow">Google Translate Vanuatu</a>',
'google_vu','<a href="http://google.vu" title="Search Engine Home Page" rel="nofollow">Google Vanuatu ( catchall )</a>',
'www_google_ws','<a href="http://www.google.ws" title="Search Engine Home Page" rel="nofollow">Google Samoa</a>',
'images_google_ws','<a href="http://images.google.ws" title="Search Engine Home Page" rel="nofollow">Google Samoa ( images )</a>',
'translate_google_ws','<a href="http://translate.google.ws" title="Search Engine Home Page" rel="nofollow">Google Translate Samoa</a>',
'google_ws','<a href="http://google.ws" title="Search Engine Home Page" rel="nofollow">Google Samoa ( catchall )</a>',

'google_cache','<a href="http://www.google.com/help/features.html#cached" title="Search Engine Home Page" rel="nofollow">Google (cache)</a>',
'google_froogle','<a href="http://froogle.google.com" title="Search Engine Home Page" rel="nofollow">Froogle (Google)</a>',
'google_groups','<a href="http://groups.google.com" title="Search Engine Home Page" rel="nofollow">Google (Groups)</a>',
'google_maps','<a href="http://maps.google.co.uk" title="Search Engine Home Page" rel="nofollow">Google Maps</a>',
'googleByIP','<a href="http://173.194.35.177" title="Google (Access by IP-Address)" rel="nofollow">Google (Access by IP-Address)</a>',
'google_catchall','<a href="http://www.google.com" title="Search Engine Home Page" rel="nofollow">Google catchall sites not specified</a>',
'google_products','<a href="http://www.google.com/products" title="Search Engine Home Page" rel="nofollow">Google (Products)</a>',
'google_translate','<a href="http://translate.google.com" title="Search Engine Home Page" rel="nofollow">Google Translate ( catchall )</a>',
'google4counter','<a href="http://www.4-counter.com" title="Search Engine Home Page" rel="nofollow">4-counter (Google)</a>',
'android_googlequicksearchbox','<a href="android-app://com.google.android.googlequicksearchbox" title="Search Engine Home Page">android-app://com.google.android.googlequicksearchbox ( what is this )</a>',

'1klik','1Klik',
'1search','<a href="http://1search-board.com" rel="nofollow">1search-board.com</a>',
'1und1_de','<a href="http://suche.1und1.de" title="1&amp;1 Suche" rel="nofollow">1&amp;1 Suche (subdomain "suche")</a>',
'3721','<a href="http://www.3721.com" rel="nofollow">3721</a>',
'a9','<a href="http://www.a9.com" title="Search Engine Home Page" rel="nofollow">A9</a>',
'abacho','Abacho',
'accoona','<a href="http://cn.accoona.com" rel="nofollow">Accoona</a>',
'alexa','<a href="http://www.alexa.com" title="Search Engine Home Page" rel="nofollow">Alexa</a>',
'aliceit','<a href="http://www.alice.it" title="Search Engine Home Page" rel="nofollow">alice.it</a>',
'aliceitmaster','<a href="http://www.alice.it" title="Search Engine Home Page" rel="nofollow">search.alice.it.master</a>',
'allesklar','allesklar.de',
'allgameshome','<a href="http://my.allgameshome.com" title="AllGamesHome" rel="nofollow">AllGamesHome</a>',
'alltheweb','<a href="http://www.alltheweb.com" title="Search Engine Home Page" rel="nofollow">AllTheWeb</a>',
'alot','alot',
'altavista','<a href="http://www.altavista.com" title="Search Engine Home Page" rel="nofollow">AltaVista</a>',
'amazon','amazon',
'androidsearch','<a href="http://www.androidsearch.com" title="androidsearch.com" rel="nofollow">androidsearch.com</a>',
'answerbus','<a href="http://www.answerbus.com" title="Search Engine Home Page" rel="nofollow">Answerbus</a>',
'anzwers','<a href="http://anzwers.com.au" title="anzwers.com.au home page" rel="nofollow">anzwers.com.au</a>',
'aol_o2suche_de','AOL O2Suche (de)', 
'aolcatchall','<a href="http://search.aol.com" title="Search Engine Home Page" rel="nofollow">AOL catchall countries</a>',
'aolcom','<a href="http://search.aol.com" title="Search Engine Home Page" rel="nofollow">AOL .com</a>',
'aolde','<a href="http://suche.aol.de" title="Search Engine Home Page" rel="nofollow">AOL .de</a>',
'aolfr','AOL (fr)', 
'aolpl','<a href="http://search.aol.pl" title="Search Engine Home Page" rel="nofollow">AOL .pl</a>',
'aolsearchde','<a href="http://de.aolsearch.com" title="AOL Search Home Page" rel="nofollow">AOL Search de</a>',
'aoluk','<a href="http://search.aol.co.uk" title="Search Engine Home Page" rel="nofollow">AOL .uk</a>',
'aport','Aport',
'arianna','<a href="http://arianna.libero.it" title="Search Engine Home Page" rel="nofollow">Arianna</a>',
'asevenboard','<a href="http://asevenboard.com" title="Search Engine Home Page" rel="nofollow">asevenboard</a>',
'askcatchall','<a href="http://www.ask.com" title="Search Engine Home Page" rel="nofollow">Ask catchall sites</a>',
'askde','<a href="http://de.ask.com" title="Search Engine Home Page" rel="nofollow">Ask Deutschland</a>',
'askes','<a href="http://es.ask.com" title="Search Engine Home Page" rel="nofollow">Ask Espa&ntilde;a</a>', # break out Ask country specific engines.
'askfr','<a href="http://fr.ask.com" title="Search Engine Home Page" rel="nofollow">Ask France</a>',
'askimages','ask images',
'askit','<a href="http://it.ask.com" title="Search Engine Home Page" rel="nofollow">Ask Italia</a>',
'askjp','<a href="http://www.ask.jp" title="Search Engine Home Page" rel="nofollow">Ask Japan</a>',
'asknl','<a href="http://nl.ask.com" title="Search Engine Home Page" rel="nofollow">Ask Nederland</a>',
'askuk','<a href="http://uk.ask.com" title="Search Engine Home Page" rel="nofollow">Ask UK</a>',
'atlanticbb','atlanticbb',
'atlas','Atlas.cz',
'atomz','Atomz',
'att','<a href="http://www.att.net" title="Search Engine Home Page" rel="nofollow">AT&T search (powered by Google)</a>',
'auone','auone',
'avantfind','<a href="http://www.avantfind.com" title="Search Engine Home Page" rel="nofollow">Avantfind</a>',
'avg','avg',
'babylon','<a href="http://search.babylon.com" title="Babylon Home Page" rel="nofollow">Babylon</a>',
'baidu','<a href="http://www.baidu.com" rel="nofollow">Baidu</a>',
'bbc','BBC', 
'benefind','<a href="http://www.benefind.de" title="benefind Home Page" rel="nofollow">benefind</a>',
'biglotron','<a href="http://www.biglotron.com" title="Search Engine Home Page" rel="nofollow">Biglotron</a>',

'www_bing_com','<a href="http://www.bing.com" title="Search Engine Home Page" rel="nofollow">Bing</a>',
'cn_bing_com','<a href="http://cn.bing.com" title="Search Engine Home Page">Bing : cn.bing.com</a>',
'global_bing_com','<a href="http://global.bing.com" title="Search Engine Home Page">Bing : global.bing.com</a>',
'bing_com_catchall','<a href="http://www.bing.com" title="Search Engine Home Page">Bing : bing.com ( catchall )</a>',

'blekko','blekko',
'blingo','<a href="http://www.blingo.com" title="Search Engine Home Page" rel="nofollow">Blingo</a>',
'boatdesign','<a href="http://www.boatdesign.net" title="Search Engine Home Page">Boatdesign .net</a>',
'bluewin','search.bluewin.ch',
'bt','BT',
'bungeebonesdotcom','<a href="http://BungeeBones.com/search.php/" title="Search Engine Home Page" rel="nofollow">BungeeBones</a>',
'burett_pagelink_si','<a href="http://burett.pagelink.si" title="Search Engine Home Page">burett.pagelink.si</a>',
'centraldatabase','<a href="http://search.centraldatabase.org" title="Search Engine Home Page" rel="nofollow">GPU p2p search</a>',
'centrum','Centrum.cz', 
'centurylink','centurylink',
'certifiedtoolbarsearch','<a href="http://search.certified-toolbar.com" title="Certified-Toolbar Search" rel="nofollow">Certified-Toolbar Search</a>',
'charter','charter',
'chatzum','chatzum',
'checkparams','checkparams',
'chelloat','<a href="http://www.chello.at" title="Search Engine Home Page" rel="nofollow">Chello Austria</a>',
'chellobe','<a href="http://www.chello.be" title="Search Engine Home Page" rel="nofollow">Chello Belgium</a>',
'chellocom','<a href="http://www.chello.com" title="Search Engine Home Page" rel="nofollow">Chello (Country not recognized)</a>',
'chellocz','<a href="http://www.chello.cz" title="Search Engine Home Page" rel="nofollow">Chello Czech Republic</a>',
'chellofr','<a href="http://www.chello.fr" title="Search Engine Home Page" rel="nofollow">Chello France</a>',
'chellohu','<a href="http://www.chello.hu" title="Search Engine Home Page" rel="nofollow">Chello Hungary</a>',
'chellonl','<a href="http://www.chello.nl" title="Search Engine Home Page" rel="nofollow">Chello Netherlands</a>',
'chellono','<a href="http://www.chello.no" title="Search Engine Home Page" rel="nofollow">Chello Norway</a>',
'chellopl','<a href="http://www.chello.pl" title="Search Engine Home Page" rel="nofollow">Chello Poland</a>',
'chellose','<a href="http://www.chello.se" title="Search Engine Home Page" rel="nofollow">Chello Sweden</a>',
'chellosk','<a href="http://www.chello.sk" title="Search Engine Home Page" rel="nofollow">Chello Slovakia</a>',
'clarosearch','<a href="http://www.claro-search.com" title="Search Engine Home Page" rel="nofollow">Claro Search</a>',
'clinck','clinck',
'clubinternet','Club-internet',
'clusty','<a href="http://www.clusty.com" title="Search Engine Home Page" rel="nofollow">Clusty</a>',
'comcast','comcast',
'comettoolbar','<a href="http://as.starware.com/dp/search" title="Comet toolbar search home page" rel="nofollow">Comet toolbar search</a>',
'conduit','<a href="http://search.conduit.com" title="Conduit Search Home Page" rel="nofollow">Conduit Search</a>',
'copernic','<a href="http://www.copernic.com" title="Search Engine Home Page" rel="nofollow">Copernic</a>',
'crawler','<a href="http://www.crawler.com" title="Search Engine Home Page" rel="nofollow">crawler.com</a>',
'csillamker','<a href="http://csillamker.hu" title="Search Engine Home Page">csillamker.hu</a>',
'ctrouve','C\'est trouve', 
'dalesearch','<a href="http://www.dalesearch.com" title="Dale Search" rel="nofollow">Dale Search</a>',
'danielsen','Thor (danielsen.com)', 
'daum','daum',
'de_dolphin_com','<a href="http://de.dolphin.com" title="Dolphin Search search page" rel="nofollow">Dolphin Search</a>',
'de_wiki_gov_cn','<a href="http://de.wiki.gov.cn" title="Wiki Sucher" rel="nofollow">Wiki Sucher</a>',
'dealwifi_com','<a href="http://mystart2.dealwifi.com/search/" title="Search Engine Home Page">Dealwifi',
'dejanews','DejaNews',
'delicious','<a href="http://del.icio.us" title="del.icio.us home page" rel="nofollow">del.icio.us</a> (Social Bookmark)',
'delta-search','<a href="http://www.delta-search.com" title="Delta Search Home Page" rel="nofollow">Delta Search</a>',
'digg','<a href="http://www.digg.com" title="Digg home page" rel="nofollow">Digg</a> (Social Bookmark)',
'dmoz','<a href="http://dmoz.org" title="Search Engine Home Page" rel="nofollow">DMOZ</a>',
'dodajpl','<a href="http://www.dodaj.pl" title="Dodaj.pl home page" rel="nofollow">Dodaj.pl</a>',
'dogpile','<a href="http://www.dogpile.com" title="Search Engine Home Page" rel="nofollow">Dogpile</a>',
'duckduckgo','<a href="http://r.duckduckgo.com" title="DuckDuckGo Home Page" rel="nofollow">DuckDuckGo (Does not provide search keyphrases, using found page instead)</a>',
'earthlink','Earth Link',
'easysearch','<a href="http://heatherjeffery.easysearch.org.uk" title="Search Engine Home Page" rel="nofollow">easysearch</a>',
'ecosia','ecosia',
'edderkoppen','Edderkoppen', 
'engine','Cade', 
'eniro','<a href="http://www.eniro.no" title="Search Engine Home Page" rel="nofollow">Eniro</a>',
'enirose','<a href="http://www.eniro.se" title="Eniro Sverige home page" rel="nofollow">Eniro Sverige</a>',
'ereadingsource','ereadingsource',
'etools_ch','<a href="http://www.etools.ch" title="eTools.ch" rel="nofollow">eTools.ch</a>',
'euroseek','Euroseek',
'everyclick','everyclick',
'excite','<a href="http://www.excite.com" title="Search Engine Home Page" rel="nofollow">Excite</a>',
'facemoods','<a href="http://sr.facemoods.com" title="Facemoods Search" rel="nofollow">Facemoods Search</a>',
'fastbot_de','<a href="http://fastbot.de" title="Fastbot.de" rel="nofollow">Fastbot.de (Does not provide search keyphrases; using found page instead)</a>',
'fbdownloader','<a href="http://search.fbdownloader.com" title="FBDownloader Home Page" rel="nofollow">FBDownloader (fbdownloader)</a>',
'fdownloadr_com','<a href="http://search.fdownloadr.com" title="FBDownloader Home Page" rel="nofollow">FBDownloader (fdownloadr)</a>',
'find1friend','<a href="http://find1friend.com" title="Find1Friend" rel="nofollow">Find1Friend</a>',
'findamo','findamo',
'findarticles','Find Articles',
'finddk','Find', 
'fireball','fireball',
'flipora','<a href="http://static.flipora.com" title="Flipora Home Page" rel="nofollow">Flipora</a>',
'foxstart','foxstart',
'francite','Francite', 
'free','Free.fr', 
'freenet_de','<a href="http://suche.freenet.de" title="suche.freenet.de" rel="nofollow">suche.freenet.de</a>',
'freeserve','Freeserve', 
'funmoods','funmoods',
'gazetapl','<a href="http://szukaj.gazeta.pl" title="Gazeta.pl home page" rel="nofollow">Gazeta.pl</a>',
'genieo','<a href="http://search.genieo.com" title="Genieo home page" rel="nofollow">Genieo</a>',
'gerypl','<a href="http://szukaj.gery.pl" title="Gery.pl home page" rel="nofollow">Gery.pl</a>',
'globososo','Various variants of Globososo (Kingtale Technology): <a href="http://www.globososo.com" title="Globososo search page" rel="nofollow">www</a>, <a href="http://searches.globososo.com" title="searches subdomain of globososo.com" rel="nofollow">searches</a>, <a href="http://searches3.globososo.com" title="searches3 subdomain of globososo.com" rel="nofollow">searches3</a>, and at inspsearch.com (<a href="http://globososo.inspsearch.com" title="Globososo search page at globososo.inspsearch.com" rel="nofollow">globososo</a>, <a href="http://kingtale3.inspsearch.com" title="Globososo search page at kingtale3.inspsearch.com" rel="nofollow">kingtale3</a>)',
'gmxsuche','<a href="http://suche.gmx.net" title="GMX Suche Home Page" rel="nofollow">GMX Suche</a>',
'gmxsuche_at','<a href="http://suche.gmx.at" title="GMX Suche Österreich Home Page" rel="nofollow">GMX Suche Österreich</a>',
'go','Go.com',
'go_mail_ru','<a href="http://go.mail.ru" title="GMX Suche Oesterreich Home Page" rel="nofollow">Go.Mail.ru</a>',
'go2net','Go2Net (Metamoteur)',
'godado','Godado.it',
'goliat','Goliat', 
'goodsearch','<a href="http://www.goodsearch.com" title="Search Engine Home Page" rel="nofollow">GoodSearch</a>',
'gotuneed','<a href="http://www.gotuneed.com" title="Search Engine Home Page" rel="nofollow">got u need</a>',
'govome','<a href="http://www.govome.com" title="Govome" rel="nofollow">Govome</a>',
'haku','Ihmemaa',
'handycafe','handycafe',
'heureka','Heureka', 
'hogapl','<a href="http://www.hoga.pl" title="Hoga.pl home page" rel="nofollow">Hoga.pl</a>',
'holasearch','<a href="http://www.holasearch.com" title="Hola Search Home Page" rel="nofollow">Hola Search</a>',
'hotbot','Hotbot',
'hp_my_aol','hp my aol',
'hubwe','hubwe',
'iask','<a href="http://www.iask.com" rel="nofollow">Iask</a>',
'iboats','<a href="http://forums.iboats.com" title="forum home page" rel="nofollow">Iboats</a>',
'icerocket','<a href="http://www.icerocket.com" title="Search Engine Home Page" rel="nofollow">Icerocket (Blog)</a>',
'ichiro','<a href="http://search.goo.ne.jp" title="Search Engine Home Page" rel="nofollow">Ichiro</a>',
'icq','<a href="http://www.icq.com" title="Search Engine Home Page" rel="nofollow">icq</a>',
'ilse','Ilse',
'iminent','<a href="http://start.iminent.com" title="Iminent Home Page" rel="nofollow">Iminent</a>',
'inbox','<a href="http://www2.inbox.com/search/results1.aspx" title="Inbox Search" rel="nofollow">Inbox Search</a>',
'incredibar','incredibar',
'incredimail','incredimail',
'indexhu','Index', 
'ineffabile','<a href="http://www.ineffabile.it" title="Ineffabile.it home page" rel="nofollow">Ineffabile.it</a> (Social Bookmark)',
'ineffabile','<a href="http://www.ineffabile.it" title="Search Engine Home Page" rel="nofollow">Ineffabile.it</a> (Social Bookmark)',
'intelseek_com/','<a href="http://www.intelseek.com" title="Search Engine Home Page" rel="nofollow">Intelseek .com',
'www_info_com','<a href="http://www.info.com/search/" title="Search Engine Home Page" rel="nofollow">Info .com',
'infoseek','Infoseek',
'infospace','InfoSpace',
'infouk','<a href="http://info.co.uk" title="home page" rel="nofollow">Info UK</a>',
'inspsearch','<a href="http://airzip.inspsearch.com" title="airzip.inspsearch.com" rel="nofollow">airzip.inspsearch.com</a>',
'int_search_myway_com','<a href="http://int.search.myway.com" title="MyWay search page" rel="nofollow">MyWay</a>',
'interiapl','<a href="http://www.google.interia.pl" title="Interia.pl home page" rel="nofollow">Interia.pl</a>',
'internetto','Internetto Kereso',
'isearch_nation_com','<a href="http://isearch.nation.com" title="Nation Search" rel="nofollow">Nation Search</a>',
'iune','<a href="http://www.i-une.com" title="Search Engine Home Page" rel="nofollow">i-une</a>',
'ixquick','<a href="http://www.ixquick.com" title="Search Engine Home Page" rel="nofollow">ix quick</a>',
'izito_catchall','izito ( catchall )', 
'izito_de','<a href="http://www.izito.de" title="iZito Deutschland" rel="nofollow">iZito Deutschland</a>',
'izito_uk','<a href="http://www.izito.co.uk" title="Search Engine Home Page" rel="nofollow">izito .uk</a>', 
'jubii','Jubii', 
'jumpyit','Jumpy.it',
'startjuno_com','<a href="http://www.startjuno.com/search/" title="Search Engine Home Page" rel="nofollow">Startjuno .com</a>', 
'juno','<a href="http://search.juno.com" title="Search Engine Home Page" rel="nofollow">juno</a>', 
'jyxo','Jyxo.cz', 
'kartoo','<a href="http://www.kartoo.com" title="Search Engine Home Page" rel="nofollow">Kartoo</a>',
'katalogonetpl','<a href="http://katalog.onet.pl" title="Katalog.Onet.pl home page" rel="nofollow">Katalog.Onet.pl</a>',
'kataweb','<a href="http://www.kataweb.it/ricerca/" title="Search Engine Home Page" rel="nofollow">Kataweb</a>',
'keresolap_hu','<a href="http://keresolap.hu" title="Search Engine Home Page" rel="nofollow">Tango keresolap</a>',
'kvasir','kvasir',
'kvitters','kvitters',
'lapkereso_hu','Startlapkereso', 
'lbb','LBB', 
'ledix','<a href="http://www.ledix.net" title="Search Engine Home Page" rel="nofollow">Ledix</a>',
'libero','<a href="http://www.libero.it" title="Search Engine Home Page" rel="nofollow">Libero IT</a>',
'libertysurf','Libertysurf', 
'live','<a href="http://www.live.com" title="Search Engine Home Page" rel="nofollow">Microsoft Windows Live</a>',
'localmoxie','<a href="http://www.localmoxie.com" title="Local Moxie" rel="nofollow">Local Moxie</a>',
'looksmart_catchall','looksmart ( catchall )',
'looksmart_co_uk','looksmart .co.uk',
'lycos','<a href="http://www.lycos.com" title="Search Engine Home Page" rel="nofollow">Lycos</a>',
'mamma','Mamma',
'meinestadt','meinestadt.de', 
'metabot','MetaBot',
'metacrawler','MetaCrawler (Metamoteur)',
'metacrawler_de','metacrawler.de',
'metager','<a href="http://www.metager.de" title="MetaGer Home Page" rel="nofollow">MetaGer</a>',
'metahannover','uni-hannover.de',
'metasearch','metasearch',
'metaspinner','metaspinner',
'metasuche_ch','<a href="http://www.metasuche.ch" title="Metasuche search page" rel="nofollow">Metasuche.ch</a>',
'metaua','meta.ua',
'miner','Meta Miner',
'mirago','<a href="http://www.mirago.com" title="Search Engine Home Page" rel="nofollow">Mirago (country unknown)</a>',
'miragobe','<a href="http://www.mirago.be" title="Search Engine Home Page" rel="nofollow">Mirago Belgium</a>',
'miragoch','<a href="http://www.mirago.ch" title="Search Engine Home Page" rel="nofollow">Mirago Switzerland</a>',
'miragocouk','<a href="http://zone.mirago.co.uk" title="Search Engine Home Page" rel="nofollow">Mirago UK</a>',
'miragode','<a href="http://www.mirago.de" title="Search Engine Home Page" rel="nofollow">Mirago Germany</a>',
'miragodk','<a href="http://www.mirago.dk" title="Search Engine Home Page" rel="nofollow">Mirago Denmark</a>',
'miragoes','<a href="http://es.mirago.com" title="Search Engine Home Page" rel="nofollow">Mirago Spain</a>',
'miragofr','<a href="http://www.mirago.fr" title="Search Engine Home Page" rel="nofollow">Mirago France</a>',
'miragoit','<a href="http://www.mirago.it" title="Search Engine Home Page" rel="nofollow">Mirago Italy</a>',
'miragonl','<a href="http://www.mirago.nl" title="Search Engine Home Page" rel="nofollow">Mirago Netherlands</a>',
'miragono','<a href="http://no.mirago.com" title="Search Engine Home Page" rel="nofollow">Mirago Norway</a>',
'miragose','<a href="http://www.mirago.se" title="Search Engine Home Page" rel="nofollow">Mirago Sweden</a>',
'mitrasites','mitrasites',
'mozbot','<a href="http://www.mozbot.fr" title="Search Engine Home Page" rel="nofollow">Mozbot</a>',
'msn','<a href="http://search.msn.com" title="Search Engine Home Page" rel="nofollow">Microsoft MSN Search</a>',
'mys_yoursearch_me','<a href="http://mys.yoursearch.me" title="Yoursearch.me search page" rel="nofollow">Yoursearch.me</a>',
'mysearch','<a href="http://www.mysearch.com" title="Search Engine Home Page" rel="nofollow">My Search</a>',
'mysearchdial','<a href="http://start.mysearchdial.com" title="Search Engine Home Page" rel="nofollow">mysearchdial</a>',
'mysearchresults','<a href="http://www.mysearchresults.com" title="Search Engine Home Page" rel="nofollow">mysearchresults</a>',
'myway','<a href="http://search.myway.com" title="Search Engine Home Page" rel="nofollow">myway</a>',
'mywebsearch','<a href="http://search.mywebsearch.com" title="MyWebSearch home page" rel="nofollow">MyWebSearch</a>',
'najdi','Najdi.to',
'nation','nation', 
'navigationshilfe_t_online','<a href="http://navigationshilfe.t-online.de" title="MyWebSearch home page" rel="nofollow">T-Online Navigationshilfe</a>',
'nbci','NBCI',
'netease','<a href="http://www.163.com" rel="nofollow">NetEase</a>',
'netluchs','<a href="http://www.netluchs.de" title="Search Engine Home Page" rel="nofollow">Netluchs</a>',
'netscape','<a href="http://www.netscape.com" title="Search Engine Home Page" rel="nofollow">Netscape</a>',
'netsprintpl','<a href="http://www.netsprint.pl" title="NetSprint.pl home page" rel="nofollow">NetSprint.pl</a>',
'netstjernen','Netstjernen',
'netzero','<a href="http://search.netzero.net" title="home page" rel="nofollow">netzero</a>',
'northernlight','NorthernLight',
'nortonsavesearch','<a href="http://int.search-results.com" title="Norton Safe Search Home Page" rel="nofollow">Norton Safe Search</a>',
'nusearch','<a href="http://www.nusearch.com" title="Search Engine Home Page" rel="nofollow">Nusearch</a>',
'o2pl','<a href="http://szukaj2.o2.pl" title="o2.pl home page" rel="nofollow">o2.pl</a>',
'ofir','Ofir',
'oneseek_de','<a href="http://www.oneseek.de" title="Metasuchmaschine OneSeek.de" rel="nofollow">Metasuchmaschine OneSeek.de</a>',
'onetpl','<a href="http://szukaj.onet.pl" title="Onet.pl home page" rel="nofollow">Onet.pl</a>',
'opasia','Opasia', 
'orange','orange',
'orangeworld','orangeworld',
'orbis','Orbis', 
'origo','Origo-Vizsla', 
'overture','Overture',
'passagen','Evreka',
'pch','pch',
'peoplecheck_de','<a href="http://peoplecheck.de" title="PeopleCheck.de" rel="nofollow">PeopleCheck.de</a>',
'picsearch','<a href="http://www.picsearch.de" title="picsearch" rel="nofollow">picsearch</a>',
'pictures','pictures',
'plusnetwork','<a href="http://www.searchplusnetwork.com" title="Search Plus Network" rel="nofollow">Search Plus Network</a>',
'pogodak','<a href="http://www.pogodak.com" title="Pogodak search engine home page" rel="nofollow">Pogodak.com</a>',
'polskapl','<a href="http://szukaj.polska.pl" title="Polska home page" rel="nofollow">Polska</a>',
'polymeta_hu','<a href="http://www.polymeta.hu" title="Search Engine Home Page" rel="nofollow">Polymeta</a>',
'preciobarato_xyz','<a href="http://preciobarato.xyz" title="preciobarato.xyz offline on Oct 2, 2015" rel="nofollow">Yandex</a>',
'questionanswering','<a href="http://www.questionanswering.com" title="Questionanswering home page" rel="nofollow">Questionanswering</a>',
'quick','Quick.cz', 
'qwant_com','<a href="https://www.qwant.com" title="qwant.com" rel="nofollow">qwant.com</a>',
'rakuten','<a href="http://websearch.rakuten.co.jp" title="websearch.rakuten.co.jp" rel="nofollow">websearch.rakuten.co.jp</a>',
'rambler','Rambler',
'redbox','RedBox.cz',
'rr','rr',

'safehomepage_com','<a href="http://searches.safehomepage.com" title="safehomepage.com" rel="nofollow">safehomepage.com</a>',
'sagool','<a href="http://sagool.jp" title="Sagool home page" rel="nofollow">Sagool</a>',
'sapo','<a href="http://www.sapo.pt" title="Sapo search engine home page" rel="nofollow">Sapo</a>',
'schoenerbrausen','<a href="http://www.schoenerbrausen.de" title="Search Engine Home Page" rel="nofollow">Schoenerbrausen/</a>',
'scroogle','<a href="http://www.scroogle.org" title="Search Engine Home Page" rel="nofollow">Scroogle</a>',
'search.com','<a href="http://www.search.com" title="Search Engine Home Page" rel="nofollow">Search.com</a>',
'search_1und1_de','<a href="http://search.1und1.de" title="1&amp;1 Suche" rel="nofollow">1&amp;1 Suche (subdomain "search")</a>',
'search_foxtab_com','<a href="http://search.foxtab.com" title="Foxtab Search" rel="nofollow">Foxtab Search</a>',
'search_socialdownloadr_com','<a href="http://search.socialdownloadr.com" title="Socialdownloadr search page" rel="nofollow">Socialdownloadr</a>',
'search_zonealarm_com','<a href="http://search.zonealarm.com" title="Zone Alarm Search" rel="nofollow">Zone Alarm Search</a>',
'searchalgo','searchalgo',
'searchall_com','<a href="http://www.searchall.com/search/" title="Search Engine Home Page" rel="nofollow">Searchall</a>',
'searchalot','<a href="http://www.searchalot.com" title="Search Engine Home Page" rel="nofollow">Searchalot</a>',
'searchch','search.ch',
'searchcompletion','<a href="http://search.searchcompletion.com" title="SearchCompletion Search" rel="nofollow">SearchCompletion Search</a>',
'searches_qone8_com','<a href="http://searches.qone8.com" title="Omiga-Plus" rel="nofollow">Omiga-Plus</a>',
'searchesnavigator','<a href="http://searchesnavigator.com" title="Search Engine Home Page" rel="nofollow">searchesnavigator</a>',
'searchfunmoods','<a href="http://sr.searchfunmoods.com" title="Funmoods" rel="nofollow">Funmoods</a>',
'searchgol','<a href="http://www.searchgol.com" title="Search-Gol" rel="nofollow">Search-Gol</a>',
'searchlistingsite','<a href="http://searchlistingsite.com" title="home page" rel="nofollow">SearchLlistingSite</a>',
'searchmobileonline','<a href="http://www.searchmobileonline.com" title="Search Mobile Online (StartApp) Home Page" rel="nofollow">Search Mobile Online (StartApp)</a>',
'searchresults','<a href="http://www1.search-results.com" title="Search-results Home Page" rel="nofollow">Search-results</a>',
'nortonsavesearch','<a href="http://int.search-results.com" title="Norton Safe Search Home Page" rel="nofollow">Norton Safe Search</a>',
'mysearchdial','<a href="http://start.mysearchdial.com" title="My Search Dial" rel="nofollow">My Search Dial</a>',
'searchresults','<a href="http://www1.search-results.com" title="Search Engine Home Page" rel="nofollow">Search-results</a>',
'searchresultscom','<a href="http://www.search-results.com" title="search-results" rel="nofollow">search-results.com ( all sites )</a>',
'searchresultsmobi','<a href="http://www.search-results.mobi" title="Search Engine Home Page" rel="nofollow">search-results.mobi</a>',
'searchsafer','searchsafer',
'searchy','searchy.co.uk',
'searchya','<a href="http://www.searchya.com" title="Searchya" rel="nofollow">Searchya</a>',
'segnalo','<a href="http://segnalo.alice.it" title="Segnalo home page" rel="nofollow">Segnalo</a> (Social Bookmark)',
'semalt','semalt',
'sensis','<a href="http://www.sensis.com.au" title="Segnalo home page" rel="nofollow">Sensis AU</a>',
'seznam','<a href="http://search.seznam.cz">Seznam.cz</a>',
'shawca','<a href="http://start.shaw.ca" title="Search Engine Home Page" rel="nofollow">Shaw.ca</a>',
'shinyseek\.it','Shinyseek.it',
'shoppstop','<a href="http://www.shoppstop.com" title="ShoppStop" rel="nofollow">ShoppStop</a>',
'sify','<a href="http://search.sify.com" title="Search Engine Home Page" rel="nofollow">Sify</a>',
'sky','sky',
'smartsuggestor','<a href="http://search.smartsuggestor.com" title="home page" rel="nofollow">smartsuggestor</a>',
'smde','<a href="http://www.sm.de" title="SM.de - Die SuchMaschine" rel="nofollow">SM.de - Die SuchMaschine</a>',
'snapdo','snapdo',
'softonic','softonic',
'sogou','<a href="http://www.sogou.com" rel="nofollow">SoGou</a>',
'sol','SOL', 
'so_com','<a href="http://www.so.com" rel="nofollow">So .com</a>',
'soso','<a href="http://www.soso.com" rel="nofollow">SoSo</a>',
'speedbit','<a href="http://go.speedbit.com" title="Speedbit" rel="nofollow">Speedbit</a>',
'sphere','<a href="http://www.sphere.com" title="Search Engine Home Page" rel="nofollow">Sphere (Blog)</a>',
'splut','Splut', 
'spotjockey','Spotjockey',
'spray','Spray',
'start','start.no',
'startlap_hu','<a href="http://kereso.startlap.hu" title="Search Engine Home Page" rel="nofollow">Startlab Kereso</a>',
'startpage','startpage.com',
'startsiden','<a href="http://www.startsiden.no/sok/">Startsiden Norway</a>',
'startxxl','<a href="http://www.startxxl.com" title="StartXXL Home Page" rel="nofollow">StartXXL</a>',
'steadysearch','<a href="http://www.avantfind.com" title="Search Engine Home Page" rel="nofollow">Avantfind</a>',
'stumbleupon','<a href="http://www.stumbleupon.com" title="Stumbleupon home page" rel="nofollow">Stumbleupon</a> (Social Bookmark)',
'sucheaolde','<a href="http://sucheaol.aol.de" title="Search Engine Home Page" rel="nofollow">SucheAOL .de</a>',
'sumaja','<a href="http://www.sumaja.de" title="Sumaja" rel="nofollow">Sumaja</a>',
'supereva','<a href="http://search.supereva.com" title="Search Engine Home Page" rel="nofollow">Supereva</a>',
'surfcanyon_com','<a href="http://search.surfcanyon.com" title="SurfCanyon" rel="nofollow">SurfCanyon</a>',
'sweetim','<a href="http://search.sweetim.com" title="SweetIM Search" rel="nofollow">SweetIM Search</a>',
'sweetpacks','<a href="http://www.sweetpacks-search.com" title="Sweetpacks" rel="nofollow">Sweetpacks</a>',
'swik','<a href="http://swik.net" title="Swik home page" rel="nofollow">Swik</a> (Social Bookmark)',
'swisscows_ch','<a href="https://swisscows.ch" title="Swisscows search page" rel="nofollow">Swisscows</a>',
'sympatico','<a href="http://sympatico.msn.ca" title="Search Engine Home Page" rel="nofollow">Sympatico</a>',
'szukaczpl','<a href="http://www.szukacz.pl" title="Szukacz home page" rel="nofollow">Szukacz</a>',
't_online_catchall','T-Online ( catchall )',
't_online_de','<a href="http://suche.t-online.de" title="Szukacz home page" rel="nofollow">T-Online .de</a>',
'talktalk_uk','talktalk uk',
'tango_hu','<a href="http://tango.hu" title="Search Engine Home Page" rel="nofollow">Tango</a>',
'tbask','tb.ask ?',
'teecnoit','<a href="http://www.teecno.it" title="Teecno home page" rel="nofollow">Teecno</a>',
'teoma','<a href="http://search.ask.com" title="Search Engine Home Page" rel="nofollow">Teoma</a>',							# Replace 'directhit\.com','DirectHit',
'terra','<a href="http://www.terra.es" title="Search Engine Home Page" rel="nofollow">Terra</a>',
'tesco','tesco',
'theallsearches','<a href="http://theallsearches.com" title="Search Engine Home Page" rel="nofollow">theallsearches</a>',
'three','three',
'tiscali','<a href="http://search.tiscali.com" title="Search Engine Home Page" rel="nofollow">Tiscali</a>',
'tixuma_de','<a href="http://www.tixuma.de" title="Tixuma Deutschland" rel="nofollow">Tixuma Deutschland</a>',
'toile','Toile du Quebec',
'toshiba','<a href="http://start.toshiba.com/search/">Toshiba</a>',
'turtle','Turtle',
'tyfon','Tyfon', 
'uk_foxstart_com','<a href="http://uk.foxstart.com" title="Foxstart search page" rel="nofollow">Foxstart.com</a>',
'ukindex','UKIndex', 
'ukplus','UK Plus', 
'umfis','<a href="http://www.umfis.de" title="UMFIS-Online Das Umweltfirmen-Informationssystem der IHKs in Deutschland" rel="nofollow">UMFIS-Online Das Umweltfirmen-Informationssystem der IHKs in Deutschland</a>',
'umuwa_de','<a href="http://umuwa.de" title="Umuwa Deutschland" rel="nofollow">Umuwa Deutschland</a>',
'usatoday','<a href="http://www.usatoday.com/search">usatoday</a>',
'vindex','Vindex',
'virgilio','<a href="http://www.virgilio.it" title="Search Engine Home Page" rel="nofollow">Virgilio</a>',
'virginmedia','<a href="http://search.virginmedia.com" title="Search Engine Home Page" rel="nofollow">Virgin Media</a>',
'vi-view_com','<a href="http://searches.vi-view.com" title="vi-view.com" rel="nofollow">vi-view.com</a>',
'vivisimo','<a href="http://www.vivisimo.com" title="Search Engine Home Page" rel="nofollow">Vivisimo</a>',
'vlips_de','<a href="http://www.vlips.de/semags_proxy.php" title="vlips Proxy Page (Homepage not yet ready?)" rel="nofollow">vlips.de</a>',
'vnet','<a href="http://114.vnet.cn" rel="nofollow">VNet</a>',
'voila','<a href="http://www.voila.fr" title="Search Engine Home Page" rel="nofollow">Voila</a>',
'wahoo','Wahoo', 
'webalta','<a href="http://www.webalta.ru" title="Search Engine Home Page" rel="nofollow">webalta.ru</a>',
'webcrawler','<a href="http://www.webcrawler.com" title="Search Engine Home Page" rel="nofollow">WebCrawler</a>',
'webmania','webmania.hu', 
'whorush_com','whorush com',
'windowssearch_com','<a href="http://www.windowssearch.com/search?q=AWStats" title="Example page" rel="nofollow">windowssearch.com</a>',
'wisenut','WISENut',
'wow_utop_it','<a href="http://wow.utop.it" title="wow.utop.it" rel="nofollow">wow.utop.it</a>',
'wowpl','<a href="http://szukaj.wow.pl" title="Wow.pl home page" rel="nofollow">Wow.pl</a>',
'wowsearch','<a href="http://de.wow.com" title="Wow Search Home Page" rel="nofollow">Wow Search</a>',
'wowuk','<a href="http://uk.wow.com" title="uk.Wow home page" rel="nofollow">uk.wow.com</a>',
'wp','<a href="http://szukaj.wp.pl" title="Wirtualna Polska home page" rel="nofollow">Wirtualna Polska</a>',
'www_buenosearch_com','<a href="http://www.buenosearch.com" title="BuenoSearch" rel="nofollow">BuenoSearch</a>',
'www_dregol_com','<a href="http://www.dregol.com" title="Dregol Search" rel="nofollow">Dregol Search</a>',
'www_wow_com','<a href="http://www.wow.com" title="www.wow.com" rel="nofollow">WOW.com</a>',
'wwweasel','<a href="http://wwweasel.de" title="Search Engine Home Page" rel="nofollow">WWWeasel</a>',
'xfinity_com','<a href="http://search.xfinity.com">Xfinity</a>',
'ar_images_search_yahoo_com','<a href="http://ar.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ar.images.search.yahoo.com</a>',
'ar_search_yahoo_com','<a href="http://ar.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ar.search.yahoo.com</a>',
'at_images_search_yahoo_com','<a href="http://at.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : at.images.search.yahoo.com</a>',
'at_search_yahoo_com','<a href="http://at.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : at.search.yahoo.com</a>',
'au_images_search_yahoo_com','<a href="http://au.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : au.images.search.yahoo.com</a>',
'au_search_yahoo_com','<a href="http://au.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : au.search.yahoo.com</a>',
'br_images_search_yahoo_com','<a href="http://br.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : br.images.search.yahoo.com</a>',
'br_search_yahoo_com','<a href="http://br.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : br.search.yahoo.com</a>',
'ca_images_search_yahoo_com','<a href="http://ca.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ca.images.search.yahoo.com</a>',
'ca_search_yahoo_com','<a href="http://ca.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ca.search.yahoo.com</a>',
'ca_yhs4_search_yahoo_com','<a href="http://ca.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ca.yhs4.search.yahoo.com</a>',
'ch_images_search_yahoo_com','<a href="http://ch.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ch.images.search.yahoo.com</a>',
'ch_yhs4_search_yahoo_com','<a href="http://ch.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ch.yhs4.search.yahoo.com</a>',
'de_search_yahoo_com','<a href="http://de.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : de.search.yahoo.com</a>',
'de_yhs4_search_yahoo_com','<a href="http://de.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : de.yhs4.search.yahoo.com</a>',
'es_images_search_yahoo_com','<a href="http://es.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : es.images.search.yahoo.com</a>',
'es_search_yahoo_com','<a href="http://es.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : es.search.yahoo.com</a>',
'es_yhs4_search_yahoo_com','<a href="http://es.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : es.yhs4.search.yahoo.com</a>',
'espanol_images_search_yahoo_com','<a href="http://espanol.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : espanol.images.search.yahoo.com</a>',
'espanol_search_yahoo_com','<a href="http://espanol.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : espanol.search.yahoo.com</a>',
'fr_images_search_yahoo_com','<a href="http://fr.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : fr.images.search.yahoo.com</a>',
'fr_search_yahoo_com','<a href="http://fr.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : fr.search.yahoo.com</a>',
'fr_yhs4_search_yahoo_com','<a href="http://fr.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : fr.yhs4.search.yahoo.com</a>',
'gr_search_yahoo_com','<a href="http://gr.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : gr.search.yahoo.com</a>',
'gr_yhs4_search_yahoo_com','<a href="http://gr.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : gr.yhs4.search.yahoo.com</a>',
'hk_image_search_yahoo_com','<a href="http://hk.image.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : hk.image.search.yahoo.com</a>',
'hk_images_search_yahoo_com','<a href="http://hk.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : hk.images.search.yahoo.com</a>',
'hk_search_yahoo_com','<a href="http://hk.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : hk.search.yahoo.com</a>',
'id_images_search_yahoo_com','<a href="http://id.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : id.images.search.yahoo.com</a>',
'id_search_yahoo_com','<a href="http://id.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : id.search.yahoo.com</a>',
'id_yhs4_search_yahoo_com','<a href="http://id.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : id.yhs4.search.yahoo.com</a>',
'ie_search_yahoo_com','<a href="http://ie.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ie.search.yahoo.com</a>',
'image_search_yahoo_co_jp','<a href="http://image.search.yahoo.co.jp" title="Search Engine Home Page" rel="nofollow">Yahoo : image.search.yahoo.co.jp</a>',
'images_search_yahoo_com','<a href="http://images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : images.search.yahoo.com</a>',
'in_images_search_yahoo_com','<a href="http://in.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : in.images.search.yahoo.com</a>',
'in_search_yahoo_com','<a href="http://in.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : in.search.yahoo.com</a>',
'in_yhs4_search_yahoo_com','<a href="http://in.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : in.yhs4.search.yahoo.com</a>',
'it_images_search_yahoo_com','<a href="http://it.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : it.images.search.yahoo.com</a>',
'it_search_yahoo_com','<a href="http://it.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : it.search.yahoo.com</a>',
'it_yhs4_search_yahoo_com','<a href="http://it.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : it.yhs4.search.yahoo.com</a>',
'kr_search_yahoo_com','<a href="http://kr.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : kr.search.yahoo.com</a>',
'malaysia_images_search_yahoo_com','<a href="http://malaysia.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : malaysia.images.search.yahoo.com</a>',
'malaysia_search_yahoo_com','<a href="http://malaysia.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : malaysia.search.yahoo.com</a>',
'mx_images_search_yahoo_com','<a href="http://mx.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : mx.images.search.yahoo.com</a>',
'mx_search_yahoo_com','<a href="http://mx.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : mx.search.yahoo.com</a>',
'nl_images_search_yahoo_com','<a href="http://nl.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : nl.images.search.yahoo.com</a>',
'nl_search_yahoo_com','<a href="http://nl.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : nl.search.yahoo.com</a>',
'nl_yhs4_search_yahoo_com','<a href="http://nl.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : nl.yhs4.search.yahoo.com</a>',
'no_search_yahoo_com','<a href="http://no.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : no.search.yahoo.com</a>',
'nz_search_yahoo_com','<a href="http://nz.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : nz.search.yahoo.com</a>',
'pe_images_search_yahoo_com','<a href="http://pe.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : pe.images.search.yahoo.com</a>',
'ph_images_search_yahoo_com','<a href="http://ph.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ph.images.search.yahoo.com</a>',
'ph_search_yahoo_com','<a href="http://ph.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ph.search.yahoo.com</a>',
'ph_yhs4_search_yahoo_com','<a href="http://ph.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ph.yhs4.search.yahoo.com</a>',
'pl_yhs4_search_yahoo_com','<a href="http://pl.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : pl.yhs4.search.yahoo.com</a>',
'qc_images_search_yahoo_com','<a href="http://qc.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : qc.images.search.yahoo.com</a>',
'qc_search_yahoo_com','<a href="http://qc.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : qc.search.yahoo.com</a>',
'r_search_yahoo_com','<a href="http://r.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : r.search.yahoo.com</a>',
'ru_images_search_yahoo_com','<a href="http://ru.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : ru.images.search.yahoo.com</a>',
'se_images_search_yahoo_com','<a href="http://se.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : se.images.search.yahoo.com</a>',
'se_search_yahoo_com','<a href="http://se.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : se.search.yahoo.com</a>',
'se_yhs4_search_yahoo_com','<a href="http://se.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : se.yhs4.search.yahoo.com</a>',
'search_yahoo_co_jp','<a href="http://search.yahoo.co.jp" title="Search Engine Home Page" rel="nofollow">Yahoo : search.yahoo.co.jp</a>',
'search_yahoo_com','<a href="http://search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : search.yahoo.com</a>',
'sg_images_search_yahoo_com','<a href="http://sg.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : sg.images.search.yahoo.com</a>',
'sg_search_yahoo_com','<a href="http://sg.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : sg.search.yahoo.com</a>',
'sg_yhs4_search_yahoo_com','<a href="http://sg.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : sg.yhs4.search.yahoo.com</a>',
'tr_yhs4_search_yahoo_com','<a href="http://tr.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : tr.yhs4.search.yahoo.com</a>',
'tw_image_search_yahoo_com','<a href="http://tw.image.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : tw.image.search.yahoo.com</a>',
'tw_images_search_yahoo_com','<a href="http://tw.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : tw.images.search.yahoo.com</a>',
'tw_search_yahoo_com','<a href="http://tw.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : tw.search.yahoo.com</a>',
'uk_images_search_yahoo_com','<a href="http://uk.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : uk.images.search.yahoo.com</a>',
'uk_search_yahoo_com','<a href="http://uk.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : uk.search.yahoo.com</a>',
'uk_yhs_search_yahoo_com','<a href="http://uk.yhs.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : uk.yhs.search.yahoo.com</a>',
'uk_yhs4_search_yahoo_com','<a href="http://uk.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : uk.yhs4.search.yahoo.com</a>',
'us_search_yahoo_com','<a href="http://us.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : us.search.yahoo.com</a>',
'us_yhs4_search_yahoo_com','<a href="http://us.yhs4.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : us.yhs4.search.yahoo.com</a>',
'vn_images_search_yahoo_com','<a href="http://vn.images.search.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo : vn.images.search.yahoo.com</a>',

'yahoo_mindset','<a href="http://mindset.research.yahoo.com" title="Search Engine Home Page" rel="nofollow">Yahoo! Mindset</a>',

'images_search_yahoo_catchall','Yahoo : images search ( catchall )',
'yhs4_search_yahoo_catchall','Yahoo : yhs4 search ( catchall )',
'search_yahoo_catchall','Yahoo : search ( catchall )',
'yahoo_catchall','Yahoo : ( catchall )',

'ya_ru','<a href="http://ya.ru">Ya.ru ( Yandex )</a>',
'yandex','yandex ( catchall )',
'yandexcom','<a href="http://yandex.com" title="Search Engine Home Page" rel="nofollow">Yandex .com</a>',
'yandexcomtr','<a href="http://yandex.com.tr" title="Search Engine Home Page" rel="nofollow">Yandex .com.tr</a>',
'yandexkz','<a href="http://yandex.kz" title="Search Engine Home Page" rel="nofollow">Yandex .kz</a>',
'yandexru','<a href="http://yandex.ru" title="Search Engine Home Page" rel="nofollow">Yandex .ru</a>',
'yandexua','<a href="http://yandex.ua" title="Search Engine Home Page" rel="nofollow">Yandex .ua</a>',
'yell','<a href="http://www.yell.com" title="Yell Home Page" rel="nofollow">Yell</a>',
'yourbestsearch','<a href="http://yourbestsearch.net" title="Home Page" rel="nofollow">YourBest Search</a>',
'youtube','youtube',
'zapmeta_catchall','zapmeta ( catchall )',
'zapmeta_ch','<a href="http://www.zapmeta.ch" title="ZapMeta.ch" rel="nofollow">ZapMeta.ch</a>',
'zapmeta_com','zapmeta com',
'zapmeta_de','<a href="http://www.zapmeta.de" title="ZapMeta" rel="nofollow">ZapMeta.de</a>',
'zapmeta_it','<a href="http://www.zapmeta.it">Zapmeta .it</a>',
'fr_zapmeta_ws','<a href="http://fr.zapmeta.ws">Zapmeta fr .ws</a>',
'zapmeta_ws','<a href="http://www.zapmeta.ws">Zapmeta .ws</a>',

'zhongsou','<a href="http://www.zhongsou.com" rel="nofollow">ZhongSou</a>',
'zoeken','<a href="http://www.zoeken.nl" rel="nofollow">Zoeken</a>',
'zoznam','<a href="http://www.zoznam.sk" title="Zoznam search engine home page" rel="nofollow">Zoznam</a>',

# Generic search engines
'search',"$Message[215]"
);


# Sanity check.
# Enable this code and run perl search_engines.pm to check file entries are ok
#-----------------------------------------------------------------------------
#my %listcheck = ();
#foreach my $key (@SearchEnginesSearchIDOrder_list1) {
#	if (! $SearchEnginesHashID{$key}) { print "Entry '$key' has been found in SearchEnginesSearchIDOrder_list1 with no value in SearchEnginesHashID\n";}
#	if ($listcheck{$key} == 1) {print "Entry '$key' has been found in SearchEnginesSearchIDOrder_list1 twice\n";}
#	else {$listcheck{$key} = 1;}
#}
#foreach my $key (@SearchEnginesSearchIDOrder_list2) {
#	if (! $SearchEnginesHashID{$key}) { print "Entry '$key' has been found in SearchEnginesSearchIDOrder_list1 with no value in SearchEnginesHashID\n";}
#	if ($listcheck{$key} == 1) {print "Entry '$key' has been found in SearchEnginesSearchIDOrder_list twice\n";}
#	else {$listcheck{$key} = 1;}
#}
#foreach my $key (@SearchEnginesSearchIDOrder_listgen) {
#	if (! $SearchEnginesHashID{$key}) { print "Entry '$key' has been found in SearchEnginesSearchIDOrder_listgen with no value in SearchEnginesHashID\n";}
#	if ($listcheck{$key} == 1) {print "Entry '$key' has been found in SearchEnginesSearchIDOrder_list twice\n";}
#	else {$listcheck{$key} = 1;}
#}


#foreach my $key (keys %SearchEnginesHashID) {
#	if (! exists($listcheck{$key})) { print "Entry '$key' has been found in SearchEnginesHashID with no value in SearchEnginesSearchIDOrder_list\n"; }
#}


#foreach my $key (keys %NotSearchEnginesKeys) { if (! $SearchEnginesHashID{$key}) { print "Entry '$key' has been found in NotSearchEnginesKeys with no value in SearchEnginesHashID\n"; } }
#foreach my $key (keys %SearchEnginesKnownUrl) {
#	my $found=0;
#	foreach my $key2 (values %SearchEnginesHashID) {
#		if ($key eq $key2) { $found=1; last; }
#	}
#	if (! $found) { print "Entry '$key' has been found in SearchEnginesKnownUrl with no value in SearchEnginesHashID\n"; }
#}
#foreach my $key (keys %SearchEnginesHashLib) {
#	my $found=0;
#	foreach my $key2 (values %SearchEnginesHashID) {
#		if ($key eq $key2) { $found=1; last; }
#	}
#	if (! $found) { print "Entry '$key' has been found in SearchEnginesHashLib with no value in SearchEnginesHashID\n"; }
#}

#print @SearchEnginesSearchIDOrder_list1." ".@SearchEnginesSearchIDOrder_list2." ".@SearchEnginesSearchIDOrder_listgen;

#foreach my $key (keys %listcheck) {
#	print "$key\n";
#}

#print "%SearchEnginesKnownUrl\n";
#foreach my $key (keys %SearchEnginesKnownUrl) {
#	print "$key\n";
#}

#foreach my $key (keys %SearchEnginesHashLib) {
#	print "$key\n";
#}

1;
