# AWSTATS MIME DATABASE
#-------------------------------------------------------
# If you want to add MIME types,
# you must add an entry in MimeHashLib and assign it to a family
#-------------------------------------------------------

# ホビット 2017/6/14

#package AWSMIME;

# MimeHashFamily
# This is a hash table of mime groupings and descriptions.
# Report icons will appear if file name is the same as a family,
# e.g. if you have a "text.png" icon in the icon/mime directory,
# the report will load the icon
# Format: 	'family', 'descriptive text',
#---------------------------------------------------------------
%MimeHashFamily = (
'text',      'テキストファイル',
'page',      '静的なHTMLもしくはXMLファイル',
'script',    '動的なHTMLページもしくはスクリプトファイル',
'pl',        'Perlスクリプトファイル',
'php',       'PHPスクリプトファイル',
'image',     'イメージファイル',
'document',  '文書ファイル',
'package',   'パッケージファイル',
'archive',   'アーカイブファイル',
'audio',     'オーディオクリップ',
'video',     'ビデオクリップ',
'jscript',   'Javaスクリプトファイル',
'json',      'Javaスクリプトオブジェクト記述ファイル',
'vbs',       'Visual Basicスクリプトファイル',
'conf',      'Configファイル',
'css',       'CSS(Cascading Style Sheet)ファイル',
'xsl',       'XSL(Extensible Stylesheet Language)ファイル',
'runtime',   '動的なHTMLもしくはバイナリのランタイム',
'library',   'バイナリのライブラリ',
'flash',     'Adobe Flashアニメーション',
'flv',       'Adobe Flashビデオ',
'dtd',       'DTD(Document Type Definition)ファイル',
'csv',       'CSV(Comma Separated Value)ファイル',
'jnlp',      'Java Web Start launch file',
'lit',       'Microsoft Reader e-book',
'de',        '独語HTMLもしくはXMLファイル',
'el',        'ギリシア語HTMLもしくはXMLファイル',
'en',        '英語HTMLもしくはXMLファイル',
'es',        'スペイン語HTMLもしくはXMLファイル',
'et',        'エストニア語HTMLもしくはXMLファイル',
'fr',        '仏語HTMLもしくはXMLファイル',
'he',        'ヘブライ語HTMLもしくはXMLファイル',
'hr',        'クロアチア語HTMLもしくはXMLファイル',
'it',        '伊語HTMLもしくはXMLファイル',
'ja',        '日本語HTMLもしくはXMLファイル',
'ko',        '韓国・朝鮮語HTMLもしくはXMLファイル',
'nl',        'オランダ語HTMLもしくはXMLファイル',
'pt',        'ポルトガル語HTMLもしくはXMLファイル',
'ru',        '露語HTMLもしくはXMLファイル',
'sjis',      '日本語HTMLもしくはXMLファイル(Shift JIS)',
'cp866',      'HTMLもしくはXMLファイル(cp866)',
'utf8',      'HTMLもしくはXMLファイル(UTF-8)',
'iso8859-1', 'HTMLもしくはXMLファイル(iso8859-1)',
'eot',       'Web埋め込みフォント',
'lit',       'Microsoft Reader e-book',
'svg',       'Scalable Vector Graphics',
'ai',        'Adobe Illustratorファイル',
'phshop',    'Adobe Photoshopイメージファイル',
'ttf',       'TrueTypeフォントファイル',
'fon',       'フォントファイル',
'pdf',       'Adobeポータブル・ドキュメント・フォーマット',
'rdf',       'Resource Definition Framework',
'dotnet',	 'Dot Net Dynamic Script or File',
'mdb', 		 'MS Database Object',
'crystal',	 'クリスタルレポートファイル、データ',
'ooffice',	 'オープンオフィスドキュメント',
'libreoffice',   'リブレオフィスドキュメント',
'encrypt',	 '暗号文書',
'gpx',       'GPS Exchange Formatファイル',
'diskimage', 'Disc and media file extensions',
'vm',        'Virtual Machine image',
'torrent',   'BitTorrent File',
'gis',       'GIS File',
'ebook',     'Ebook File',
'ppt',		 'MS PowerPointファイル',
'doc',		 'MS Wordファイル',
'xls',		 'MS Excelファイル',
'var',       'Apache タイプマップファイル',
'other',     'その他',
);

# MimeHashLib
# This is a hash of arrays where the key is a specific file extension
# and the array is a list of family and file type, e.g. 'd' for download
# If a file does not have a type defined, it is counted as a page. Each
# mime entry can have only one type
# Format:	'extension', ['family', 'type'],
# Valid Types:
#		i - image
#		d - download
#		p - page
#---------------------------------------------------------------
%MimeHashLib=(
# Text file
'txt',['text','d'],
'log',['text','d'],
# HTML Static page
'chm',['page',''],
'html',['page',''],
'htm',['page',''],
'mht',['page',''],
'wml',['page',''],
'wmlp',['page',''],
'xhtml',['page',''],
'xml',['page',''],
'vak',['page',''],
'sgm',['page',''],
'sgml',['page',''],
'ja',['page',''],
'de',['page',''],
'el',['page',''],
'es',['page',''],
'et',['page',''],
'en',['page',''],
'fr',['page',''],
'he',['page',''],
'hr',['page',''],
'it',['page',''],
'ko',['page',''],
'nl',['page',''],
'pt',['page',''],
'ru',['page',''],
'sjis',['page',''],
'cp866',['page',''],
'utf8',['page',''],
'iso8859-1',['page',''],
'var',['page',''],
# HTML Dynamic pages or script
'asp',['script',''],
'aspx',['dotnet',''],
'ashx',['dotnet',''],
'asmx',['dotnet',''],
'axd', ['dotnet',''],
'cfm',['script',''],
'class',['script',''],
'js',['jscript',''],
'jsp',['script',''],
'cgi',['script',''],
'ksh',['script',''],
'php',['php',''],
'php3',['php',''],
'php4',['php',''],
'pl',['pl',''],
'py',['script',''],
'rss',['rss',''],
'sh',['script',''],
'shtml',['script',''],
'tcl',['script',''],
'xsp',['script',''],
'vbs',['vbs',''],
# Image
'gif',['image','i'],
'png',['image','i'],
'bmp',['image','i'],
'jpg',['image','i'],
'jpeg',['image','i'],
'cdr',['image','d'],
'ico',['image','i'],
'svg',['image','i'],
'svgz',['image','i'],
# Document
'ai',['document','d'],
'doc',['doc','d'],
'docx',['docx','d'],
'wmz',['document','d'],
'rtf',['document','d'],
'mso',['document','d'],
'pdf',['pdf','d'],
'frl',['pdf','d'],
'xls',['xls','d'],
'xlsx',['xlsx','d'],
'ppt',['ppt','d'],
'pptx',['pptx','d'],
'pps',['document','d'],
'psd',['document','d'],
'sxw',['ooffice','d'],
'sxc',['ooffice','d'],
'sxi',['ooffice','d'],
'sxd',['ooffice','d'],
'sxm',['ooffice','d'],
'sxg',['ooffice','d'],
'odb',['libreoffice','d'],
'odf',['libreoffice','d'],
'odg',['libreoffice','d'],
'odm',['libreoffice','d'],
'odp',['libreoffice','d'],
'ods',['libreoffice','d'],
'odt',['libreoffice','d'],
'oth',['libreoffice','d'],
'otg',['libreoffice','d'],
'otp',['libreoffice','d'],
'ots',['libreoffice','d'],
'ott',['libreoffice','d'],
'oxt',['libreoffice','d'],
'csv',['xls','d'],
'xsl',['css',''],
'lit',['lit','d'],
'mdb',['mdb','d'],
'rpt',['crystal','d'],
'epub',['ebook','d'],
'mobi',['ebook','d'],
'azw',['ebook','d'],
'azw3',['ebook','d'],
# GIS files
'gpx',['gis','d'],
'kml',['gis','d'],
'kmz',['gis','d'],
'rdf',['rss',''],
# Package
'rpm',[($LogType eq 'S'?'audio':'package'),'d'],
'deb',['package','d'],
'msi',['package','d'],
'pkg',['package','d'],
'apk',['package','d'],
# Archive
'7z',['archive','d'],
'ace',['archive','d'],
'bz2',['archive','d'],
'cab',['archive','d'],
'dmg',['package','d'],
'emz',['archive','d'],
'gz',['archive','d'],
'jar',['archive','d'],
'lzma',['archive','d'],
'rar',['archive','d'],
'tar',['archive','d'],
'tgz',['archive','d'],
'tbz2',['archive','d'],
'xz',['archive','d'],
'z',['archive','d'],
'zip',['archive','d'],
# Audio
'aac',['audio','d'],
'flac',['audio','d'],
'mp3',['audio','d'],
'oga',['audio','d'],
'ogg',['audio','d'],
'wav',['audio','d'],
'wma',['audio','d'],
'm4a',['audio','d'],
'm3u',['audio','d'],
'asf',['audio','d'],
# Video
'avi',['video','d'],
'divx',['video','d'],
'mp4',['video','d'],
'm4v',['video','d'],
'mpeg',['video','d'],
'mkv',['video','d'],
'mpg',['video','d'],
'ogv',['video','d'],
'ogx',['video','d'],
'rm',['video','d'],
'swf',['flash',''],
'flv',['flash','d'],
'f4v',['flash','d'],
'wmv',['video','d'],
'wmf',['video','d'],
'mov',['video','d'],
'qt',['video','d'],
'webm',['video','d'],
# Config
'cf',['conf',''],
'conf',['conf',''],
'css',['css',''],
'ini',['conf',''],
'dtd',['dtd',''],
'json',['json',''],
# Program
'exe',['runtime',''],
'jnlp',['jnlp',''],
'dll',['library',''],
'bin',['library',''],
# Font
'ttf',['ttf',''],
'fon',['ttf',''],
'eot',['ttf',''],
'woff',['ttf',''],
'woff2',['ttf',''],
'eot',['eot',''],
# Encrypted files
'pgp',['encrypt',''],
'gpg',['encrypt',''],
# Disc and media file extensions
'bin',['diskimage','d'],
'dmg',['diskimage','d'],
'iso',['diskimage','d'],
'toast',['diskimage','d'],
'vcd',['diskimage','d'],
# Virtual Machine images
'qcow2',['vm','d'],
'raw',['vm','d'],
'ovf',['vm','d'],
'ova',['vm','d'],
'vmdk',['vm','d'],
'vdi',['vm','d'],
'vhdx',['vm','d'],
'vpc',['vm','d'],
);

# MimeHashIcon
# Each Mime ID is associated to a string that is the name of icon
# file for this Mime type.
#---------------------------------------------------------------------------
%MimeHashIcon = (
# Text file
'txt','text',
'log','text',
# HTML Static page
'html','html',
'htm','html',
'hdml','html',
'wml','html',
'wmlp','html',
'xhtml','html',
'xml','html',
'vak','glasses',
'sgm','html',
'sgml','html',
'ja','html',
'en','html',
'sjis','html',
'utf8','html',
'iso8859-1','html',
# HTML Dynamic pages or script
'asp','script',
'aspx','script',
'asmx','script',
'cfm','script',
'jsp','script',
'cgi','script',
'ksh','script',
'php','php',
'phps',['php',''],
'php3','php',
'php4','php',
'pl','pl',
'py','script',
'atom',['rss',''],
'sh','script',
'shtml','html',
'tcl','script',
'xsp','script',
# Image
'gif','image',
'png','image',
'bmp','image',
'jpg','image',
'jpeg','image',
'cdr','image',
'ico','image',
'svg','svg',
'psd','phshop',
'webp',['image','i'],
'heic',['image','i'],
'tif',['image','i'],
'tiff',['image','i'],
# Document
'doc','doc',
'wmz','doc',
'rtf','doc',
'pdf','pdf',
'xls','xls',
'ppt','ppt',
'pps','ppt',
'sxw','other',
'sxc','other',
'sxi','other',
'sxd','other',
'csv','other',
'xsl','html',
'lit','lit',
'ai','ai',
'rdf','rss',
# Package
'rpm',($LogType eq 'S'?'audio':'archive'),
'deb','archive',
'msi','archive',
'dmg','archive',
# Archive
'7z','archive',
'ace','archive',
'bz2','archive',
'gz','archive',
'jar','archive',
'rar','archive',
'tar','archive',
'tgz','archive',
'tbz2','archive',
'z','archive',
'zip','archive',
# Audio
'mp3','audio',
'ogg','audio',
'wma','audio',
'wav','audio',
# Video
'avi','video',
'divx','video',
'mp4','video',
'mpeg','video',
'mpg','video',
'rm','real',
'swf','flash',
'flv','flash',
'wmv','video',
'mov','quicktime',
'qt','quicktime',
# Web scripts
'js','jscript',
'vbs','jscript',
# Config
'cf','other',
'conf','other',
'css','other',
'ini','other',
'dtd','other',
# Program
'exe','script',
'dll','script',
'jnlp','jnlp',
# Fonts
'ttf','ttf',
'fon','fon',
'eot','eot',
);

1;
