#!/usr/bin/perl
#------------------------------------------------------------------------------
# Tool to test your geoipfree setup
# To use it to test your geoip setup instead of geoipfree, comments
# or uncomment appropriated lines
#------------------------------------------------------------------------------
# Exemple of results on Linux Celeron 1.7Ghz
# GeoIPfree:		15s =    485 lookup/s
# GeoIP (PurePerl):	 1s > 10 000 lookup/s
# GeoIP (C lib):	 1s > 10 000 lookup/s
#------------------------------------------------------------------------------


push @INC, ".";
push @INC, "./plugins";
push @INC, "../wwwroot/cgi-bin/plugins";

require "Geo/IPfree.pm";		# For GeoIPfree
#require "Geo/IP/PurePerl.pm";	# For GeoIP (PurePerl)
#require "Geo/IP.pm";			# For GeoIP (C lib)

my $gi = Geo::IPfree->new();												# for GeoIPfree
#my $gi = Geo::IP->new(Geo::IP::GEOIP_MEMORY_CACHE());						# For GeoIP (C lib)
#my $gi = Geo::IP::PurePerl->new(Geo::IP::PurePerl::GEOIP_MEMORY_CACHE());	# For GeoIP (PurePerl)
#my $gi = Geo::IP->new(Geo::IP::GEOIP_STANDARD());							# For GeoIP (C lib)
#my $gi = Geo::IP::PurePerl->new(Geo::IP::PurePerl::GEOIP_STANDARD());		# For GeoIP (PurePerl)


$DORESULTTEST=1;
$DOSPEEDTEST=1;

if ($DORESULTTEST) {
	# Do the result test
	#-------------------
	print "----- Sample test\n";
	my %testtodo=(
    '212.26.25.24'=>'SA',
    '66.108.94.158'=>'US',
    '80.8.55.4'=>'FR'
	);

	foreach my $ip (sort keys %testtodo) {
		my ($res,$resname)=();
		($res,$resname)=$gi->LookUp($ip);		# For GeoIPfree
#		$res=$gi->country_code_by_addr($ip);	# For GeoIP (C lib and PurePerl)
		print "Example for $ip: You should get '$testtodo{$ip}' ... and you get '$res".($resname?" $resname":"")."'";
		if ($res =~ /$testtodo{$ip}/i) { print " ... Looks good.\n"; }
		else { print " ... Looks wrong.\n"; }
	}

}

if ($DOSPEEDTEST) {
	# Do the speed test
	#------------------
	print "----- Speed test\n";
	my $timebefore=time();
	print "Start at ".localtime($timebefore)." for 10201 lookups\n";
	foreach my $j (100..200) {
		foreach my $i (100..200) {
			my ($res,$resname)=$gi->LookUp("$j.50.$i.50");				# For GeoIPfree
#			my ($res)=$gi->country_code_by_addr("$j.50.$i.50");			# For GeoIP (C lib and PurePerl)
		}
	}
	my $timeafter=time();
	print "End at ".localtime($timeafter)."\n";
	print "Duration: ".($timeafter-$timebefore)." seconds\n";
	print "Speed: ".(101*101/(($timeafter-$timebefore)||1))." lookup/s\n";
}



sleep 3;

0;

