#!/usr/bin/env python

"""
logtrans.py - Translates web server logfiles from one format to another.

Main use is to process old IIS logfiles for use with awstats (see awstats.sourceforge.net),
but other potential applications as well.

cobbled together by Alastair Rankine <a_rankine@yahoo.co.uk>, 9/9/01
"""

import fileinput, re, string

#desired output format
outfmt = "%(time2)s %(host)s %(other)s %(method)s %(url)s %(code)s "\
		 "%(bytesd)s %(other)s %(ua)s %(referer)s"

re_infmt = re.compile("^#Fields: (.+)$")
re_date = re.compile("^#Date: (\d{4}-\d{2}-\d{2})")
re_comment = re.compile("^#")
infmt = None

class LogEntry:

	aliases = {
		"host": "c-ip",
		"method": "cs-method",
		"url": "cs-uri-stem",
		"code": "sc-status"
		}
	defaults = {
		"other": "-",
		"bytesd": "-",
		"ua": "-",
		"referer": "-"
		}
	infmt = []

	def __init__(self, line):
		if not self.infmt:
			raise "No input line format set!"

		invals = string.split(line)
		if len(invals) != len(self.infmt):
			raise "Input file format does not match input line"

		# set the attributes according to the input format
		for attr, val in zip(self.infmt, invals):
			setattr(self, attr, val)
	
	def __getitem__(self, name):
		if self.__dict__.has_key(name):
			return getattr(self, name)
		
		# computed attributes:
		if name == "time2":
			return "%(date)s %(time)s" % self

		# aliased attributes
		elif self.aliases.has_key(name):
			return self[self.aliases[name]]

		# defaulted attributes:
		elif self.defaults.has_key(name):
			return self.defaults[name]

		# nothing else to try!
		else:
			raise AttributeError, name
		
for line in fileinput.input():

	dt = re_date.match(line)
	if dt:
		LogEntry.defaults["date"] = dt.group(1)
		continue

	fmt = re_infmt.match(line)
	if fmt:
		LogEntry.infmt = string.split(fmt.group(1))
		continue

	if re_comment.match(line):
		continue

	# create the log entry
	e = LogEntry(line)
	
	# and print it out
	print outfmt % e
