#!/usr/bin/perl
# Awstats CGI script configurator.
# Copyright (C) 2002 Disoft. www.disoft.es
# Hctor Garca lvarez <hector@disoft.es>, 2002.
# Juantomas Garca Molina <juantomas@disoft.es>, 2002.
# These configuration system is under GPL 2 license.


package PTL;

@required_options = ("LogFile", "LogFormat", "DNSLookup", "DirData", "DirCgi", "DirIcons", "SiteDomain", "HostAliases", "AllowToUpdateStatsFromBrowser");

%required = ("LogFile"=>["Ubicacin del archivo de log del servidor",
							"<p>Aqui debe indicar tanto el lugar donde se puede encontrar el archivo de
							 log generado por apache como el nombre de este.<br>
							 Puede indicar la ubicacin tanto de forma absoluta como de forma relativa<br>
							 Ejemplos:<br>
							 &nbsp;&nbsp;&nbsp;c:/apache/logs/access.log<br>
							 &nbsp;&nbsp;&nbsp;../logs/mylog.log</p>",
							"c:/apache/logs/access.log",
							"string"],
			"LogFormat"=>  ["Formato del archivo de log",
							'<p>Debe indicar el formato del log que genera su servidor web.<br>
							 Puede elegir entre uno de los siguientes formatos predefinidos:<br>
						  	 <br>
			 &nbsp;&nbsp;&nbsp;&nbsp;1 = Apache formato nativo de log combined.<br>
			 &nbsp;&nbsp;&nbsp;&nbsp;2 = IIS (W3C log format).<br>
			 &nbsp;&nbsp;&nbsp;&nbsp;3 = Webstar.<br>
			 &nbsp;&nbsp;&nbsp;&nbsp;4 = Apache o Squid formato de log nativo common.<br>
			 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Con LogFormat=4, algunas caracteristicas no funcionan.<br>
			 &nbsp;&nbsp;&nbsp;&nbsp;5 = ISA server standard log format.<br>
							 <br>
							 O puede indicar su formato de log personalizado, para lo que deber usar
							 la siguiente sintaxis:<br>
							 
<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %host             Host client name or IP adress<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %logname          Authenticated login/user used on protected pages<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %time1            Date and time with format: [dd/mmm/yyyy:hh:mm:ss +0000]<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %time2            Date and time with format: yyyy-mm-dd hh-mm-ss<br>
&nbsp;&nbsp;&nbsp;&nbsp;  		%methodurl        Method and URL with format: "GET /index.html HTTP/x.x"<br>
&nbsp;&nbsp;&nbsp;&nbsp;     	%methodurlnoprot  Method and URL with format: "GET /index.html"<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %method           Method with format: GET<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %url              URL only with format: /index.html<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %query            Query string (used by URLWithQuery option)<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %code             HTTP return code with format: 999<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %bytesd           Size of document in bytes<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %refererquot      Referer page with format: "http://from.com/from.htm"<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %referer          Referer page with format: http://from.com/from.htm<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %uaquot           User agent with format: "Mozilla/4.0 (compatible, ...)"<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %ua               User agent with format: Mozilla/4.0_(compatible...)<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %gzipres          Mod_gzip compression results: STATUS:STATUS<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %gzipin           Mod_gzip compression input bytes: In:num_bytes   <br>
&nbsp;&nbsp;&nbsp;&nbsp;		%gzipout          Mod_gzip compression output bytes & percentage: Out:num_bytes:%<br>
							 If your log format has some fields not included in this list, use<br>
&nbsp;&nbsp;&nbsp;&nbsp;	    %other            Means another field<br>
							 Ejemplos:<br>
&nbsp;&nbsp;&nbsp;&nbsp;     1<br>
&nbsp;&nbsp;&nbsp;&nbsp;     %host %other %logname %time1 %methodurl %code %bytesd %refererquot %uaquot</p>',
							"1",
							"string"],
							
		   "DNSLookup"=>   ["Desea tener informacin del dominio de los visitantes",
			   				 "<p>Si desea saber el pais de procedencia de sus visitantes basandose en la
							  informacin de obtenida a partir del dominio al que pertenece la direccin
							  ip de la persona que le visita.<br>Esta informacin siempre es orientativa
							  dado que no es obligatorio uso de un dominio de su propio pas de origen</p>", 
							 0,
							 "bool"],
							 
			"DirData"=>    ["Directorio de la base de datos de awstats",
							"<p>Awstats necesita almacenar el resultado de sus anlisis antes de poder
							 generar las pginas web.<br> 
							 Si pretende activar la opcin \"Permitir actualizar estadisticas desde
							 el navegador\", el usuario del servidor web debe tener permisos de escritura
							 en este directorio (para sistemas UNIX)<br>
							 Ejemplos:<br>
&nbsp;&nbsp;&nbsp;			      C:/awstats_data_dir<br>
&nbsp;&nbsp;&nbsp;			      ../data</p>",
							"C:/awstats_data_dir",
							"string"],
							
			"DirCgi"=>	   ["URL del directorio donde est awstats.pl",
							"<p>URL en forma relativa o absoluta donde se encuentra el ejecutable awstats.pl.
							 <br>Ejemplo:<br>
&nbsp;&nbsp;&nbsp;			     /cgi-bin</p>",
							"/cgi-bin",
							"string"],
							
			"DirIcons"=>   ["URL del directorio donde estn los iconos",
							"<p>URL en forma relativa o absoluta donde se encuentran los iconos<br>
							 Ejemplo:<br>
&nbsp;&nbsp;&nbsp;			     /icons</p>",
							"/icons",
							"string"],
							
			"SiteDomain"=> ["Nombre del dominio o nombre del servidor de la intranet",
							'<p>Este parmetro se usa para generar las URLs completas para los enlaces, por
							 lo que debe proporcionar el nombre de su dominio o el nombre que se use
							 en la intranet interna para acceder al servidor.<br>
							 Los puntos deben ponerse como \.<br>
							 Ejemplo:<br>
&nbsp;&nbsp;&nbsp;			     www\.midominio\.com<br>
&nbsp;&nbsp;&nbsp;			     miservidorinterno</p>',
							"",
							"string"],
							
			"HostAliases"=>["Alias de los host virtuales",
							'<p>Escriba todos los nombres por los que alguien podria acceder a su servidor 
							 web separados por espacios.<br>
							 Los puntos deben ponerse como \.<br>
							 Ejemplo:<br>
&nbsp;&nbsp;&nbsp;			     www\.miservidor\.com www\.miotronombre\.net localhost 127\.0\.0\.1</p>',
							"localhost",
							"string"],
			"AllowToUpdateStatsFromBrowser"=>["Permitir actualizar las estadisticas desde el navegador",
							"<p>Cuando esta opcin esta activada, aparece un botn que permite obligar a 
							awstats a actualizar las estadisticas en ese momento.</p>",
							"0",
							"bool"]);



							
@optional_options = ("CreateDirDataIfNotExists", "PurgeLogFile", "ArchiveLogRecords", "KeepBackupOfHistoricFiles", "Lang", "DirLang", "DefaultFile", "SkipHosts", "SkipDNSLookupFor", "SkipFiles", "OnlyFiles", "NotPageList", "ValidHTTPCodes", "URLWithQuery", "WarningMessages", "NbOfLinesForCorruptedLog", "FirstDayOfWeek", "MaxNbOfDomain", "MaxNbOfHostsShown", "MinHitHost", "MaxNbOfLoginShown", "MinHitLogin", "MaxNbOfRobotShown", "MinHitRobot", "MaxNbOfPageShown", "MinHitFile", "MaxNbOfRefererShown", "MinHitRefer", "MaxNbOfKeywordsShown", "MinHitKeyword", "SplitSearchString", "Expires");

@optional_stats_options = ("ShowHeader", "ShowMenu", "ShowMonthDayStats", "ShowDaysOfWeekStats", "ShowHoursStats", "ShowDomainsStats", "ShowHostsStats", "ShowAuthenticatedUsers", "ShowRobotsStats", "ShowPagesStats", "ShowCompressionStats", "ShowFileTypesStats", "ShowBrowsersStats", "ShowOSStats", "ShowOriginStats", "ShowKeyphrasesStats", "ShowHTTPErrorsStats", "ShowFlagLinks", "ShowLinksOnUrl", "MaxLengthOfURL", "DetailedReportsOnNewWindows");

@optional_look_options = ("HTMLHeadSection", "HTMLEndSection", "BarWidth", "BarHeight", "Logo", "LogoLink", "color_Background", "color_TableBGTitle", "color_TableTitle", "color_TableBG", "color_TableRowTitle", "color_TableBGRowTitle", "color_TableBorder", "color_text", "color_titletext", "color_weekend", "color_link", "color_hover", "color_u", "color_v", "color_p", "color_h", "color_k", "color_s");

%optional = (
			"CreateDirDataIfNotExists"=>["Crear el directorio de datos si no existe",
							"<p>Si el directorio de datos no existe el programa devuelve un fallo.<br>
						 Si esta opcin est activada el programa crear el directorio automaticamente.</p>",
						 	"1",
							"bool"],
							
			"PurgeLogFile"=>["Borrar los archivos de log tras leerlos",
							"<p>El programa es capaz de detectar las lneas nuevas en el archivo de log,
							 pero cuanto mayor sea este archivo ms tardar en leerlo y analizarlo.<br>
							 Si esta opcin est activada, cada vez que se lean los logs y se extraiga
							 de ellos la informacin necesaria, sern borrados",
							 "0",
							 "bool"],
							 
			"ArchiveLogRecords"=>["Guardar archivos de log",
							"<p>Si 'Borrar los archivos de log tras leerlos' est activado y activa esta
							 opcin se guardar una copia del archivo de log una vez procesado</p>",
							 "0",
							 "bool"],
							 
			"KeepBackupOfHistoricFiles"=>["Hacer backup del archivo de historicos",
							"<p>Si esta opcin est activada se har una copia del archivo donde se guarda 
							 toda la informacin de las estadisticas antes de actualizarla.<br>
							 Por supuesto si est activada esta opcin el uso de espacio en disco ser 
							 mayor</p>",
							 "0",
							 "bool"],
							 
			"Lang"=>[		"Idioma",
							"<p>Puede elegir entre los siguientes idiomas:<br>
			&nbsp;&nbsp;&nbsp;&nbsp;Espaol = es<br>
			&nbsp;&nbsp;&nbsp;&nbsp;Ingles  = en<br>
			&nbsp;&nbsp;&nbsp;&nbsp;Frances = fr<br>
			&nbsp;&nbsp;&nbsp;&nbsp;Alemn  = de</p>",
							"es",
							"string"],
							
			"DirLang"=>[	"Archivos de idiomas",
							"<p>Directorio donde estn las traducciones a los distintos idiomas.<br>
							 Si no se facilita este directorio o no es correcto, los mensajes 
							 aparecern en ingles</p>",
							"./lang",
							"string"],
							 
			"DefaultFile"=>["Pgina principal del servidor",
							"<p>Pgina de entrada de su servidor web.<br>
							 Suele ser index.html o index.htm",
							"index.html",
							"string"],
							
			"SkipHosts"=>[	"No incluir accesos desde",
							'<p>Lista separada por espacios de servidores/dominios  que no queremos que 
							 aparezcan en las estadisticas.<br>Ejemplo:<br>
		 &nbsp;&nbsp;&nbsp;&nbsp;127\.0\.0\.1 163\.84\.<br>
		 &nbsp;&nbsp;&nbsp;&nbsp;localhost www\.midominiointerno\.es</p>',
		 					"",
							"string"],

			"SkipDNSLookupFor"=>["Direccions IP que no se deben resolver",
							'<p>Especifique las direciones IP para las cuales no se debe hacer la
							 resolucin inversa para averiguar el dominio.<br>
							 Las direcciones se deben poner separadas por espacios.<br>
							 Los puntos se ponen como \.<br>Ejemplo:<br>
			&nbsp;&nbsp;&nbsp;&nbsp;163\.85\. 192\.168\.1\.</p>',
							"",
							"string"],
							
			"SkipFiles"=>[	"Archivos a ignorar",
							'<p>Ignora el hacer estadisticas de las URLs que contegan el criterio 
							 especificado.<br>
							 Para ignorar un directorio completo aada el nombre del directorio.<br>
							 Los puntos se ponen como \.<br> xxx$ significa URL que acabe en xxx<br>
							 No quite los valores por defecto.</p>',
							'\.css$ \.js$ \.class$ robots\.txt$',
							"string"],
			
			"OnlyFiles"=>[	"Hacer estadsticas solo de",
							'<p>Hacer estadsticas solo las URLs que contengan cierto criterio 
							 especificado.<br>
							 Esta opcin es muy util si tenemos una copia del programa de estadsticas
							 solo para un departamento o seccin.<br>
							 Para aadir un directorio completo aada el nombre del directorio.<br>
							 Los puntos se ponen como \.<br> xxx$ significa URL que acabe en xxx<br>
							 Ejemplo:<br>
		 &nbsp;&nbsp;&nbsp;&nbsp;directorio_de_marketing</p>',
		 					"",
							"string"],
							
			"NotPageList"=>["No son pginas",
							"<p>Aada que tipo de extensiones deben ser contadas solamente como Hits y no 
							 como pginas vistas.</p>",
							"",
							"string"],
							
			"ValidHTTPCodes"=>["Cdigos HTTP vlidos",
							"<p>Por defecto se toman como vlidos los cdigos 200 y 304, y el resto de
							 cdigos se consideran erroneos.<br>En algunos casos, (redirecciones,...) es 
							 necesario considerar otros cdigos como vlidos.<br>Ejemplo:<br>
			&nbsp;&nbsp;&nbsp;&nbsp;200 304 302 305</p>",
							"200 304",
							"string"],
							
			"URLWithQuery"=>["Contar la query como parte de la URL",
							"<p>Si est activada esta opcin la query se contar como parte de ls URL, por
							 lo que mipagina.html?id=x y mipagina.html?id=y, sern contadas como dos 
							 pginas distintas.<br>Esta opcin es util para hacer estadsticas de pginas
							 dinmicas</p>",
							"0",
							"bool"],
							
			"WarningMessages"=>["Detectar problemas de configuracin",
							"<p>Al estar activada avisar de posibles errores en la configuracin</p>",
							"1",
							"bool"],
							
			"NbOfLinesForCorruptedLog"=>["N de lneas en logs corruptos",
							"<p>Para ayudarle a detectar si el formato de log es el correcto, el programa
							 mostrar un mensaje de error si las primeras <n a configurar> lneas 
							 contienen un formato de log no vlido<br>
							 Algunos gusanos generan, al intentar atacar al servidor, en el log muchas 
							 lneas erroneas, si detecta que el programa se detiene debido a la presencia
							 de estas entradas en el log, pruebe a incrementar el nmero de lneas</p>",
							"50",
							"int"],
							
			"FirstDayOfWeek"=>["Primer da de la semana",
							"<p>Si esta activada la semana empezar en lunes, sino comenzar en domingo</p>",
							"1",
							"bool"],
							
			"MaxNbOfDomain"=>["Nmero mximo de dominios",
							"<p>Nmero mximo de lineas mostradas para este campo</p>",
							"25",
							"int"],
							
			"MaxNbOfHostsShown"=>["Nmero mximo de servidores",
							"<p>Nmero mximo de lineas mostradas para este campo</p>",
							"25",
							"int"],
							
			"MinHitHost"=>[	"Nmero mnimo de servidores",
							"<p>Nmero mnimo de lineas mostradas para este campo</p>",
							"1",
							"int"],
							
			"MaxNbOfLoginShown"=>["Nmero mximo de usuarios autenticados",
							"<p>Nmero mximo de lineas mostradas para este campo</p>",
							"10",
							"int"],
							
			"MinHitLogin"=>["Nmero mnimo de usuarios autenticados",
							"<p>Nmero mnimo de lineas mostradas para este campo</p>",
							"1",
							"int"],
							
			"MaxNbOfRobotShown"=>["Nmero mximo de robots",
							"<p>Nmero mximo de lineas mostradas para este campo</p>",
							"25",
							"int"],
							
			"MinHitRobot"=>["Nmero mnimo de robots",
							"<p>Nmero mnimo de lineas mostradas para este campo</p>",
							"1",
							"int"],
							
			"MaxNbOfPageShown"=>["Nmero mximo de pginas",
							"<p>Nmero mximo de lineas mostradas para este campo</p>",
							"25",
							"int"],
							
			"MinHitFile"=>["Nmero mnimo de pginas",
							"<p>Nmero mnimo de lineas mostradas para este campo</p>",
							"1",
							"int"],
							
			"MaxNbOfRefererShown"=>["Nmero mximo de enlaces de procedencia",
							"<p>Nmero mximo de lineas mostradas para este campo</p>",
							"25",
							"int"],
							
			"MinHitRefer"=>["Nmero mnimo de enlaces de procedencia",
							"<p>Nmero mnimo de lineas mostradas para este campo</p>",
							"1",
							"int"],
							
			"MaxNbOfKeywordsShown"=>["Nmero mximo de palabras de bsqueda",
							"<p>Nmero mximo de lineas mostradas para este campo</p>",
							"25",
							"int"],
							
			"MinHitKeyword"=>["Nmero mnimo de palabras de bsqueda",
							"<p>Nmero mnimo de lineas mostradas para este campo</p>",
							"1",
							"int"],
							
			"SplitSearchString"=>["Palabras de bsqueda juntas o separadas",
							"<p>Si se activa esta opcin las palabras de bsqueda usadas en el buscador se
							 se considerarn como palabras independientes para las estadisticas, incluso
							 cuando se hayan utilizado varias para buscar estas pginas</p>",
							"0",
							"bool"],
							
			"Expires"=>[	"Forzar la recarga de la pgina cada",
							"<p>Al activar esta opcin se incluye cdigo HTML que fuerza la recarga de la 
							 pgina, en lugar de dejar que el navegador coja la pgina de la cache.<br>
							 til cuando se actualizan las estadisticas amenudo.<br>
							 Ejemplo:<br>&nbsp;&nbsp;&nbsp;&nbsp;3600</p>",
							"0",
							"int"],
							
			"ShowHeader"=>[	"Mostrar cabecera",
							"<p>Al activar esta opcin se mostrar la cabecera</p>",
							"1",
							"bool"],
							
			"ShowMenu"=>[	"Mostrar men",
							"<p>Al activar esta opcin se mostrar el men</p>",
							"1",
							"bool"],
							
			"ShowMonthDayStats"=>["Mostrar dias del mes",
							"<p>Al activar esta opcin se mostrar la estadistica segn dias del mes</p>",
							"1",
							"bool"],
							
			"ShowDaysOfWeekStats"=>["Mostrar das de la semana",
						  "<p>Al activar esta opcin se mostrar la estadistica segn dias de la semana</p>",
							"1",
							"bool"],
							
			"ShowHoursStats"=>["Mostrar horas",
							"<p>Al activar esta opcin se mostrar la estadistica segn horas</p>",
							"1",
							"bool"],
							
			"ShowDomainsStats"=>["Mostrar dominios",
							"<p>Al activar esta opcin se mostrar la estadistica segn dominios</p>",
							"1",
							"bool"],
							
			"ShowHostsStats"=>["Mostrar servidores",
							"<p>Al activar esta opcin se mostrar la estadistica segn servidores</p>",
							"1",
							"bool"],
							
			"ShowAuthenticatedUsers"=>["Mostrar usurios autenticados",
							"<p>Al activar esta opcin se mostrar la estadistica de acceso de usuarios
							 autenticados</p>",
							"0",
							"bool"],
							
			"ShowRobotsStats"=>["Mostrar robots",
							"<p>Al activar esta opcin se mostrar la estadistica de acceso de robots 
							 de bsqueda</p>",
							"1",
							"bool"],
							
			"ShowPagesStats"=>["Mostrar pginas",
							"<p>Al activar esta opcin se mostrar la estadistica de pginas accedidas</p>",
							"1",
							"bool"],
							
			"ShowCompressionStats"=>["Mostrar estadisticas de compresin",
							"<p>Al activar esta opcin se mostrar la estadistica de compresin de
							 pginas cuando se use mod_gzip",
							"0",
							"bool"],
							
			"ShowFileTypesStats"=>["Mostrar tipos de archivo",
							"<p>Al activar esta opcin se mostrar la estadistica de los tipos de archivos
							 descargados</p>",
							"1",
							"bool"],
							
			"ShowBrowsersStats"=>["Mostrar navegadores",
							"<p>Al activar esta opcin se mostrar la estadistica de los navegadores usados
							 por los usuarios para acceder a las pginas</p>",
							"1",
							"bool"],
							
			"ShowOSStats"=>["Mostrar sistemas operativos",
							"<p>Al activar esta opcin se mostrar la estadistica de los sistemas 
							 operativos usados por los usuarios para acceder a las pginas</p>",
							"1",
							"bool"],
							
			"ShowOriginStats"=>["Mostrar origen",
							"<p>Al activar esta opcin se mostrar la estadistica de las pginas desde las
							 que llegan los usuarios</p>",
							"1",
							"bool"],
							
			"ShowKeyphrasesStats"=>["Mostrar frases",
							"<p>Al activar esta opcin se mostrar la estadistica de las palabras usadas en
							 los buscadores para llegar hasta las pginas</p>",
							"1",
							"bool"],

			"ShowHTTPErrorsStats"=>["Mostrar errores",
							"<p>Al activar esta opcin se mostrar la estadistica de los errores HTTP</p>",
							"1",
							"bool"],

							
			"ShowFlagLinks"=>["Mostrar banderas de idiomas",
							"<p>Se mostrarn las distintas banderas de los idiomas disponibles para 
							 permitir al usuario ver las estadsticas en el idioma elegido.<br>
							 Solo vlida si esta activada 'Mostrar cabecera'<br>
							 Debe escribir los cdigos de los idiomas o dejarlo en blanco si no quiere
							 que aparezcan banderas</p>",
							"es en fr de it nl",
							"string"],
							
			"ShowLinksOnUrl"=>["Mostrar las URLs como enlaces",
							"<p>Al activar esta opcin las URLs se mostrarn como enlaces en los que 
							 poder pinchar</p>",
							"1",
							"bool"],
							
			"MaxLengthOfURL"=>["Longitud mxima de la URL",
							"<p>Longitud mxima a mostrar de la URL.<br>Solo afecta al texto, no al 
							 enlace</p>",
							"72",
							"int"],
							
			"DetailedReportsOnNewWindows"=>["Abrir informes detallados en nueva ventana",
							"<p>Al activar esta opcin, se abrir una nueva ventana para mostrar 
							 los informes detallados en lugar de mostrarlos en la pgina principal</p>",
							"1",
							"bool"],
							
			"HTMLHeadSection"=>["Cdigo HTML al inicio del informe",
							"<p>El cdigo HTML que ponga aqu se adjuntar al inicio de los informes</p>",
							"",
							"string"],
							
			"HTMLEndSection"=>["Cdigo HTML al final del informe",
							"<p>El cdigo HTML que ponga aqu se adjuntar al final de los informes</p>",
							"",
							"string"],
							
			"BarWidth"=>[	"Ancho de las barras horizontales",
							"<p>Ancho mximo de la barra horizontal de los grficos de barras</p>",
							"260",
							"int"],
							
			"BarHeight"=>[	"Altura de las barras verticales",
							"<p>Altura mxima de las barras verticales de los grficos de barras</p>",
							"180",
							"int"],
							
			"Logo"=>[		"Logo",
							'<p>Logo a poner en las estadisticas.<br>
							 Debe estar en <i>$DirIcons/other</i></p>',
							"logo.png",
							"string"],
							
			"LogoLink"=>[	"Enlace del logo",
							"<p>URL a la que se ir al pinchar en el logo</p>",
							"",
							"string"],
							
			"color_Background"=>["Color de fondo",
							"",
							"FFFFFF",
							"string"],
							
			"color_TableBGTitle"=>["Color de fondo del ttulo",
							"",
							"CCCCDD",
							"string"],
							
			"color_TableTitle"=>["Color del ttulo de las tablas",
							"",
							"000000",
							"string"],
							
			"color_TableBG"=>["Color de fondo de las tablas",
							"",
							"CCCCDD",
							"string"],
							
			"color_TableRowTitle"=>["Color de la fila del ttulo de las tablas",
							"",
							"FFFFFF",
							"string"],
							
			"color_TableBGRowTitle"=>["Color de fondo de la fila del ttulo de las tablas",
							"",
							"ECECEC",
							"string"],
							
			"color_TableBorder"=>["Color del borde de las tablas",
							"",
							"ECECEC",
							"string"],

			"color_text"=>[	"Color del texto",
							"",
							"000000",
							"string"],
							
			"color_titletext"=>["Color del texto de los ttulos",
							"",
							"000000",
							"string"],
							
			"color_weekend"=>["Color de los fines de semana",
							"",
							"EAEAEA",
							"string"],
							
			"color_link"=>[	"Color de los enlaces",
							"",
							"0011BB",
							"string"],
							
			"color_hover"=>["Color de los enlaces al estar bajo el ratn",
							"",
							"605040",
							"string"],
							
			"color_u"=>[	"Color de fondo para visitantes nicos",
							"",
							"FF9933",
							"string"],
							
			"color_v"=>[	"Color de fondo para las visitas",
							"",
							"F3F300",
							"string"],
							
			"color_p"=>[	"Color de fondo para las pginas",
							"",
							"4477DD",
							"string"],
							
			"color_h"=>[	"Color de fondo para los hits",
							"",
							"66F0FF",
							"string"],
							
			"color_k"=>[	"Color de fondo para el nmero de bytes",
							"",
							"339944",
							"string"],
							
			"color_s"=>[	"Color de fondo para las bquedas",
							"",
							"8888DD",
							"string"]);



1;
