#!/usr/bin/perl 
# Awstats CGI script configurator.
# Copyright (C) 2002 Disoft. www.disoft.es
# Hctor Garca lvarez <hector@disoft.es>, 2002.
# Juantomas Garca Molina <juantomas@disoft.es>, 2002.
# These configuration system is under GPL 2 license.

sub cargar_datos_actuales () {
	my ($archivo,@parametros) = @_;
	
	foreach my $opcion (@parametros) {
	    my $valor = &obtener_valor ($archivo,$opcion);
		$valor =~ s/"//g;
		$valor =~ s/#.*//;
		$valor =~ s/\s*$//g;
		
		if ( $valor cmp "vacio" ) {
			$estado {$opcion}=$valor;
		}
	}
	return \%estado;
}


sub obtener_valor () {
	my $directiva = $_[1];
	my $archivo = $_[0];
	
#	print "Buscando $directiva\n";
	if ($archivo =~ /^ *$directiva\s*=\s*(.+)/m) {
		return $1;
	}
	return "vacio";
}


sub cabecera () {
	print "<table border='2'><tr>\n";
	print "<td><input type='submit' name='opciones' value='Requerido'></td>\n";
	print "<td><input type='submit' name='opciones' value='Logs'></td>\n";
	print "<td><input type='submit' name='opciones' value='Estadisticas'></td>\n";
	print "<td><input type='submit' name='opciones' value='Aspecto'></td>\n";
	print "<br>\n";
}



sub page_hidden () {
	my ($hash,@options) = @_;
    foreach my $opcion (@options) {
        if ($$hash{$opcion}) {
           print "<input type='hidden' name='$opcion' value='$$hash{$opcion}'>\n";
		} 
    }
}

sub page_shown () {
	my ($opt,$hash,@options) = @_;
	$contador = 0;
	foreach my $opcion (@options) {
		if ( $contador == 0 ) {
			print "<tr bgcolor='#bbbbbb'>";
			$contador = 1;
		} else {
			print "<tr bgcolor='#aaaaaa'>";
			$contador = 0;
		}
		print "<td width='40%' nowrap>$$opt{$opcion}[0]</td><td><input name='$opcion' type='";
		
		if ( $$opt{$opcion}[3] eq 'bool') { 
		
			print "checkbox"; 
			if ( $$hash{$opcion}) { print "' checked='on"; } 
			
		} elsif ( $$opt{$opcion}[3] eq 'int') { 
		
			print "text"; 
			if ($$hash{$opcion}) { print "' value='$$hash{$opcion}"; }
			
		} else {
			print "text";
			if ($$hash{$opcion}) { print "' value='$$hash{$opcion}"; }
		}
		
		print "' size='50'></td><td><a href='./ayuda.pl?$opcion' target='_blank'>AYUDA</a></td></tr>\n";
	}
}


sub save_data () {
	my ($archivo, $estado, $required, $optional) = @_;
	open IN, "<$archivo" or die "No pude abrir $archivo\n";
	open OUT, ">$archivo.new" or die "No pude crear $archivo.new\n";
	while (<IN>) {
		if ( /^(#|\n)/ ) { 
			print OUT ;
			next; 
		}
		$comentario = "";
		if ( /^(\w+) *= *.*? *(#.*)?/) {
			$comentario = $2;
#			print OUT "clave $1 => $$estado{$1}\n";
#			if ( $$estado{$1} ) {
				print OUT "$1=";
				if ($$required{$1}) {
					if ($$required{$1}[3] eq "bool") {
						if ( $$estado{$1} eq "on" ) { print OUT "1"; } 
						elsif ( $$estado{$1} == 1 ) { print OUT "1"; }
						else { print OUT "0"; }
					} elsif ($$required{$1}[3] eq "int") {
						 print OUT "$$estado{$1}";
					} else {
						print OUT "\"$$estado{$1}\"";
					}
				} elsif ($$optional{$1}) {
                    if ($$optional{$1}[3] eq "bool") {
                        if ( $$estado{$1} eq "on" ) { print OUT "1"; } 
						elsif ( $$estado{$1} == 1 ) { print OUT "1"; }
                        else { print OUT "0"; }
                    } elsif ($$optional{$1}[3] eq "int") {
                         print OUT "$$estado{$1}";
                    } else {
                        print OUT "\"$$estado{$1}\"";
                    }
                } else {
					print OUT "\"$$estado{$1}\"";
				}
				if ($comentario ) { print OUT "  $comentario"; }
				print OUT "\n";
#			} else {
#				print OUT "AQUI $_";
#			}
			next;
		}
		print OUT ;
	}
	close IN;
	close OUT;
	move("$archivo","$archivo.back");
	move("$archivo.new","$archivo");

}

1;
